# In the Realm of the Hubble tension − a Review of Solutions †

Eleonora Di Valentino1∗, Olga Mena2, Supriya Pan $^ 3$ , Luca Visinelli $^ 4$ , Weiqiang Yang5, Alessandro Melchiorri $_ 6$ , David F. Mota $^ 7$ , Adam G. Riess $^ { 8 , 9 }$ , Joseph Silk8,10,11

E-mail: $^ *$ eleonora.di-valentino@durham.ac.uk   
1 Institute for Particle Physics Phenomenology, Department of Physics, Durham University, Durham DH1 3LE, UK.   
2 IFIC, Universidad de Valencia-CSIC, 46071, Valencia, Spain   
3 Department of Mathematics, Presidency University, 86/1 College Street, Kolkata 700073, India   
4 INFN, Laboratori Nazionali di Frascati, C.P. 13, I-100044 Frascati, Italy   
5 Department of Physics, Liaoning Normal University, Dalian, 116029, P. R. China $^ 6$ Physics Department and INFN, Universit\`a di Roma “La Sapienza”, Ple Aldo Moro 2, 00185, Rome, Italy   
$^ { 7 }$ Institute of Theoretical Astrophysics, University of Oslo, 0315 Oslo, Norway 8 Department of Physics and Astronomy, Johns Hopkins University, Baltimore, MD 21218, USA   
$^ { 9 }$ Space Telescope Science Institute, 3700 San Martin Drive, Baltimore, MD 21218, USA   
$^ { 1 0 }$ Institut d’Astrophysique de Paris (UMR7095: CNRS & UPMC- Sorbonne Universities), F-75014, Paris, France   
$_ { 1 1 }$ BIPAC, Department of Physics, University of Oxford, Keble Road, Oxford OX1 3RH, UK

Abstract. The simplest $\Lambda$ CDM model provides a good fit to a large span of cosmological data but harbors large areas of phenomenology and ignorance. With the improvement of the number and the accuracy of observations, discrepancies among key cosmological parameters of the model have emerged. The most statistically significant tension is the $4 \sigma$ to $6 \sigma$ disagreement between predictions of the Hubble constant, $H _ { 0 }$ , made by the early time probes in concert with the “vanilla” ΛCDM Cosmological model, and a number of late time, model-independent determinations of $H _ { 0 }$ from local measurements of distances and redshifts. The high precision and consistency of the data at both ends present strong challenges to the possible solution space and demands a hypothesis with enough rigor to explain multiple observations – whether these invoke new physics, unexpected large-scale structures or multiple, unrelated errors. A thorough review of the problem including a discussion of recent Hubble constant estimates and a summary of the proposed theoretical solutions is presented here. We include more than 1000 references, indicating that the interest in this area has grown considerably just during the last few years. We classify the many proposals to resolve the tension in these categories: Early Dark Energy, Late Dark Energy, Dark energy models with 6 degrees of freedom and their extensions, Models with extra relativistic degrees of freedom, Models with Extra Interactions, Unified cosmologies, Modified gravity, Inflationary models, Modified recombination history, Physics of the critical Phenomena, and Alternative proposals. Some are formally successful, improving the fit to the data in light of their additional degrees of freedom, restoring agreement within $1 - 2 \sigma$ between Planck 2018, using the Cosmic Microwave Background power spectra data, Baryon Acoustic Oscillations, Pantheon SN data, and R20, the latest SH0ES Team [2] measurement of the Hubble constant ( $H _ { 0 } = 7 3 . 2 \pm 1 . 3 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% confidence level). However, there are many more unsuccessful models which leave the discrepancy well above the $3 \sigma$ disagreement level. In many cases, reduced tension comes not simply from a change in the value of $H _ { 0 }$ but also due to an increase in its uncertainty due to degeneracy with additional physics, complicating the picture and pointing to the need for additional probes. While no specific proposal makes a strong case for being highly likely or far better than all others, solutions involving early or dynamical dark energy, neutrino interactions, interacting cosmologies, primordial magnetic fields, and modified gravity provide the best options until a better alternative comes along.

# Contents

#

1 Introduction 7

# 2 Experimental measurements of $H _ { 0 }$ 9

2.1 Early . . . . 9   
2.1.1 CMB − systematics in Planck? 13   
2.2 Late 15   
2.2.1 (Astrophysical) Model-Dependent: 18   
2.2.2 Standard Sirens: 22   
2.2.3 Systematics: . . 22

# 3 The Local Solution and the Sound Horizon Problem 23

3.1 Inhomogeneous and Anisotropic Solutions 23   
3.2 The Sound Horizon Problem . . . 25

# 4 Early Dark Energy 28

# 4.1 Anharmonic Oscillations . . . . 28

4.2 Ultra-Light Axions 31   
4.2.1 Dissipative Axion: 32   
4.2.2 Axion Interacting With a Dilaton: 32   
4.3 Power-Law Potential 33   
4.4 Rock ‘n’ Roll 33   
4.5 New Early Dark Energy 33   
4.6 Chain Early Dark Energy 34   
4.7 Anti-de Sitter phase 34   
4.8 Graduated Dark Energy 35   
4.9 Acoustic Dark Energy 35   
4.9.1 Exponential Acoustic Dark Energy: 36   
4.10 EDE in $\alpha$ -attractors 36

# 5 Late Dark Energy 39

# 5.1 $w$ CDM model . . . . 39

5.2 $w _ { 0 } w _ { a }$ CDM or CPL parameterization 40   
5.3 Dark energy in extended parameter spaces 41   
5.4 Dynamical dark energy parameterisations with two free parameters 41   
5.5 Dynamical dark energy parameterizations with one free parameter 42   
5.6 Metastable dark energy . 42   
5.7 Phantom Crossing 43   
5.8 Late Dark Energy Transition . 44   
5.9 Running vacuum model 45   
5.10 Transitional Dark Energy model 45   
5.11 Negative Dark Energy 45   
5.12 Bulk viscous models . . . 46   
5.13 Holographic Dark Energy 47   
5.13.1 Tsallis Holographic Dark Energy: 48   
5.14 Swampland Conjectures 48   
5.15 Late time transitions in the quintessence field 49   
5.16 Phantom Braneworld Dark Energy 49   
5.17 Frame dependent dark energy 50   
5.18 Chameleon dark energy . . . 50

# 6 Dark energy models with 6 degrees of freedom and their extensions 50

6.1 Phenomenologically Emergent Dark Energy 50   
6.1.1 Generalized Emergent Dark Energy: 52   
6.1.2 Modified Emergent Dark Energy: 53   
6.2 Vacuum Metamorphosis 53   
6.2.1 Elaborated Vacuum Metamorphosis: 54

# 7 Models With Extra Relativistic Degrees of Freedom 56

7.1 Sterile neutrinos . . . . 57   
7.2 Neutrino Asymmetries 58   
7.3 Thermal Axions . 58   
7.4 Decaying dark matter . . . . . 59   
7.4.1 Self-interacting Dark Matter: 60   
7.4.2 Two-body dark matter decays: . 60   
7.4.3 Light Gravitino scenarios: 61   
7.4.4 Decaying $Z ^ { \prime }$ : . 62   
7.4.5 Dynamical Dark Matter: 62   
7.4.6 Degenerate Decaying Fermion Dark Matter: 62   
7.5 Neutrino-Dark Matter Interactions 62   
7.5.1 Neutrino-Majoron Interactions: 63   
7.5.2 FIMPs Decay into Neutrinos: 63   
7.6 Interacting Dark Radiation . . 63   
7.7 Coupled DM - Dark Radiation scenarios 63   
7.8 Cannibal Dark Matter 64   
7.9 Decaying Ultralight Scalar 64   
7.10 Ultralight dark photon 65   
7.11 Primordial Black Holes 65   
7.12 Unparticles 65

# 8 Models With Extra Interactions 66

# 8.1 Interacting Dark Energy . . . . 66

8.1.1 Interacting vacuum energy: 69   
8.1.2 Coupled Scalar Field: . 69   
8.1.3 IDE with a constant DE equation of state: . . 70

8.1.4 IDE with variable DE equation of state: 8.1.5 IVS and IDE with variable coupling: 8.1.6 IDE with sign-changing interaction: 8.1.7 Anisotropic Stress in IDE: 73 8.1.8 Interaction in the Anisotropic Universe: . 73 8.1.9 Metastable Interacting dark energy: . 8.1.10 Quantum Field Cosmology: 8.1.11 Interacting Quintom dark energy:   
8.2 Interacting Dark Matter . . . . 8.2.1 DM - Photon Coupling: 8.2.2 DM - Baryon Coupling:   
8.3 DE - Baryon Coupling . . . . .   
8.4 Interacting neutrinos . . . 8.4.1 Self-interacting neutrinos: 8.4.2 Self-interacting sterile neutrino model: 78 8.4.3 Dark Neutrino Interactions: 79

# 9 Unified cosmologies 79

9.1 Generalized Chaplygin gas model 79   
9.2 A new unified model 79   
9.3 $\Lambda ( t )$ CDM model . 82   
9.4 $\Lambda$ -gravity . . . 82

# 10 Modified gravity 82

10.1 $f ( \mathcal R )$ gravity theory . . . . . 83   
10.2 $f ( \mathcal T )$ gravity theory . 84   
10.3 $f ( T , B )$ gravity theory 86   
10.4 $f ( \mathcal { Q } )$ gravity theory . 86   
10.5 Jordan-Brans-Dicke gravity 87   
10.5.1 BD- $\Lambda$ CDM: 87   
10.6 Scalar-tensor theories of gravity: 88   
10.6.1 Early modified gravity: 88   
10.6.2 Screened Fifth Forces: 89   
10.7 Uber-gravity . . .¨ 89   
10.8 Galileon gravity . . 90   
10.9 Nonlocal gravity . . 91   
10.10 Unimodular gravity 91   
10.11 Scale − dependent scenario of gravity 92   
10.12 VCDM 92

# 11 Inflationary models 92

11.1 Exponential inflation 93   
11.2 Reconstructed Primordial Power Spectrum 93   
11.3 Lorentzian Quintessential Inflation 94   
11.4 Harrison-Zel’dovich spectrum 94

# 12 Modified recombination history 94

12.1 Effective Electron Rest Mass . . 94   
12.2 Time Varying Electron Mass . 95   
12.3 Axi-Higgs model . . . 95   
12.4 Primordial magnetic fields 95

# 13 Physics of the critical Phenomena 97

13.1 Double- $\Lambda$ CDM (ΛΛCDM) 97   
13.2 Ginzburg-Landau theory of phase transition 98   
13.3 Critically Emergent Dark Energy 98

# 14 Alternative proposals 98

# 14.1 Local Inhomogeneity . . . . . 98

14.2 Bianchi type I spacetime 99   
14.3 Scaling Solutions 99   
14.4 CMB monopole temperature $T _ { 0 }$ 99   
14.4.1 Open and Hotter Universe: 100   
14.5 Super- $\Lambda$ CDM 100   
14.6 Heisenberg uncertainty 100   
14.7 Diffusion . 101   
14.8 Casimir Cosmology 101   
14.9 Surface forces 101   
14.10 Milne Model 101   
14.11 Running Hubble Tension 101   
14.12 Rapid Transition in the effective Gravitational Constant 101   
14.13 Causal Horizons 102   
14.14 Milgromian Dynamics 102   
14.15 Charged Dark Matter 102

# 15 Summary and Conclusions 102

Appendix A List of conventions and acronyms used 106   
Appendix B Successful Models in light of the Hubble constant tension 107

# 1. Introduction

Although the standard cosmological scenario, the so-called $\Lambda$ -Cold Dark Matter ( $\Lambda$ CDM) model, provides a remarkable fit to the bulk of available cosmological data, we should not forget that there is little understanding of the nature of its largest components. The aphorism, “All models are wrong but some are useful” (see e.g. Ref. [3]) may be especially appropriate for $\Lambda$ CDM which lacks the deep underpinnings a model requires to approach fundamental physics laws. Specifically, there are three ingredients, i.e. Inflation [4–6], Dark Matter (DM) [7, 8] and Dark Energy (DE) [9, 10], for which the physical evidence comes from cosmological and astrophysical observations only. In addition, in the standard $\Lambda$ CDM model we assume, these ingredients take on their simplest (i.e. “Vanilla”) form (until there is strong evidence to the contrary), adopting an effective theory perspective for an underlying physical theory (yet to be discovered). With the increase of experimental sensitivity, deviations from the standard scenario therefore may be expected and could provide the means to reach a deeper understanding of the theory. In this predicament, we must be careful not to cling to the model too tightly or to risk missing the appearance of departures from the paradigm.

In this context, several tensions present between the different cosmological probes become interesting because, if not due to systematic errors (and as we shall later show, their explanation would appear to require multiple, unrelated errors), they could indicate a failure of the canonical $\Lambda$ CDM model. Currently, the most notable anomalies worth consideration are those arising when the Planck satellite measurements [11] of the Cosmic Microwave Background (CMB) anisotropies are compared to low redshift probes, or compared within the Planck data itself. The Planck experiment has measured the CMB power spectra with an exquisite precision, but the constraints for the cosmological parameters are always model-dependent.1 This means that, if there is no evidence for systematic errors in the data, a better model may be found which, if used for analysing the measured power spectra, would make tensions and anomalies disappear. In particular, extensively discussed in the literature, are the tensions present between the Planck data in a $\Lambda$ CDM context [11] and local determinations of the Hubble constant, e.g. Ref. [2] (here R20), and the weak lensing experiments [12–16] for the $S _ { 8 }$ parameter. In addition, there are the Planck internal lensing anomalies related to the excess of lensing in the temperature power spectrum, producing a tension between the cosmological parameters extracted in the high- $\ell$ and low- $\ell$ multipole ranges: $A _ { \mathrm { l e n s } } > 1$ at about 2.8σ [11, 17] and a closed Universe (i.e. a Universe with $\Omega _ { k } < 0$ ) is preferred at more than $3 . 4 \sigma$ without the inclusion of additional constraints [11, 18, 19].

In this review, we shall focus on the Hubble constant $H _ { 0 }$ tension between the late

1 To date, very few conclusions about the kinematics and/or dynamics of the Universe have been made without model assumptions in cosmology, typically in the form of a $\Lambda$ CDM model or in the form of a Friedmann-Lemaˆıtre-Robertson-Walker (FLRW) metric. The claimed ${ \sim } 1 \%$ precision in cosmology is achieved at the expense of strong model assumptions. Additionally, the data reduction in the large cosmological surveys (employed before the cosmological model fit) is often achieved within the context of a $\Lambda$ CDM fiducial model.

time and early time measurements of the Universe because this is the most statistically significant, long-lasting and widely persisting tension, with $4 \sigma$ to $6 \sigma$ disagreement depending on the datasets considered. Indeed, this tension has existed since the first release of results from Planck in 2013 [20] and has grown in significance with the improvement of the data. We consider a broad range of investigations performed over the last few years by the scientific community, and discuss how the Hubble constant value can be either resolved or reconciled in various cosmological models.

After a presentation of the most recent experimental measurements of the Hubble constant in Section 2, we revise the possibility of a local solution and the sound horizon problem in Section 3. At this point, we classify many proposals to resolve the Hubble puzzle in different categories: we discuss the Early Dark Energy models in Section 4, the Late Dark Energy proposals in Section 5, the dark energy models with 6 degrees of freedom and their extensions in Section 6, models predicting extra relativistic degrees of freedom that can be parameterized by the effective number of neutrino species $N _ { \mathrm { e f f } }$ in Section 7, models with Extra Interactions between the different components of the Universe in Section 8, Unified cosmologies in Section 9, modified gravity scenarios in Section 10, inflationary models in Section 11, models of modified recombination history in Section 12, models based on the physics of the critical Phenomena in Section 13, and finally in Section 14 we present other alternative proposals.

At the beginning of each section, we shall present an illustrative figure showing the estimated values of the present matter energy density parameter $\Omega _ { m } h ^ { 2 }$ , the Hubble constant $H _ { 0 }$ , and the sound horizon $r _ { d } h$ for the several models described in the corresponding section. In these figures, we shall also depict a cyan horizontal band corresponding to the $H _ { 0 }$ value measured in R20 [2], a yellow vertical band to the $\Omega _ { m } h ^ { 2 }$ value estimated by Planck 2018 [11] in a $\Lambda$ CDM scenario, and a light green horizontal band associated with the $r _ { d } h$ value measured by the Baryonic Acoustic Oscillation (BAO) data. The points sharing the same symbol refer to the very same model in the same paper, and the different colors refer to different dataset combinations. These plots are useful to have a clear visualization of the overall agreement of the proposed model with the current cosmological probes. In addition, we shall also present a figure with a whisker plot illustrating the 68% marginalized Hubble constant values obtained in the several cases reported in the section. We present our conclusions in Section 15.

Finally, in the Appendix we show Table A1 with the notation convention used in this review, two additional tables (i.e. Table B1 and Table B2) where we classify the several theoretical or phenomenological proposals depending on the agreement among their predictions of the Hubble constant and the value of $H _ { 0 }$ reported in Ref. [2] and a useful plot in Figure B1 for the readers. In particular, in Table B1 we report the results from those analyses that account for Planck data only, and in Table B2 those that consider a combination of Planck plus additional observational probes. In Figure B1 we show the combined effort made by the entire scientific community to solve or alleviate the Hubble constant tension until today.2 A sample code for 2 This figure has been made by combining all the similar Figures in the review, i.e.

producing the whisker plots associated with this work is made publicly available online at github.com/lucavisinelli/H0TensionRealm.

# 2. Experimental measurements of $H _ { 0 }$

Within the class of cosmological models described by the Friedmann-LemaˆıtreRobertson-Walker (FLRW) metric, the physical scale of the Universe is a time-dependent quantity whose knowledge allows us to convert all relative quantities to absolute ones. At a given time there should be only one correct distance scale of the background Universe. In principle, scales measured at different times should appear consistent when interpreted in the context of an accurate, time-dependent cosmological model. The Hubble constant (or Hubble-Lemaˆıtre constant) is the name given to the present expansion rate which sets the distance scale, defined as $H _ { 0 } \equiv a ^ { - 1 } \mathrm { d } a / \mathrm { d } t$ when the scale factor of the expanding Universe, $a = 1$ (or $z = 0$ ). Figure 1 (and 2 for the filtered version) provide a useful reference for the following discussion of the Hubble constant landscape.

Because the Hubble constant tension appears to manifest as a difference between its value predicted via the use of measurements in concert with Early Universe physics (described by $\Lambda$ CDM) and the value measured in the Late Universe (with or without the use of the late-time behavior of $\Lambda$ CDM) we shall briefly review these two sets of inferences. To be explicit in our phenomenological definition, Early and Late do not refer to the redshift when the measurement is made but rather to the epoch of the $\Lambda$ CDM model that is invoked. For example, a useful test is to consider whether a specific measurement has any dependence on the number of neutrinos included in $\Lambda$ CDM (in this dichotomy Early does and Late does not).

# 2.1. Early

We consider here as “Early” predictions for $H _ { 0 }$ those relying, in principle or in practice, on the accuracy of a number of assumptions of the $\Lambda$ CDM model used to describe the Universe at $z > 1 0 0 0$ , including a number of ansatzes about the properties of neutrinos (e.g. there are 3 active species known with a minimal total mass of $0 . 0 6 \mathrm { e V }$ assuming normal hierarchy [21]), particle interactions, the absence of primordial magnetic fields, a null running of the scalar spectral index, no additional relativistic particles or degrees of freedom, etc. Certain types and scales of breakdowns in these assumptions may be apparent within the CMB power spectra (and are not seen) though others may not. Many of these same ansatzes are used to relate local measurements of “primordial” abundances to the baryon density [22]. The $\Lambda$ CDM model is further used to describe the evolution of the Universe at $0 ~ < ~ z ~ < ~ 1 0 0 0$ to predict the expansion rate, $H ( z )$ and its present value, $H _ { 0 }$ , from the parameters derived from the CMB data and the early model. The late Universe form of $\Lambda$ CDM makes use of different ansatzes than at early times including descriptions of dark matter (no interactions, stable, cold) and dark energy (as a cosmological constant). Again, some of these are tested but not to the precision with which they are relied upon in the model. For this reason the Hubble constant tension can identify a failure of the standard $\Lambda$ CDM scenario at early or late epochs.

![](images/252070aaafa528e389bb2e0eedd1f64d736a857ca1a6e497e030b828fb3f3b36.jpg)  
Figure 1. Whisker plot with $6 8 \%$ CL constraints of the Hubble constant $H _ { 0 }$ through direct and indirect measurements by different astronomical missions and groups performed over the years. The cyan vertical band corresponds to the $H _ { 0 }$ value from SH0ES Team [2] (R20, $H _ { 0 } = 7 3 . 2 \pm 1 . 3 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL) and the light pink vertical band corresponds to the $H _ { 0 }$ value as reported by Planck 2018 team [11] within a ΛCDM scenario. A sample code for producing similar figures with any choice of the data is made publicly available online at github.com/lucavisinelli/H0TensionRealm.

First we review the status of $H _ { 0 }$ predictions from a variety of CMB experiments beginning with Planck which is the de-facto “Gold standard” experiment. The most widely cited prediction from Planck in a flat $\Lambda$ CDM model for the Hubble constant is $H _ { 0 } = 6 7 . 2 7 \pm 0 . 6 0 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ confidence level (CL) for Planck 2018 [11], while it is $H _ { 0 } \ = \ 6 7 . 3 6 \pm 0 . 5 4 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL for Planck 2018 $^ +$ CMB lensing [11], i.e. with the inclusion of the four-point correlation function or trispectrum data.3 The previous CMB satellite experiment Wilkinson Microwave Anisotropy Probe (WMAP) [23], in its nine-year data release, assuming the same $\Lambda$ CDM model, preferred a value for the Hubble constant $H _ { 0 } = 7 0 . 0 \pm 2 . 2 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL, a value that can be in agreement with both Planck and R20 because of its very large error bars. This conclusion used to apply to another CMB experiment from the ground, South Pole Telescope (SPTPol) [24], that reports a value of $H _ { 0 } = 7 1 . 3 \pm 2 . 1 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL, considering the full datasets in TE and EE. However, the result from SPT-3G [25] improves from those in Ref. [24] and leads to a value of $H _ { 0 } = 6 8 . 8 \pm 1 . 5 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL. The recent SPTPol result is competitive with those from other groundbased experiments such as the combination of the Atacama Cosmology Telescope (ACT), a ground based telescope, and WMAP. Indeed, the combination of ACT (from $\ell = 6 0 0$ in TT and $\ell = 3 5 0$ in TE/EE) and WMAP data, with a Gaussian prior on $\tau$ instead of the low- $\ell$ polarization likelihood, results in $H _ { 0 } = 6 7 . 6 \pm 1 . 1 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [26], always assuming a $\Lambda$ CDM model, or $H _ { 0 } = 6 7 . 9 \pm 1 . 5 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL for ACT alone. Finally, a combination of ground based CMB experiments SPT, SPTPol, and the Atacama Cosmology Telescope Polarimeter (ACTPol) gives $H _ { 0 } \ = \ 6 9 . 7 2 \pm 1 . 6 3 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [27], while SPTP $\mathrm { \Delta \omega _ { o l } ~ + ~ A C I ^ { \prime } l }$ Pol, when combined with the Planck dataset, gives $H _ { 0 } = 6 7 . 4 9 { \pm } 0 . 5 3 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [28].

We may also consider less precise constraints that arise exclusively from measurements of the polarization of the CMB, i.e. from the EE CMB power spectra [29], always assuming a $\Lambda$ CDM model: Planck EE gives $H _ { 0 } ~ = ~ 7 0 . 0 \pm$ $2 . 7 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL, ACTPol $H _ { 0 } = 7 2 . 4 _ { - 4 . 8 } ^ { + 3 . 9 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL, and SPTPol $H _ { 0 } = 7 3 . 1 _ { - 3 . 9 } ^ { + 3 . 3 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL, but their combination finds $H _ { 0 } =$ $6 8 . 7 \pm 1 . 3 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL for the different directions of correlations [29].

Measurements of Baryon Acoustic Oscillations (BAO) (or other features in galaxy power spectra) at any redshift are “scale-free”, primarily constraining the product of the

3 We will use Planck 2015 to indicate the full Planck 2015 TT, TE, EE $^ +$ lowTEB dataset combination, and Planck 2015 TT for Planck 2015 T $^ { \mathrm { ~ \scriptsize ~ 1 ~ + ~ } }$ lowTEB. Here, TT is the temperature power spectrum, EE is the E-mode polarization auto-power spectra, and TE is the temperature-E-mode cross-power spectra. Similarly, we will indicate with Planck 2018 the full Planck 2018 TT, TE, EE $^ +$ low- $\ell +$ lowE combination and we will use Planck 2018 TT for the Planck 2018 TT $^ +$ low-\` + lowE combination.

sound horizon and the $H _ { 0 }$ value, but neither without a prior on the other. When the prior comes from the CMB, or baryon abundance estimates, the determination of $H _ { 0 }$ depends on the above ansatz at $z > 1 0 0 0$ and we will consider the result as belonging to the Early or indirect class. As such, there are $H _ { 0 }$ estimates from a reanalysis of the Baryon Oscillation Spectroscopic Survey (BOSS) Data Release 12 (DR12) on anisotropic galaxy clustering in Fourier space [30], that provide $H _ { 0 } = 6 7 . 9 \pm 1 . 1 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL using a prior on the physical baryon density $\omega _ { b }$ , derived from measurements of primordial deuterium abundance [22] $\mathit { D } / H = ( 2 . 5 2 7 \pm 0 . 0 3 0 ) \times 1 0 ^ { - 5 } )$ ) assuming the standard Big Bang Nucleosynthesis (BBN) picture, and a $\Lambda$ CDM model with a total neutrino mass free to vary in a small CMB-motivated range and a fixed primordial power spectrum tilt $n _ { s }$ to the Planck best-fit. The same lower $H _ { 0 }$ is confirmed also from a reanalysis of the BOSS DR12 data using the Effective Field Theory of Large-Scale Structure (EFTofLSS) formalism [31], predicting the clustering of Cosmological Large-Scale Structure in the mildly non-linear regime, that results in $H _ { 0 } = 6 8 . 5 \pm 2 . 2 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL, always assuming BBN, and fixing the values of the baryon/dark-matter ratio, $\Omega _ { b } / \Omega _ { c }$ , and $n _ { s }$ to the Planck 2018 best-fit. A companion paper [32] gives instead $H _ { 0 } = 6 8 . 7 \pm 1 . 5 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL, assuming a BBN prior on $\Omega _ { b } h ^ { 2 }$ instead of $\Omega _ { b } / \Omega _ { c }$ . In addition, the combination of BAO from Main Galaxy Sample (MGS) [33], BOSS galaxy and extended BOSS (eBOSS), with the BBN prior independent from the CMB anisotropies, provides $H _ { 0 } = 6 7 . 3 5 \pm 0 . 9 7 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL in a $\Lambda$ CDM scenario [34]. Moreover, a lower Hubble constant $H _ { 0 } = 6 8 . 1 9 \pm 0 . 3 6 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [34] is also obtained within the $\Lambda$ CDM scheme when combining together Planck 2018, the Pantheon sample [35] of 1048 Type Ia supernovae (SNIa), Sloan Digital Sky Survey (SDSS) BAO $^ +$ Redshift Space Distortions (RSD), and the Dark Energy Survey (DES) $3 \times 2$ pt data [16,36,37]. We have to note here that SNIa data is similar to BAO in that it is scale-free and cannot directly measure $H _ { 0 }$ nor is Early or Late until its luminosity is calibrated at one end or the other. These lower Hubble constant values are in agreement with previous estimates, when other BAO data [38–40] were included in the dataset combinations (see also Refs. [41–46]). For a flat $\Lambda$ CDM model, the combination of WMAP $^ +$ BAO (6dF Galaxy Survey, MGS, the BOSS DR12 galaxies and the eBOSS DR14 quasars) also gives a lower value $H _ { 0 } = 6 8 . 3 6 _ { - 0 . 5 2 } ^ { + 0 . 5 3 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [47]. Lastly, a combination of galaxy cluster sparsity, cluster gas mass fraction and BAO gives $H _ { 0 } = 6 9 . 6 \pm 1 . 7 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL [48].

By combining the unreconstructed BOSS DR12 galaxy power spectra $P _ { \ell } ( k )$ , modeled using the EFTofLSS, assuming a weak Gaussian prior on the amplitude of the scalar primordial power spectrum $A _ { s }$ centered on the Planck best-fit, and a $\Omega _ { m }$ prior from Pantheon, Ref. [49] finds $H _ { 0 } = 6 5 . 1 _ { - 5 . 4 } ^ { + 3 . 0 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL. In addition, the same analysis is performed with a $\Omega _ { m }$ prior from uncalibrated BAO (6dFGS, MGS, and eBOSS DR14 Lyman- $\alpha$ measurements) giving $H _ { 0 } = 6 5 . 6 _ { - 5 . 5 } ^ { + 3 . 4 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [49]. Finally, considering the combination of $P _ { \ell } ( k )$ with the Planck 2018 CMB-marginalized lensing likelihood [50], and a prior on $A _ { s }$ twice tighter than before, Ref. [49] obtains $H _ { 0 } = 7 0 . 6 _ { - 5 . 0 } ^ { + 3 . 7 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL. This result is shifted and slightly stronger (for the addition of galaxy information) with respect to another sound horizon independent measurement as obtained in Ref. [51], that, analysing the same CMB lensing data from Planck, using conservative external priors on $\Omega _ { m }$ from Pantheon and $A _ { s }$ from Planck 2018, and varying the total neutrino mass, finds $H _ { 0 } = 7 3 . 5 \pm 5 . 3 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL. Finally, for the combination $P _ { \ell } ( k ) + \mathrm { B A O } +$ BBN, Ref. [52] finds $H _ { 0 } = 6 8 . 6 \pm 1 . 1 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL within a $\Lambda$ CDM model plus a total neutrino mass free to vary, using a prior on the physical baryon density $\omega _ { b }$ but neglecting any knowledge on the power spectrum tilt $n _ { s }$ .

Using the latest BAO data, including the eBOSS DR16 measurements [34], and a prior on $\Omega _ { m } h ^ { 2 }$ based on the Planck 2018 best fit in a $\Lambda$ CDM model, Ref. [53] finds $H _ { 0 } = 6 9 . 6 \pm 1 . 8 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL. Considering Pantheon SNIa apparent magnitude $^ +$ DES-3yr binned SNIa apparent magnitude $^ +$ $H ( z )$ + BAO in Ref. [54] the authors find $H _ { 0 } = 6 8 . 8 \pm 1 . 8 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL. In Ref. [55] the authors apply the inverse distance ladder to fit a parametric form of $H ( z )$ to BAO and SNIa data, using priors on the sound horizon at the drag epoch $r _ { d }$ from Planck, obtaining $H _ { 0 } = 6 8 . 4 2 \pm 0 . 8 8 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL, and from WMAP, obtaining $H _ { 0 } = 6 7 . 9 \pm 1 . 0 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL.

It may be worth noting that Early inferences of $H _ { 0 }$ tend to increase (rather than decrease) from the baseline value derived from the Planck 2018 temperature anisotropy data with the inclusion of polarization data, BAO data, or additional freedom in $\Lambda$ CDM (see Figure 1).

2.1.1. CMB − systematics in Planck? The Planck CMB angular spectra provide the most precise constraints on the cosmological parameters. However, as with any experimental measurement, it is not free from systematic errors. Let us therefore briefly discuss here what are these errors and whether they may have a significant impact in the determination of $H _ { 0 }$ under the $\Lambda$ CDM assumption.

First of all, the Planck collaboration [50] presented the results using two different likelihood pipelines for the data at multipoles $\ell > 3 0$ : Plik and CamSpec (now updated in Ref. [56]). It is important to stress here that, while both likelihood codes in principle should use the same measurements, in reality they consider different sky masks and chunks of data. Moreover, they treat foregrounds in a significant different way, especially for what concerns polarization. In the case of Plik, for example, foregrounds and calibration efficiencies are treated by varying 21 additional parameters, while in CamSpec only 9 parameters are varied. This is because in CamSpec, the foregrounds in polarization are subtracted in the map domain, and it does not include the $1 0 0 \times 1 0 0 \mathrm { G } \mathrm { t }$ Hz TT spectrum. The cosmological constraints on $\Lambda$ CDM parameters from Plik and CamSpec differ at most by $0 . 5 \sigma$ in case of the baryon density and just by $0 . 1 \sigma$ for the Hubble constant [50]. While the choice between Plik or CamSpec seems to have little effect in reducing the Hubble tension, it is important to stress that just a different likelihood assumption could in principle shift by $0 . 5 \sigma$ any constraint coming from the CMB.

A more worrying systematic could, on the contrary, be responsible for the so-called

$A _ { \mathrm { l e n s } }$ anomaly. Introduced in Ref. [17], the $A _ { \mathrm { l e n s } }$ parameter is an “unphysical” parameter that simply rescales by hand the effects of gravitational lensing on the CMB angular power spectra, and can be measured by the smoothing of the peaks in the damping tail. For $A _ { \mathrm { l e n s } } = 0$ one has no lensing effect, while for $A _ { \mathrm { l e n s } } = 1$ one simply recovers the value expected in the cosmological model of choice. Interestingly, the Planck CMB power spectra show a preference for $A _ { \mathrm { l e n s } } ~ > ~ 1$ at more than two standard deviations using both Plik and CamSpec. Perhaps, even more interesting is that the inclusion of BAO data provides evidence for $A _ { \mathrm { l e n s } } > 1$ at more than 99% CL (about 99% for the CamSpec likelihood pipeline). Having $A _ { \mathrm { l e n s } } > 1$ can not be easily explained theoretically since it would require either a closed Universe (that would challenge several other datasets and the simplest inflationary models [18]) or even more exotic solutions such as the modifications to GR [11, 57–59]. Moreover, this lensing anomaly is not seen in the Planck trispectrum data (CMB lensing) that offer a complementary and independent measurement. If not due to new physics, the $A _ { \mathrm { l e n s } }$ anomaly is probably due to a small but still undetected systematic error in the Planck data. Can this systematic help in reducing the Hubble tension? The answer is affirmative. When $A _ { \mathrm { l e n s } }$ is included in the analysis, the Planck and Planck $^ +$ BAO constraints on $H _ { 0 }$ are indeed slightly shifted towards higher values to $H _ { 0 } = 6 8 . 3 \pm 0 . 7 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ and $H _ { 0 } = 6 8 . 2 2 \pm 0 . 4 9 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL, respectively, using either Plik or CamSpec. Assuming the Planck constraints, the introduction of $A _ { \mathrm { l e n s } }$ would therefore reduce from $4 . 2 ~ \sigma$ to $3 . 3 \sigma$ the current tension with the R20 constraint of $H _ { 0 } = 7 3 . 2 \pm 1 . 3 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [2].

However, a proper physical interpretation of $A _ { \mathrm { l e n s } }$ is still unavailable. If, indeed, $A _ { \mathrm { l e n s } }$ demands for new physics, then one may actually derive a smaller value of $H _ { 0 }$ from the Planck satellite. In a physical model based on General Relativity (GR), more lensing is now inevitably connected to an increase in the cold dark matter density and this changes the previous constraints. Just as an example, if a closed Universe is the explanation for $A _ { \mathrm { l e n s } } > 1$ , then the Hubble constant from Planck could be as low as $\sim 5 5 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ [11, 18, 19]. Nonetheless, as we discuss in this review, (exotic) modified gravity models have been proposed that could explain at the very same time the Planck lensing anomaly and the Hubble tension. On the other hand, if $A _ { \mathrm { l e n s } }$ is due to systematics, then there is still the question, if the same systematic is fully described by $A _ { \mathrm { l e n s } }$ , or if further extensions are needed and how they could impact the final constraints on $H _ { 0 }$ .

In a few words, one can conclude that systematics in the Planck data (as in any other experimental measurement) could certainly be present and are actually suggested by the $A _ { \mathrm { l e n s } }$ anomaly. However, at the moment, there is no indication for a systematic that could increase the mean value of the Hubble constant from Planck by significantly more than $1 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ under the $\Lambda$ CDM assumption. The Hubble tension, even if weakened in statistical significance, would probably remain.

# 2.2. Late

The best-established and only strictly empirical method to measure $H _ { 0 }$ locally comes from measuring the distance-redshift relation, usually undertaken by building a “distance ladder”. The most often utilized approach is to use geometry (e.g. parallax) to calibrate the luminosities of specific star types (e.g. pulsating Cepheid variables and exploding Type Ia supernovae or SNIa) which can be seen at great distances where their redshifts measure cosmic expansion. Cepheids are most often used to reach distances of $1 0 - 4 0 \mathrm { M p c }$ because they are the brightest objects in the optical with luminosities reaching in excess of 100,000 solar luminosities and offer the highest precision per object of about 3% in distance at a given pulsation period.4 SNIa exceed a billion solar luminosities and are nearly as precise per object but they are rare in any volume, such as the local one, thus often serve as the last rung on the distance ladder. These methods treat stars as empirical, standardized candles, i.e. the premise that once empirically standardized, the same type has the same luminosity, without reference to stellar modeling or astrophysics theory. One may consider the failure of this premise to be anti-Copernican and harder to imagine than a failure of $\Lambda$ CDM!

The Hubble Space Telescope (HST) provided the first capability to measure Cepheids beyond a few Mpc to reach the nearest SNIa hosts (and the hosts of other long-range distance indicators) and the final result of the Hubble Space Telescope Key Project was $( 7 2 \pm 8 ) \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ [61], a result later recalibrated to use improved geometric distance calibration to the Large Magellanic Cloud (LMC) to yield $( 7 4 . 3 \pm$ $2 . 2 ) \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ [62], see also Ref. [63]. However, these efforts were severely limited by the reach of the first generation of Hubble instruments to observing Cepheids in the hosts of just a few well-observed, well-standardizable SNIa.

The SH0ES Project started in 2005 and advanced this approach by

(i) increasing the sample of high quality calibrations of SNIa by Cepheids from a few to 19 (R16) [64],   
(ii) increasing the number of independent geometric calibrations of Cepheids to five (R18) [65] including by extending the range of parallax measurements to Cepheids using spatial scanning of HST,   
(iii) measuring the fluxes of Cepheids with geometric distance measurements and those in supernova hosts with the same instrument to negate calibration errors (R19) [66],   
(iv) measuring Cepheids in the near-infrared to reduce systematics related to dust and reddening laws.

Improved geometric distance estimates to the LMC using detached eclipsing binaries [67], to NGC 4258 using water masers [68] and to Milky Way Cepheids from European Space Agency (ESA) Gaia parallaxes [69] have greatly advanced this work in recent years. The values of $H _ { 0 }$ by this route have ranged between 73 − 4 For a discussion about the cosmological model insensitivity of the local measure of the Hubble constant $H _ { 0 }$ from the Cepheid distance ladder see Ref. [60].

$7 4 \ \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ , with the present status based on the improved ESA Gaia mission Early Data Release 3 (EDR3) of parallax measurements using 75 Milky Way Cepheids with Hubble Space Telescope photometry and EDR3 parallaxes [70], that gives $H _ { 0 } =$ $\mathrm { 7 3 . 2 \pm 1 . 3 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } } }$ at 68% CL [2], in tension at $4 . 2 \sigma$ with the Planck value in a $\Lambda$ CDM scenario. We will refer to this new measurement as R20 and this will be a reference throughout the review. This value is also close to the conservative average (excludes R20) and optimistic average (includes R20) we present later in this section so this is a reasonable overall benchmark.

There have been numerous reanalyses of the SH0ES data using different formalisms, statistical methods of inference, or replacement of parts of the dataset, but none has produced a significant indication of a change in $H _ { 0 }$ . The larger value of $H _ { 0 }$ is seen in the reanalysis of the R16 Cepheid data by using Bayesian hyper-parameters [71] $H _ { 0 } = 7 3 . 7 5 \pm 2 . 1 1 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL, and the local determination of the Hubble constant [72] achieved using the cosmographic expansion of the luminosity distance, that gives $H _ { 0 } \ = \ 7 5 . 3 5 \pm 1 . 6 8 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL. There is a measurement obtained replacing the sample of SNIa measured in the optical with that measured in the near-infrared (NIR) where SNIa are better standard candles [73], i.e. $H _ { 0 } = 7 2 . 8 \pm$ $1 . 6 ( \mathrm { s t a t } ) { \pm } 2 . 7 ( \mathrm { s y s } ) \mathrm { m s } ^ { - 1 } \mathrm { M p c } ^ { - 1 }$ at 68% CL. Other measurements based on the CepheidsSNIa include Ref. [74], that finds $H _ { 0 } = 7 3 . 2 \pm 2 . 3 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL, analysing the final data release of the Carnegie Supernova Project I and a different method for standardizing SNIa light curves. A number of reanalyses including a notable one that leaves the reddening laws in distant galaxies uninformed by the Milky Way is performed in Ref. [75], that finds $H _ { 0 } = 7 3 . 3 { \pm } 1 . 7 { \mathrm { k m } } { \mathrm { s } } ^ { - 1 } { \mathrm { M p c } } ^ { - 1 }$ at 68% CL. These are in agreement with R16, showing that systematic bias or uncertainty in the Cepheid calibration step of the distance ladder measurement can not explain the Hubble tension. Reference [76] produces an estimate of the Hubble constant based on a Bayesian hierarchical model of the local distance ladder, that gives $H _ { 0 } = 7 3 . 1 5 \pm 1 . 7 8 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL, allowing outliers to be modeled. These measurements generally made use of the Cepheid photometry presented by the SH0ES Team. However, the previously cited result for $H _ { 0 }$ of $7 4 . 3 \pm 2 . 2 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ from Ref. [62] used an independent set of Cepheid data from that of the SH0ES Team, obtained with different instruments on HST, and with photometry measured with different algorithms (and by different investigators) which removes the dependence of the tension on any one set of Cepheid measurements. Similarly, Ref. [77] has undertaken a complete reanalysis of SH0ES Cepheid measurements starting at the pixel level from the Hubble Space Telescope data and using different methods for measuring Cepheid photometry, correcting for bias, developing new Cepheid light curve templates, etc, and the result agreed with the prior SH0ES analysis in R16 to 0.5 $\sigma$ or 0.02 mag ( $1 \%$ in distance) indicating that the measurements are robust.

Using the Gaia Data Release 2 parallaxes [78] of Cepheid companions (in binaries or host clusters rather than of the Cepheids themselves) to obtain a Galactic calibration of the Leavitt law in the V, J, H, $K _ { S }$ , and Wesenheit $W _ { H }$ bands, it is possible to derive a Hubble constant measurement anchored to Milky Way Cepheids. When all Cepheid companions are considered, the authors in Ref. [79] obtain $H _ { 0 } = 7 2 . 8 \pm 1 . 9 ( \mathrm { s t a t + s y s } ) \pm$ 1.9(parallax zero−point) $\mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL.

There have been alternative distance ladders which substitute another type of star for Cepheids. There are such measurements obtained using the Tip of the Red Giant Branch (TRGB) in lieu of Cepheids, performed by different teams, and these are in the range of $\mathrm { \sim 7 0 { - } 7 2 ~ \ k m s ^ { - 1 } M p c ^ { - 1 } }$ . We have the 2017 measurement of the Hubble constant based on the calibration of the SNIa using the TRGB obtained by Ref. [80], that is $H _ { 0 } ~ = ~ 7 1 . 1 7 \pm 1 . 6 6 ( \mathrm { r a n d o m } ) \pm 1 . 8 7 ( \mathrm { s y s } ) \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL. There is the 2019 determination made by Ref. [81] which measures TRGB in a nine SNIa hosts, adds 5 from [80], and calibrates TRGB in the LMC which yields $H _ { 0 } ~ = ~ 6 9 . 8 \pm 0 . 8 \mathrm { ( s t a t ) } \pm 1 . 7 \mathrm { ( s y s ) } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL and Ref. [82] (F20), for which $H _ { 0 } ~ = ~ 6 9 . 6 \pm 0 . 8 \mathrm { ( s t a t ) } \pm 1 . 7 \mathrm { ( s y s ) } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL, or the same but with a different accounting of the LMC extinction of the TRGB using reddening maps derived from Red Clump stars by [83] gives $H _ { 0 } = 7 2 . 4 \pm 2 . 0 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL. A value of $H _ { 0 } \sim 7 2 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ also results from the revised OGLE Team LMC reddening maps [84, 85]. The addition of two new TRGB measurements in NGC 1404 and NGC 5643, host to 4 SNIa [86] appears to raise the F20 value of $H _ { 0 }$ by ${ \sim } 1 \%$ to $\mathrm { \sim 7 0 ~ k m s ^ { - 1 } M p c ^ { - 1 } }$ but the revised value is not tabulated. Even the lower mean value from F20 from the higher LMC extinction gives $H _ { 0 }$ measurements in agreement with both Planck and R20 estimates within 95% CL, and therefore can not discriminate between the two. Furthermore, if the luminosity of SNIa is calibrated with the TRGB luminosity, that is, calibrated with the Gaia EDR3 trigonometric parallax of Omega Centauri, in Ref. [85] is obtained the Hubble constant $H _ { 0 } = 7 2 . 1 \pm 2 . 0 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL. Another determination of $H _ { 0 }$ using velocities and TRGB distances to 33 galaxies located between the Local Group and the Virgo cluster is given by Ref. [87] and it is equal to $H _ { 0 } = 6 5 . 9 \pm 3 . 5 ( \mathrm { s t a t } ) \pm 2 . 4 ( \mathrm { s y s } ) \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL, i.e. in agreement with both Planck and R20 within $2 \sigma$ .

An alternative to either Cepheids or TRGB is MIRAS (variable red giant stars) [88]. These stars come from older stellar populations than Cepheid variables and have been calibrated directly in the maser host, NGC 4258 and used to calibrate SNIa in the host NGC 1559, to yield $H _ { 0 } = 7 3 . 3 \pm 4 . 0 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL.

There has been some discussion of whether the SNIa used at either ends of the distance ladder are consistent because of the possibility of differences in the SNIa environments and related impact on their luminosity (Refs. [89–91]). Such differences will depend on the specific samples used to measure $H _ { 0 }$ . In Ref [92] the authors analysed the residual, host dependencies on the sample used by the SH0ES Team and found expectable deviations in $H _ { 0 }$ at the level of $0 . 3 \%$ and thus which do not appear to encompass a large fraction of the difference.

There are also distance ladders which substitute SNIa for another long range indicator calibrated by Cepheids and TRGB such as the use of the Surface Brightness Fluctuations (SBF) method, which gives $H _ { 0 } ~ = ~ 7 0 . 5 0 \pm 2 . 3 7 ( \mathrm { s t a t } ) \pm$

$3 . 3 8 ( \mathrm { s y s ) k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [93] from legacy SBF data and $H _ { 0 } = 7 3 . 3 \pm 0 . 7 \pm$ $2 . 4 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL [94] from a new sample of NIR data from HST. Moreover, in Ref. [94] a reanalysis of the result obtained by Ref. [93] is performed, improving the LMC distance, and finding $H _ { 0 } = 7 1 . 1 \pm 2 . 4 ( \mathrm { s t a t } ) \pm 3 . 4 ( \mathrm { s y s } ) \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL. Likewise is the use of Tully-Fisher Relation, i.e. on the correlation between the rotation rate of spiral galaxies and their absolute luminosity, used to measure the distances after calibration from TRGB and Cepheids. Considering the optical and the infrared bands, Ref. [95] finds $H _ { 0 } ~ = ~ 7 6 . 0 \pm 1 . 1 ( \mathrm { s t a t } ) \pm 2 . 3 ( \mathrm { s y s } ) \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL, while using the Baryonic Tully-Fisher relation, Ref. [96] finds $H _ { 0 } \ =$ $7 5 . 1 \pm 2 . 3 ( \mathrm { s t a t } ) \pm 1 . 5 ( \mathrm { s y s } ) \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL. Lastly, the authors of Ref. [97] have presented another measurement of $H _ { 0 }$ independent of SNIa using Type II supernovae (SN II) as standardisable candles, providing the result $H _ { 0 } = 7 5 . 8 _ { - 4 . 9 } ^ { + 5 . 2 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL. A further Hubble constant determination is given in Ref. [98], that uses as a standard candle the relation between the integrated $\mathrm { H } \beta$ line luminosity and the velocity dispersion of the ionized gas of HII galaxies and giant HII regions, finding $H _ { 0 } = 7 1 . 0 \pm 2 . 8 ( \mathrm { r a n d o m } ) \pm 2 . 1 ( \mathrm { s y s } ) \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL.

Finally, the Megamaser Cosmology Project (MCP) [99] measures the Hubble constant using geometric distance measurements to six Megamaser-hosting galaxies. This approach avoids any distance ladder (i.e. multiple objects) by providing geometric distance directly into the Hubble flow and finds $H _ { 0 } = 7 3 . 9 { \pm } 3 . 0 \mathrm { k m } \mathrm { s } ^ { - 1 } \mathrm { M p c } ^ { - 1 }$ at 68% CL for maser host redshifts in the CMB rest frame, and a value of a few higher or lower for different methods of mapping peculiar velocities. The use of the 2M++ peculiar velocity maps in particular gives a value that is lower than this by $\mathrm { \sim 2 { - } 3 \ k m s ^ { - 1 } M p c ^ { - 1 } }$ [100].

The above methods have been fully or largely empirical and we may view these as being largely independent of astrophysical modeling other than the assumptions of a FLRW metric for computing distances. Although the systematic uncertainty of the distance ladder measurement has also been debated, recent surveys including various $H _ { 0 }$ measurements robustly conclude that the discrepancy in the value of $H _ { 0 }$ between early- and late-Universe observations ranges between $4 \sigma$ and $6 \sigma$ [101–103]. The distance ladder method also seems to be insensitive to the choice of the cosmology underlying Cepheids calibration [75]. Now we consider Late Universe approaches to measuring $H _ { 0 }$ with some dependence on astrophysical modeling problems, though the models are not the same as $\Lambda$ CDM.

2.2.1. (Astrophysical) Model-Dependent: Methods that make use of significant astrophysical input (rather than strict empirical fitting) present additional challenges to the quantification of systematic uncertainties. In these cases one must measure the allowed theory space using a wide range of plausible, if not preferable assumptions. This is not common to such analyses which often use “one that works”. However, there have been great recent strides in quantifying the systematic uncertainty due to astrophysical inputs.

The time delays seen for strongly lensed images and their different path lengths can be modeled to measure the Hubble constant, though model-dependence results from imperfect knowledge of the foreground and lens mass distributions, i.e. how and where the dark matter is distributed between the observed and the image plane. The mass distribution problem is not settled and has a significant role in the inference of $H _ { 0 }$ in this approach. Assuming lens models where the lens mass follows either a powerlaw or a Navarro-Frenk-White (NFW) [104] profile plus stars distribution, the most conventional assumption, the H0LiCOW ( $H _ { 0 }$ Lenses in COSMOGRAIL’s Wellspring) experiment [105] uses the time-delay in strong lensing to perform a cosmographic analysis of multiply-imaged quasars, improving the Hubble constant measurement from $H _ { 0 } = 7 1 . 9 _ { - 3 . 0 } ^ { + 2 . 4 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL in 2016 [106], to $H _ { 0 } = 7 2 . 5 _ { - 2 . 3 } ^ { + 2 . 1 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL in 2018 [107], and to $H _ { 0 } = 7 3 . 3 _ { - 1 . 8 } ^ { + 1 . 7 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL in 2019 [108]. A reanalysis of H0LiCOW’s four lenses, which have both measurements of time-delay distance and distance inferred from stellar kinematics, has been performed in Ref. [109], that finds $H _ { 0 } = 7 3 . 6 5 _ { - 2 . 2 6 } ^ { + 1 . 9 5 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL. A blind time-delay cosmographic analysis for the strong lens system DES $J 0 4 0 8 - 5 3 5 4$ (STRIDES) is instead presented in Ref. [110] and, assuming a flat $\Lambda$ CDM cosmology, gives $H _ { 0 } = 7 4 . 2 _ { - 3 . 0 } ^ { + 2 . 7 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL. Compressing the cumulative distribution function of time-delays using Principal Component Analysis, fitting a Gaussian Processes Regressor, and assuming a flat Universe, the fit of 27 doubly-imaged quasars results in $H _ { 0 } = 7 1 _ { - 3 } ^ { + 2 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [111]. The combination of 6 lenses from H0LiCOW and 1 from STRIDES (called TDCOSMO) and a power-law model measures $H _ { 0 } = 7 4 . 2 \pm 1 . 6 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL [112]. However, without the use of conventional, locally determined priors on the lens mass distribution, the constraints become weaker and relatively undiscriminating such as those from TDCOSMO giving $H _ { 0 } = 7 4 . 5 _ { - 6 . 1 } ^ { + 5 . 6 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [113], or TDCOSMO $^ +$ SLACS analysis, where knowledge of the mass distribution in galaxies is discarded and replaced with that inferred from a specific set of galaxies, the SLACS sample of 33 strong gravitational lenses. This route places only weak constraints on the lens mass profiles and finds $H _ { 0 } = 6 7 . 4 _ { - 3 . 2 } ^ { + 4 . 1 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [113]. Its mean value is more similar to the one of Planck 2018, but in agreement with R20 at $1 . 3 \sigma$ , i.e. unable to discriminate between the two measurements now, but it is expected to be able to resolve the Hubble tension at $3 - 5 \sigma$ in the future [114] with the use of kinematic information to constrain the mass profiles. Another time-delay strong lensing measurement of the Hubble constant has been obtained analysing 8 strong lensing systems in [115], and is equal to $H _ { 0 } = 7 1 . 8 _ { - 3 . 3 } ^ { + 3 . 9 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL. An alternative use of lensing is to observe time delays of SN images behind a combination of a cluster lens and galaxy lens. Unfortunately, only one such object has been seen, SN Refsdal [116], and the uncertainty per object in $H _ { 0 }$ is large, 7% to $1 0 \%$ and most sensitive to the model of the mass distribution in the cluster and nearest galaxy and “blind” predictions of new images of Refsdal by different models did not statistically agree to within their errors [117].

A determination of $H _ { 0 }$ which is independent of late-time behavior of $\Lambda$ CDM has been obtained in [118] from strongly lensed quasar systems from the H0LiCOW program and Pantheon SNIa compilation using Gaussian process regression, estimating $H _ { 0 } = 7 2 . 2 \pm 2 . 1 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL. An updated result using the H0LiCOW dataset consisting of six lenses [119] gives instead $H _ { 0 } = 7 2 . 8 _ { - 1 . 7 } ^ { + 1 . 6 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL.

There are also estimates of the Hubble constant based on determining the change in age of the oldest elliptical galaxies as a function of redshift, so-called “Cosmic Chronometers” (CC). Such galaxies are demonstrated to be largely “passively” evolving [120] (i.e. stars form in one episode and then simply age) so that the oldest age at given redshifts may be directly equated with the change in the age of the Universe between those redshifts. Spectra of these galaxies are used to measure the 4000 angstrom break whose size has been modeled to depend on age but also depends on metallicity, and star formation history, but it is weakly dependent on the initial mass function. The break occurs due to the superposition of the spectral energy distribution of older stars where absorption features just blueward of the break produce the appearance of a jump. Stars of different masses and with different metallicities produce different depths of absorption and hence contributions to the break. The relation between the size of the break and age, metallicity and star formation history (i.e. how many stars of what range of mass form how often) is given by a stellar population synthesis model (summing stellar spectra in proportion to an estimated interstellar mass function, i.e. the initial ratios of small to large stars). Assuming the correct mean metallicity and functional form of the star formation history (and negligible residual star formation), the aging, $\mathrm { d } t$ , is estimated across the change in redshift $\mathrm { d } z$ where $H ( z )$ is proportional to $\mathrm { d } z / \mathrm { d } t$ and the value at $z = 0$ may be estimated. In principle there is a great deal of astrophysics involved in this estimate including the time scale of star formation (exponential decline rate, truncation, new potential episodes due to refueling from mergers, etc), the estimation of metallicity with redshift, the spectral energy distribution of stars at a given metallicity and their initial mass function, both as a function of redshift, and questions related to alterations in the passive model due to merging and downsizing of galaxies. However, it has been shown in Ref. [121] that the spectra have enough information to largely constrain both the metallicity and the star formation history (especially in super red galaxies as shown in Ref. [122]), while the initial mass function has still to be assumed. This method is ultimately challenging to independently test (e.g. with null tests to see if they can recover known aging as can be done for distance indicators comparing them to each other) $^ { 5 }$ but new ideas may help.

Because this idea is new, there has not yet been enough independent effort to produce such measurements of $H ( z )$ , as all are sourced from the same compilation, to adequately sample the variance of the model space. This situation appears to be improving as an initial effort to quantify these systematics has been done by Ref. [121] demonstrating systematic uncertainties most limited by stellar libraries and metallicity

5 See along this line Ref. [123], where CC measurements of $H ( z )$ were provided before the BAO ones and are in very good agreement, except for the overall normalisation if BAO are calibrated using the sound horizon of Planck’s ΛCDM, while CC bounds are cosmology independent [124].

ranging from 5% to $1 5 \%$ in $H ( z )$ . However, many earlier measurements were based on a single model of stellar population synthesis [125] and did not consider all of the modeling uncertainties. A recent analysis [121] that incorporates the systematic uncertainty shows that the uncertainty in $H _ { 0 }$ is $\sim 6 \%$ if one incorporates the systematic errors (on diagonal) and 8% (optimistic scenario that excludes worst model) after including the covariance of these uncertainties across redshift. The uncertainty from transforming these measures from $H ( z )$ to $H _ { 0 }$ is an additional $\sim 4 \%$ for a total uncertainty in $H _ { 0 }$ with present data of 9%.

An additional concern is sample selection bias. Because the value of $H _ { 0 }$ in early studies appeared to have some dependence on the mass range of the galaxies [126] seen at low redshift in SDSS data, it is important to correct surveys for mass incompleteness bias when harvesting passive galaxies from higher redshift surveys which will be more severely magnitude limited (easier to find more massive galaxies at a given redshift and a noisy measurement of mass is more likely higher of higher mass at higher redshift where the volume is greater). These measurements with the same data compilation, often in conjunction with other probes and different redshift space interpolation generally finds $H _ { 0 } = 6 6 - 7 3 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ and an uncertainty of $6 ~ \mathrm { k m ~ s } ^ { - 1 } ~ \mathrm { M p c } ^ { - 1 }$ following the inclusions of systematic uncertainties [126–136].6 It is probably safe to say at present this technique does not weigh heavily on the Hubble tension.

There is an estimate of $H _ { 0 }$ based on modeling the extragalactic background light and its role in attenuating $\gamma$ -rays that yields [138], i.e. $\begin{array} { r l } { H _ { 0 } } & { { } = } \end{array}$ $7 1 . 8 _ { - 5 . 6 } ^ { + 4 . 6 } ( \mathrm { s t a t ) _ { - 1 3 . 8 } ^ { + 7 . 2 } ( \mathrm { s y s ) k m s ^ { - 1 } M p c ^ { - 1 } } }$ at $6 8 \%$ CL, and the updated value [139], i.e. $H _ { 0 } = 6 7 . 4 _ { - 6 . 2 } ^ { + 6 . 0 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL. However, the extragalactic background light is challenging to model and plays a dominant role in this approach. Finally, Ref. [140], combining the observations of ultra-compact structure in radio quasars and strong gravitational lensing with quasars acting as background sources, finds in a flat Universe $H _ { 0 } = 7 3 . 6 _ { - 1 . 6 } ^ { + 1 . 8 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL.

In Ref. [141], using X-ray and Sunyaev-Zel’dovich (SZ) effect signals measured with Chandra, Planck and Bolocam for a sample of 14 massive, dynamically relaxed galaxy clusters, $H _ { 0 } = 6 7 . 3 _ { - 1 3 . 3 } ^ { + 2 1 . 3 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL is obtained including the temperature calibration uncertainty, while $H _ { 0 } = 7 2 . 3 { \pm } 7 . 6 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL only statistically.

In Ref. [102] it has been pointed out that if some of the late Universe measurements are averaged together, by not considering each time a different method or geometric calibration or team, the Hubble constant tension between these averaged values and Planck will range between $4 . 5 \sigma$ and $6 . 3 \sigma$ . In particular, in Ref. [101] an optimistic average of the late time Universe measurements gives $H _ { 0 } = 7 3 . 3 \pm 0 . 8 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL, and in Ref. [103] $H _ { 0 } = 7 2 . 9 4 \pm 0 . 7 5 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL, showing a $5 . 9 \sigma$ level of disagreement with the standard $\Lambda$ CDM model. A conservative estimate may be made by leaving out the most precise and most model-dependent results, i.e. excluding the measurements based on Cepheids-SNIa and Time-Delay Lensing, and gives $H _ { 0 } = 7 2 . 7 \pm 1 . 1 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [103]. In fact, even if multiple and/or unrelated systematic errors in the different experiments could be present (see for example the discussion in Refs. [142–144]), it seems unlikely these can resolve the Hubble tension, lowering all the late time measurements to agree with the early ones.

2.2.2. Standard Sirens: An approach that does not require any form of cosmic distance ladder (see Ref. [61]) is the combination of the distance to the source inferred purely from the gravitational-wave signal, with the recession velocity inferred from measurements of the redshift using electromagnetic data. Gravitational-waves (GW) can therefore be used as standard sirens to estimate the luminosity distance out to cosmological scales directly, without the use of intermediate astronomical distance measurements. Unfortunately, there has only been one high-confidence event to date, GW170817, and it is too nearby ( $z < 0 . 0 1$ ) to yield a good constraint on the Hubble expansion, though it has been attempted many times yielding results that sit between the Early and Late and with large uncertainties that encompass both. The authors of Ref. [145] have used the detection of the GW170817 event in both gravitational waves and electromagnetic signals to determine $H _ { 0 } ~ = ~ 7 0 . 0 _ { - 8 . 0 } ^ { + 1 2 . 0 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL. In Ref. [146] the authors showed that, introducing a peculiar velocity correction for GW sources, the GW170817 event, combined with the Very Large Baseline Interferometry observation, gives $H _ { 0 } = 6 8 . 3 _ { - 4 . 5 } ^ { + 4 . 6 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL. Other constraints on the Hubble constant are those presented in Refs. [147–149]. These bounds assume that the event “ZTF19abanrhr”, reported by the Zwicky Transient Facility, is identified as the electromagnetic counterpart of the observed black hole merger GW190521, but such an association is still controversial [150]. Another interesting observables are the so-called “dark sirens”, i.e. compact binaries coalescences without electromagnetic counterpart, from LIGO/Virgo, that give $H _ { 0 } ~ = ~ 7 5 _ { - 2 2 } ^ { + 2 5 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL alone [151], or $H _ { 0 } = 7 0 _ { - 7 } ^ { + 1 1 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [151] in combination with GW170817.

2.2.3. Systematics: It is hard to conceive of a single type of systematic error that would apply to the measurements of the disparate phenomena reviewed above as to effectively resolve the Hubble constant tension. We stress that the high quality of the measurements of the last decade demand a specific hypothesis for the nature of such a systematic that can be tested against the data rather than a non-specific statement of “unknown unknowns” which makes no testable predictions. We may consider greatly underestimated experimental errors in this same category as measurement error is as integral to the experiments as the measured value. Because the tension remains with the removal of the measurements of any single type of object, mode or calibration (e.g. SNIa, Cepheids, CMB, the distance to the LMC, etc) it is challenging to devise a single error that would suffice and we are not aware of a specific proposal that is not ruled out by the data. Of course multiple, unrelated systematic errors have a great deal more flexibility to resolve the tension but become less likely by their inherent independence. It is beyond the scope here to consider and review all such possible combinations. Such a resolution might argue for a true value of $H _ { 0 }$ “in the middle”, e.g. $\mathrm { \sim 7 0 ~ k m s ^ { - 1 } M p c ^ { - 1 } }$ , as the easiest to accommodate, as was the resolution of the 1980’s debate between 50 and 100. However, the analogy with the present situation breaks down because in the past case the tension was within the same types of measurements and at the same redshifts and thus pointed directly to systematics and away from the possibility of cosmological discovery of new physics. Nevertheless it is important to continue to broaden the measurements as a hedge against such a multiple-error scenario.

In summary, we conclude the case for an observational difference between the Early and Late Universe appears strong, is hard to dismiss, and merits an explanation. Even adopting a conservative view of the present situation, the agreement between early and late determinations of $H _ { 0 }$ , to high $\sim 1 \%$ precision, is a critical test of $\Lambda$ CDM, which none have suggested has been passed. Thus it is important to explore what may or may not be discovered if this fundamental test is ever passed.

# 3. The Local Solution and the Sound Horizon Problem

The different $H _ { 0 }$ measurements have motivated the scientific community to look for alternative cosmological scenarios that could reconcile or alleviate the $H _ { 0 }$ tension.7

# 3.1. Inhomogeneous and Anisotropic Solutions

An underdense local Universe, corresponding to the simplest possibility for solving the Hubble constant tension for a sample-variance effect, has been definitely ruled out, because empirical and theoretical estimates of such fluctuations are a factor of $\sim 2 0$ too small. Such a void would need to extend to $z > 0 . 5$ or higher to not be apparent in the Hubble diagram of SNIa or BAO measurements. Considering a large-volume cosmological N-body simulation $^ 8$ to model the local measurements and to quantify the variance due to local density fluctuations and inhomogeneous selection of SNIa, in Ref. [155] it has been found that the extreme underdensity required for such a void is very unlikely to exist in the LSS fluctuations of a $\Lambda$ CDM Universe aside from the conflict with the observations. In Ref. [156] the evidence in the Hubble diagram of large scale outflows caused by local voids has been studied, finding that the SNIa luminosity distance-redshift relation is in disagreement at $4 - 5 \sigma$ with large local underdensities that can explain the Hubble tension. These findings agree with Ref. [157], that concludes that a large local void alone is a very unlikely explanation, and with Ref. [158], where the void matter distribution is described by an inhomogeneous but isotropic LemaˆıtreTolman-Bondi (LTB) metric.

Previous work has questioned the isotropy of the expansion of the Universe by estimating the anisotropy in the Hubble constant from SNIa data [159–161] and from

7 This is a tension which historically has been called the Hubble Tension for ease of comparison but it could have easily been referred to as a sound horizon tension, among other possibilities. The only danger through naming is to neglect correlations and covariances between different measurements. 8 For cosmological N-body simulations, the readers might be interested to Refs. [152–154].

![](images/83807d57d1227461707a98d2e116b1bc4f7b42f97e332d61866d1487f80e0538.jpg)  
Figure 2. Filtered version of Fig. 1 showing the $6 8 \%$ CL constraints of the Hubble constant $H _ { 0 }$ with error bars less than $3 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ for the direct measurements and less than $1 . 5 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ for the indirect estimates. Similar to Fig. 1, the cyan vertical band corresponds to the $H _ { 0 }$ value from SH0ES Team [2] (R20, $H _ { 0 } =$ $\mathrm { 7 3 . 2 \pm 1 . 3 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } } }$ at 68% CL) and the light pink vertical band corresponds to the $H _ { 0 }$ value as reported by $P l a n c k 2 0 1 8$ team [11] within a $\Lambda$ CDM scenario. A dotted vertical line for $H _ { 0 } = 6 9 . 3 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ has been added for a quick visualization of the division for the $H _ { 0 }$ values obtained in the different measurements.

large samples of galaxies and clusters [162,163], coming to diverse conclusions regarding the level of anisotropy. When the Pantheon dataset is analysed, a non-zero anisotropy is found which is mostly due to the non-uniform angular distribution of SNIa in the sample [164].

In Refs. [165, 166], a consistent analysis that does not take into account an underlying FLRW metric has computed the luminosity distance cosmography for a general spacetime under a minimal set of assumptions. This is achieved by a series expansion of the luminosity distance for a general spacetime with no assumptions on the metric tensor and allows to relax the assumptions of an isotropic expansion rate. In this metric-free analysis, the effective deceleration parameter can be negative without the need for a cosmological constant. A direct testing of the geometric assumptions for the FLRW metric using this method has yet to be carried out. This framework has been recently tested against cosmological numerical simulations [167–169].

A different type of inhomogeneity relates to the non-linear time evolution in general relativity. Local inhomogeneities could drive a portion of volume away from an initial “background” FLRW model, which would serve as an approximation to the actual spacetime metric. How well the FLRW metric approximates the actual lumpy spacetime metric, the “fitting problem”, was first discussed in Refs. [170, 171]. Inhomogeneities back-react on the large scale metric to produce an effective stress-energy tensor that adds up to the large scale stress-energy tensor. Different studies that attempt to assess the magnitude of such a backreaction of local structure on large scale cosmological dynamics reach conflicting results [172, 173], with the discrepancy being partly due to the differences in the quantification of backreaction in the different schemes [174]. Various frameworks for investigating the fitting problem have been proposed, see e.g. Refs. [175–180], including the Buchert’s scheme [181–184] which is treated in relation to the Hubble tension in Section 14.3.

# 3.2. The Sound Horizon Problem

In the following sections we will briefly review some of the most discussed models in the literature. Before going through all the possibilities, a word of caution is mandatory here: the solution to the Hubble constant tension can introduce a further disagreement with the BAO data, or the so-called “sound horizon problem”.

The Hubble constant value is estimated from the CMB data, assuming a model, in three passages:

(i) from the measurements of the baryon density and the matter density, derivation of the sound horizon at the CMB last-scattering $r _ { \mathrm { s } } ^ { \ast }$ at redshift $z _ { * }$ ,   
(ii) from the position of the CMB acoustic peaks, derivation of the comoving angular diameter distance to last scattering $D _ { A } ^ { * } = r _ { \mathrm { s } } ^ { * } / \theta _ { s } ^ { * }$ ,   
(iii) from $\begin{array} { r } { D _ { A } ^ { \ast } = \int _ { 0 } ^ { z _ { \ast } } \mathrm { d } z / H ( z ) } \end{array}$ , a derivation of $H ( z )$ is available for all the redshifts $z$ .

BAO data can also provide a measurement of the Hubble constant, since these measurements constrain the product $H r _ { d }$ .9 This implies that in order to be in agreement with the CMB, which requires a low value of the Hubble constant value, the BAO constraints on the sound horizon at the baryon drag epoch lie on the high allowed region, i.e. around 147 Mpc. Contrarily, to be in agreement with R20, BAO data prefer a lower value for the sound horizon, i.e. around 137 Mpc. Therefore, to reach an agreement among all the datasets, both a larger $H _ { 0 }$ value and a lower sound horizon are needed from the CMB assuming a specific model, see Ref. [186].

In Ref. [187] it has been argued that late time dark energy modifications of the expansion history are slightly disfavoured. Instead, in a pre-CMB decoupling scenario, an extra dark energy component can better solve the $H _ { 0 }$ tension. The same thing happens if Modified Gravity modifications are accounted for, see e.g. Ref. [188].

Following this direction, guidance to model building can instead be found in Ref. [189]. If different solutions are divided into post-recombination and prerecombination solutions of the Hubble tension, the post-recombination modifications of the expansion history, such as the $w$ CDM model where the DE equation of state is free to vary (see Section 5.1), do not change the sound horizon, therefore they are unlikely to be a possible direction for fitting all the datasets. More promising are instead the prerecombination solutions, as extra radiation at recombination as parameterized by $N _ { \mathrm { e f f } }$ or an Early Dark Energy component, since these non-standard cosmologies can increase $H _ { 0 }$ while reducing $r _ { \mathrm { s } }$ . Unfortunately, these solutions are unable to solve completely the $H _ { 0 }$ tension with R20 [190].

Many modifications to the $\Lambda$ CDM model have been proposed in order to solve the Hubble constant tension, focusing on the scenarios that can reduce the sound horizon $r _ { \mathrm { s } }$ at recombination. Nevertheless, it has been pointed out in a recent article [191] that models which only reduce $r _ { \mathrm { s } }$ can never fully resolve the Hubble constant tension, if they are expected to be in agreement at the same time with the other cosmological datasets, such as BAO or weak lensing observations. For this very same reason different proposed models in the literature are often classified as either early or late time modifications of the expansion history, in order to take into account the sound horizon problem appearing when BAO data are considered [189, 190].10

“Late time solutions” of the Hubble constant tension refer to the modifications of the expansion history after recombination, that increase the $H _ { 0 }$ value leaving the sound horizon unaltered. These late solutions are well-known for solving successfully the Hubble constant tension, but being in disagreement with the BAO $+$ Pantheon data [189, 190]. In the following sections we shall present some of the most studied models in the literature belonging to this class of solutions.

9 For a study of the Hubble constant tension between CMB lensing and BAO measurements, see Ref. [185].   
10 The BAO data are extracted under the assumption of a $\Lambda$ CDM scenario, and their reliability has been tested for Early Time solutions [192] and dark energy models that can be parameterized by $w _ { 0 } - w _ { a }$ [34]. Therefore, we should be careful in excluding all the Late Time solutions only using this argument (see also Ref. [193]).

We offer a brief comment that some local determinations of $H _ { 0 }$ and constraints on $H ( z )$ that use SNIa (e.g. from SH0ES and Pantheon SNIa) have covariance, sharing SNIa and light curve parameters which define the Hubble expansion at $0 . 0 2 < z < 0 . 1 5$ and that it is not strictly valid to use both constraints simultaneously and independently without proper account of their interdependence [60, 194]. This is likely to have consequences particularly for late-time solutions that allow for a sudden or rapid change in $H ( z )$ at $z ~ < ~ 0 . 1$ which would impact both constraints. There are two approaches that may be used in principle to account for the covariance. One may use an inverse distance ladder starting in the Early Universe to calibrate SNIa in the Hubble flow (in the context of any cosmological model to predict $H ( z )$ ) and thus predict the absolute peak magnitude $M _ { B }$ of SNIa needed to match its empirical calibration from the local distance ladder. However, we caution that the value of $M _ { B }$ derived is specific to a SNIa light curve fitting formalism and therefore it is crucial to measure $M _ { B }$ consistently and to account for the covariance of SNIa data in both the local and Hubble flow samples. Alternatively one may use the SNIa distance ladder to directly calibrate Hubble flow SNe so that their constraining power and covariance are fully contained in the SNIa sample, i.e. a single set of distances, redshifts and their covariance which may then be used to constrain a cosmological or cosmographic model as done in [60]. This approach will be formally included in a future SH0ES $+$ Pantheon data release. A good approximation to this latter approach (neglecting only the SNIa-SNIa data covariance) is to i) subtract from Pantheon distance moduli the quantity $5 \log _ { 1 0 } ( H _ { 0 } / 7 0 . 0 )$ in magnitudes, where e.g. $H _ { 0 } = 7 3 . 2 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ [2] as 70.0 was the Pantheon reference; ii) include covariance between every SN, namely a coherent 1.7% (the uncertainty on $H _ { 0 }$ from the calibration procedure only), which corresponds to a magnitude of 0.037. This later step adds a fixed quantity $( 0 . 0 3 7 ) ^ { 2 }$ to the covariance matrix of errors which is already provided by the Pantheon collaboration. Here we note that the benchmark local $H _ { 0 }$ determination from R21 uses a value of $q _ { 0 } = - 0 . 5 5$ derived from Pantheon, so this approximation is not strictly combining independent information, but any non-pathological alternative expansion of $H ( z )$ consistent with either BAO, SNIa or CMB+ΛCDM would affect $H _ { 0 }$ at the $\leq 1 \%$ level.

“Early time solutions”, instead, modify the expansion history before the recombination period, changing both $H _ { 0 }$ and $r _ { \mathrm { s } }$ in the appropriate direction to solve the Hubble tension and the sound horizon problem simultaneously. Namely, a lower value of the sound horizon $r _ { \mathrm { s } }$ is needed to allow $H _ { 0 }$ to be in agreement with R20 and BAO $^ +$ Pantheon at the same time. This can be achieved by increasing the expansion rate $H ( z )$ before decoupling by, for instance, allowing an energy injection around the recombination epoch [195, 196]. This class of early time solutions is known to be able to alleviate, but not to solve, the $H _ { 0 }$ tension below the $3 \sigma$ significance [190, 197].

Finally, while in Ref. [198] the authors explored a set of 7 assumptions that a model needs to break in order to alleviate the Hubble tension, in Ref. [199] the authors propose the use of new cosmic triangle plots to simultaneously represent independent constraints on key quantities related to the Hubble parameter ( $t _ { U } , \ r _ { \mathrm { s } }$ , and $\Omega _ { m }$ ) useful to find its

solution.

# 4. Early Dark Energy

The presence of a dark energy component during the early evolution of the Universe would affect the clustering of both dark matter and the baryon-photon fluid, suppressing the clustering power on small length-scales [200–202]. These Early Dark Energy (EDE) models are able to solve the Hubble tension, reducing at the same time the sound horizon [203].

Since the EDE component must arise dynamically around the epoch of matterradiation equality, these cosmologies could suffer from a “cosmic-coincidence” problem (see e.g. Ref. [204]). A possibility proposed for solving this fine-tuning is to have EDE generated by a scalar field that conformally couples to neutrinos [205]. Indeed, in this scenario there will be a large injection of energy when neutrinos become non-relativistic, that could be around the time of matter-radiation equality for neutrinos with masses $m _ { \nu } \sim 0 . 2 \mathrm { e V }$ . The model proposed, therefore, exploits a possible natural coincidence. A similar solution to the fine-tuning problem is provided by the early neutrino dark energy model proposed in Ref. [206] (see also previous work of Refs. [207–209]), where the dark energy density is controlled by the value of neutrino mass. Another possibility is instead proposed by Ref. [210], where the onset and ending of EDE are triggered by the radiation-matter transition, solving the fine-tuning. Finally, in Ref. [211] the coincidence problem is solved with an assisted quintessence, showing that this scaling possibility, that naturally explains the EDE, restores the Hubble constant tension.

In Figures 3 and 4 we provide a very useful assessment of the models discussed in this Section 4 in light of the Hubble constant tension, as explained in the Introduction.

# 4.1. Anharmonic Oscillations

An injection of energy at early times (approximately at $z \gtrsim 3 0 0 0$ ), where the dark energy component behaves like a cosmological constant and then dilutes away as radiation, has been shown to be an effective possibility for reducing the $H _ { 0 }$ tension. For example, the authors in Ref. [212] proposed a physical EDE model based on a scalar field $\phi$ with a potential having an oscillating feature of the form [213]:

$$
V ( \phi ) \propto \Big [ 1 - \cos { ( \phi / f ) } \Big ] ^ { n } ,
$$

where $f$ is an unknown energy scale and $n > 0$ . At early times, the scalar field is frozen and behaves like a cosmological constant until it starts to oscillate at a critical redshift $z _ { c }$ , after which it behaves as a fluid with an equation of state $w _ { n } = ( n - 1 ) / ( n + 1 )$ [214]. The energy density parameter and the equation of state of the scalar field as a function of the scale factor $a _ { c } \equiv ( 1 + z _ { c } ) ^ { - 1 }$ at which the transition occurs are, respectively [215]:

![](images/4af585ebb40ddc85a07edcc180809679aab67815f9d1944ed538b51374fcc1a9.jpg)

![](images/d403c8c5c16576c56f7a80f7545fcf369fe40843b4ef19f3ab9cc6352900e7c1.jpg)  
Figure 3. Estimated values of the current matter energy density $\Omega _ { m } h ^ { 2 }$ , Hubble constant $H _ { 0 }$ and sound horizon $r _ { d } h$ in terms of various data points for different models discussed throughout Section 4. The cyan horizontal band corresponds to the $H _ { 0 }$ value measured by R20 [2], the yellow vertical band to the $\Omega _ { m } h ^ { 2 }$ value estimated by Planck 2018 [11] in a $\Lambda$ CDM scenario, and the light green horizontal band to the $r _ { d } h$ value measured by BAO data. The points sharing the same symbol refer to the same model in the same paper, and the different colors indicate a different dataset combination.

![](images/3deb69b1092766b986ae207a1e56ad084d81a751960c78c8031e070680ff4e3b.jpg)  
Figure 4. Whisker plot with the $6 8 \%$ marginalized Hubble constant constraints for the models of Section 4. The cyan vertical band corresponds to the $H _ { 0 }$ value measured by R20 [2] and the light pink vertical band corresponds to the $H _ { 0 }$ value estimated by Planck 2018 [11] in a $\Lambda$ CDM scenario. For each line, when more than one error bar is shown, the dotted one corresponds to the Planck only constraint on the Hubble constant, while the solid one to the different dataset combinations reported in the red legend, in order to appreciate the shift due to the additional datasets.

$$
\begin{array} { l } { \Omega _ { \phi } ( a ) = \frac { 2 \Omega _ { \phi } ( a _ { c } ) } { \left( a / a _ { c } \right) ^ { 3 ( 1 + w _ { n } ) } + 1 } , } \\ { w _ { \phi } ( a ) = - 1 + \frac { 1 + w _ { n } } { 1 + ( a _ { c } / a ) ^ { 3 ( 1 + w _ { n } ) } } . } \end{array}
$$

At early times $a  0$ , the scalar field behaves as a cosmological constant with the equation of state $w _ { \phi } ( a )  - 1$ , while for $a \gg a _ { c }$ we have $w _ { \phi } ( a )  w _ { n }$ . Hence, the energy density is constant at early times, and decays as $a ^ { - 3 ( 1 + w _ { n } ) }$ when the scalar field becomes dynamical [216]. The EDE component dilutes like matter ( $w _ { n } = 0$ ) for $n = 1$ , like radiation ( $w _ { n } = 1 / 3$ ) for $n = 2$ , and faster than radiation for $n \geq 3$ ; for $n \to \infty$ , the scalar field behaves like a stiff fluid with the equation of state $w _ { n } \to 1$ , and corresponds to a scalar “kination” field [217] whose energy density is dominated by its kinetic term and dilutes as $a ^ { - 6 }$ .

The authors of Ref. [212] showed that $n \ = \ 3$ is the solution preferred by the data, and Planck 2015 $+$ CMB lensing $+$ BAO $^ +$ Pantheon $+$ R18 gives $H _ { 0 } \ =$ $7 0 . 6 \pm 1 . 3 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL, solving the Hubble tension within $2 \sigma$ . We should stress here that this result includes the R18 prior on the Hubble constant.

# 4.2. Ultra-Light Axions

Extremely light pseudoscalar particles known as “axions” can arise from various mechanisms such as the breaking of “accidental” symmetries [218,219] or from manifold compactification within string theory [220–224]. We discuss the QCD axion in Section 7.3, while for now we consider an axion-like field $\phi$ of mass $m$ that does not necessarily relate to QCD. Axion-like particles can explain the dark matter observed [225, 226] and, at a different mass scale, they are a candidate for dark energy [227].

Ref. [228] attempts to alleviate the Hubble tension by considering sub-dominant oscillating scalar field moving under a potential inspired by the one that generically arises in string theory for an axion-like field:

$$
V ( \phi ) = m ^ { 2 } f ^ { 2 } \big [ 1 - \cos { ( \phi / f ) } \big ] ^ { n } ,
$$

where $f$ is an energy scale. The axion-like potential is recovered for the case $n = 1$ . A fit to the Planck 2015 $^ +$ CMB lensing $^ +$ BAO $^ +$ Pantheon $+$ R19 datasets gives $H _ { 0 } = 7 1 . 4 9 { \pm } 1 . 2 0 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL for $n = 3$ , and $H _ { 0 } = 7 1 . 4 5 _ { - 1 . 4 0 } ^ { + 1 . 1 0 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL for free $n$ [228], apparently reducing the Hubble tension at one standard deviations. Indeed, as in the previous case, we should stress that the R19 prior is included in the analysis, possibly biasing the final result towards higher $H _ { 0 }$ values.

Although the expressions in Eqs. (1)-(4) share a similar dependence on the field $\phi$ , the results presented in Ref. [228] differ from those in Ref. [212] because in the latter an approximate form of the scalar field evolution equations was used, while the authors in Ref. [228] investigate the scenario by directly solving the linearized scalar field equations without relying on approximations.

An update of these results that considers more recent data is performed in Ref. [229]. In this case, while the fit of a full combination Planck 2018 + CMB lensing $+$ BAO $^ +$ RSD $+$ Pantheon $^ +$ R19 gives $H _ { 0 } = 7 0 . 9 8 \pm 1 . 0 5 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL, in tension at $1 . 3 \sigma$ with R20, also including a prior on the Hubble constant, Planck 2018 data alone provides a value of $H _ { 0 } = 6 8 . 2 9 _ { - 1 . 0 0 } ^ { + 1 . 0 2 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL, in disagreement at $2 . 9 \sigma$ with R20. The authors therefore conclude that this EDE model, apart from showing a disagreement with all current cosmological datasets, does not solve the $H _ { 0 }$ tension. These findings are confirmed by Refs. [230, 231], where additional dataset combinations and model extensions are considered, and in Ref. [232], where Planck

2018 $^ +$ CMB lensing $^ +$ BOSS DR12 gives $H _ { 0 } = 6 8 . 5 4 _ { - 0 . 9 5 } ^ { + 0 . 5 2 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL, with a disagreement at $3 . 3 \sigma$ with R20.

A different conclusion is instead reached in Ref. [233], where the authors revisit the impact of EDE on galaxy clustering using BOSS galaxy power spectra, properly analysed adopting the EFTofLSS, and Planck 2018. They found that the conclusions can change with the choice of priors on the EDE parameter space, and that EDE and $\Lambda$ CDM provide a statistically indistinguishable fits, with almost the same $\chi ^ { 2 }$ , for EFTofLSS $^ +$ Planck 2018 $^ +$ SNIa. Unfortunately, a Bayesian model comparison accounting for the numbers of extra parameters in the EDE model is missing. However, in Ref. [234] the authors analyse the same model, finding for Planck 2018 $^ +$ CMB lensing $^ +$ BAO $^ +$ Pantheon $^ +$ Full Shape (FS) of BOSS DR12 $H _ { 0 } = 6 7 . 7 2 _ { - 1 . 0 0 } ^ { + 0 . 4 2 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL, in disagreement with R20 at $3 . 9 \sigma$ .

In Ref. [235], moreover, it has been pointed out that the 1-parameter EDE cosmology can solve the tension between Planck and R20 and be favoured by the full dataset combination. In particular, Planck 2018 gives $H _ { 0 } = 7 0 . 1 0 _ { - 1 . 6 } ^ { + 1 . 4 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL [235], alleviating the tension with R20 at $1 . 6 \sigma$ , and Planck $2 0 1 8 + \mathrm { C M B }$ lensing + BAO $+$ Pantheon $+$ FS of BOSS DR12 $+$ R19 gives $H _ { 0 } = 7 1 . 7 1 _ { - 0 . 9 5 } ^ { + 1 . 0 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [235], in full agreement with R20.

A complementary analysis is performed in [236], that for Planck 2018 TT (up to $\ell = 1 0 0 0$ ) + SPTPol (TE and EE) $^ +$ SPT Lensing gives $H _ { 0 } = 7 0 . 7 9 { \pm } 1 . 4 1 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL, solving the tension with R20 within $1 . 3 \sigma$ .

Finally, in Ref. [237] it is argued that a mechanism in which an EDE dumps most of its energy content into radiation in the redshift range $z \ = \ \lvert 3 0 0 0 , 5 0 0 0 \rvert$ can solve the Hubble tension, and this might be an observational signal of the Weak Gravity Conjecture.

4.2.1. Dissipative Axion: The authors of Ref. [238] present a concrete realization of a particle physics model for EDE. In more detail, an axion-like particle acts as a dark energy component which mimics EDE at the background level and behaves as a cosmological constant at early times, before decaying to dark gauge bosons through sphaleron processes mediated by a new non-Abelian gauge group. Although in this “dissipative axion” model the Hubble tension can potentially be alleviated, a proper comparison with Planck 2018 data is to date missing.

4.2.2. Axion Interacting With a Dilaton: Another possible realization of the EDE scenario is an axion interacting with a dilaton, as proposed in Ref. [239]. Starting from string theory, the authors showed that the dynamics of an interacting dilatonaxion scenario naturally realizes the EDE potential. Despite its promising potential, a comparison with Planck 2018 data is absent.

# 4.3. Power-Law Potential

In Ref. [240], the authors consider an alternative EDE scenario with a potential of the form:

$$
V _ { n } ( \phi ) = V _ { 0 } \frac { \phi ^ { 2 n } } { 2 ^ { n } } ,
$$

where $V _ { 0 }$ is the amplitude of the potential and $n$ is a power-law index. This potential approximates the anharmonic potential in Eq. (1) in the limit $\phi / f \ll 1$ . A fit to the Planck 2018 TT (up to $\ell = 1 0 0 0$ ) $^ +$ SPTPol (TE and EE) $^ +$ SPTLensing $+ \ S _ { 8 }$ prior (from KiDS, VIKING-450 and DES of [241]) $^ +$ R19 datasets with $n = 3$ gives $H _ { 0 } = 7 3 . 0 6 { \pm } 1 . 2 6 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [240], solving the Hubble tension within $1 \sigma$ . However, since the derived $H _ { 0 }$ value is obtained assuming the R19 prior, it is difficult to properly assess the ability of the model to solve the tension.

# 4.4. Rock ‘n’ Roll

Reference [242] considers a scenario in which a scalar field evolves under a potential of the form $V ~ \propto ~ \phi ^ { 2 n }$ . Depending on the value of the index $n$ , the scalar field asymptotically evolves to either an oscillatory (rocking) behavior or to a rolling solution with a nearly constant equation of state. The presence of the scalar field injects energy close to recombination, effectively reducing the sound horizon and increasing the Hubble constant value. The potential of the model is parameterized as:

$$
V ( \phi ) = V _ { 0 } \left( \frac { \phi } { M _ { \mathrm { P l } } } \right) ^ { 2 n } + V _ { \Lambda } ,
$$

with a constant value of $V _ { 0 }$ and $V _ { \Lambda }$ , and where $M _ { \mathrm { P l } } = 1 / \sqrt { 8 \pi G _ { N } }$ is the reduced Planck mass. Within this model, and for $n = 2$ , the Planck data and the R20 measurement are in better agreement than in the canonical $\Lambda$ CDM framework, provided a modest tuning to justify the absence of lower orders in the potential [242].

Indeed, for this scenario, $P l a n c k 2 0 1 5 + \mathrm { B A O } + \mathrm { P a n t h e o n } + \mathrm { R 1 8 }$ data provides the constraint $H _ { 0 } = 7 0 . 1 _ { - 1 . 2 } ^ { + 1 . 0 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [242], apparently reducing the Hubble tension at $1 . 9 \sigma$ . However, again, we note the presence of the R18 prior in the analysis. An updated analysis is performed in Ref. [234], where Planck 2018 $^ +$ CMB lensing $^ +$ BAO $+$ Pantheon gives $H _ { 0 } = 6 8 . 5 2 _ { - 0 . 8 9 } ^ { + 0 . 5 5 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL, in disagreement with R20 at $3 . 3 \sigma$ .

# 4.5. New Early Dark Energy

In Ref. [243] the authors propose a model in which a first-order phase transition occurs in a dark sector before recombination and avoid to imprint unobserved large-scale anisotropies in the CMB. Such a transition would produces a short phase of New EDE (NEDE) which could address the Hubble tension. Similarly to previously considered mechanisms for ending inflation [244–246], the potential considered involves two scalar

fields and it is of the form:

$$
V ( \psi , \phi ) = \frac { \lambda } { 4 } \psi ^ { 4 } + \frac { 1 } { 2 } \beta M ^ { 2 } \psi ^ { 2 } - \frac { 1 } { 3 } \alpha M \psi ^ { 3 } + \frac { 1 } { 2 } m ^ { 2 } \phi ^ { 2 } + \frac { 1 } { 2 } \tilde { \lambda } \phi ^ { 2 } \psi ^ { 2 } ,
$$

where $\psi$ is the field responsible for the tunneling and $\phi$ is the trigger field required to modulate the tunneling. The parameters of the potential are subject to the restrictions $\alpha ^ { 2 } > 4 \beta \lambda$ and $\beta > 0$ . The background field changes from the cosmological constant equation of state $w _ { \Lambda } = - 1$ to a constant $w _ { \mathrm { N E D E } } ^ { \ast }$ around the time $t _ { \mathrm { t r } }$ . Such a sudden transition can be modeled through the equation of state:

$$
w _ { \mathrm { N E D E } } ( t ) = \left\{ { \begin{array} { l l } { - 1 , } & { \quad \mathrm { f o r } t \leq t _ { \mathrm { t r } } ; } \\ { w _ { \mathrm { N E D E } } ^ { * } , } & { \quad \mathrm { f o r } t > t _ { \mathrm { t r } } , } \end{array} } \right.
$$

where we expect that the NEDE energy density redshifts faster than radiation, as $1 / 3 \le w _ { \mathrm { N E D E } } ^ { * } \le 1$ . In the approximation of a sudden transition, the background energy density evolves as:

$$
\bar { \rho } _ { \mathrm { N E D E } } ( t ) = \bar { \rho } _ { \mathrm { N E D E } } ^ { * } \left( \frac { a ( t _ { * } ) } { a ( t ) } \right) ^ { 3 [ 1 + w _ { \mathrm { N E D E } } ( t ) ] } ,
$$

with a constant parameter $\rho _ { \mathrm { N E D E } } ^ { * }$

A fit to Planck 2018 $^ +$ CMB lensing $^ +$ BAO $^ +$ Pantheon data gives $H _ { 0 } \ =$ $6 9 . 6 _ { - 1 . 3 } ^ { + 1 . 0 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL, reducing the Hubble tension within $2 . 3 \sigma$ [247]. Including R19, the Hubble constant becomes $H _ { 0 } = 7 1 . 4 \pm 1 . 0 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL, with an evidence at $4 \sigma$ for NEDE, and reducing the tension with R20 at $1 . 1 \sigma$ .

# 4.6. Chain Early Dark Energy

Chain EDE proposes an alternative mechanism in which a scalar field tunnels rapidly via a series of first order phase transitions through many ( $N \gg 1$ ) successive metastable minima of ever lower energy. This kind of model was previously employed as a mechanism for inflation [248]. Building on this, an alternative model of EDE called Chain EDE has been proposed in Ref. [249] as a solution to the Hubble constant tension. In the model, the Hubble tension could be resolved without inducing large anisotropies in the CMB by invoking $N \gtrsim 1 0 ^ { 4 }$ such phase transitions [249]. However, a full data analysis for this model is currently missing.

# 4.7. Anti-de Sitter phase

In Ref. [250] the authors propose a phenomenological EDE model with an Anti-de Sitter (AdS) phase around the recombination period as a solution to the Hubble tension. AdS vacua are theoretically important because they naturally emerge within the string theory framework (for late-time AdS see Refs. [251–253]).

This EDE model with an AdS phase will make the energy injection more efficient without spoiling the fit to CMB data. We have $w _ { \mathrm { D E } } > - 1$ when the EDE field rolls down to $V < 0$ . Therefore, $\rho _ { \phi } \sim a ^ { - 3 ( 1 + w ) }$ redshifts very rapidly. In [250] the potential is modeled as:

$$
\begin{array} { r } { V ( \phi ) = \left\{ \begin{array} { l l } { V _ { 0 } \left( \frac { \phi } { M _ { \mathrm { P l } } } \right) ^ { 4 } - V _ { \mathrm { A d S } } , \quad } & { \mathrm { f o r } ~ \frac { \phi } { M _ { \mathrm { P l } } } \leq \left( \frac { V _ { \mathrm { A d S } } } { V _ { 0 } } \right) ^ { 1 / 4 } , } \\ { 0 , \quad } & { \mathrm { f o r } ~ \frac { \phi } { M _ { \mathrm { P l } } } > \left( \frac { V _ { \mathrm { A d S } } } { V _ { 0 } } \right) ^ { 1 / 4 } , } \end{array} \right. } \end{array}
$$

where $V _ { \mathrm { A d S } }$ is the depth of the AdS well.

While a constraint on $H _ { 0 }$ from Planck data alone is missing, Planck 2018 + CMB $\mathrm { l e n s i n g + B A O + P a n t h e o n + R 1 9 }$ gives $H _ { 0 } = 7 2 . 6 4 _ { - 0 . 6 4 } ^ { + 0 . 5 7 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [250] solving the tension within one standard deviation. However, the presence of the R19 Gaussian prior in the analysis makes difficult to assess the consistency between the measurements. An extended model considering the temperature of the CMB $T _ { 0 }$ free to vary has been studied in Ref. [254], finding consistent results.

# 4.8. Graduated Dark Energy

In Ref. [253] the graduated Dark Energy model (gDE) is introduced, inspired by Ref. [255]. A limiting case of the gDE is a sign-switching cosmological constant, that can be appealing from the string theory perspective. Using the Planck information as a BAO data point at redshift $z = 1 0 9 0$ , and using also SNIa JLA [256] $+$ BAO $^ +$ CC measurements, the authors in Ref. [253] argue that this model is in agreement with the local $H _ { 0 }$ measurements. However, a complete and robust data analysis considering the perturbations and the full Planck 2018 data is missing to date.

# 4.9. Acoustic Dark Energy

Acoustic Dark Energy (ADE) has been proposed in Ref. [257] to alleviate the Hubble tension. The authors consider a general phenomenological model of perturbations in a dark fluid which becomes important around matter-radiation equality. The presence of ADE impacts on the CMB through the gravitational effects on the acoustic oscillations. More concretely, ADE consists of a perfect dark fluid specified by its background equation of state $w _ { \mathrm { A D E } } ( a )$ and its rest frame sound speed $c _ { s } ^ { 2 }$ . The ADE equation of state changes around the scale factor $a = a _ { c }$ , ranging from $w _ { \mathrm { A D E } } = - 1$ to $w _ { f }$ as:

$$
w _ { \mathrm { A D E } } ( a ) = - 1 + \frac { 1 + w _ { f } } { [ 1 + ( a _ { c } / a ) ^ { 3 ( 1 + w _ { f } ) / p } ] ^ { p } } ,
$$

where the index $p$ controls the rapidity of the transition, such that small values lead to sharper transitions. For $p = 1$ , the model described in Section 4.1 is obtained. In Ref. [257], the ADE model with $p = 1 / 2$ is analysed by fitting against Planck $2 0 1 5 +$ CMB $\mathrm { 3 \ l e n s i n g + B A O + P a n t h e o n + R 1 9 }$ data, obtaining $H _ { 0 } = 7 0 . 6 0 { \pm } 0 . 8 5 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL [257] and reducing the Hubble tension to $1 . 6 \sigma$ . An updated analysis without the Gaussian prior on the Hubble constant is presented in Ref. [258], where the combination of Planck 2018 $+$ CMB lensing $+$ ACT $^ +$ Pantheon $^ +$ BAO gives

$H _ { 0 } = 6 8 . 5 0 _ { - 0 . 9 3 } ^ { + 0 . 5 5 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL, restoring the tension with R20 at the $3 . 6 \sigma$ level.

4.9.1. Exponential Acoustic Dark Energy: Acoustic Dark Energy in which the equation of state has an exponential dependence on the scale factor (eADE) has been explored in Ref. [259]:

$$
w _ { \mathrm { e A D E } } ( a ) = - 1 + 2 ^ { 1 - \frac { a _ { c } } { 2 a } } ,
$$

where $a _ { c }$ corresponds to the critical scale factor at which the eADE fluid becomes dominant. The equation of state evolves from the value $w = - 1$ before the transition to $w \approx 1$ at present time. The fractional energy density evolves as

$$
\Omega _ { \mathrm { e A D E } } ( a ) = 2 f _ { c } \frac { ( c _ { s } ^ { 2 } + 1 ) ^ { 2 } - ( w _ { \mathrm { e A D E } } ( a ) + 1 ) ^ { 2 } } { ( c _ { s } ^ { 2 } + 1 ) ^ { 2 } } ,
$$

where $f _ { c }$ is the fractional contribution of eADE at $a _ { c }$ , and $c _ { s }$ is the sound speed. For this model, a fit to $P l a n c k ~ 2 0 1 8 + \mathrm { C M B }$ lensing $^ +$ BAO $+$ Pantheon $+$ R19 datasets provides the constraint $H _ { 0 } = 7 1 . 6 5 _ { - 4 . 4 0 } ^ { + 1 . 6 2 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [259], solving within $1 \sigma$ the tension with R20. However, the analysis already includes a Gaussian prior on the Hubble constant.

# 4.10. EDE in $\alpha$ -attractors

In the framework of inflation (see Section 11), it is possible to introduce a class of models that possess an attractor point predicting the value of the scalar spectral tilt $n _ { s }$ and the tensor-to-scalar ratio $r$ , independently from the specific functional form of the inflaton potential $V ( \phi )$ [260–262]. An EDE model can also be extended to include $\alpha$ -attractors, with a potential for the EDE scalar field of the form [263]:

$$
V ( \phi ) = \Lambda + V _ { 0 } \frac { ( 1 + \beta ) ^ { 2 n } \operatorname { t a n h } \left( \phi / \sqrt { 6 \alpha } M _ { \mathrm { P l } } \right) ^ { 2 p } } { \left[ 1 + \beta \operatorname { t a n h } \left( \phi / \sqrt { 6 \alpha } M _ { \mathrm { P l } } \right) \right] ^ { 2 n } } ,
$$

where $V _ { 0 }$ , $p$ , $n$ , $\alpha$ and $\beta$ are constants. The shape of the potential, away from the plateau and around its minimum, regulates the shape of the energy injection and it is thus crucial to successfully alleviate the Hubble tension. For the choice $p = 2$ and $n = 4$ , the scalar field oscillates at the bottom of the potential, making this case more similar to the original EDE proposal [212]. For these values of the model parameters, the analysis of Planck 2018 $^ +$ CMB lensing $^ +$ BAO $^ +$ Pantheon $^ +$ R19 data gives $H _ { 0 } = 7 0 . 9 \pm 1 . 1 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL, softening the tension with R20 down to the $1 . 4 \sigma$ level [263]. Note, however, that this result already incorporates a Gaussian prior in the Hubble constant.

![](images/b6253ee169b917aa3f72f0e300e96b05c6edeb936464cb5c76114d3c245e3228.jpg)  
Figure 5. Estimated values of the current matter energy density $\Omega _ { m } h ^ { 2 }$ , Hubble constant $H _ { 0 }$ and sound horizon $r _ { d } h$ in terms of various data points for different models discussed throughout Section 5. The cyan horizontal band corresponds to the $H _ { 0 }$ value measured by R20 [2], the yellow vertical band to the $\Omega _ { m } h ^ { 2 }$ value estimated by Planck 2018 [11] in a ΛCDM scenario, and the light green horizontal band to the $r _ { d } h$ value measured by BAO data. The points sharing the same symbol refer to the same model in the same paper, and the different colors indicate a different dataset combination.

![](images/0d0b3b1bcad41591c0554fc3755ea4b16300d82968ba22a20c7d7436f1fc7972.jpg)  
Figure 6. Whisker plot with the $6 8 \%$ ( $9 5 \%$ if dashed) marginalized Hubble constant constraints for the models of Section 5. The cyan vertical band shows the $H _ { 0 }$ value measured by R20 [2] and the light pink vertical band corresponds to the $H _ { 0 }$ value estimated by Planck 2018 [11] in a $\Lambda$ CDM scenario. For each line, when more than one error bar is shown, the dotted one corresponds to the Planck only constraint on the Hubble constant, while the solid one to the different dataset combinations reported in the red legend, in order to appreciate the shift due to the additional datasets.

# 5. Late Dark Energy

A dark energy component with a time-varying equation of state $w _ { \mathrm { D E } } ( z ) \equiv p _ { \mathrm { D E } } / \rho _ { \mathrm { D E } }$ modifies the Hubble rate through the first Friedmann equation:

$$
H ^ { 2 } ( z ) = H _ { 0 } ^ { 2 } \left[ \Omega _ { r } ( 1 + z ) ^ { 4 } + \Omega _ { m } ( 1 + z ) ^ { 3 } + \Omega _ { \mathrm { D E } } f ( z ) + \Omega _ { k } ( 1 + z ) ^ { 2 } \right] ,
$$

where

$$
f ( z ) = \exp \left[ 3 \int _ { 0 } ^ { \ln ( 1 + z ) } \mathrm { d } \ln ( 1 + z ^ { \prime } ) ( 1 + w _ { \mathrm { D E } } ( z ^ { \prime } ) ) \right] ,
$$

and $\Omega _ { r }$ , $\Omega _ { m }$ , $\Omega _ { \mathrm { D E } }$ and $\Omega _ { k }$ are the density parameters, evaluated at present time, for radiation, matter (cold dark matter+baryons), dark energy and curvature, respectively, satisfying $\Omega _ { r } + \Omega _ { m } + \Omega _ { \mathrm { D E } } + \Omega _ { k } = 1$ . We have also defined the Hubble rate $H ( z )$ at redshift $z$ as:

$$
H ( z ) \equiv { \frac { 1 } { a ( z ) } } { \frac { \mathrm { d } a } { \mathrm { d } t } } ,
$$

so that at present time $H ( z = 0 ) \equiv H _ { 0 }$ .

In Ref. [264], it has been argued that the Hubble tension can be interpreted as an evidence for a non-constant dynamical dark energy at $3 . 5 \sigma$ (see also Ref. [265]). A different approach aimed at reconstructing the dark energy properties using Gaussian processes constrains the Hubble constant as $H _ { 0 } = 7 3 . 7 8 { \pm } 0 . 8 4 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL, using a joint analysis of the geometrical cosmological probes such as SNIa, CC, BAO, and the H0LiCOW lenses sample [266]. Finally, a reconstruction of the dynamical Dark Energy using the latest measurements has been studied also in Ref. [267].

In Figures 5 and 6 we provide a very comprehensive status of the models discussed in this Section 5 in light of the Hubble constant tension, as explained in the Introduction.

# 5.1. wCDM model

We first consider a model in which the equation of state for the dark energy component is independent of redshift and generally differs from the cosmological constant value, $w _ { \mathrm { D E } } ( z ) \equiv w _ { 0 } \neq - 1$ . This simple extension of $\Lambda$ CDM is referred to as the $w$ CDM model, where “ $w$ ” stands for the equation of state $w _ { 0 }$ . Here, Eq. (16) gives:

$$
f ( z ) = ( 1 + z ) ^ { 3 ( 1 + w _ { 0 } ) } .
$$

For the case $w _ { 0 } = - 1$ , the function $f ( z )$ is also independent of redshift and the dark energy component acts as a cosmological constant of density parameter $\Omega _ { \mathrm { D E } }$ .

A likelihood analysis with Planck 2018 data for this model assumes a constant equation of state for DE, $w _ { 0 } = - 1 . 5 8 _ { - 0 . 3 5 } ^ { + 0 . 1 6 }$ at $6 8 \%$ CL and $H _ { 0 } > 6 9 . 9 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 95% CL [11]. Such a $w$ CDM scenario would therefore solve the $H _ { 0 }$ tension within two standard deviations. The Hubble constant is in fact almost unconstrained in the $w$ CDM scenario, due to the geometrical degeneracy between $w _ { \mathrm { D E } }$ and $H _ { 0 }$ . Therefore, this scenario can perfectly accommodate a Hubble constant in agreement with R20, at the price of a phantom-like dark energy equation of state, i.e. $w _ { 0 } < - 1$ . Such a result implies that the energy density of dark energy is increasing over time, so that the scale factor of the Universe would reach infinity in a finite time and the Universe would end in a “big rip” [268]. In addition, the Hamiltonian of the theory could have vacuum instabilities due to negative kinetic terms. Nevertheless, the reader should keep in mind that despite of these many theoretical problems, there exist models with an effective energy density with a phantom-like equation of state which avoid the aforementioned difficulties, see e.g. Refs. [269–273]. This model is however in tension with additional datasets, and considering Planck 2018 $+$ Pantheon $+$ BAO, the Hubble constant will be $H _ { 0 } = 6 8 . 3 4 \pm 0 . 8 2 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [11], in $3 . 2 \sigma$ tension with R20. Other approaches in the literature that explored the ability of a phantom dark energy to solve the Hubble tension considered a redshift-binned dark energy model [274], a $w$ CDM model in which $w _ { 0 }$ is fixed to some specific values [275], taking into account previously unconsidered systematic effects affecting the SNIa measurements [276], exploiting the $H _ { 0 } \mathrm { ~ - ~ } w _ { 0 }$ degeneracy [277], reanalysing the BOSS DR12 data using the EFTofLSS formalism [278], considering an extreme combination of Hubble measurements [103], and exploring the epoch that possibly sourced the $H _ { 0 }$ tension [231].

# 5.2. $w _ { 0 } w _ { a } C D M$ or CPL parameterization

We now discuss some models in which the equation of state for DE depends on the redshift. Among such models, we first consider the Chevallier - Polarski - Linder parameterization (CPL) [279, 280]:

$$
w _ { \mathrm { D E } } ( a ) = w _ { 0 } + ( 1 - a ) w _ { a } ,
$$

where $a$ is the cosmological scale factor normalized to unity today, $w _ { 0 }$ is the DE equation of state today, and $w _ { a }$ describes its evolution with time. We refer to this scenario as the $w _ { 0 } w _ { a }$ CDM model. For example, if $w _ { a } \ < \ 0$ $\mathit { \Delta } w _ { a } \ > \ 0 )$ , $w _ { \mathrm { D E } } ( a )$ becomes more negative (positive) as we look backwards in time. Within the CPL parameterization, Planck 2018 provides the constraints $w _ { 0 } ~ = ~ - 1 . 2 1 _ { - 0 . 6 0 } ^ { + 0 . 3 3 }$ and $w _ { a } ~ < ~ - 0 . 8 5$ at $6 8 \%$ CL [281],11 and $H _ { 0 } > 6 3 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 95% CL, in agreement with R20 within $2 \sigma$ . However, when additional datasets are considered, Planck 2018 $^ +$ Pantheon $^ +$ BAO gives $H _ { 0 } = 6 8 . 3 5 \pm 0 . 8 4 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [11], in $3 . 2 \sigma$ tension with R20.

Other studies that account how the CPL parameterization of the DE equation of state addresses the Hubble tension explore the $w _ { 0 } w _ { a }$ CDM model by changing the pivot redshift [283], taking into account unconsidered systematic effects affecting the SNIa [276], exploiting the degeneracy between $H _ { 0 }$ and $w _ { \mathrm { D E } }$ [277], considering an extreme combination of Hubble measurements [103], demanding a higher power of polarizations with respect to $\Lambda$ CDM to be in agreement with R19 [284], or showing how this solution worsens the $\Omega _ { m } - \sigma _ { 8 }$ growth tension [285].

11 Such constraints for the DE equation of state parameters are also in agreement with the bounds obtained in Ref. [282] using the abundance of massive Galaxies at high redshifts.

# 5.3. Dark energy in extended parameter spaces

In order to identify the optimal extension of the minimal $\Lambda$ CDM model to alleviate the $H _ { 0 }$ tension, leading to a better fit to observations, one can allow to vary more than one well-motivated cosmological parameters simultaneously. In other words, one should try a combination of parameters that can ameliorate the Hubble tension without considering only one specific mechanism. Indeed, many assumptions and simplifications made in the six parameter description of the $\Lambda$ CDM model may not be fully justified, and perhaps could hide some physical aspects essential in the evolution of the Universe. In a multi-parameter space, the biases introduced by the choice of the model are easily avoided [286–290].

To begin with, the authors consider an 11-parameter space model in which the $\Lambda$ CDM model is augmented by the running of the scalar spectral index $\alpha _ { s }$ , the total neutrino mass $\Sigma m _ { \nu }$ , the effective number of relativistic degrees of freedom $N _ { \mathrm { e f f } }$ (see Section 7 for details), a constant dark energy equation of state $w _ { 0 }$ , and the $A _ { \mathrm { l e n s } }$ parameter [17]. In this scenario, a fit of the 11-parameter space model to the Planck 2018 data results in $H _ { 0 } = 7 3 _ { - 2 0 } ^ { + 1 0 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL, in agreement with R20 within $1 \sigma$ . When additional data are considered, Planck 2018 $^ +$ BAO gives $H _ { 0 } = 6 7 . 9 \pm 1 . 7 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL [289], in $2 . 5 \sigma$ tension with R20, and Planck 2018 + Pantheon gives $H _ { 0 } = 6 6 . 9 \pm 2 . 0 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [289], in $2 . 6 \sigma$ tension.

The $\Lambda$ CDM model can be further extended by considering, instead, a dynamical dark energy equation of state $w _ { \mathrm { D E } } ( z )$ , parameterized by the CPL relation in Eq. (19). This is the same as considering the 11-parameter space model but with a DE equation of state modeled with the CPL relation. In this 12-parameter space, a fit to the Planck 2018 data gives $H _ { 0 } = 7 2 \pm 2 0 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [289], in agreement with R20 within $1 \sigma$ . Again, the results prefer a phantom-like DE at more than three standard deviations. When additional data are considered, Planck 2018 $^ +$ BAO gives $H _ { 0 } = 6 4 . 8 _ { - 2 . 9 } ^ { + 2 . 5 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [289], in $3 \sigma$ tension with R20, and Planck 2018 $^ +$ Pantheon gives $H _ { 0 } = 6 6 . 8 \pm 2 . 1 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [289], in $2 . 6 \sigma$ tension.

# 5.4. Dynamical dark energy parameterisations with two free parameters

Dynamical dark energy parameterizations with two free parameters have been extensively studied in the literature, see for instance [279, 280, 291–307]. Apart from the most well known dynamical dark energy prescribed by the CPL parameterization with two free parameters [279, 280, 291], some other two-parameter parameterizations have recently been confronted with the latest Planck 2018 data in Ref. [281], namely:

• The JBP parameterization of the dark energy equation of state proposed by JassalBagla-Padmanabhan [295]:

$$
w _ { \mathrm { D E } } ( a ) = w _ { 0 } + w _ { a } a \left( 1 - a \right) ,
$$

that, when analysed in light of Planck 2018 measurements, provides $\begin{array} { r l } { H _ { 0 } } & { { } = } \end{array}$

$8 5 _ { - 7 } ^ { + 1 3 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL, while Planck 2018 + BAO gives $\begin{array} { r l } { H _ { 0 } } & { { } = } \end{array}$ $6 7 . 4 _ { - 2 . 9 } ^ { + 1 . 9 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL.

• The Logarithmic dark energy equation of state parameterization proposed by Efstathiou [292]:

$$
w _ { \mathrm { D E } } ( a ) = w _ { 0 } - w _ { a } \ln a ,
$$

for which the Planck 2018 data analysis results in a value of the Hubble constant $H _ { 0 } ~ = ~ 8 3 _ { - 8 } ^ { + 1 5 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL, while Planck 2018 $^ +$ BAO gives $H _ { 0 } \ =$ $6 4 . 8 \pm 2 . 1 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL.

• The BA parameterization proposed by Barboza and Alcaniz [298]:

$$
w _ { \mathrm { D E } } ( a ) = w _ { 0 } + w _ { a } \left( \frac { 1 - a } { 2 a ^ { 2 } - 2 a + 1 } \cdot \right) ,
$$

for which the Planck 2018 data analysis results in a value of the Hubble constant $H _ { 0 } ~ = ~ 8 3 _ { - 8 } ^ { + 1 5 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL, while Planck 2018 $^ +$ BAO gives $H _ { 0 } \ =$ $6 5 . 2 _ { - 2 . 8 } ^ { + 2 . 2 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL.

All of the parameterizations above are in agreement with R20 within $2 \sigma$ for Planck 2018 only, while for Planck $2 0 1 8 + \mathrm { B A O }$ are in tension at $2 . 5 \sigma$ , $3 . 4 \sigma$ and $3 . 1 \sigma$ , respectively.

# 5.5. Dynamical dark energy parameterizations with one free parameter

Compared to the dynamical dark energy parameterizations with two free parameters, there are only a few dynamical dark energy parameterizations with one free parameter [308, 309]. However, some recent investigations clearly demonstrate that dynamical dark energy parameterizations with a single parameter are very effective in alleviating the Hubble tension (see Ref. [309]).

The models considered in [309] are reported in Table 1, together with their results on the value of $H _ { 0 }$ are all at 68% CL. Note, that $w _ { 0 }$ is the present value of the dark energy equation of state, that means $w _ { 0 } = w _ { \mathrm { D E } } ( a = 1 )$ .

All the models considered in Ref. [309] are in agreement with R20 within $1 \sigma$ for Planck 2015 only, always at the price of a phantom dark energy equation of state today, and within $2 . 6 \sigma$ for Planck 2015 + BAO $^ +$ JLA. However, a re-analysis with the most recent Planck 2018 dataset is still missing in the literature.

# 5.6. Metastable dark energy

Another possibility to solve the Hubble constant problem relies on metastable DE models, where the DE energy density can decay or increase depending only on its intrinsic nature and not on the external parameters [310–314]. In the simplest model of metastable DE, the DE energy density evolves as [310, 311]:

$$
\frac { \mathrm { d } \rho _ { \mathrm { D E } } } { \mathrm { d } t } = - \Gamma \rho _ { \mathrm { D E } } ,
$$

Table 1. The models considered in Ref. [309] and the Hubble constant obtained by analysing the Planck 2015 data and its combination with BAO and JLA.   

<html><body><table><tr><td></td><td>Model Equation of state</td><td>Hubble constant Ho</td><td></td></tr><tr><td>i)</td><td>WDE(a) = wo exp(a - 1)</td><td>Planck 2015 74±11 km s-1 Mpc-1</td><td>+ BAO + JLA 69.2±10 km s-1 Mpc-1</td></tr><tr><td>ii)</td><td>WDE(a) = woa[1 -log(a)]</td><td>81±² kms-1 Mpc-1</td><td>69.0±1.1 kms-1 Mpc-1</td></tr><tr><td>ii)</td><td>WDE(a) = woaexp(1 - a),</td><td>84+10 kms-1 Mpc-1</td><td>69.4 ± 1.0 km s-1 Mpc-1</td></tr><tr><td>iv)</td><td>WDE(a)= woa[1 + sin(1 - a)]</td><td></td><td>84.3k1</td></tr><tr><td>v)</td><td>WDE(a)= woa[1 + arcsin(1-α)] 83±12 kms-1 Mpc-1</td><td></td><td>69.6±1.2 kms-1 Mpc-1</td></tr></table></body></html>

where $\Gamma$ is a constant decay rate and $t$ denotes cosmic time. The equation of state obtained from Eq. (23) is:

$$
w _ { \mathrm { D E } } = - 1 - \frac { 1 } { 3 H } \frac { \mathrm { d } \ln \rho _ { \mathrm { D E } } } { \mathrm { d } t } = - 1 + \frac { \Gamma } { 3 H } .
$$

The fit against Pantheon $^ +$ BAO data provides $H _ { 0 } = 7 5 . 0 1 _ { - 5 . 8 0 } ^ { + 4 . 7 1 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL. However, when CMB distance priors from Planck 2018 are included, the Hubble tension is restored at more than $3 \sigma$ [311].

Reference [314] performs an analysis of this metastable DE model against Planck 2018 $( P l a n c k ~ 2 0 1 8 ~ + ~ \mathrm { { B A O } } ~ + ~ \mathrm { { D E S } } ~ + ~ \mathrm { { R 1 9 } } )$ data which leads to a value of the Hubble constant $H _ { 0 } = 6 9 . 3 _ { - 3 . 5 } ^ { + 5 . 9 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ $H _ { 0 } = 7 1 . 9 4 \pm 1 . 0 8 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } } )$ ) at $6 8 \%$ CL, solving the tension with R20 within $1 \sigma$ . Notice that the alleviation of the tension for Planck 2018 alone is mainly due to the large error bars in $H _ { 0 }$ .

# 5.7. Phantom Crossing

If a Phantom Crossing model is accounted for, the Hubble tension can be solved within one standard deviation, without spoiling the agreement with the BAO data [315]. If the dark energy density is Taylor-expanded around an extremum at scale factor $a = a _ { m }$ as:

$$
\rho _ { \mathrm { D E } } ( a ) = \rho _ { 0 } + \rho _ { 2 } ( a - a _ { m } ) ^ { 2 } + \rho _ { 3 } ( a - a _ { m } ) ^ { 3 } = \rho _ { 0 } [ 1 + \alpha ( a - a _ { m } ) ^ { 2 } + \beta ( a - a _ { m } ) ^ { 3 } ] ,
$$

where $\rho _ { 0 }$ , $\rho _ { 2 }$ , $\rho _ { 3 }$ are constants and $\alpha \equiv \rho _ { 2 } / \rho _ { 0 }$ , $\beta \equiv \rho _ { 3 } / \rho _ { 0 }$ , the DE equation of state results in:

$$
w _ { \mathrm { D E } } ( a ) = - 1 - \frac { a \left[ 2 \alpha ( a - a _ { m } ) + 3 \beta ( a - a _ { m } ) ^ { 2 } \right] } { 3 [ 1 + \alpha ( a - a _ { m } ) ^ { 2 } + \beta ( a - a _ { m } ) ^ { 3 } ] } .
$$

For this particular parameterization, an analysis to $P l a n c k 2 0 1 8 + \mathrm { B A O }$ measurements results in a Hubble constant value of $H _ { 0 } = 7 1 . 0 _ { - 3 . 8 } ^ { + 2 . 9 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [315]. A

full dataset combination of Planck 2018 $^ +$ CMB lensing $^ +$ BAO $^ +$ R19 $^ +$ Pantheon gives instead $H _ { 0 } = 7 0 . 2 5 \pm 0 . 7 8 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [315], in agreement with R20 at $2 \sigma$ .

# 5.8. Late Dark Energy Transition

Another possibility for solving the Hubble tension is to consider a Late Dark Energy Transition, in which the equation of state for dark energy sharply changes from the cosmological constant value $w _ { \mathrm { D E } } = - 1$ to a phantom-like value $w _ { \mathrm { D E } } < - 1$ at redshift $z \sim \mathcal { O } ( 0 . 1 )$ [60,316–318]. Such a transition is referred to as a “hockey stick” because of the shape of the equation of state $w _ { \mathrm { D E } } ( z )$ .

Starting from the prediction for the Hubble constant ${ \tilde { H } } _ { 0 }$ in $\Lambda$ CDM, a late DE transition leads to the actual Hubble constant $H _ { 0 } = ( 1 + \delta ) \tilde { H } _ { 0 }$ where $\delta$ is the fractional change in the Hubble constant. To model this, one considers a DE energy density content $\rho _ { \mathrm { D E } } ( z )$ that transitions from the cosmological constant value $\rho _ { \Lambda } = \Omega _ { \Lambda } \rho _ { \mathrm { c r i t , 0 } }$ to a phantom-like fluid at redshift $z _ { t }$ . The transition is modulated by a smooth step function $f ( z )$ as:

$$
\begin{array} { r l } { \rho _ { \mathrm { D E } } ( z ) = \rho _ { \Lambda } \left[ 1 + f ( z ) \right] ; } & { { } } \\ { f ( z ) } & { { } = \cfrac { 2 \delta } { \Omega _ { \Lambda } } \cfrac { S ( z ) } { S ( 0 ) } ; } \\ { S ( z ) } & { { } = \cfrac { 1 } { 2 } \left[ 1 - \operatorname { t a n h } \left( \cfrac { z - z _ { t } } { \Delta z } \right) \right] , } \end{array}
$$

where $\Delta z$ is the duration of the transition. For $z \gg z _ { t }$ , the expansion history is indistinguishable from the $\Lambda$ CDM scenario. In Ref. [317] it has been shown that the combination Planck 2018 $^ +$ CMB lensing $^ +$ BAO $^ +$ Pantheon $^ +$ R19 provides $H _ { 0 } \ = \ 7 2 . 5 \pm 1 . 8 5 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL, solving the Hubble tension within one standard deviation. However, notice that this result incorporates already a Gaussian prior on the Hubble constant corresponding to R19.

In Ref. [318], a sudden change in the dark energy equation of state by a quantity $\Delta w$ is considered as a possible solution to the Hubble tension. The equation of state is modeled as:

$$
w _ { \mathrm { D E } } ( z ) = - 1 + \Delta w \Theta ( z _ { t } - z ) ,
$$

where $\Theta$ is the Heaviside step function.

The possibility that a Late Phantom Transition ever occurred has been recently challenged in Ref. [319], where it has been shown that a “hockey stick” dark energy can not solve the Hubble crisis because the SNIa absolute magnitude $M _ { B }$ considered to obtain R19 is inconsistent with the $M _ { B }$ necessary to fit SNIa, BAO and CMB data.

However, if a corresponding transition for the SNIa absolute magnitude $M$ is accounted for, as in Ref. [318]:

$$
M ( z ) = M _ { C } + \Delta M \Theta ( z _ { t } - z ) ,
$$

then the Late Phantom Transition approach is again a viable possibility to address the Hubble tension. However, a full CMB data analysis is currently missing.

# 5.9. Running vacuum model

The running vacuum model was proposed in Refs. [320, 321] to solve the “coincidence problem” by using a Quantum Field Theory approach in cosmology, where the vacuum energy density can be derived from a general renormalization group equation whose beta-function takes the form of an adiabatic expansion in powers of the Hubble rate and its time derivatives (see also the explanations in Refs. [322–324] and the analysis in Refs. [325–327]). Therefore, in this model the cosmological constant is assumed to be an affine power-law function of the Hubble rate, $\Lambda \ = \ \Lambda ( H )$ . The story of the running vacuum model and related ideas can be found in the reviews [328, 329], while the extensions for a curved spacetime and for a string Universe are carried out in Refs. [330] and [331], respectively. Another extension of the $\Lambda$ CDM model that accounts for this parameterizations are the dynamical quasi-vacuum models ( $w$ DVMs), in which the Hubble tension is reduced because of the phantom-like behavior of DE [332]. The analysis of Planck 2015 $^ +$ CMB lensing $\mathrm { 2 0 1 5 + B A O + R I 6 }$ provides, indeed, $H _ { 0 } = 7 0 . 9 5 \pm 1 . 4 6 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [332], solving the Hubble tension at $1 . 1 \sigma$ . However, in this result the R16 Gaussian prior on the Hubble constant and the BAO data are both considered.

Another extension named as RRVM of type-II, where the vacuum dynamics is not caused by an interaction between the vacuum and matter sectors, but by the running of the gravitational coupling G, has been studied in Ref. [333], where Planck 20 $\mathrm { 1 8 ~ + ~ P a n t h e o n ~ + ~ D E S ~ + ~ E ~ }$ AO $^ +$ RSD $^ +$ CC $+$ a prior on $H _ { 0 }$ from [68] gives $H _ { 0 } = 7 0 . 9 3 _ { - 0 . 8 7 } ^ { + 0 . 9 3 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL, in agreement at $1 . 4 \sigma$ with R20, but already including a prior on the Hubble constant.

# 5.10. Transitional Dark Energy model

When a parametric model where a transition in the dark energy equation of state is accounted for, in order to be consistent with $H _ { 0 } \sim 7 3 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ , the DE component is not yet present until redshifts around $z = 2$ , but its energy density has instead a rapid change between $z = 0 . 5$ and $z = 2$ [334]. This result has been obtained with a modelindependent Gaussian regression analysis process using Planck 2015, BAO, Pantheon and R16 data, but a complete analysis with perturbations and the full Planck 2018 data is absent.

# 5.11. Negative Dark Energy

In Ref. [335] the authors assume that the Universe follows a ΛCDM cosmology at higher redshifts ( $z \geq 4$ ), in agreement with the Planck measurements, and reanalyse the low redshift cosmological data in order to reconstruct a Hubble rate $H ( z )$ which is in full agreement with R16. Once the energy density for the DE component is computed as a function of redshift without assuming a specific model, they find a local minimum of the DE energy density with a negative value. While this scenario could be ascribed to a negative cosmological constant plus an evolving dark energy component, the model considered deserves further investigations since these findings compromise its stability. A model which comprises a negative cosmological constant plus a timeevolving quintessence field has been considered in Refs. [251, 252] and tested against BAO surveys and the Pantheon SNIa data, however, a test against the full Planck dataset is still missing.

# 5.12. Bulk viscous models

Bulk viscous models have been proposed to alleviate the $H _ { 0 }$ tension. A bulk viscous fluid is characterized by its energy density $\rho$ and a pressure term $p$ which comprises two components, the first being the conventional pressure term $p _ { \mathrm { c o n } } ~ = ~ w _ { 0 } \rho$ , where $w _ { 0 }$ is a constant equation of state, and the second one being a viscosity component $p _ { \mathrm { v i s } } = - \xi ( t ) u ^ { \mu } { } _ { ; \mu } $ that depends on the coefficient of bulk viscosity $\xi ( t ) > 0$ and on the four-velocity of the fluid $u ^ { \mu }$ [336]. Therefore, the effective pressure term $p$ takes the form $p = w _ { 0 } \rho - \xi ( \rho ) u ^ { \mu } { } _ { ; \mu }$ .

The bulk viscosity can play an effective role in describing the evolution of the Universe in its early and late phases [337] (see the review in Ref. [338] for more details). For any bulk viscous fluid as described above, its evolution in the FLRW Universe is given by:

$$
\frac { \mathrm { d } \rho } { \mathrm { d } t } + 3 H ( 1 + w _ { 0 } ) \rho = 9 H ^ { 2 } \xi ( t ) ,
$$

where $H$ has been defined in Eq. (17). In general, two different kinds of bulk viscous models are considered: one where dark energy has a viscous nature [339,340] but matter has an independent evolution, or alternatively, a unified bulk viscous model in which dark matter and dark energy can not be distinguished [341]. Both scenarios can alleviate the $H _ { 0 }$ tension.

Considering that dark energy has a viscous nature, where the viscosity coefficient is proportional to the Hubble parameter $\xi ( t ) ~ = ~ \eta _ { 0 } H$ , as introduced in Ref. [339], the authors of Ref. [340] have found that for this model, the combination of Planck 2018 CMB distance priors $^ +$ Pantheon $^ +$ BAO $^ +$ BBN $^ +$ CC results in $H _ { 0 } \ =$ $6 9 . 3 \pm 1 . 7 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL, reducing the Hubble tension to the $1 . 9 \sigma$ level.

A model in which the bulk viscosity is proportional to the energy density and inversely proportional to the Hubble parameter, $\xi ( t ) = \eta _ { 0 } \sqrt { \rho _ { \mathrm { D E } } } / H$ , has been introduced in Refs. [342,343] and considered in light of the Hubble tension in Ref. [340]. An analysis that fits the Planck 2018 CMB distance priors $+$ Pantheon $+$ BAO + BBN + CC data provides $H _ { 0 } = 6 9 . 3 \pm 1 . 7 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL, thus reducing the tension with R20 down to $\boldsymbol { \mathrm { 1 . 9 \sigma } }$ [340].

The bulk viscosity can be a thermodynamic function $\xi ( t ) = \eta _ { 0 } \rho _ { \mathrm { D E } } ^ { \nu }$ , as introduced in Ref. [344]. A fit to the combination of Planck 2018 CMB distance priors $^ +$ Pantheon + BAO $^ +$ B $\mathrm { 3 B N ~ + }$ CC data on this model gives $H _ { 0 } = 6 9 . 2 \pm 1 . 7 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL [340], alleviating the Hubble tension down to $1 . 9 \sigma$ as in the two previous models. Note that a CMB-only analysis for all these models is currently missing.

In Ref. [341] the authors have investigated a unified cosmic scenario endowed with a bulk viscosity in which the bulk viscosity coefficient follows a general law $\xi ( t ) = \alpha \rho ^ { m }$ (see also Ref. [344]). We see that in the scenario where $w _ { 0 } = 0$ and $m$ is a free parameter, Planck 2015 $+$ Pantheon leads to $H _ { 0 } = 6 8 . 0 \pm 1 . 1 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL [341] and is hence in disagreement with R20 at $3 . 1 \sigma$ . For the case of a free $w _ { 0 }$ with $m = 0$ , instead, Planck 2015 $+$ Pantheon leads to $H _ { 0 } = 7 0 . 2 _ { - 1 . 9 } ^ { + 1 . 6 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL [341], solving the tension at $1 . 4 \sigma$ . Lastly, for the case in which both $w _ { 0 }$ and $m$ are free parameters, Planck 2015 + Pantheon gives $H _ { 0 } = 6 8 . 0 _ { - 2 . 4 } ^ { + 2 . 7 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [341], alleviating the tension with R20 at $1 . 7 \sigma$ .

Models in which a viscous inhomogeneous fluid describes the content of the late Universe are adopted in Ref. [345]. In the models studied, the pressure of the single fluid considered is a function of both the Hubble rate and density, with parameters that are fixed through a Bayesian Learning method over measured values of $H ( z )$ for $z \lesssim 2 . 5$ . For the models considered, this method yields $H _ { 0 } = 7 3 . 4 \pm 0 . 1 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ and $H _ { 0 } = 7 3 . 5 2 \pm 0 . 1 5 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [345], respectively. Note however that an analysis that uses Planck 2018 data is still missing.

# 5.13. Holographic Dark Energy

An interesting DE candidate that was proposed following the holographic principle is the holographic dark energy (HDE) [346–348]. The model was extensively studied for its ability to explain the late-time cosmic acceleration (see the review of Ref. [349]). In this model, the dark energy equation of state is given by:

$$
w _ { \mathrm { D E } } ( z ) = - \frac { 1 } { 3 } - \frac { 2 } { 3 c } \sqrt { \Omega _ { \mathrm { D E } } ( z ) } ,
$$

where $c$ is a dimensionless parameter.

In Ref. [350], the authors argue that the HDE model can alleviate the tension with the local measurements of $H _ { 0 }$ . A fit to the Planck $2 0 1 5 + \mathrm { C M B }$ lensing $^ +$ BAO $^ +$ JLA $+ ~ \mathrm { R 1 6 }$ data for HDE returns $H _ { 0 } = 6 9 . 6 7 _ { - 0 . 9 4 } ^ { + 0 . 9 5 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [350], which alleviates the tension with R20 down to the $2 . 2 \sigma$ level. The fit within the extended model HDE $+ N _ { \mathrm { e f f } } + m _ { \nu , \mathrm { s t e r i l e } } ^ { \mathrm { e f f } }$ (in which a massive sterile neutrino is included) to the same dataset gives $H _ { 0 } = 7 0 . 7 0 \pm 1 . 1 0 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL [350], alleviating the tension with R20 at $1 . 5 \sigma$ .

An updated analysis for HDE using Planck 2018 data can be found in Ref. [351], where $P l a n c k ~ 2 0 1 8 + \mathrm { B A O } + \mathrm { R 1 9 }$ gives $H _ { 0 } = 7 3 . 1 2 \pm 1 . 1 4 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL, in agreement with R20. Ref. [351] also considers the effect of including Pantheon data, finding that this inclusion shifts the value of $H _ { 0 }$ to a lower value. In fact, Ref. [351] further uncovered that both the subsets of the Pantheon data with $z > 0 . 2$ and $z < 0 . 2$ prefer a higher value of $H _ { 0 }$ , but they have a large negative correlation in between which has not yet been fully understood. Ref. [351] also considered an analysis that includes Pantheon data, finding that this inclusion shifts the value of $H _ { 0 }$ to a lower value. In fact, the analysis in Ref. [352] considers Planck 2018 $^ +$ BAO $^ +$ Pantheon and obtains $H _ { 0 } = 6 7 . 9 4 \pm 0 . 8 0 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [352], at $3 . 5 \sigma$ tension with R20 once the Pantheon data are included.

In this context one may be interested in the stability of the de Sitter state in the dark energy models following a Holographic approach [353]. As argued in Ref. [353], unlike in the $\Lambda$ CDM model where the de Sitter state is assumed to be stable in the distance future, the dark energy model following a holographic approach could alleviate the Hubble constant tension leading to an unstable de Sitter state in the distance future. This instability is actually responsible for a turning point [354] which seems crucial in capturing the $H _ { 0 }$ tension quantitatively and providing a common ground with the Swampland conjectures.

5.13.1. Tsallis Holographic Dark Energy: An extension of the previous holographic model following Tsallis statistics [355], dubbed as Tsallis Holographic dark energy, has been found to alleviate the $H _ { 0 }$ tension [356]. For this model, Planck 2018 CMB distance priors $^ +$ BAO $^ +$ $\mathrm { B B N } ~ + ~ ( $ CC $^ +$ Pantheon gives $H _ { 0 } = 6 9 . 8 \pm 1 . 8 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL which alleviates the tension with R20 at $1 . 5 \sigma$ . A full Planck data analysis is however missing.

# 5.14. Swampland Conjectures

String theory is a potential candidate for a UV-complete theory. A large number of string vacua are expected, therefore providing a consistent low-energy effective field theory (EFT) limit [357]. These well-behaved solutions that populate the “landscape” are conjectured to be surrounded by a “swampland” of semi-classical EFTs for which a consistent theory of quantum gravity does not exist [358]. Various recipes have been conjectures in the attempt to understand the conditions under which a given EFT does not lie in the swampland, such as the weak-gravity conjecture [359] and a set of swampland conjectures [360–363]. In particular, two of these swampland conjectures constrain the excursion range $\Delta \phi$ of a scalar field $\phi$ in field space as well as the logarithmic gradient of the scalar field potential $V ( \phi )$ . The first “distance” conjecture avoids that a tower of light states emerges when a scalar field moves by a distance $\Delta \phi ~ \ge ~ { \cal O } ( 1 )$ (in Planck units) [364–366]. The second of these swampland criteria establishes that a scalar field potential $V$ arising from a consistent quantum theory of gravity should satisfy $| V _ { \phi } | \ge c V$ , where $c \sim \mathcal { O } ( 1 )$ (in Planck units) is a positive constant and $V _ { \phi } = \mathrm { d } V ( \phi ) / \mathrm { d } \phi$ (see Refs. [367,368] for the implications of the swampland conjecture in cosmology).

Scalar field models obeying the swampland conjectures have recently gained considerable attention in relation with the proposed solutions to the Hubble tension. In fact, one could construct physically viable scalar field models that could explain the dark energy effects at late time and satisfy the swampland criteria [369–372].

In Ref. [370], it is found that a scalar field model, satisfying the swampland criteria with a fixed value of $c$ , can alleviate the Hubble tension. For example, an analysis using Planck 2015 $^ +$ CMB lensing $^ +$ BAO $^ +$ Pantheon $+$ R19 fixing $c = 0 . 1$ gives $H _ { 0 } ~ = ~ 6 9 . 0 6 _ { - 0 . 7 3 } ^ { + 0 . 6 6 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL, reducing the tension down to $2 . 8 \sigma$ level (notice that R19 is already included in the analysis).

The authors in Ref. [373] use low-redshift measurements of $H _ { 0 }$ to fit a polynomial expansion of the Hubble rate $H ( z )$ and test the different features against $\Lambda$ CDM to alleviate the Hubble tension (see also Ref. [374]). In particular, the functions for $H ( z )$ in Ref. [373] possess a turning point at a critical redshift $z _ { c } = z _ { c } ( \Omega _ { m } )$ , where $\Omega _ { m }$ is the fractional matter density today. Unfortunately, a full data analysis for this model is missing to date.

A consequence of the swampland criteria within string theory is to consider a quintessence field instead of a cosmological constant. In Ref. [375], this possibility is investigated for solving the Hubble tension, concluding that quintessence models always prefer a lower Hubble constant value than that obtained within the standard $\Lambda$ CDM. The addition of an exponential coupling to the dark matter sector does not change this result.

# 5.15. Late time transitions in the quintessence field

In Ref. [376], a quintessence field which transits from a matter-like to a cosmological constant-like behavior between recombination and the present time has been proposed to alleviate the Hubble tension. The authors model a transition with the effective DE equation of state:

$$
w _ { \mathrm { D E } } ( a ) = \frac { w _ { \phi 0 } } { 1 + ( \frac { a } { a _ { \mathrm { t r } } } ) ^ { - \frac { 2 } { \Delta } } } ,
$$

where $a _ { \mathrm { t r } }$ is the scale factor of the transition and $\Delta$ defines its duration. They conclude that Planck 2015 data exclude this model as a possible solution of the Hubble tension, since the best fit value of the Hubble constant is $H _ { 0 } = 6 7 . 2 0 \pm 0 . 6 4 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [376], at $4 . 3 \sigma$ tension with R20.

A similar observation was found in the context of a minimally coupled slowly or moderately rolling quintessence field with a smooth potential [377]. The authors of Ref. [377] considered the curvature parameter in the analysis and found that the $H _ { 0 }$ tension in such models remains at more than $3 \sigma$ .

# 5.16. Phantom Braneworld Dark Energy

In Ref. [378] a braneworld scenario, introduced in [379], has been proposed to increase the Hubble constant estimate. In this model the observable Universe is situated in a four-dimensional brane embedded in a fifth dimension, the ‘bulk’. The braneworld dark energy has an equation of state phantom-like, and the accelerated expansion of the Universe is therefore a consequence of this modification of gravity. Using a combination of Planck 2015 CMB distance priors, Union 2.1 SNIa and BAO in Ref. [378] the authors find for this scenario $H _ { 0 } = 7 0 . 7 5 \pm 1 . 3 0 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL, solving the Hubble tension within $1 . 4 \sigma$ . A full 2018 CMB data analysis is however missing.

# 5.17. Frame dependent dark energy

In Ref. [380], a frame dependent, although scale invariant, dark energy theory was proposed to alleviate the Hubble tension. In this late time model, the Hubble constant can take extremely large values comparable with the local measurements of $H _ { 0 }$ , offering at the same time an excellent fit to the CMB spectra. The model has some interesting implications, however it needs to be robustly investigated by means of a full data analysis.

# 5.18. Chameleon dark energy

In Ref. [381] a chameleon field (see also Refs. [382–390]) has been proposed to alleviate the Hubble tension. In this paper, the possibility that a matter overdensity, coupled to the chameleon dark energy, can increase the Hubble constant locally, introducing the cosmic inhomogeneity in the Hubble expansion rate at late-time, is taken into consideration. A full data analysis is however missing, but it does not go against the No-Go theorem of general chameleon [389].

# 6. Dark energy models with 6 degrees of freedom and their extensions

To alleviate the Hubble constant tension, some dark energy models with no extra degrees of freedom with respect to the $\Lambda$ CDM scenario have been proposed. Having the same number of degrees of freedom means that they are not disfavored by a Bayesian model comparison analysis. In Figures 7 and 8 we have classified the models according to the values of a number of key parameters, as described in the Introduction.

# 6.1. Phenomenologically Emergent Dark Energy

A famous possibility is a Phenomenologically Emergent Dark Energy (PEDE) model, in which a redshift-dependent dark energy component emerges at late times. In this model, firstly introduced in Ref. [391], the fractional DE energy density has the following parameterization:

$$
\tilde { \Omega } _ { \mathrm { P E D E } } ( z ) \equiv \frac { \rho _ { \mathrm { D E } } } { \rho _ { \mathrm { c r i t , 0 } } } = \Omega _ { \mathrm { P E D E , 0 } } \Big [ 1 - \operatorname { t a n h } ( \log _ { 1 0 } ( 1 + z ) ) \Big ] ,
$$

where $\Omega _ { \mathrm { P E D E , 0 } } ~ = ~ \Omega _ { \mathrm { P E D E } } ( z = 0 )$ and $\rho _ { \mathrm { c r i t , 0 } } = 3 H _ { 0 } ^ { 2 } M _ { \mathrm { P l } } ^ { 2 }$ is the present critical energy density. The fluid described by Eq. (35) has a phantom-like equation of state that asymptotically approaches the cosmological constant value $w _ { \Lambda } ~ = ~ - 1$ as time proceeds [391]:

$$
w _ { \mathrm { P E D E } } ( z ) = - 1 - \frac { 1 } { 3 \ln 1 0 } \left[ 1 + \operatorname { t a n h } \bigl ( \log _ { 1 0 } ( 1 + z ) \bigr ) \right] .
$$

![](images/d9e9176137a65e8d703eccac54e9a7956e94161697dff96a4ec9a478044618d9.jpg)  
Figure 7. Estimated values of the current matter energy density $\Omega _ { m } h ^ { 2 }$ , Hubble constant $H _ { 0 }$ and sound horizon $r _ { d } h$ in terms of various data points for different models discussed throughout the Section 6. The cyan horizontal band corresponds to the $H _ { 0 }$ value measured by R20 [2], the yellow vertical band to the $\Omega _ { m } h ^ { 2 }$ value estimated by Planck 2018 [11] in a ΛCDM scenario, and the light green horizontal band to the $r _ { d } h$ value measured by BAO data. The points sharing the same symbol refer to the same model in the same paper, and the different colors indicate a different dataset combination.

![](images/cf6d846572bb6a7e96345fb38568a394cfe11bda0b881f569bbe742aadd39078.jpg)  
Figure 8. Whisker plot with the $6 8 \%$ marginalized Hubble constant constraints for the models of Section 6. The cyan vertical band shows the $H _ { 0 }$ value measured by R20 [2] and the light pink vertical band denotes the $H _ { 0 }$ value estimated by Planck 2018 [11] in a ΛCDM scenario. For each line, when more than one error bar is shown, the dotted one corresponds to the Planck only constraint on the Hubble constant, while the solid one to the different dataset combinations reported in the red legend, in order to appreciate the shift due to the additional datasets.

Using the Planck 2015 CMB distance priors $^ +$ Pantheon $^ +$ BAO + Ly- $\alpha$ data, Ref. [391] finds $H _ { 0 } = 7 1 . 0 2 _ { - 1 . 3 7 } ^ { + 1 . 4 5 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL, solving the Hubble tension at $1 . 1 \sigma$ . Considering a full CMB analysis for this scenario, Planck 2015 alone gives instead $H _ { 0 } \ = \ { 7 2 . 5 8 _ { - 0 . 8 0 } ^ { + 0 . 7 9 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } } }$ at $6 8 \%$ CL [392], solving the Hubble tension within $1 \sigma$ , and Planck $2 0 1 5 \ + \ \mathrm { B A O }$ gives $H _ { 0 } \ = \ 7 1 . 5 5 _ { - 0 . 5 7 } ^ { + 0 . 5 5 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL, in agreement with R20 at $1 . 2 \sigma$ . This result is in agreement with Ref. [393], where CC measurements are considered. The very same model has been updated in Ref. [394], which finds $H _ { 0 } = 7 2 . 3 5 _ { - 0 . 7 9 } ^ { + 0 . 7 8 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL for the Planck 2018 data, and $H _ { 0 } = 7 2 . 1 6 \pm 0 . 4 4 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL for Planck 2018 $^ +$ CMB lensing $^ +$ BAO $+ \ \mathrm { P a n t h e o n } \ + \ \mathrm { D E S } \ + \ \mathrm { R 1 9 }$ , confirming the agreement with R20 within one standard deviation. However, in Ref. [395] it has been argued that, while at the background level the flat-PEDE model fits the data as well as the $\Lambda$ CDM scenario, at the perturbation level the PEDE model can not fit the observational data in cluster scales compared to the $\Lambda$ CDM. Extensions of this model considering neutrinos or a non-zero curvature of the Universe can be found in Refs. [394–396].

6.1.1. Generalized Emergent Dark Energy: A generalization of the PEDE model, including one more degree of freedom $\Delta$ , known as Generalized Emergent Dark Energy (GEDE) can be found in Ref. [397]. In the GEDE model, the evolution for the dark energy density is written as [397]:

$$
\widetilde { \Omega } _ { \mathrm { G E D E } } ( z ) \equiv \frac { \rho _ { \mathrm { D E } } } { \rho _ { \mathrm { c r i t , 0 } } } = \Omega _ { \mathrm { G E D E , 0 } } \frac { 1 - \operatorname { t a n h } \left( \Delta \log _ { 1 0 } ( \frac { 1 + z } { 1 + z _ { t } } ) \right) } { 1 + \operatorname { t a n h } \left( \Delta \log _ { 1 0 } ( 1 + z _ { t } ) \right) } ,
$$

where the redshift $z _ { t }$ marks the transition at which the densities in dark energy and matter equate, $\widetilde \Omega _ { \mathrm { G E D E } } ( z _ { t } ) \ : = \ : \Omega _ { m } ( 1 + z _ { t } ) ^ { 3 }$ . The redshift $z _ { t }$ is thus not a free parameter. For $\Delta \ : = \ : 0$ this model recovers the $\Lambda$ CDM scenario, while for $\Delta \ : = \ : 1$ and $z _ { t } = 0$ , the PEDE model is recovered. The GEDE equation of state is:

$$
w _ { \mathrm { G E D E } } ( z ) = - 1 - \frac { \Delta } { 3 \ln 1 0 } \left( 1 + \operatorname { t a n h } \left[ \Delta \log _ { 1 0 } \left( \frac { 1 + z } { 1 + z _ { t } } \right) \right] \right) .
$$

The analysis of Planck 2018 data at the background level for this GEDE scenario provides $H _ { 0 } = 6 6 . 7 6 _ { - 0 . 7 6 } ^ { + 2 . 9 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [397], reducing the Hubble tension down to the $2 \sigma$ level. However, this result is mostly driven by a volume effect, due to the increased volume of the parameter space. This result is in agreement with the results of Ref. [393], where CC data are considered. An updated result of this scenario is presented in Ref. [398] considering also the effects of the dark energy perturbations where for Planck 2018, $H _ { 0 } = 8 5 _ { - 6 } ^ { + 1 2 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL.

6.1.2. Modified Emergent Dark Energy: Another generalization of the PEDE model which includes one additional degree of freedom $\alpha$ is the Modified Emergent Dark Energy (MEDE), in which the dark energy equation of state can be written as [399]:

$$
w _ { \mathrm { M E D E } } ( z ) = - 1 - \frac { \alpha } { 3 \ln 1 0 } \left( 1 + \operatorname { t a n h } \bigl [ \alpha \log _ { 1 0 } \left( 1 + z \right) \bigr ] \right) .
$$

If $\alpha = 0$ , the model reduces to the $\Lambda$ CDM scenario, while for $\alpha = 1$ the PEDE model is recovered. A fit to Planck 2018 $^ +$ BAO data within the MEDE model provides $H _ { 0 } = 6 8 . 4 \pm 1 . 5 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL and reduces the Hubble tension to $2 . 4 \sigma$ [399].

# 6.2. Vacuum Metamorphosis

The Vacuum Metamorphosis (VM) model is a cosmological scenario which is physically motivated by quantum gravitational effects, where a gravitational phase transition occurs at late times [269–271]. The phase transition is induced when the Ricci scalar curvature $R$ is of the order of the mass squared of the field $m ^ { 2 }$ , after which $R$ is frozen. The value of $m ^ { 2 }$ determines the matter density today $\Omega _ { m }$ , and therefore the VM model has the same number of free parameters than the flat $\Lambda$ CDM scenario.

It has been found that this specific model can be an excellent candidate to solve the $H _ { 0 }$ tension [400]. In more detail, the expansion rate above and below the phase transition reads as [400]:

$$
\begin{array} { r } { \frac { \tau ^ { 2 } } { \tau _ { 0 } ^ { 2 } } = \{ \begin{array} { l l } { \Omega _ { m } ( 1 + z ) ^ { 3 } + \Omega _ { r } ( 1 + z ) ^ { 4 } + M \{ 1 - [ 3 ( \frac { 4 } { 3 \Omega _ { m } } ) ^ { 4 } M ( 1 - M ) ^ { 3 } ] ^ { - 1 } \} , } & { \mathrm { f o r } z > 0 } \\ { 0 } & { \mathrm { f o r } z \leq M \{ 1 - \frac { 4 } { 3 } ( 1 - z ) ^ { 4 } + M \{ 1 - \frac { 4 } { 3 } ( 1 - z ) ^ { 3 } \} , } & { \mathrm { f o r } z > 0 } \end{array}  , } \end{array}
$$

where $M = m ^ { 2 } / ( 1 2 H _ { 0 } ^ { 2 } )$ and the phase transition occurs at the redshift

$$
z _ { t } ^ { \mathrm { p h } } = - 1 + \frac { 3 \Omega _ { m } } { 4 ( 1 - M ) } .
$$

The effective DE equation of state is [400]:

$$
w _ { \mathrm { V M D E } } ( z ) = - 1 - \frac { 1 } { 3 } \frac { 3 \Omega _ { m } ( 1 + z ) ^ { 3 } - 4 ( 1 - M ) ( 1 + z ) ^ { 4 } } { M + ( 1 - M ) ( 1 + z ) ^ { 4 } - \Omega _ { m } ( 1 + z ) ^ { 3 } } ,
$$

below the phase transition, while $w _ { \mathrm { V M D E } } ( z ) = - 1$ above the phase transition.

For the VM scenario, Planck 2015 gives $H _ { 0 } = 7 8 . 6 1 \pm 0 . 3 8 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL [400], reducing the tension at $3 . 9 \sigma$ . An updated analysis is performed in Ref. [401], where a fit to the Planck 2018 data gives $H _ { 0 } = 8 1 . 1 \pm 2 . 1 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL, reducing the tension at $3 . 1 \sigma$ , and an analysis to Planck $\mathrm { 2 0 1 8 ~ + ~ B A O ~ + ~ R 1 9 }$ gives $H _ { 0 } = 7 5 . 2 2 { \pm } 0 . 6 0 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL, in agreement at $1 . 4 \sigma$ with R20. An extension of the model considering a non-zero curvature of the Universe can be found in Ref. [401]. The extension considering the neutrino sector, instead, explored in Ref. [402], provides, for Planck 2018, $H _ { 0 } = 7 8 . 0 _ { - 2 . 6 } ^ { + 3 . 8 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL, alleviating the tension at $1 . 7 \sigma$ , and, for $^ { p } l a n c k ~ 2 0 1 8 + \mathrm { B A O } + \mathrm { R 1 9 }$ , $H _ { 0 } = 7 4 . 6 0 \pm 0 . 9 7 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL, in agreement with R20 within $1 \sigma$ .

6.2.1. Elaborated Vacuum Metamorphosis: While in the original VM, $M$ is not a free parameter, but fixed by:

$$
\Omega _ { m } = \frac { 4 } { 3 } \left[ 3 M ( 1 - M ) ^ { 3 } \right] ^ { 1 / 4 } ,
$$

a scenario where the model has one more free parameter $M$ , can also be regarded as a possible cosmological scenario. For the VM scenario Planck 2015 gives $H _ { 0 } \ =$ $7 1 . 6 _ { - 5 . 1 } ^ { + 2 . 8 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL [400], solving the Hubble tension within $1 \sigma$ . This result is confirmed by the updated analysis performed in Ref. [401], where Planck 2018 gives $H _ { 0 } = 7 6 . 7 _ { - 2 . 6 } ^ { + 3 . 9 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL, and $P l a n c k ~ 2 0 1 8 + \mathrm { B A O } + \mathrm { R 1 9 }$ $H _ { 0 } ~ = ~ 7 3 . 6 3 _ { - 0 . 4 8 } ^ { + 0 . 3 3 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL, in agreement within $1 \sigma$ with R20. An extension of this model, considering a curvature component, can be found in Ref. [401]. The extension considering the neutrino sector, instead, explored in Ref. [402], provides, for Planck 2018, $H _ { 0 } = 7 5 . 2 _ { - 2 . 4 } ^ { + 1 . 6 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL, and, for Planck 2018 $^ +$ BAO $+ \ \mathrm { R 1 9 }$ , $H _ { 0 } = 7 3 . 1 9 \pm 0 . 8 5 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL, both in agreement with R20 within $1 \sigma$ .

![](images/cbb9aa4dbac05029576c030af662ea436b0d2bf3aa18e14f032b048edd673f4c.jpg)  
Figure 9. Estimated values of the current matter energy density $\Omega _ { m } h ^ { 2 }$ , Hubble constant $H _ { 0 }$ and sound horizon $r _ { d } h$ in terms of various data points for different models discussed throughout the Section 7. The cyan horizontal band corresponds to the $H _ { 0 }$ value measured by R20 [2], the yellow vertical band to the $\Omega _ { m } h ^ { 2 }$ value estimated by Planck 2018 [11] in a ΛCDM scenario, and the light green horizontal band to the $r _ { d } h$ value measured by BAO data. The points sharing the same symbol refer to the same model in the same paper, and the different colors indicate a different dataset combination.

![](images/ba237a9553ba1e7c8383ef53907561ca75ee1b1a06c4d08762e327ffa5af9704.jpg)  
Figure 10. Whisker plot with the $6 8 \%$ ( $9 5 \%$ if dashed) marginalized Hubble constant constraints for the models of Section 7. The cyan vertical band corresponds to the $H _ { 0 }$ value measured by R20 [2] and the light pink vertical band corresponds to the $H _ { 0 }$ value estimated by Planck 2018 [11] in a $\Lambda$ CDM scenario. For each line, when more than one error bar is shown, the dotted one corresponds to the Planck only constraint on the Hubble constant, while the solid one to the different dataset combinations reported in the red legend, in order to appreciate the shift due to the additional datasets.

# 7. Models With Extra Relativistic Degrees of Freedom

One classical extension of the standard $\Lambda$ CDM model considered for the $H _ { 0 }$ tension resolution, is the possibility of having extra “dark” radiation at the recombination period, usually quantified by the number of relativistic degrees of freedom, $N _ { \mathrm { e f f } }$ [403]. The radiation density $\rho _ { r }$ can be written as a function of the photon density $\rho _ { \gamma }$ , where we consider the ratio $T _ { \nu } / T _ { \gamma } = ( 4 / 1 1 ) ^ { 1 / 3 }$ between the background temperatures of neutrinos and photons under the approximation of instantaneous neutrino decoupling:

$$
\rho _ { r } = \rho _ { \gamma } \left[ 1 + \frac { 7 } { 8 } \Bigg ( \frac { 4 } { 1 1 } \Bigg ) ^ { 4 / 3 } N _ { \mathrm { e f f } } \right] .
$$

For three active massless neutrino families we usually expect $N _ { \mathrm { e f f } } ^ { \mathrm { S M } } \simeq 3 . 0 4 6$ [404–406], albeit the latest calculations provide $N _ { \mathrm { e f f } } ^ { \mathrm { S M } } ~ = ~ 3 . 0 4 4 0 \pm 0 . 0 0 0 2$ [407, 408], where the uncertainty is due to errors associated to the numerical solution procedure, increased by the errors on the measurement of the solar mixing angle. Note, that additional relativistic degrees of freedom other than the three standard model neutrinos will produce more radiation. Its effect will be the smearing and shifting of the acoustic peaks in the damping tail of the CMB temperature power spectrum, and a delay in the matter to radiation equivalence [409–412], with a corresponding increase of the early Integrated Sachs-Wolfe (eISW) effect, and therefore of the amplitude of the peak around multipoles $\ell \sim 2 0 0$ . Because of the strong degeneracy between $N _ { \mathrm { e f f } }$ and the Hubble constant, it would be possible to have a larger value of $H _ { 0 }$ from the CMB perspective at the price of additional radiation present at recombination (see for example, Ref. [413] and the sub-sections below).

While $N _ { \mathrm { e f f } }$ was a possible way of solving the Hubble constant tension at $1 . 8 \sigma$ with the Planck 2015 TT data ( $H _ { 0 } = 6 8 . 0 _ { - 3 . 0 } ^ { + 2 . 6 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL) [414], with the new Planck 2018 polarization measurements there is still a disagreement at about $3 . 6 \sigma$ with R20. In particular, Planck 2018 (Planck $2 0 1 8 \mathrm { ~ + ~ C M B }$ lensing $+$ BAO $^ +$ Pantheon) provides the constraint $N _ { \mathrm { e f f } } = 2 . 9 2 \pm 0 . 1 9$ at $6 8 \%$ CL, and $H _ { 0 } = 6 6 . 4 \pm 1 . 4 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [11] $H _ { 0 } = 6 7 . 5 \pm 1 . 1 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL), while one would need $N _ { \mathrm { e f f } } \approx 3 . 9 5$ to obtain a value of $H _ { 0 }$ from Planck $\mathrm { 2 0 1 8 + B A O \ - }$ $^ +$ Pantheon in perfect agreement with R19 [275].12

To understand the ability of the models of this section in alleviating the Hubble tension, in Figures 9 and 10 we have classified them in terms of various key cosmological parameters, as explained in the Introduction.

# 7.1. Sterile neutrinos

A possibility for having extra relativistic degrees of freedom at recombination is the presence of additional sterile neutrinos [416–419], since they are not forbidden by any fundamental symmetry within the Standard Model of elementary particles. They can contribute to $N _ { \mathrm { e f f } }$ in a fractional way, if not fully thermalized, and can still be in agreement with the CMB data, while a thermalized sterile neutrino with $\Delta N _ { \mathrm { e f f } } = N _ { \mathrm { e f f } } - N _ { \mathrm { e f f } } ^ { \mathrm { S M } } = 1$ is ruled out at about $6 \sigma$ .

Light sterile neutrinos are strongly motivated by neutrino short baseline (SBL) oscillation anomalies. In fact, there is a $6 . 1 \sigma$ indication for an electron-neutrino appearance, when combining together the MiniBooNE [420] and the Liquid Scintillator

Neutrino Detector (LSND) [421] data, even if this result has been challenged by STEREO [422] and PROSPECT [423]. These anomalous datasets can be explained with one sterile neutrino [424–428] with $\Delta N _ { \mathrm { e f f } } \approx 1$ , in strong contradiction with cosmological constraints. A possibility is the presence of some non-standard interactions [429– 431], low-temperature reheating [432], or other special mechanisms. Nevertheless, in Ref. [433], the authors showed that the combination of the Planck 2015 CMB distance priors $7 3 . 6 4 _ { - 2 . 6 8 } ^ { + 2 . 6 1 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ $^ +$ BAO at 68% CL, perfectly in agreement with R20. A full Planck $^ +$ Pantheon $^ +$ BBN $^ +$ R16 gives $N _ { \mathrm { e f f } } ~ \approx ~ 4$ and $H _ { 0 } \ =$ 2018 analysis is however in contradiction with this result.

In Ref. [434], instead, the authors showed that additional radiation produced just before the BBN by an unstable sterile neutrino with a mass of the order of tens of MeV can alleviate the Hubble tension by increasing $N _ { \mathrm { e f f } }$ in the right amount. Also, in Ref. [435], it is shown that, in the presence of a large lepton asymmetry, sterile neutrinos with the masses in the (150 − 450) MeV range can increase $N _ { \mathrm { e f f } }$ by $0 . 2 - 0 . 4$ and reduce the Hubble tension.

# 7.2. Neutrino Asymmetries

A large lepton number asymmetry $\xi$ in one or more neutrino species contributes to $\Delta N _ { \mathrm { e f f } }$ in the following way, accounting for the thermal distributions of two light mass eigenstates [436–439]:

$$
\Delta N _ { \mathrm { e f f } } = \frac { 1 5 } { 7 } \sum _ { i = 1 , 2 } \left( \frac { \xi _ { i } } { \pi } \right) ^ { 2 } \left[ 2 + \left( \frac { \xi _ { i } } { \pi } \right) ^ { 2 } \right] .
$$

Given the role of the extra dark radiation in solving the Hubble tension, in Ref. [440] it has been investigated the possibility that a primordial lepton asymmetry can alleviate the tension between the CMB and R16. The combination of Planck 2015 + BICEP2 & Keck Array (BKP) [441] results in $H _ { 0 } = 6 7 . 7 1 \pm 0 . 9 5 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [440], showing still a disagreement at $3 . 4 \sigma$ with R20.

# 7.3. Thermal Axions

The QCD axion [442, 443] is a hypothetical particle that emerges from the PecceiQuinn solution to the strong CP problem [444,445] (see Ref. [446] for a review). These particles may be copiously produced in the early Universe through either non-thermal mechanisms comprising CDM or thermal mechanisms which lead to a population of relativistic axions that would contribute to $N _ { \mathrm { e f f } }$ [413, 447–455].

The production of thermal axions might proceed through various mechanisms. Since the QCD axion couples to the gluon through a model-independent interaction, thermal axions are produced via scatterings off gluons for the decoupling temperature $T _ { D } \ \gtrsim \ 1 \mathrm { G e V }$ [456], and through the scattering off pions and nucleons at lower temperatures, regardless of the QCD axion model (see Ref. [457] for recent updates).

Since the coupling of the QCD axion with other SM particles is model-dependent, other production mechanisms via scattering off photons [458] and SM leptons [459] or quarks [460] might also arise. The energy density of radiation in the late Universe leads to a deviation in the effective number of relativistic degrees of freedom given by:

$$
\Delta N _ { \mathrm { e f f } } = \frac { 8 } { 7 } \left( \frac { 1 1 } { 4 } \right) ^ { \frac { 4 } { 3 } } \frac { \rho _ { a } } { \rho _ { \gamma } } ,
$$

where the axion energy density is found in terms of the current axion number density $n _ { a }$ and the internal degrees of freedom of the relativistic gas of bosons $g$ , and it reads as:

$$
\rho _ { a } = \frac { \pi ^ { 2 } } { 3 0 } \left( \frac { \pi ^ { 2 } n _ { a } } { \zeta ( 3 ) g } \right) ^ { \frac { 4 } { 3 } } .
$$

The assessment of a model in which hot axions are produced from the coupling with muons leads to an alleviation of the Hubble tension at $3 \sigma$ level [459]. In this $\Lambda$ CDM $+ N _ { \mathrm { e f f } }$ scenario, the fit to Planck 2018 $^ +$ BAO data results in a value for the Hubble constant corresponding to $H _ { 0 } = 6 8 . 0 _ { - 1 . 1 } ^ { + 2 . 3 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 95% CL.

# 7.4. Decaying dark matter

Cosmological scenarios in which it is present a decaying dark matter component [461] could be alternative proposals to reduce the Hubble constant tension. For instance, a dark matter fluid could decay into invisible massless particles after recombination while still avoiding photon overproduction [462]. This model has been explored in Refs. [463–465] making use of different combinations of the Planck 2015 data with other cosmological probes. In Ref. [466], a model of cold dark matter decaying before recombination is inspected and it is shown to not to be a satisfactory solution to the Hubble tension. Nevertheless, the best case scenario to alleviate the Hubble constant occurs when the dark matter particles decay exclusively into dark radiation.

A cosmological model where a fraction of the dark matter density decays into dark radiation increasing $\Delta N _ { \mathrm { e f f } }$ , as proposed by Ref. [467], has been considered as a solution for the Hubble tension by many authors. Such a decaying scenario in terms of the background equations reads as:

$$
\begin{array} { r l } { \dot { \rho } _ { \mathrm { D M } } + 3 \mathcal { H } \rho _ { \mathrm { D M } } = { \mathbf { \Gamma } } - Q ; } & { { } } \\ { \dot { \rho } _ { \mathrm { D R } } + 4 \mathcal { H } \rho _ { \mathrm { D R } } = Q , } & { { } } \end{array}
$$

where here and in the following, a dot stands for a differentiation with respect to conformal time, and the source term $Q = \Gamma \rho _ { \mathrm { D M } }$ , depends on a constant decay rate $\Gamma$ (see Refs. [468–470] for different functional forms of $\Gamma$ ). Within this scenario, the authors of Ref. [471] have found from the analysis of Planck $2 0 1 5 + \mathrm { R } 1 8$ a value for the Hubble constant $H _ { 0 } = 7 0 . 6 _ { - 1 . 3 } ^ { + 1 . 1 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL, reducing the Hubble tension down to the $1 . 5 \sigma$ level. Notice however that this result may be biased due to the fact that it already includes a R18 prior on the Hubble constant.

If we consider two different regimes, i.e. one for long-lived decaying cold dark matter (with a lifetime longer than the epoch corresponding to recombination) and another one for short-lived decaying cold dark matter particles, for which the mass-energy density decreases significantly well before recombination, the latter will leave a strong imprint on the CMB. In Ref. [472], Planck 2015 + BAO gives $H _ { 0 } = 6 7 . 9 3 _ { - 0 . 6 3 } ^ { + 0 . 5 3 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL for long-lived decaying cold dark matter, in disagreement with R20 at more than $3 . 8 \sigma$ , while $H _ { 0 } = 6 8 . 3 7 _ { - 0 . 8 9 } ^ { + 0 . 6 1 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL for short-lived decaying cold dark matter, in disagreement with R20 at $3 . 5 \sigma$ . An update is presented in Ref. [473], where Planck 2018 provides $H _ { 0 } = 6 7 . 7 { \pm } 1 . 2 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ ( $H _ { 0 } = 6 7 . 8 _ { - 1 . 5 } ^ { + 1 . 4 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } ) }$ at $9 5 \%$ CL for long (short)-lived decaying cold dark matter particles, in disagreement with R20 at more than $3 . 7 \sigma$ $( 3 . 6 \sigma )$ , and Planck 2018 $^ +$ BAO instead lead to $H _ { 0 } =$ $6 7 . 7 _ { - 0 . 9 } ^ { + 1 . 0 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ ( $H _ { 0 } = 6 8 . 6 _ { - 1 . 4 } ^ { + 1 . 2 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } ) }$ at $9 5 \%$ CL, in disagreement with R20 at more than $3 . 9 \sigma$ $( 3 . 2 \sigma )$ . If, instead, dark matter is composed of decaying warm dark matter particles, it has been shown in Ref. [474] that for a dark matter particle mass $m = 4 0 \mathrm { e V }$ , Planck 2018 + CMB lensing $( P l a n c k 2 0 1 8 + \mathrm { C M B \ l e n s i n g + B A O + R 1 9 } )$ provides the constraint $H _ { 0 } = 6 9 . 0 5 _ { - 0 . 9 5 } ^ { + 0 . 6 6 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ ( $H _ { 0 } = 7 0 . 2 0 _ { - 0 . 9 4 } ^ { + 0 . 7 9 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } ) }$ at 68% CL, reducing the Hubble tension down to the $2 . 8 \sigma$ (2 $\sigma$ ) significance level.

7.4.1. Self-interacting Dark Matter: Another possibility proposed for solving the $H _ { 0 }$ tension is to consider a self-interacting dark matter sector (SIDM) [475–477] with a light force mediator coupled to dark radiation. In this way, there will be a second epoch of hidden dark matter annihilation into dark radiation long after the standard thermal freeze-out, affecting the visible sectors only gravitationally. In Ref. [478], this scenario is proposed to alleviate the Hubble tension, without performing a data analysis.

Such an analysis has been carried out in Ref. [479], where a model with selfinteracting dark matter particles exchanging a light mediator, produced by the decay of a messenger WIMP-like state, is considered. From the cosmological perspective, this paradigm is very similar to a decaying cold dark matter one and therefore the analysis is applied to the latter. The combination of $P l a n c k ~ 2 0 1 8 ~ + ~ \mathrm { B A O } ~ + ~ \mathrm { R 1 9 }$ + Planck galaxy cluster counts measurements gives $H _ { 0 } ~ = ~ 6 9 . 4 _ { - 0 . 6 0 } ^ { + 0 . 4 3 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ $M _ { 0 } = 6 9 . 7 _ { - 0 . 4 4 } ^ { + 0 . 3 3 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } ) }$ at $6 8 \%$ CL [479] for the short-(long) lived case, reducing the disagreement with R20 at $2 . 7 \sigma$ , even if a Gaussian prior on $H _ { 0 }$ is included in the data analyses.

7.4.2. Two-body dark matter decays: Different from the two previous cases is the model presented in Ref. [480] and analysed in Ref. [481], where a parent particle decays into two daughter particles, one massless and one massive, with the form $\psi  \chi + \gamma$ . This decay is well-known within the context of Super Weakly Interacting Massive particles (Super WIMPs) [482]. This decaying dark matter model has therefore two free parameters: the fraction $\epsilon$ of the energy of the parent particle which is transferred to the massless particle, and the lifetime $\tau = 1 / \Gamma$ , where $\Gamma$ is the decay rate. Assuming there are no decays prior the recombination period, the energy densities of the parent particle $\rho _ { 0 }$ and of the massless daughter particle $\rho _ { 1 }$ evolve as:

$$
\begin{array} { l } { \displaystyle \frac { \mathrm { d } \rho _ { 0 } } { \mathrm { d } t } + 3 H \rho _ { 0 } = - \Gamma \rho _ { 0 } ; } \\ { \displaystyle \frac { \mathrm { d } \rho _ { 1 } } { \mathrm { d } t } + 4 H \rho _ { 1 } = \epsilon \Gamma \rho _ { 0 } ; } \\ { \displaystyle 3 H ^ { 2 } ( a ) \qquad = \kappa ^ { 2 } \sum _ { i } \rho _ { i } ( a ) , } \end{array}
$$

where, referring to the massive daughter particle with the subscript 2, the total energy density is:

$$
\sum _ { i } \rho _ { i } ( a ) = \rho _ { 0 } ( a ) + \rho _ { 1 } ( a ) + \rho _ { 2 } ( a ) + \rho _ { r } ( a ) + \rho _ { \nu } ( a ) + \rho _ { b } ( a ) + \rho _ { \Lambda } .
$$

In this scenario, an analysis with Planck 2015 $^ +$ CMB lensing $^ +$ R18 $+$ BAO provides $H _ { 0 } = 7 0 _ { - 3 } ^ { + 4 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL, in agreement with R20 within $1 \sigma$ [481]. However, since both the R18 prior on the Hubble constant and the BAO data are present in the joint analysis, so it is difficult to assess how well the model can solve the Hubble tension for the CMB dataset alone.13 An updated CMB result is nevertheless present in Ref. [484], where taking into account the late-Universe decaying dark matter effects like ISW and lensing, an analysis with Planck 2018 $^ +$ CMB lensing data results in $H _ { 0 } = 6 7 . 3 1 _ { - 0 . 5 6 } ^ { + 0 . 5 3 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 95% CL, consistent with the $\Lambda$ CDM value and in disagreement with R20 at $4 . 2 \sigma$ , excluding at a high significance the preferred region of the earlier analysis carried out in Ref. [481].

7.4.3. Light Gravitino scenarios: In Ref. [485] the authors study the keV gravitino dark matter model arguing that this could reduce the Hubble tension at around the $3 \sigma$ level. The bino, the superpartner of the $U ( 1 )$ weak hypercharge gauge field, can have a late decay into a gravitino nearly relativistic in the early Universe, increasing the radiation density by:

$$
\rho _ { R } ^ { \mathrm { e x t r a } } = f \times \rho _ { 3 / 2 } \times \left( \gamma _ { 3 / 2 } - 1 \right) ,
$$

where $\gamma _ { 3 / 2 }$ will be the boost factor of the gravitino from the bino decay, and $f$ will be the fraction of the non-thermal gravitino density in the total gravitino production. Therefore, the gravitino contributes to the effective number of relativistic degrees of freedom $\Delta N _ { \mathrm { e f f } }$ as [486]:

$$
\Delta N _ { \mathrm { e f f } } = f \times \left( \gamma _ { 3 / 2 } - 1 \right) / 0 . 1 6 .
$$

A similar contribution to $\Delta N _ { \mathrm { e f f } }$ is expected from a light dark matter candidate suggested in Ref. [487] to solve both the Lithium problem and reconcile the Hubble tension. Another particle physics model to address the Hubble tension is presented in Ref. [488], where the authors consider a gravitino as decaying dark matter and a quintessence dark energy axion, nevertheless a full Planck 2018 analysis is however still missing.

13 Another analysis of the model, excluding the CMB measurements is performed in Ref. [483], where Pantheon $^ +$ H0LiCOW provides $H _ { 0 } = 7 2 . 1 _ { - 1 . 7 } ^ { + 1 . 6 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL.

7.4.4. Decaying $Z ^ { \prime }$ : The authors of Ref. [489] studied the cosmological implications of a $L _ { \mu } - L _ { \tau }$ gauge boson.14 They consider the evolution of a light and weakly coupled $Z ^ { \prime }$ and its contribution to $\Delta N _ { \mathrm { e f f } }$ . There are two qualitatively distinct scenarios:

• Early Universe Equilibrium: The $Z ^ { \prime }$ population thermalizes at early times and decays into neutrinos, leading to the effective number of neutrino species:

$$
N _ { \mathrm { e f f } } = \frac { 8 } { 7 } \left( \frac { 1 1 } { 4 } \right) ^ { 4 / 3 } \frac { \rho _ { \nu } } { \rho _ { \gamma } } ,
$$

where $\rho _ { \nu }$ is modified by the entropy transferred from $Z ^ { \prime }$ decays.

• Late Equilibration: The $Z ^ { \prime }$ population will be produced through the freeze-in mechanism and eventually thermalizes with neutrinos, increasing $\Delta N _ { \mathrm { e f f } } ~ \simeq ~ 0 . 2 1$ through $Z ^ { \prime } \to \bar { \nu } \nu$ decays.

Nevertheless, complete Planck 2018 analyses for these models are missing in the literature and therefore is not possible to quantify their effectiveness in alleviating the Hubble constant tension.

7.4.5. Dynamical Dark Matter: The authors in Ref. [491] discuss a scenario in which the observed DM comprises a vast array of interacting fields, each with different values of their masses, couplings, and abundances. Within such a “dynamical” dark matter model, a generalization of the decaying dark matter scenario, it is possible to address the Hubble tension issue, providing a self-sustaining framework to unify short-lived and long-lived decaying dark matter models [492].

7.4.6. Degenerate Decaying Fermion Dark Matter: A sub-keV decaying fermion as a dark matter candidate has been proposed in Ref. [493]. Such a scenario could address both the Hubble tension issue and the core-cusp problem. Despite that the theoretical framework seems appealing, the strength of the method can only be quantitatively evaluated once a full Planck 2018 analysis is performed in this cosmological context.

# 7.5. Neutrino-Dark Matter Interactions

Neutrinos interacting with dark matter have been investigated in the literature [494– 503], because dark matter annihilations into neutrinos can mimic an increase in the value of the dark radiation $N _ { \mathrm { e f f } }$ [504,505], and therefore solve the Hubble tension. In Ref. [506], it has been shown that varying $N _ { \mathrm { e f f } }$ , Planck 2015 gives $H _ { 0 } = 6 6 . 8 _ { - 1 . 9 } ^ { + 1 . 8 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL, reducing the tension with R20 down to the $2 . 9 \sigma$ level.

7.5.1. Neutrino-Majoron Interactions: The interaction between Majorons and neutrinos has also been proposed to alleviate the Hubble tension. The massive Majoron is a pseudo-Goldstone boson arising from the spontaneous breaking of global lepton number [507], that can thermalize with neutrinos after BBN via inverse neutrino decays [508], increasing $\Delta N _ { \mathrm { e f f } }$ . For this scenario, Planck 2018 $^ +$ CMB lensing $+$ BAO $+ \textrm { R 1 9 }$ gives $H _ { 0 } = 7 1 . 9 2 \pm 1 . 2 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [509], reducing the tension with R20 within $1 \sigma$ , but this result includes already a prior on the Hubble constant. Unfortunately the result for Planck 2018 alone is absent in the literature. This very same scenario is analysed also in Refs. [510–512].

7.5.2. FIMPs Decay into Neutrinos: Another model proposed to solve the Hubble constant tension has been explored in Ref. [513], where it is shown that feebly interacting massive particles [514–516] can affect $N _ { \mathrm { e f f } }$ . In particular the authors focus on Heavy Neutral Leptons, that in the pure mixing cases can give $\Delta N _ { \mathrm { e f f } } = 0 . 4$ and alleviate the Hubble tension. Unfortunately a data analysis for this model is missing.

# 7.6. Interacting Dark Radiation

An interacting dark radiation component increasing $\Delta N _ { \mathrm { e f f } }$ has been proposed to alleviate the Hubble tension in Ref. [517]. In this model, the energy density in relativistic particles is [518]:

$$
\rho _ { r } = \rho _ { \gamma } \left[ 1 + \frac { 7 } { 8 } \bigg ( \frac { 4 } { 1 1 } \bigg ) ^ { 4 / 3 } \bigg ( N _ { \mathrm { e f f } } + N _ { \mathrm { f } } \bigg ) \right] ,
$$

where $N _ { \mathrm { H } }$ is the interacting counterpart of the dark radiation component. If $N _ { \mathrm { e f f } } = 3 . 0 4 6$ and $N _ { \mathrm { H } }$ is free to vary, a fit to Planck $2 0 1 8 + \mathrm { C M B }$ lensing $( P l a n c k 2 0 1 8 + \mathrm { C M B }$ lensing $+ \ \mathrm { B A O } + \mathrm { R 1 9 } )$ provides $H _ { 0 } = 6 9 . 1 4 _ { - 1 . 2 6 } ^ { + 0 . 7 7 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ $( H _ { 0 } = 7 0 . 6 4 _ { - 1 . 0 0 } ^ { + 0 . 9 3 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } ) }$ at 68% CL [517], alleviating the tension with R20 down to the 2.7σ $( 1 . 6 \sigma )$ level.

# 7.7. Coupled DM - Dark Radiation scenarios

The possibility of a dark matter interacting with massless relics from the dark sector, i.e. dark radiation [519–531], has been proposed to solve the Hubble tension. One example is given by the ETHOS formalism [532], in which it is assumed that a single dark matter species interacts with a relativistic component via 2-to-2 scattering processes of the form $\mathrm { D M } + \mathrm { D R }  \mathrm { D M } + \mathrm { D R }$ , with a comoving interaction rate that depends on temperature as $\Gamma _ { \mathrm { D R - D M } } \propto T ^ { n }$ . For the case $n = 0$ , corresponding to a class of non-Abelian dark matter models, the analysis of $P l a n c k ~ 2 0 1 5 + ~ \mathrm { B A O }$ datasets gives $H _ { 0 } = 6 8 . 0 4 _ { - 0 . 6 0 } ^ { + 0 . 5 0 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [533], in disagreement with R20 at $3 . 7 \sigma$ . An update of this work is presented in Ref. [534], where $P l a n c k ~ { 2 0 1 8 } ~ + ~ { \mathrm { B A U } }$ results in $H _ { 0 } = 6 8 . 7 3 \pm 0 . 9 6 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL, reducing the Hubble tension with R20 at $2 . 8 \sigma$ .

# 7.8. Cannibal Dark Matter

A scattering process that allows three particles to annihilate into two has been proposed as a possible dark matter scenario in Ref. [535]. Dark matter “cannibalism” is a generic feature arising in any hidden sector in which a mass gap exists between two species.

This model has been considered for solving the Hubble tension, because it can increase the dark radiation component in the Universe [536]. The thermal history can be divided into three different phases:

• The cannibal dark matter paradigm, made of a real scalar field $\phi$ , behaves as a radiation fluid, indistinguishable from an extra contribution to $N _ { \mathrm { e f f } }$ , while its temperature is above the $\phi$ mass.   
• A cannibalistic phase happens at a given scale factor, when the $\phi$ -fluid cools below the mass of the particles: the interaction $3  2$ starts processing mass into temperature and the temperature drops logarithmically.   
• The $3  2$ interactions decouple and the temperature drops as in the ordinary non-relativistic matter case.

Due to its strongly exothermic nature, cannibal dark matter acts as a warm dark matter component for a long period and turns non-relativistic at later times than cold dark matter. In the simplest scenario, this strongly suppresses structure growth, so cannibal dark matter can not be all of the dark matter [537]. In the analysis of Ref. [536], only $\sim 1 \%$ of the dark matter is considered as cannibalistic. As in many of the previous scenarios, a quantitative assessment of the ability of this model to solve the Hubble constant tension can not be performed, since a full Planck 2018 analysis for these models is absent in the literature.

# 7.9. Decaying Ultralight Scalar

A class of models that takes advantage of both the $\Delta N _ { \mathrm { e f f } }$ and the EDE models, improving on their downsides, has been proposed in Ref. [538]. The authors study the Decaying Ultralight Scalar (dULS) model, which does not suffer from the EDE fine-tuning. In this model, the dark sector contains an ultralight scalar field $\phi$ of mass $m \gtrsim H _ { \mathrm { e q } } \sim 1 0 ^ { - 2 8 } \mathrm { e V }$ , where $H _ { \mathrm { e q } }$ is the Hubble rate at matter-radiation equality, which resonantly decays into an Abelian gauge field $A _ { \mu }$ when the axion field starts to oscillate at $m \sim H$ . Mimicking the perturbative preheating stage after inflation, see e.g. Refs. [539, 540], an effective description of the model in terms of coupled fluid equations is:

$$
\begin{array} { l } { \displaystyle \frac { \mathrm { d } \rho _ { \phi } } { \mathrm { d } t } + 3 H ( 1 + w _ { \phi } ) \rho _ { \phi } = - \Gamma ( t ) \rho _ { \phi } ; } \\ { \displaystyle \frac { \mathrm { d } \rho _ { A } } { \mathrm { d } t } + 4 H \rho _ { A } \qquad = \Gamma ( t ) \rho _ { \phi } , } \end{array}
$$

where $\Gamma ( t )$ is a time-dependent decay rate and the equation of state for the ultralight scalar field transitions from $w _ { \phi } ~ = ~ - 1$ to $\begin{array} { r l r } { w _ { \phi } } & { { } = } & { 0 } \end{array}$ at $m \ \sim \ H$ . A combined analysis to Planck 2018 $^ +$ CMB lensing $^ +$ BAO $^ +$ Pantheon $+$ R19 data gives

$H _ { 0 } = 6 9 . 9 _ { - 0 . 8 6 } ^ { + 0 . 8 4 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [538], reducing the $H _ { 0 }$ tension at 2.2 standard deviations. However, a Gaussian prior for the Hubble constant coming from the Sh0ES measurement is also included in the analysis.

# 7.10. Ultralight dark photon

In Ref. [541] the possibility that an extra radiation density could be due to extra vector fields, different from the visible photon field, has been considered for solving the Hubble tension. These vector fields, called dark photon fields, must interact very weakly with the visible matter and should have a small mass (see Refs. [542, 543]), contributing as dark matter. In Ref. [544] this model has been studied considering the BBN observations concluding that even if the addition of three dark massive vector fields can help to soften the Hubble tension, the mechanism can not resolve it completely.

# 7.11. Primordial Black Holes

Recently a strong interest for primordial black holes (PBHs) as a possible dark matter component of our Universe (see e.g. Refs. [545–548]) has developed. In particular, in Ref. [545] the implications of the Hawking evaporation of light PBHs have been studied, showing that those can affect either $N _ { \mathrm { e f f } }$ or $w _ { D E }$ , depending on their precise mass, and potentially alleviate the Hubble tension. The authors of Ref. [545] find that Planck 2018 CMB distance priors (Planck 2018 CMB distance prior $\mathrm { \Omega ^ { \prime } + B A O + P a n t h e o n + H ( z ) ) }$ give for this model $H _ { 0 } = 6 5 . 3 7 \pm 1 . 9 2 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ $M _ { 0 } = 6 7 . 0 9 \pm 1 . 7 6 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } } )$ at 68% CL, reducing the tension at $3 . 4 \sigma$ $( 2 . 8 \sigma )$ . However, they also speculate that an ultra-light PBH, decaying around the neutrino decoupling period, could raise $H _ { 0 } = 7 0 . 4 9 \pm 1 . 3 4 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL for Planck 2018 CMB shift, solving the Hubble tension with R20 at $1 . 4 \sigma$ .

In Ref. [549] a new scenario for the formation of primordial black holes within the dark sector is proposed. This scenario predicts a modification to $N _ { \mathrm { e f f } }$ by:

$$
\Delta N _ { \mathrm { e f f } } = 1 4 \left( \frac { g _ { 1 } } { g _ { * } ( T _ { D } ) } \right) ^ { 4 / 3 } ,
$$

i.e. by about $0 . 1 ~ - ~ 0 . 2$ , which could potentially alleviate the Hubble tension. Unfortunately, a full data analysis for this model is missing and therefore it is not possible to fully quantify its effectiveness in solving the $H _ { 0 }$ tension.

# 7.12. Unparticles

The physics beyond the SM could contain a sector that is conformally invariant in the infra-red region and classically scale-invariant in the ultra-violet limit [550, 551], referred to as the “unparticle” and the Banks-Zaks phases [552]. Unparticles behave like radiation at high energies, increasing $\Delta N _ { \mathrm { e f f } }$ and therefore reducing the Hubble tension due to their correlation [553]. In addition, unparticles may act as a cosmological constant at low energies mimicking the standard $\Lambda$ CDM model. A full data analysis for this model is however required to quantitatively assess its ability to resolve the Hubble tension.

# 8. Models With Extra Interactions

Cosmological models allowing for a non-gravitational interaction between the components of the Universe have been found to be successful in alleviating the $H _ { 0 }$ tension. As the number of models in this section is very large, for the clarity in the graphical presentation, we have devoted four figures for this section. Figures 11 and 12 refer to the models discussed throughout Section 8.1 of the main Section 8. Figures 13 and Figure 12 cover the models of the remaining sections, i.e. Sections 8.2 to 8.4.

# 8.1. Interacting Dark Energy

Along with the early and late time solutions, a generalized cosmological scenario in which the dark matter and the dark energy interact with each other in a non-gravitational way received massive attention in the literature. These are known as Interacting Dark Energy (IDE) or Coupled Dark Energy (CDE) models [554]. The possibility of an interaction was thought to deal with the cosmological constant problem [555]. Later on, it was argued that an interaction between the dark fluids, namely, dark matter and dark energy, can be used to provide a possible solution to the cosmic coincidence problem [556–562]. Additionally, an interaction in the dark sector can explain the phantom dark energy regime without any scalar field having a negative kinetic term [556,563–567]. For those reasons, IDE scenarios have been substantially investigated in the literature, see e.g. Refs. [568–631] (see also two review articles [632,633] in this context for a comprehensive reading) with some interesting consequences.

The IDE models, as examined by several investigators over the last couple of years, can play an effective role to alleviate/solve the Hubble constant tension. In this section, we therefore revisit different IDE models which significantly increase the $H _ { 0 }$ value. The basic framework of this theory is the coupling between dark matter and dark energy characterizing the energy flow between these dark sectors. Due to such a coupling between these dark fluids, the continuity equations can be written as:

$$
\begin{array} { r l r } & { \dot { \rho } _ { \mathrm { D M } } + 3 \mathcal { H } \rho _ { \mathrm { D M } } } & { = a Q ; } \\ & { \dot { \rho } _ { \mathrm { D E } } + 3 \mathcal { H } ( 1 + w _ { \mathrm { D E } } ) \rho _ { \mathrm { D E } } = - a Q , } \end{array}
$$

where the dot corresponds to the derivative with respect to conformal time $\tau$ , $a$ is the scale factor, $\mathcal { H } \equiv \mathrm { d } { \ln { a } / \mathrm { d } { \tau } }$ is the conformal expansion rate of the Universe, and $\rho _ { \mathrm { D M } }$ , $\rho _ { \mathrm { D E } }$ are respectively the energy density of dark matter and dark energy. The quantity $Q$ denotes the interaction rate/interaction function/coupling function which characterizes the energy or/and momentum flow between these dark fluids. In the following, we classify the models based on the functional form of $Q$ .

![](images/c8875c4dfe4793727a4b70c6f6e7bcda8fbdebee29b334a61a03376d64978878.jpg)  
Figure 11. Estimated values of the current matter energy density $\Omega _ { m } h ^ { 2 }$ , Hubble constant $H _ { 0 }$ and sound horizon $r _ { d } h$ in terms of various data points for different models discussed throughout the Section 8.1 of the main Section 8. The cyan horizontal band corresponds to the $H _ { 0 }$ value measured by R20 [2], the yellow vertical band to the $\Omega _ { m } h ^ { 2 }$ value estimated by Planck 2018 [11] in a ΛCDM scenario, and the light green horizontal band to the $r _ { d } h$ value measured by BAO data. The points sharing the same symbol refer to the same model in the same paper, and the different colors indicate a different dataset combination.

![](images/3e96c2ab7746f67333a8199f60e8e7612d26a6b1f995dfbdb53adedb16abab07.jpg)  
Figure 12. Whisker plot with the $6 8 \%$ ( $9 5 \%$ if dashed) marginalized Hubble constant constraints for the models discussed throughout the Section 8.1 of the main Section 8. The cyan vertical band corresponds to the $H _ { 0 }$ value measured by R20 [2] and the light pink vertical band corresponds to the $H _ { 0 }$ value estimated by Planck 2018 [11] in a $\Lambda$ CDM scenario. For each line, when more than one error bar is shown, the dotted one corresponds to the Planck only constraint on the Hubble constant, while the solid one to the different dataset combinations reported in the red legend, in order to appreciate the shift due to the additional datasets.

8.1.1. Interacting vacuum energy: The simplest interacting scenario is the case where vacuum energy characterized by the equation of state $w _ { \mathrm { D E } } \equiv p _ { \mathrm { D E } } / \rho _ { \mathrm { D E } } = - 1$ interacts with dark matter, known as the Interacting Vacuum Scenario (IVS). Consistent observational evidences indicate that IVS can solve the $H _ { 0 }$ tension [634–641] in an exceptional way, even if this result is mostly driven by the existing parameter degeneracies [642].

A possibility is to assume that the rate of the interaction $Q$ between the two dark components is proportional to the dark energy density $\rho _ { \mathrm { D E } }$ as:

$$
Q = \xi \mathcal { H } \rho _ { \mathrm { D E } } ,
$$

where $\xi$ is a dimensionless parameter that quantifies the coupling between dark matter and dark energy. An analysis that accounts for Planck 2015 TT power spectra data ( $F l a n c k \ \mathrm { 2 0 1 5 \ ^ { \prime } I " I ~ + ~ R 1 6 ~ + ~ K i D S  – 4 5 6 }$ 0 [13]) results in $H _ { 0 } ~ = ~ 7 2 . 2 _ { - 5 . 0 } ^ { + 3 . 5 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ ( $H _ { 0 } = 7 3 . 6 \pm 1 . 6 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ ) at 68% CL [639], solving the Hubble tension within $1 \sigma$ .

Repeating the analysis in an extended scenario where the parameters in the neutrino sector are also allowed to vary, and using the Planck 20 $\mathrm { 1 1 5 + \mathrm { \Omega \Omega \Omega \Omega + \mathrm { ~ B A U } } }$ datasets yields the Hubble constant $H _ { 0 } = 6 8 . 2 \pm 1 . 4 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [635], alleviating the Hubble tension at $2 . 6 \sigma$ . For this latter case, results obtained by fitting Planck observations alone are absent in the literature.

An update to this scenario that considers a flux of energy from dark matter to the dark energy components is presented in Ref. [637], where it is shown that a fit against Planck 2018 $( P l a n c k 2 0 1 8 + \mathrm { B A O } + \mathrm { R 1 9 } )$ data gives $H _ { 0 } = 7 2 . 8 _ { - 1 . 5 } ^ { + 3 . 0 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ ( $H _ { 0 } =$ $7 1 . 7 { \pm } 1 . 1 \mathrm { k m } \mathrm { s } ^ { - 1 } \mathrm { M p c } ^ { - 1 } )$ at 68% CL, resolving completely the Hubble tension within $1 \sigma$ . This is in agreement with the findings in Refs. [103,631,640] and Ref. [636], where instead the interaction term differs by a factor of three, and for which an assessment against Planck 2018 $( P l a n c k 2 0 1 8 + \mathrm { B A O } )$ data gives $H _ { 0 } = 7 0 . 8 _ { - 2 . 5 } ^ { + 4 . 3 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL ( $H _ { 0 } = 6 8 . 8 _ { - 1 . 5 } ^ { + 1 . 3 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL), solving the tension within $1 \sigma$ (at $2 . 4 \sigma$ ). In Refs. [631, 636], an extended model in which the neutrino sector is also allowed to vary has been considered.

The case in which there is a transition between an interacting and a non-interacting scenario is instead analysed in Ref. [638], where it was shown that the Hubble constant resulting from Planck 2015 data can not solve the tension with R19.

8.1.2. Coupled Scalar Field: We now discuss the Coupled Dark Energy (CDE) scenario, in which dark matter interacts via a dark force mediated by a new scalar field $\phi$ , which in turn drives cosmic acceleration [554,643–646]. In this model, the coupling in the dark sector is described by the Lagrangian term:

$$
{ \mathcal L } = - \frac { 1 } { 2 } \partial ^ { \mu } \phi \partial _ { \mu } \phi - V ( \phi ) - m ( \phi ) \bar { \psi } \psi + { \mathcal L } _ { \mathrm { k i n } } [ \psi ] ,
$$

in which the mass of DM field $\psi$ , $m ( \phi )$ , is a function of the scalar field $\phi$ , $V ( \phi )$ is a self-coupling potential, and the last term describes the DM kinetic term. This

model has been assessed against WMAP [647], Planck 2013 [584], and Planck 2015 [57] measurements, by employing a Peebles-Ratra potential [648]:

$$
V ( \phi ) = V _ { 0 } \phi ^ { - \alpha } ,
$$

where $V _ { 0 }$ and $\alpha > 0$ are constants. Recently, the model has been reconsidered in H0LiCOW), obtaining the result for the Hubble constant light of the Planck 2018 data (Planck 2018 BAO $H _ { 0 } = 6 7 . 7 4 _ { - 0 . 6 6 } ^ { + 0 . 5 7 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ Pantheon $^ +$ CC + R19 + $H _ { 0 } = 6 8 . 7 9 _ { - 0 . 4 0 } ^ { + 0 . 3 5 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } } \mathrm { , }$ at 68% CL [649], a value that is in tension with R20 at $3 . 9 \sigma \ ( 3 . 4 \sigma )$ .

In Ref. [650] a quintessence model with a Yukawa interaction between dark energy and dark matter has been explored, finding that Planck 2015 gives $H _ { 0 } \ =$ $6 6 . 8 9 _ { - 2 . 3 } ^ { + 2 . 1 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL, at $2 . 5 \sigma$ tension with R20.

Recently, in Ref. [630] the authors have explored the scalar field interacting scenario proposed in Ref. [651]. Using a combination of C $\mathrm { \Delta ^ { \prime } C + B A O + H i g h }$ redshift HII galaxy measurements (HIIG) $^ +$ JLA, the authors find $H _ { 0 } = 6 9 . 9 _ { - 1 . 0 2 } ^ { + 0 . 4 6 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL [630], alleviating the tension with R20 at $2 . 4 \sigma$ .

8.1.3. IDE with a constant DE equation of state: A possible extension to the previous model is an interacting dark energy scenario where the dark energy fluid has a constant equation of state different from the cosmological constant value, $w _ { \mathrm { D E } } \neq - 1$ .

• For the interaction rate of Eq. (63), i.e. $Q \ = \ \xi \mathcal { H } \rho _ { \mathrm { D E } }$ , Planck 2015 provides $H _ { 0 } = 8 2 _ { - 8 } ^ { + 1 0 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [652], in agreement with R20. An update is presented in Ref. [653] where, for $w _ { \mathrm { D E } } < - 1$ , a fit to Planck 2018 (Planck 2018 $+ \mathrm { C M B \ l e n s i n g \ + B A O + P a n t h e o n + R 1 9 } )$ data gives $H _ { 0 } > 7 0 . 4 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $9 5 \%$ CL ( $H _ { 0 } = 6 9 . 8 \pm 0 . 7 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL), in agreement with R20 within $2 \sigma$ (at $2 . 3 \sigma$ ). These results hold when an extended model varying the neutrino sector is considered [654].

• Ref. [655] considered a model in which the rate of the interaction $Q$ is proportional to the DM energy density $\rho _ { \mathrm { D M } }$ instead of the DE energy density:

$$
Q = \delta \mathcal { H } \rho _ { \mathrm { D M } } ,
$$

where $\rho _ { \mathrm { D M } } = \rho _ { \mathrm { D M } , 0 } a ^ { - 3 + \delta }$ , $\rho _ { \mathrm { D M , 0 } }$ is the present value of $\rho _ { \mathrm { D M } }$ , and the quantity $\delta > 0$ controls the deviation of the DM scaling from its standard case. A fit to Planck 2015 $+ \mathrm { J L A } + \mathrm { B A O }$ datasets leads to the Hubble constant $H _ { 0 } = 6 8 . 4 { \pm } 1 . 2 \mathrm { k m } \mathrm { s } ^ { - 1 } \mathrm { M p c } ^ { - 1 }$ at 68% CL [634], considering a flux of energy from the dark matter sector to the dark energy one and a neutrino mass freely varying. In this case, the Hubble constant tension is at $2 . 7 \sigma$ , but results with Planck data alone are missing.

• The authors in Ref. [656] consider the rate of interaction of the form:

$$
Q = 3 ( 1 + w _ { \mathrm { D E } } ) \xi \mathcal { H } \rho _ { \mathrm { D M } } ,
$$

which, instead of the coupling parameter $\xi$ , a term containing the DE equation of gives state $w _ { \mathrm { D E } }$ $H _ { 0 } = 6 6 . 2 _ { - 2 . 9 } ^ { + 3 . 2 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ appears. A fit to Planck 2015 (P $M _ { 0 } = 6 8 . 7 6 _ { - 0 . 8 0 } ^ { + 0 . 7 2 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } ) }$ $\mathit { l a n c k } 2 0 1 5 + \mathrm { B A O } + \mathrm { J L A } + \mathrm { C C } )$ at 68% CL [656], data alleviating the Hubble constant tension with R20 at $2 \sigma$ (3 $\sigma$ ), shifting considerably the mean value of $H _ { 0 }$ .

• In Ref. [656], an alternative form for the rate of interaction which depends on the total DM $^ +$ DE energy density is also considered, as:

$$
Q = 3 ( 1 + w _ { \mathrm { D E } } ) \xi \mathcal { H } ( \rho _ { \mathrm { D M } } + \rho _ { \mathrm { D E } } ) .
$$

An analysis with Planck 2015 $( P l a n c k 2 0 1 5 + \mathrm { B A O } + \mathrm { J L A } + \mathrm { C C } )$ data using this model results in $H _ { 0 } = 6 5 . 8 _ { - 3 . 2 } ^ { + 3 . 4 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ $\cdot H _ { 0 } = 6 8 . 8 4 _ { - 0 . 8 4 } ^ { + 0 . 7 0 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } } )$ at $6 8 \%$ CL [656], alleviating the Hubble constant tension with R20 at $2 . 1 \sigma$ $( 2 . 9 \sigma )$ . The alleviation of the tension for Planck 2015 alone is mostly due to the large error bars.

• In Ref. [657], a non-linear interaction rate is considered, of the form:

$$
Q = 3 \xi \mathcal { H } \rho _ { \mathrm { D E } } \sin \left( \frac { \rho _ { \mathrm { D E } } } { \rho _ { \mathrm { D M } } } - 1 \right) .
$$

The sinusoidal function forces the rate $Q$ to change sign according to the relative value of $\rho _ { \mathrm { D E } }$ and $\rho _ { \mathrm { D M } }$ . A fit to Planck 2018 $P l a n c k 2 0 1 8 + \mathrm { B A O } + \mathrm { R 1 9 } )$ data leads to the Hubble constant $H _ { 0 } = 7 2 . 7 _ { - 8 . 3 } ^ { + 5 . 4 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ ( $H _ { 0 } = 7 1 . 7 7 _ { - 1 . 1 7 } ^ { + 1 . 0 5 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } ) }$ at 68% CL [657], a result which is in perfect agreement with R20.

• Another possibility is the generalized three-form dark energy model proposed in Ref. [658], that can be regarded as an IDE model with $w _ { \mathrm { D E } } ~ > ~ - 1$ . The analysis of this model against Planck 2018 $^ +$ BAO $^ +$ JLA data gives $H _ { 0 } \ =$ $7 0 . 1 _ { - 1 . 5 } ^ { + 1 . 4 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [659], alleviating the Hubble constant tension with R20 at $1 . 6 \sigma$ .

8.1.4. IDE with variable DE equation of state: A further step towards the IDE models in which dark energy has a dynamical equation of state was performed in Refs. [660,661]. In Ref. [661], the authors considered different phenomenological parameterizations for the dark energy equation of state, together with an interaction rate proportional to $\rho _ { \mathrm { D E } }$ . In particular, for the interaction rate $Q = 3 H \xi [ 1 + w _ { \mathrm { D E } } ( a ) ] \rho _ { \mathrm { D E } }$ , different variants of $w _ { \mathrm { D E } } ( a )$ as described below were investigated resulting in different estimates of $H _ { 0 }$ :

• $w _ { \mathrm { D E } } ( a ) = w _ { 0 } a \left[ 1 - \log ( a ) \right]$ : For Planck 2015 gives $H _ { 0 } = 8 1 _ { - 1 4 } ^ { + 1 3 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL and Planck $2 0 1 5 + \mathrm { B A O }$ gives $H _ { 0 } = 7 1 . 0 \pm 1 . 5 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL. • $w _ { \mathrm { D E } } ( a ) = w _ { 0 } a \exp ( 1 - a )$ : For Planck 2015 gives $H _ { 0 } = 8 4 _ { - 7 } ^ { + 1 4 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL and Planck $2 0 1 5 + \mathrm { B A O }$ gives $H _ { 0 } = 7 1 . 7 _ { - 1 . 7 } ^ { + 1 . 5 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL. • $w _ { \mathrm { D E } } ( a ) = w _ { 0 } a \left[ 1 + \sin ( 1 - a ) \right]$ : For Planck 2015 gives $H _ { 0 } = 8 4 _ { - 5 } ^ { + 1 2 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL and Planck $2 0 1 5 + \mathrm { B A O }$ gives $H _ { 0 } = 7 3 . 5 _ { - 1 . 7 } ^ { + 1 . 6 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL.

• $w _ { \mathrm { D E } } ( a ) = w _ { 0 } a \left[ 1 + \arcsin ( 1 - a ) \right]$ : For Planck 2015 gives $H _ { 0 } = 8 2 _ { - 1 7 } ^ { + 1 4 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL and Planck 2015 + BAO gives $H _ { 0 } = 7 2 . 8 _ { - 1 . 8 } ^ { + 1 . 5 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL.

Note, that in all the above expressions of $w _ { \mathrm { D E } } ( a )$ , $w _ { 0 }$ denotes the present value of $w _ { \mathrm { D E } } ( a )$ . The alleviation of the $H _ { 0 }$ tension happens at the price of a phantom dark energy equation of state at more than 2-to-3 standard deviations, and for Planck 2015 data, the $H _ { 0 }$ tension with R20 is alleviated within $1 \sigma$ . In the case of the combination Planck 2015 $^ +$ BAO, the tension is alleviated within $2 \sigma$ . The analyses of the same models with Planck 2018 are pending cases in the literature.

8.1.5. IVS and IDE with variable coupling: In most of the IDE models, the coupling parameter of the interaction model is assumed to be constant. However, the most general case is only realized when a time varying coupling parameter is considered, as there is no theoretical principle that can exclude this possibility. In Ref. [662, 663], the two following coupling functions were considered:

$$
\begin{array} { r l } & { \mathrm { M o d e l ~ A } \colon \ Q = 3 \xi ( a ) H \rho _ { \mathrm { D E } } \ ; } \\ & { \mathrm { M o d e l ~ B } \colon \ Q = 3 \xi ( a ) H \frac { \rho _ { \mathrm { D M } } \rho _ { \mathrm { D E } } } { \rho _ { \mathrm { D M } } + \rho _ { \mathrm { D E } } } \ , } \end{array}
$$

where $\xi ( a )$ is the time dependent and dimensionless coupling parameter having the form

$$
\xi ( a ) = \xi _ { 0 } + \xi _ { a } \left( 1 - a \right) .
$$

The above interaction models together with the variable coupling function were investigated for $w _ { \mathrm { D E } } = - 1$ (IVS), in Ref. [662], and for a constant value of $w _ { \mathrm { D E } } \neq - 1$ in Ref. [663] (IDE).

In Ref. [662], for Model A (B), Planck 2015 alone estimates $H _ { 0 } ~ = ~ 6 9 . 2 \pm$ $5 \mathrm { k m } \mathrm { s } ^ { - 1 } \mathrm { M p c } ^ { - 1 }$ $( 6 8 . 3 _ { - 6 . 2 } ^ { + 6 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } } )$ at 95% CL. Consequently, due to the large error bars, the $H _ { 0 }$ tension with R20 is solved at $1 . 5 \sigma$ level for both models.

In Ref. [663], Model A and Model B are tested for a constant value of $w _ { \mathrm { D E } } \neq - 1$ . For Model A, when a quintessence regime $w _ { \mathrm { D E } } > - 1$ is assumed, Planck 2018 (Planck 2018 $+ \mathrm { \ B A O } )$ gives $H _ { 0 } = 7 0 . 2 _ { - 3 . 1 } ^ { + 4 . 1 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL ( $H _ { 0 } = 6 8 . 4 _ { - 2 . 5 } ^ { + 2 . 7 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $9 5 \%$ CL). Due to the very large error bars, the $H _ { 0 }$ tension with R20 is alleviated within $1 \sigma \ ( 2 . 6 \sigma )$ . For Model B and $w _ { \mathrm { D E } } < - 1$ , a fit to Planck 2018 (Planck 2018 + BAO) data provides $H _ { 0 } > 7 3 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $9 5 \%$ CL ( $H _ { 0 } = 6 9 . 4 _ { - 2 . 3 } ^ { + 2 . 6 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $9 5 \%$ CL). Notice that the tension is solved within $2 \sigma$ (at $2 . 1 \sigma$ ).

8.1.6. IDE with sign-changing interaction: The energy transfer rate that regulates the conversion between two dark sectors could switch sign during the expansion history. For example, the rate of interaction $Q$ in Eqs. (61)-(62) could change the direction in which energy flows [664–669]. In this scenario it is possible to alleviate the Hubble tension [669]. For the rate of interaction $Q = 3 \mathcal { H } \xi ( \rho _ { \mathrm { D M } } - \rho _ { \mathrm { D E } } )$ , Planck 2015 $^ +$ BAO gives $H _ { 0 } = 6 9 . 1 2 _ { - 1 . 3 9 } ^ { + 0 . 9 3 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [669], reducing the $H _ { 0 }$ tension at $2 . 6 \sigma$ , including the BAO data. One more sign-changing interaction function with two coupling parameters, having a similar feature, can be found in Ref. [669]. Another example for a sign-changing interaction has been described in Ref. [657], see Eq. (69).

8.1.7. Anisotropic Stress in IDE: An IDE scenario where the anisotropic stress of the large scale inhomogeneities is also considered has been explored in Ref. [670]. In this model, the conservation equations are:

$$
\begin{array} { r l r } & { \dot { \rho } _ { \mathrm { D M } } + 3 \mathcal { H } \rho _ { \mathrm { D M } } } & { = - a Q ; } \\ & { \dot { \rho } _ { \mathrm { D E } } + 3 \mathcal { H } ( 1 + w _ { \mathrm { D E } } ) \rho _ { \mathrm { D E } } = a Q , } \end{array}
$$

and the interaction function $Q$ reads:

$$
Q = 3 ( 1 + w _ { \mathrm { D E } } ) \mathcal { H } \rho _ { \mathrm { D E } } .
$$

A fit of this model against Planck 2015 $( P l a n c k 2 0 1 5 + \mathrm { B A O } + \mathrm { R 1 6 } + \mathrm { C F H T I }$ LenS [671]) data gives $H _ { 0 } = 6 8 . 6 _ { - 5 . 8 } ^ { + 4 . 1 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ ( $H _ { 0 } = 7 0 . 3 _ { - 1 . 3 } ^ { + 1 . 1 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } ) }$ at $6 8 \%$ CL [670], solving the tension with R20 at $\therefore \bot \sigma$ (1.7 $o$ ). The updated analysis of this scenario using Planck 2018 measurements is absent from the literature to date.

8.1.8. Interaction in the Anisotropic Universe: The Bianchi cosmological solutions of the Einstein equations break the assumption of an isotropic Universe at its largest scales. In Ref. [672], a coupling between the dark components within an anisotropic Bianchi type I Universe is considered. A fit of this model to Planck 2018 $H _ { 0 } = 6 5 . 8 2 _ { - 0 . 9 9 } ^ { + 0 . 8 5 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL, in disagreement with R20 at $^ +$ CC data gives $4 . 6 \sigma$ .

8.1.9. Metastable Interacting dark energy: A model of metastable interacting DE was studied in Refs. [310, 311, 314]. The conservation equations for DE-DM in this scenario follow:

$$
\begin{array} { r l r } & { \dot { \rho } _ { \mathrm { D E } } } & { = - \Gamma \rho _ { \mathrm { D E } } ; } \\ & { \dot { \rho } _ { \mathrm { D M } } + 3 \mathcal { H } \rho _ { \mathrm { D M } } = \Gamma \rho _ { \mathrm { D E } } , } \end{array}
$$

where $\Gamma$ is a constant (for $\Gamma < 0$ DE density increases, while for $\Gamma > 0$ DE density decreases). Notice that it is an interacting DE-DM scenario with $Q = \Gamma \rho _ { \mathrm { D E } }$ .

For the combination Pantheon $^ +$ BAO data the model results in $\begin{array} { r l } { H _ { 0 } } & { { } = } \end{array}$ $7 1 . 8 _ { - 4 . 6 } ^ { + 4 . 7 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL, showing that the Hubble tension is solved within $1 \sigma$ [311]. However, in presence of the CMB distance priors from Planck 2018, the Hubble tension is restored at more than $3 \sigma$ [311].

When a full analysis with Planck 2018 $( P l a n c k ~ 2 0 1 8 ~ + ~ \mathrm { { B A O } } ~ + ~ \mathrm { { D E S } } ~ + ~ \mathrm { { R 1 9 } } )$ is performed with this model, an increase of DE density ( $\Gamma < 0$ ) is supported by the data together with a larger value of the Hubble constant $H _ { 0 } = 7 0 . 3 _ { - 2 . 0 } ^ { + 3 . 3 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ $M _ { 0 } = 6 9 . 1 2 _ { - 0 . 4 5 } ^ { + 0 . 4 6 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } ) }$ at 68% CL [314], solving the tension with R20 within $1 \sigma$ (within $2 . 9 \sigma$ ).

8.1.10. Quantum Field Cosmology: The IDE model proposed in Ref. [673], that relies on the Einstein-Cartan gravitational theory and considers the Universe in the scale invariant ultra-violet fixed point of the theory (referred to as Quantum Field Cosmology), has been investigated as a possible solution to the Hubble tension. In this model, Newton’s gravitational constant $G _ { N }$ and the cosmological constant $\Lambda$ possess a mild dependence on redshift, and vary according to the scaling laws:

$$
\frac { G _ { N } } { G _ { 0 } } = ( 1 + z ) ^ { - \delta _ { G } } , \qquad \mathrm { a n d } \qquad \frac { \Lambda } { \Lambda _ { 0 } } = ( 1 + z ) ^ { \delta _ { \Lambda } } ,
$$

with $\delta _ { G } , \delta _ { \Lambda } \ll 1$ , and approaching to an ultraviolet fixed point of $G _ { 0 }$ and $\Lambda _ { 0 }$ where the classical Einstein theory is realized.

This picture is extended in Ref. [674] to include the matter and radiation energy densities:

$$
\begin{array} { r l } { \cfrac { G _ { N } } { G _ { 0 } } \rho _ { m , r } = \rho _ { m , r } ^ { 0 } ( 1 + z ) ^ { 3 ( 1 + w _ { m , r } ) - \delta _ { G } } ; } & { } \\ { \cfrac { G _ { N } } { G _ { 0 } } \rho _ { \Lambda } } & { = \rho _ { \Lambda } ^ { 0 } ( 1 + z ) ^ { \delta _ { \Lambda } } , } \end{array}
$$

where $\rho _ { m } ^ { 0 }$ , $\rho _ { r } ^ { 0 }$ , and $\rho _ { \Lambda } ^ { 0 }$ are the present-day values of $\rho _ { m }$ , $\rho _ { r }$ , and $\rho _ { \Lambda }$ , and $w _ { m }$ , $w _ { r }$ are the equations of state for matter and radiation, respectively. When this model is analysed using the Planck 2018 distance priors $^ +$ BAO $^ +$ Pantheon, the Hubble constant obtained is $H _ { 0 } = 6 6 . 8 7 _ { - 1 . 6 1 } ^ { + 1 . 5 7 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [674], in disagreement with R20 at $3 . 2 \sigma$ .

8.1.11. Interacting Quintom dark energy: A quintom model [675–679], i.e. a dark energy model with two scalar fields where one of them has canonical kinetic energy and the second one a negative kinetic energy term, modified to include an interaction between dark matter and dark energy, can be considered a possible alternative to reconcile the Hubble constant tension, as argued in Ref. [680]. The addition of this extra component $X$ with negative density, in the Friedmann equation, will leave unaltered the Planck’s constraints on the matter and dark energy densities, but will match the requirements for solving the Hubble tension, acting as a phantom field, while the second scalar field will be quintessence. A full data analysis is however missing.

# 8.2. Interacting Dark Matter

In the standard $\Lambda$ CDM model, dark matter is assumed to be collisionless. Therefore, a possible extension is a dark matter interacting with the other components of the Universe. This process can help in reconciling the Hubble constant tension. We already explored the possibility of self-interacting dark matter, decaying dark matter, and dark matter interacting with neutrinos and DE in the previous sections, therefore we shall restrict ourselves in the following to the remaining cases exclusively.

8.2.1. DM - Photon Coupling: A non-minimal coupling between photons and dark matter [681–684] has also been considered to ameliorate the Hubble tension.

![](images/f98925adc7fe75500485f5f3ce1677f411d458362407f54762bd03592b63688c.jpg)

![](images/f857cb330a8c305989a59d1c9efcfcf04b7658b576b8881e14ba87a5f7c364fd.jpg)  
Figure 13. Estimated values of the current matter energy density $\Omega _ { m } h ^ { 2 }$ , Hubble constant $H _ { 0 }$ and sound horizon $r _ { d } h$ in terms of various data points for different models discussed throughout the Section 8.2 of the main Section 8. The cyan horizontal band corresponds to the $H _ { 0 }$ value measured by R20 [2], the yellow vertical band to the $\Omega _ { m } h ^ { 2 }$ value estimated by Planck 2018 [11] in a ΛCDM scenario, and the light green horizontal band to the $r _ { d } h$ value measured by BAO data. The points sharing the same symbol refer to the same model in the same paper, and the different colors indicate a different dataset combination.

![](images/ee26c5d770093146d58a7115e8caf92141b9b3b3a7b140ae5257cb44b9ea1aad.jpg)  
Figure 14. Whisker plot with the $6 8 \%$ ( $9 5 \%$ if dashed) marginalized Hubble constant constraints for the models discussed throughout the Sections 8.2 and 8.4 of the main Section 8. The cyan vertical band corresponds to the $H _ { 0 }$ value measured by R20 [2] and the light pink vertical band corresponds to the $H _ { 0 }$ value estimated by Planck 2018 [11] in a $\Lambda$ CDM scenario. For each line, when more than one error bar is shown, the dotted one corresponds to the Planck only constraint on the Hubble constant, while the solid one to the different dataset combinations reported in the red legend, in order to appreciate the shift due to the additional datasets.

The coupling between the dark matter fluid and photons can be described by:

$$
\begin{array} { r l r } { \dot { \rho } _ { \mathrm { D M } } + 3 \mathcal { H } \rho _ { \mathrm { D M } } = } & { - \ Q ; } & \\ { \dot { \rho } _ { \gamma } + 4 \mathcal { H } \rho _ { \gamma } } & { = Q , } & \end{array}
$$

where $Q = \Gamma _ { \gamma } \mathcal { H } \rho _ { \mathrm { D M } }$ . For this scenario, where the neutrino sector is free to vary, Planck 2015 TT $^ +$ CMB lensing $^ +$ BAO gives $H _ { 0 } = 7 1 . 9 \pm 4 . 0 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL [685], solving the $H _ { 0 }$ tension within $1 \sigma$ . However, this result has been obtained fitting the CMB temperature power spectrum only.

An extension of this model has been investigated in Ref. [686], considering a CPL parameterization for the DE equation of state, obtaining $H _ { 0 } = 6 7 . 4 \pm 3 . 9 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL for $P l a n c k 2 0 1 5 + \mathrm { B A O }$ , and alleviating the tension with R20 at $1 . 4 \sigma$ .

An updated analysis is instead presented in Ref. [534], where Planck $\mathrm { 2 0 1 8 + B A O }$ gives $H _ { 0 } = 6 7 . 7 0 \pm 0 . 4 3 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL, showing a disagreement with R20 at $4 \sigma$ .

8.2.2. DM - Baryon Coupling: Another possibility explored in the literature to ameliorate the Hubble tension resides in considering DM and baryons interacting [687– 695]. In Ref. [534], a model in which the DM-baryon interaction modifies the Euler equation that regulates the DM-baryon momentum exchange rate is explored. The analysis against Planck 2018 $+$ BAO datasets gives $H _ { 0 } = 6 7 . 7 0 \pm 0 . 4 3 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [534], showing a disagreement with R20 at $3 . 9 \sigma$ .

# 8.3. DE - Baryon Coupling

Contrary to the search for DM, for which realistic particle models motivate the search in direct detection experiments, a laboratory search of DE is conceptually complicated to start with, since the nature of DE is not clear. For example, DE could be due to a theory of gravity beyond GR, or it could be a manifestation of new fields. In the latter case, it is not even clear what the associated mass scale should be; for the case of a light scalar field, for example, we expect a field of a mass of the order of the Hubble constant [223, 227].

Surprisingly, the interaction between dark energy and baryon could proceed through a large Thompson cross section $\sim \mathcal { O } ( \mathrm { b } )$ , with negligible impact on the CMB or structure formation [696, 697]. If instead a time-varying cross section is invoked, it is possible to have detectable signatures of an elastic interaction between baryons and DE. In this JLA latter case, an analysis that accounts for the Planck 2018 $^ +$ CFHTLensS $^ +$ Planck SZ datasets finds $H _ { 0 } = 6 7 . 6 5 _ { - 0 . 6 4 } ^ { + 0 . 8 0 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ $^ +$ CMB lensing $^ +$ BAO at $6 8 \%$ $^ +$ CL [698], and thus in disagreement with R20 at $3 . 7 \sigma$ .

# 8.4. Interacting neutrinos

The physics of neutrinos is one of the appealing topics in modern cosmology. The neutrinos may in principle interact with each other or with other cosmic sectors, see for instance Ref. [699]. The possibility of an interacting neutrino sector has been explored recently to reconcile the Hubble constant tension. While the possibility of a dark matter sector interacting with neutrinos has been already discussed in Section 7.5 in light of a contribution to $\Delta N _ { \mathrm { e f f } }$ , here we shall restrict ourselves to previously unexplored models.

8.4.1. Self-interacting neutrinos: A way for increasing the Hubble constant value is considered in Ref. [700]. In presence of a “secret” self-interacting neutrino mode, Planck 2015 TT gives $H _ { 0 } = 7 0 . 4 \pm 1 . 3 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [700], reducing the Hubble tension at $1 . 6 \sigma$ . If the Planck 2015 high- $\ell$ polarization is included the Hubble estimate becomes $H _ { 0 } = 6 9 . 5 9 _ { - 0 . 7 1 } ^ { + 0 . 7 4 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [700], increasing the Hubble tension to $2 . 3 \sigma$ level. For Planck $\mathrm { \Delta 2 0 1 5 + B A O + R 1 6 }$ the Hubble constant is instead $H _ { 0 } = 6 9 . 3 3 \pm 0 . 5 2 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [700], increasing the Hubble tension to $2 . 8 \sigma$ level.

In Ref. [701] instead, it is present a delayed onset of the neutrino free-streaming until the Universe’s expansion is very close to the matter-radiation equality epoch, and a neutrino self-interaction in presence of a total neutrino mass different from zero is considered. Therefore, for a strongly interacting neutrino cosmology, Planck 2015 gives $H _ { 0 } = 6 6 . 2 _ { - 1 . 9 } ^ { + 2 . 3 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [701], lowering the Hubble tension down to $2 . 7 \sigma$ . For a moderate interacting neutrino scenario, Planck 2015 gives $H _ { 0 } = 6 5 . 3 _ { - 1 . 7 } ^ { + 2 . 2 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL [701], showing a disagreement with R20 at $3 \sigma$ level.

An update of these results can be found in Ref. [702], where for a strongly interacting neutrino cosmology, Planck 2018 (Planck 2018 + CMB lensing $+$ BAO $+$ Pantheon) gives $H _ { 0 } = 6 6 . 4 \pm 3 . 7 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ $H _ { 0 } = 6 6 . 7 _ { - 2 . 1 } ^ { + 2 . 2 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } ) }$ at 95% CL [702], alleviating at $3 . 0 \sigma$ $( 3 . 8 \sigma )$ the tension with R20 concerning the Hubble constant, and for a moderate interacting neutrino cosmology, Planck 2018 $( P l a n c k 2 0 1 8 + \mathrm { C M B }$ lensing + BAO $+$ Pantheon) gives $H _ { 0 } = 6 6 . 0 _ { - 3 . 6 } ^ { + 3 . 5 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ $M _ { 0 } = 6 7 . 4 _ { - 2 . 1 } ^ { + 2 . 2 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } ) }$ at $9 5 \%$ CL [702], reducing the tension to $3 . 3 \sigma$ $( 3 . 4 \sigma )$ . These results show a very good agreement with those derived in Ref. [703].

A model where the self-interaction structure is flavor-specific in the three active neutrino framework has been studied in Ref. [703]. Here, for a scenario with two selfinteracting neutrino states, and a strongly interacting neutrino cosmology Planck 2018 (Planck 2018 $^ +$ CMB lensing $^ +$ BAO $^ +$ R19) gives $H _ { 0 } = 6 8 . 8 6 \pm 0 . 4 6 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ ( $H _ { 0 } = 6 9 . 0 9 \pm 0 . 3 1 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } } ,$ ) at 68% CL [703], in disagreement at $3 . 1 \sigma$ $( 3 . 2 \sigma )$ with R20, while and for a moderate interacting neutrino cosmology, Planck 2018 (Planck 2018 + CMB lensing $^ +$ BAO $^ +$ R19) gives $H _ { 0 } = 6 7 . 8 3 \pm 0 . 5 0 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ ( $H _ { 0 } = 6 8 . 4 6 \pm 0 . 3 8 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } } )$ ) at 68% CL [703], in disagreement at $3 . 8 \sigma$ $( 3 . 4 \sigma )$ .

In Ref. [704] electroweak precision observables are taken into account, while in Ref. [705] the effective four-neutrino interaction is supposed to be generated by the exchange of a light mediator. In Ref. [706] a separate analysis with IceCube data is performed, and this concludes that the strong neutrino self-interactions region preferred by cosmology is disfavoured for both flavour specific and universal cases. In Ref. [707] it is pointed out that neutrino self-interactions induced by a very light or massless mediator can not resolve the Hubble tension below $3 . 4 \sigma$ ( $H _ { 0 } = 6 8 . 1 2 \pm 0 . 6 9 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL from Planck 2015), hence in Ref. [708] self-interacting Dirac neutrinos via a lightdark-photon mediator are explored.

A consequence of a self-interacting neutrino model is, instead, studied in Ref. [709], where the experimental constraints on the coupling between the Majoron and the neutrino flavor eigenstates are presented. Following this paper, in Ref. [710] the Majoron coupling is assumed instead to be diagonal to the neutrino mass eigenstates. The authors consider several cases: all neutrino states self-interact plus $N _ { \mathrm { e f f } }$ free to vary; two neutrino species free-stream and one interacts; a variable fraction of neutrinos self-interact with or without $N _ { \mathrm { e f f } }$ free to vary. The conclusions are that all of these cases can not alleviate the Hubble tension better than the case $\Lambda$ CDM $+ N _ { \mathrm { e f f } }$ alone.

8.4.2. Self-interacting sterile neutrino model: In Ref. [711] is considered a cosmological model in which sterile neutrinos are coupled to a new, very light pseudoscalar degree of freedom, firstly introduced in Ref. [712] and analysed in Refs. [429, 713], as a solution of the Hubble tension (see also Ref. [714]). For this pseudoscalar interaction, Planck 2018 (Planck 2018 + CMB lensing $+$ BAO $^ +$ R19) gives $H _ { 0 } = 7 1 . 6 _ { - 1 . 6 } ^ { + 1 . 1 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ $H _ { 0 } = 7 1 . 4 _ { - 1 . 0 } ^ { + 0 . 9 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } ) }$ at $6 8 \%$ CL [711], reducing the Hubble tension within $1 \sigma$ (at $1 . 1 \sigma$ ) level.

8.4.3. Dark Neutrino Interactions: The Dark Neutrino Interactions scenario, introduced in [715], is provided by a component of dark matter that interacts with neutrinos impeding them to free streaming. This produces an enhancement of the Hubble constant, possibly alleviating the tension, without varying $N _ { \mathrm { e f f } }$ . In Ref. [716] the combination of Planck 2015 + CMB lensing $^ +$ WiggleZ Dark Energy Survey results in a value of $H _ { 0 } = 6 9 . 3 9 _ { - 0 . 6 8 } ^ { + 0 . 6 9 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL, ameliorating the Hubble tension down to the $2 . 5 \sigma$ level.

# 9. Unified cosmologies

Unified dark fluid models are cosmological scenarios where the dark matter and dark energy behave as a single fluid. This single fluid behaves as dark matter in the early evolution of the Universe and as dark energy at late times. The introduction of unified models in cosmology followed from a work by S. Chaplygin in Ref. [717], and subsequently, this model, known as Chaplygin model, and its generalizations were extensively investigated by many researchers [718–743]. In the following we present how the $H _ { 0 }$ tension can be reconciled in different unified cosmological models.

In analogy to earlier sections, we have shown Figures 15 and 16, providing a very comprehensive picture of the unified models along with those from the next Section 10.

# 9.1. Generalized Chaplygin gas model

The generalized Chaplygin gas model (gcg) is characterized by the equation of state:

$$
p _ { \mathrm { g c g } } = - \frac { A } { ( \rho _ { \mathrm { g c g } } ) ^ { \alpha } } ,
$$

where $A$ and $\alpha$ are two real constants, and $p _ { \mathrm { g c g } }$ and $\rho _ { \mathrm { g c g } }$ are, respectively, the pressure and energy density of this fluid. For this model, Planck 2015 estimates $H _ { 0 } = 7 1 . 0 _ { - 3 . 7 } ^ { + 1 . 7 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [744], and this solves the tension with R20 at $1 \sigma$ . The model needs to be updated with the final CMB data from Planck 2018.

# 9.2. A new unified model

In Ref. [745], we find a new type of a unified model based on field theory grounds. In this model, the explicit relation between the pressure $p _ { u }$ and the energy density $\rho _ { u }$ is [745–747]:

$$
p _ { u } = - \rho _ { u } + \rho _ { u } { \mathrm { s i n c } } \left( \frac { \mu \pi \rho _ { u , 0 } } { \rho _ { u } } \right) ,
$$

![](images/28f446abd352452983b7f0903a89c52fed33a7f45f9ebe66cf6de532d45348dd.jpg)  
Figure 15. Estimated values of the current matter energy density $\Omega _ { m } h ^ { 2 }$ , Hubble constant $H _ { 0 }$ and sound horizon $r _ { d } h$ in terms of various data points for different models discussed throughout the Sections 9 and 10. The cyan horizontal band corresponds to the $H _ { 0 }$ value measured by R20 [2], the yellow vertical band to the $\Omega _ { m } h ^ { 2 }$ value estimated by Planck 2018 [11] in a ΛCDM scenario, and the light green horizontal band to the $r _ { d } h$ value measured by BAO data. The points sharing the same symbol refer to the same model in the same paper, and the different colors indicate a different dataset combination.

![](images/49d0cf841ee9298059eb35afc04ac3f6e543963a789ecedca7a2efffab26cab7.jpg)  
Figure 16. Whisker plot with the $6 8 \%$ ( $9 5 \%$ if dashed) marginalized Hubble constant constraints for the models of Sections 9 and 10. The cyan vertical band corresponds to the $H _ { 0 }$ value measured by R20 [2] and the light pink vertical band corresponds to the $H _ { 0 }$ value estimated by Planck 2018 [11] in a $\Lambda$ CDM scenario. For each line, when more than one error bar is shown, the dotted one corresponds to the Planck only constraint on the Hubble constant, while the solid one to the different dataset combinations reported in the red legend, in order to appreciate the shift due to the additional datasets.

where $\operatorname { s i n c } ( \theta ) = \sin \theta / \theta$ , $\mu \neq 0$ is a dimensionless quantity, and $\rho _ { u , 0 }$ is the energy density of the unified dark fluid today.

A fit to Planck 2015 data alone to this model results in $H _ { 0 } = 7 7 . 3 3 _ { - 0 . 7 3 } ^ { + 0 . 7 1 }$ at $6 8 \%$ CL [747], alleviating the tension with R20 at $2 . 8 \sigma$ . However, an analysis with the new Planck 2018 data is absent in the literature.

# 9.3. Λ(t)CDM model

In Ref. [748, 749] the $\Lambda ( t ) \mathrm { C D M }$ model has been considered to address the Hubble constant tension. The authors of Ref. [748, 749] analyse a class of interacting models behaving as a generalized Chaplygin gas at the background level, i.e. like cold dark matter at early times and a cosmological constant in the asymptotic future. The explicit expression of $\Lambda ( t )$ as considered in both the works has a Hubble dependence as:

$$
\Lambda ( t ) = \sigma H ^ { - 2 \alpha } \ ,
$$

where $\alpha > - 1$ is the interaction parameter and $\sigma = 3 ( 1 - \Omega _ { m } ) H _ { 0 } ^ { 2 ( 1 + \alpha ) }$ . This is an example of a unified dark sector model where the Hubble rate follows

$$
\frac { H ( z ) } { H _ { 0 } } = \sqrt { \left[ ( 1 - \Omega _ { m } ) + \Omega _ { m } ( 1 + z ) ^ { 3 ( 1 + \alpha ) } \right] ^ { \frac { 1 } { ( 1 + \alpha ) } } + \Omega _ { r } ( 1 + z ) ^ { 4 } } ,
$$

which recovers the standard $\Lambda$ CDM model for $\alpha = 0$ .

For the above model of $\Lambda ( t ) \mathrm { C D M }$ , $P l a n c k ~ 2 0 1 5 ~ \mathrm { T T ~ + ~ J L A ~ + ~ B B N ~ + ~ R 1 9 ~ }$ estimates $H _ { 0 } = 6 9 . 1 2 _ { - 3 . 7 } ^ { + 1 . 7 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [748], and this solves the tension with R20 at $2 . 4 \sigma$ , including already a gaussian prior on $H _ { 0 }$ . An updated analysis is presented in Ref. [749], where Planck 2018 $^ +$ CMB lensing $^ +$ JLA + BBN + R19 gives $H _ { 0 } = 7 0 . 7 3 \pm 1 . 0 2 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [749], solving the Hubble tension at $1 . 5 \sigma$ , but always including a Gaussian prior.

# 9.4. Λ-gravity

In Ref. [750] the possibility that a cosmological constant, describing both the accelerated expansion of the Universe and the dynamics of galaxy groups and clusters, could solve the Hubble tension is taken into account. This theory is called $\Lambda$ -gravity and is considered in the modified weak-field limit of GR. In this context it is possible to have a local Hubble constant of a local flow and a global one [751], as a consequence of the common nature of dark energy and dark matter, solving naturally the Hubble constant problem.

# 10. Modified gravity

Alternative gravitational theories including either modified versions of GR or new gravitational theories beyond GR, have been widely studied in the literature for their ability to explain different phases of the Universe, including the late-time cosmic acceleration as well as other aspects [752–785] (see the following reviews in this direction [786–793], and the references therein). Throughout this section, we shall discuss how modified gravity may help in alleviating or even solving the $H _ { 0 }$ tension, obtaining a strong support for these models. The value of $H _ { 0 }$ from CMB estimates can indeed be shifted towards larges values if the gravity is weaker at intermediate scales.

For example, an EFT approach performing a data-driven reconstruction of gravitational theories and dark energy models on cosmological scales finds that some of the models can alleviate the Hubble tension and are actually preferred against the standard $\Lambda$ CDM model [794]. In particular, this holds for models such as Scalar Horndeski and Full Horndeski theories [795].

Modifications of gravity at early times are effective in easing the Hubble tension because of the change induced in the evolution of the gravitational potential fluctuations, which leads to a change in the CMB temperature, polarization, and lensing predictions. Nevertheless, when the background expansion remains unchanged compared to $\Lambda$ CDM, the resulting cosmology is still in tension with BAO data [188]. On the other hand, late time modifications induced by modified gravity theories are also beneficial in raising the Hubble constant $H _ { 0 }$ , since they lead to a change in the spectrum of the unlensed CMB temperature fluctuations through the ISW effect and smooth out the CMB acoustic peaks [188], even if they are in disagreement with lensed CMB data on large scales $\ell \lesssim 4 0 0$ .

Here, we describe some models of modified gravity in which the Hubble constant tension is alleviated. Figures 15 and 16 contain the models of this section together with those from the previous Section 9.

# 10.1. $f ( \mathcal R )$ gravity theory

Einstein theory of gravitation can be recovered from the principle of least action, once the Einstein-Hilbert action is introduced as

$$
{ \mathcal S } = \frac { 1 } { 2 \kappa ^ { 2 } } \int { \mathrm { d } } ^ { 4 } x \sqrt { - g } { \mathcal R } + { \mathcal S } _ { m } ,
$$

where $g$ is the determinant of the metric tensor, $\mathcal { R }$ is the Ricci scalar, $\kappa ^ { 2 } = 8 \pi G _ { N }$ , and $S _ { m }$ is the action describing any matter fields appearing in the theory.

The simplest generalization of Einstein gravity is the $f ( \mathcal R )$ gravity, in which the Ricci scalar appears in the action in a generic function $f ( \mathcal R )$ :

$$
{ \mathcal { S } } = { \frac { 1 } { 2 \kappa ^ { 2 } } } \int \mathrm { d } ^ { 4 } x { \sqrt { - g } } f ( { \mathcal { R } } ) + { \mathcal { S } } _ { m } .
$$

The modified gravity theory described in Eq. (88) has been widely investigated over the past years, considering various choices of the function $f ( \mathcal R )$ . In this context, of particular interest is the Hu-Sawicki $f ( \mathcal R )$ model [796],

$$
f ( \mathcal { R } ) = \mathcal { R } - m ^ { 2 } \frac { c _ { 1 } ( \mathcal { R } / m ^ { 2 } ) ^ { n } } { c _ { 2 } ( \mathcal { R } / m ^ { 2 } ) ^ { n } + 1 } ,
$$

where $c _ { 1 } , c _ { 2 }$ are constants, $n > 0$ is an index, and $m ^ { 2 } = H _ { 0 } ^ { 2 } \Omega _ { m }$ . In this class of models, an accelerating phase can be achieved without introducing a cosmological constant while satisfying both galactic and solar-system constraints.

Recently, the Hu-Sawicki model has been tested in light of the $H _ { 0 }$ tension with different conclusions, depending on the cosmological datasets considered. The authors of Ref. [797] study the Hu-Sawicki model for $n \ = \ 1$ using the geometrical data. Using the CC $+$ Pantheon datasets, their best estimate for the Hubble constant is $H _ { 0 } = 6 9 . 5 \pm 2 . 0 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [797], which alleviates the tension with R20 at $1 . 5 \sigma$ . In Ref. [798], the author performed the analyses exploiting Planck 2018 data in combination with other cosmological probes, leaving the index $n$ free to vary and also considering some specific values of this parameter. For example, for $n = 1$ Planck 2018 $+ \mathrm { C M B }$ lensing $( P l a n c k 2 0 1 8 + \mathrm { C M B \ l e n s i n g + R S D + B A O + P a n t h e o n + C C }$ ) gives $H _ { 0 } = 6 7 . 5 8 \pm 0 . 6 4 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ ( $H _ { 0 } = 6 7 . 8 6 \pm 0 . 4 2 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } } )$ at 68% CL [798], i.e. the $H _ { 0 }$ tension is not alleviated within this specific $f ( \mathcal R )$ gravity model. Recently, further investigations aimed at testing whether the $H _ { 0 }$ tension can be solved within the $f ( \mathcal R )$ theory have been performed in Refs. [799, 800].

# 10.2. $f ( \mathcal T )$ gravity theory

The theory of Einstein-Cartan is an extension of GR that describes gravity in spacetime metrics with a connection that has both torsion and curvature [801]. In the framework of Einstein-Cartan theory, GR is a limit which is formulated based on Levi-Civita connections, for which the spacetime metric is torsion-free and has a possible non-zero curvature. A different limit, in which the spacetime connection has a non-zero torsion tensor $\tau ^ { \lambda } { } _ { \mu \nu }$ and zero curvature (Weitzenb¨ock connection) is teleparallel gravity, see e.g. Refs. [802, 803]. A torsion scalar $\tau$ can be constructed by contractions of the torsion tensor [804].

Models based on a modification of teleparallel gravity might lead to a successful alternative to inflationary models, resulting in an accelerated expansion rate without introducing an inflaton field [805–807].15 These models are characterized by the inclusion in the action of an arbitrary function $f ( \tau )$ of the torsion scalar:

$$
{ \mathcal { S } } = { \frac { 1 } { 2 \kappa ^ { 2 } } } \int \mathrm { d } ^ { 4 } x { \sqrt { - g } } f ( T ) + { \mathcal { S } } _ { m } .
$$

An $f ( \mathcal T )$ model can be studied in a EFT framework, in which the action describing perturbations is expanded around a time-dependent background [809]. In this case, the first Hubble equation is modified as

$$
3 H ^ { 2 } = \kappa ^ { 2 } \rho + \frac { 1 } { 2 } \left[ { \cal T } - f ( { \cal T } ) + 2 { \cal T } f _ { \cal T } \right] ,
$$

where $f _ { T } = \mathrm { d } f / \mathrm { d } \mathcal { T }$ .

15 See Ref. [808] for other possibilities.

A simple parameterization for teleparallel gravity is the power-law model [810]:

$$
f ( T ) = - T + \alpha T ^ { b } ,
$$

where the torsion scalar, in the mostly plus sign convention for the metric signature, is $\mathcal { T } ~ = ~ 6 H ^ { 2 }$ , and $\alpha , ~ b$ are constants. In this model, the GR metric for $\Lambda$ CDM is recovered for $b ~ = ~ 0$ and $\alpha ~ = ~ - 2 \Lambda$ . The model described in Eq. (92) may be able to alleviate the Hubble tension [811]: a fit to Planck 2015 $^ +$ BAO data yields $H _ { 0 } = 7 2 . 4 _ { - 4 . 1 } ^ { + 3 . 3 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [812], in agreement with R20 within $1 \sigma$ , even in presence of the BAO measurements. An alternative analysis, based on Gaussian processes and $H ( z )$ data, is presented in Ref. [813], where the tension is also efficiently alleviated. In Ref. [797], instead, CC $^ +$ Pantheon gives $H _ { 0 } = 6 9 . 1 \pm 1 . 9 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL, in tension at $1 . 8 \sigma$ with R20. An updated analysis is presented in Ref. [814], where Planck 2018 for this scenario gives $H _ { 0 } = 6 6 . 5 1 \pm 3 . 6 5 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL, where the $H _ { 0 }$ value is shifted towards a lower mean value but with a larger error, alleviating therefore the Hubble tension $( 1 . 7 \sigma )$ .

In order to attain a small variation of the gravitational coupling, Ref. [815] adopts a $f ( \mathcal T )$ model with an exponential form:

$$
f ( T ) = - \mathcal { T } + \frac { 1 - \Omega _ { m } } { ( 1 + p ) e ^ { - p } - 1 } \mathcal { T } _ { 0 } \left( 1 - e ^ { - p \sqrt { T / T _ { 0 } } } \right) ,
$$

where $\mathcal { T } _ { 0 } = 6 H _ { 0 } ^ { 2 }$ and $p > 0$ . The prefactor in Eq. (93) is obtained by evaluating Eq. (91) at present time. Note, that $\Lambda$ CDM is recovered in the limit $p \to + \infty$ . For this scenario, a fit to Planck 2018 data gives $H _ { 0 } = 6 7 . 1 1 \pm 0 . 5 6 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL, value in disagreement with R20 at the level of $4 . 4 \sigma$ [814].

A different $f ( \mathcal T )$ model with an exponential form has been explored in Ref. [816]:

$$
f ( T ) = - \mathcal { T } + \frac { 1 - \Omega _ { m } } { ( 1 + 2 q ) e ^ { - q } - 1 } \mathcal { T } _ { 0 } \left( 1 - e ^ { - q \mathcal { T } / T _ { 0 } } \right) ,
$$

where $q$ is a parameters. For this scenario, a fit to the Planck 2018 data yields the result $H _ { 0 } = 6 7 . 1 2 \pm 0 . 5 6 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [814], value that shows a $4 . 4 \sigma$ disagreement with R20.

Another $f ( \mathcal T )$ parameterization with an exponential form [808]:

$$
f ( T ) = - \mathcal { T } e ^ { \beta ( T _ { 0 } / T ) } ,
$$

where $\beta$ is found from solving $1 - 2 \beta = \Omega _ { m } e ^ { - \beta }$ , has been explored in Ref. [817] in relation with the Hubble tension. A fit to Pantheon $^ +$ R20 $+$ BBN $^ +$ BAO gives at the background level $H _ { 0 } = 7 0 . 7 \pm 1 . 3 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [817], alleviating the Hubble tension at $1 . 4 \sigma$ . This estimate, however, already includes a Gaussian prior on the Hubble constant. A full CMB analysis including perturbations has been performed in Ref. [818], where Planck 2018 (Planck 2018 $+$ CMB lensing $^ +$ BAO) gives $H _ { 0 } = 7 2 . 0 3 \pm 0 . 7 0 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ $\mathrm { \mathit { ^ { \prime } } _ { } } H _ { 0 } = 7 1 . 4 9 \pm 0 . 4 7 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } } )$ at 68% CL, solving the Hubble tension within $1 \sigma$ (at 1.2 $o$ ) without the introduction of extra free parameters.

Finally, Ref. [819] presents constraints on teleparallel gravity and its $f ( \tau )$ extensions using Gaussian processes, and Ref. [820] reconstructs the free function of $f ( \mathcal T )$ gravity in a model-independent manner using different datasets and relieving the Hubble tension.

# 10.3. $f ( T , B )$ gravity theory

An extension of the $f ( T )$ scenario is the $f ( T , B )$ gravity theory where, along with the torsion $\tau$ , the boundary term $B = 2 \nabla _ { \mu } \mathcal { T } _ { \nu } ^ { \nu \mu }$ is also included [821]. Recently, some specific models of $f ( T , B )$ gravity were examined with the observational data in Ref. [822], where the authors argued there that the $H _ { 0 }$ tension can be weakened in this context. In particular, the authors of Ref. [822] investigated two different models:

$$
\begin{array} { r l } & { f ( \mathcal T , \mathcal B ) = b _ { 0 } \mathcal B ^ { k } + t _ { 0 } \mathcal T ^ { m } \quad \mathrm { ( P o w e r \mathrm { - } l a w ~ m o d e l ) } ; } \\ & { f ( \mathcal T , \mathcal B ) = f _ { 0 } \mathcal B ^ { k } \mathcal T ^ { m } \quad \quad \mathrm { ( M i x e d ~ p o w e r \mathrm { - } l a w ~ m o d e l ) } , } \end{array}
$$

where $b _ { 0 }$ , $t _ { 0 }$ , $k$ , $m$ and $f _ { 0 }$ are all arbitrary constants. A fit to BAO $+$ Pantheon $+$ CC datasets gives $H _ { 0 } = 6 7 . 7 4 \pm 1 . 1 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [822] for the powerlaw model, reducing the $H _ { 0 }$ tension with R20 down to the $3 . 2 \sigma$ level, and $H _ { 0 } \ =$ $6 7 . 8 6 _ { - 1 . 1 } ^ { + 1 . 2 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL [822] for the mixed power-law model, reducing the tension down to the $3 \sigma$ level. In this context, an analysis with the full CMB data is missing.

# 10.4. $f ( \mathcal { Q } )$ gravity theory

All models discussed so far assume $\nabla _ { \alpha } g _ { \mu \nu } = 0$ , which is a condition that assures that angles and lengths are preserved under parallel transport. This assumption is dropped in extensions of GR that include non-Riemannian spacetime metrics, introducing a nonzero non-metricity tensor ${ \mathcal { Q } } _ { \alpha \mu \nu } = \nabla _ { \alpha } g _ { \mu \nu }$ (see e.g. Refs. [823–825]). In this framework, the action for a model that includes an arbitrary function $f ( \mathcal { Q } )$ on a torsion- and curvature-free geometry is:

$$
{ \cal S } = \frac { 1 } { 2 \kappa ^ { 2 } } \int \mathrm { d } ^ { 4 } x \sqrt { - g } f ( \mathcal { Q } ) + { \cal S } _ { m } ,
$$

where the non-metricity scalar $\mathcal { Q }$ is defined as ${ \mathcal { Q } } = - { \mathcal { Q } } _ { \alpha \mu \nu } P ^ { \alpha \mu \nu }$ , in terms of the nonmetricity conjugate:

$$
P _ { \mu \nu } ^ { \alpha } = - \frac { 1 } { 2 } \left( \frac { 1 } { 2 } { \mathcal Q } ^ { \alpha } { } _ { \mu \nu } - { \mathcal Q } _ { ( \mu \nu ) } { } ^ { \alpha } \right) + \frac { 1 } { 4 } \left( { \mathcal Q } ^ { \alpha } - \tilde { Q } ^ { \alpha } \right) g _ { \mu \nu } - \frac { 1 } { 4 } \delta _ { ( \mu } ^ { \alpha } { \mathcal Q } _ { \nu ) } .
$$

Here, ${ \mathcal Q } _ { \alpha } = g ^ { \mu \nu } { \mathcal Q } _ { \alpha \mu \nu }$ and ${ \tilde { \mathcal { Q } } } _ { \alpha } = g ^ { \mu \nu } { \mathcal { Q } } _ { \mu \alpha \nu }$ are the two independent traces of the nonmetricity tensor, and round brackets mean a symmetrisation over the indices.

In Ref. [825], the $f ( \mathcal { Q } )$ modified gravity model is tested against the Pantheon sample using a cosmographic approach, in which the parameterization of $f ( \mathcal { Q } )$ involves an increase in the numbers of derivatives in the theory. More specifically, the authors consider three cosmographic $f ( \mathcal { Q } )$ models, namely M1, M2, and M3. The estimated values of $H _ { 0 }$ are higher than R20, since $H _ { 0 } = 7 9 . 5 \pm 2 . 5 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL [825] for M1, $H _ { 0 } = 7 9 . 2 \pm 3 . 1 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [825] for M2, and $H _ { 0 } = 7 9 . 5 { \pm } 2 . 6 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [825] for M3. The tension with R20 is reduced down to the $2 . 3 \sigma$ , $1 . 8 \sigma$ and $2 . 2 \sigma$ levels, respectively. However, a full analysis with Planck CMB data is missing for this theoretical framework.

# 10.5. Jordan-Brans-Dicke gravity

The replacement of Newton’s gravitational constant $G _ { N }$ with a coupling that varies with cosmic time, $G _ { N } ( t )$ , has been proposed for the first time by Brans $\&$ Dicke (BD) [826]. In the BD theory, Newton’s constant is promoted to a dynamical field that depends on the spacetime coordinates. In more detail, the action describing the BD theory depends on the BD field $\Phi$ as

$$
{ \mathcal { S } } = { \frac { 1 } { 2 \kappa ^ { 2 } } } \int \mathrm { d } ^ { 4 } x { \sqrt { - g } } \ \left[ \Phi { \mathcal { R } } - { \frac { \omega } { \Phi } } g ^ { \mu \nu } \partial _ { \mu } \Phi \partial _ { \nu } \Phi - 2 V ( \Phi ) \right] + S _ { m } ,
$$

where $\omega$ is a new parameter in the theory and $\kappa$ depends on the value of $G _ { N }$ measured today. It can be shown that the GR limit in Eq. (87) is recovered for $\omega  + \infty$ .

The Jordan [827], Brans & Dicke (JBD) gravity has been extensively studied in the literature (see Refs. [386, 828–848]) and can possibly embed the Running Vacuum Model [849,850] (see also Section 5.9). Models of JBD gravity where the Hubble tension is alleviated have also been discussed, as reviewed below.

10.5.1. BD-ΛCDM: In Ref. [851], a BD cosmology with an additional cosmological constant term (the BD- $\Lambda$ CDM model) is considered in light of easing the Hubble tension. In this case the action reads

$$
{ \mathcal { S } } = \int \mathrm { d } ^ { 4 } x { \sqrt { - g } } \ \left[ { \frac { 1 } { 2 \kappa ^ { 2 } } } \left( \Phi { \mathcal { R } } - { \frac { \omega } { \Phi } } g ^ { \mu \nu } \partial _ { \mu } \Phi \partial _ { \nu } \Phi \right) - \rho _ { \Lambda } \right] + S _ { m } .
$$

For this scenario, Plan $\varepsilon k 2 0 1 5 + \mathrm { C M B } \ \mathrm { l e n s i n g } + \mathrm { B A O } + \mathrm { R S D } + \mathrm { K i D S } \ – 4 5 0 + \mathrm { R 1 9 }$ gives $H _ { 0 } = 7 2 . 0 \pm 1 . 0 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL, solving the tension within $1 \sigma$ . Nevertheless, these results include a Gaussian prior for the Hubble constant.

An update with new data has been performed in Ref. [852], where Planck $2 0 1 8 +$ Pantheon $1 + \mathrm { B A O } + \mathrm { R S D } + \mathrm { C C } + H _ { 0 }$ from [68] gives $H _ { 0 } = 6 9 . 8 5 _ { - 0 . 8 5 } ^ { + 0 . 8 1 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [852], alleviating the tension down to $2 . 2 \sigma$ . However, a prior on the Hubble constant is already included in the analysis.

A result without this prior, and also without CMB polarization measurements, provides instead $H _ { 0 } = 6 8 . 8 6 _ { - 1 . 2 4 } ^ { + 1 . 1 5 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [852], for Planck 2018 TT + Pantheon $\mathrm { \Omega _ { 1 } + R S D + B A O + C C }$ , reducing the tension down to the $2 . 6 \sigma$ level.

10.6. Scalar-tensor theories of gravity:

The JBD theory can be reformulated to include the equivalent formulation of induced gravity (IG) in a scalar-tensor model [853, 854]:

$$
{ \cal S } = \frac { 1 } { 2 \kappa ^ { 2 } } \int \mathrm { d } ^ { 4 } x \sqrt { - g } \left[ F ( \sigma ) { \mathcal R } - g ^ { \mu \nu } \partial _ { \mu } \sigma \partial _ { \nu } \sigma - 2 V ( \sigma ) - 2 \Lambda \right] + { \mathcal S } _ { m } ,
$$

where $\sigma$ is the scalar field in units of $M _ { \mathrm { P l } }$ which is responsible for generating Newton’s gravitational constant $G _ { N }$ through the spontaneous breaking of scale invariance and moving in a potential $V ( \sigma )$ , while $F ( \sigma ) = N _ { \mathrm { P l } } ^ { 2 } + \xi \sigma ^ { 2 }$ where $N _ { \mathrm { P l } }$ is a parameter and $\xi > 0$ is the coupling to the Ricci scalar. The conformal coupling case is $\xi = - 1 / 6$ and $N _ { \mathrm { P l } } = 0$ ( $\xi = 0$ and $N _ { \mathrm { P l } } = 1$ ) for IG (GR).

In Ref. [855], an extended JBD is considered to alleviate the Hubble tension, assuming an effectively massless scalar field $\sigma$ with a potential $V ~ \propto ~ F ^ { 2 }$ . A fit to $P l a n c k 2 0 1 5 ~ \mathrm { T T } + \mathrm { C M B ~ l e n s i n g } + \mathrm { B A O }$ data gives $H _ { 0 } = 6 9 . 4 _ { - 0 . 9 } ^ { + 0 . 7 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL [855], reducing the tension with R20 at $2 . 5 \sigma$ . An update of this model is performed in Ref. [856], where $P l a n c k 2 0 1 8 + \mathrm { C M B }$ lensing $P l a n c k 2 0 1 8 + \mathrm { C M B }$ lensing $^ +$ BAO $+ \textrm { R l 9 }$ ) gives $H _ { 0 } = 6 9 . 6 _ { - 1 . 7 } ^ { + 0 . 8 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ $H _ { 0 } = 7 0 . 0 6 \pm 0 . 8 1 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } } )$ at $6 8 \%$ CL [856], alleviating the Hubble tension at $2 . 4 \sigma$ (2.1σ).

For the conformal coupling model, a fit to $P l a n c k 2 0 1 5 \ \mathrm { T T } + \mathrm { C M B \ l e n s i n g } + \mathrm { B A O }$ data gives $H _ { 0 } = 6 9 . 1 9 _ { - 0 . 9 3 } ^ { + 0 . 7 7 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL [855], in disagreement with R20 at $2 . 7 \sigma$ . An update of this model is performed in Ref. [856], where Planck $2 0 1 8 + \mathrm { C M B }$ lensing $( P l a n c k 2 0 1 8 + \mathrm { C M B \ l e n s i n g + B A O + R 1 9 } )$ gives $H _ { 0 } = 6 9 . 0 _ { - 1 . 2 } ^ { + 0 . 7 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ $( H _ { 0 } ~ = ~ 6 9 . 6 4 _ { - 0 . 7 3 } ^ { + 0 . 6 5 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } } )$ at $6 8 \%$ CL [856], with the Hubble tension still in disagreement at $2 . 8 \sigma$ $( 2 . 4 \sigma )$ .

An extension of the previous scenario is studied in Ref. [857], where the non-minimal coupling of the scalar field to the Ricci scalar is:

$$
F ( \sigma ) = 1 + \xi \sigma ^ { n } .
$$

Unfortunately, all the cases considered in the context of this model are in disagreement with R20 at more than $3 \sigma$ .

A similar scenario, where a variation of the Newton’s gravitational constant $G _ { N }$ between the early and the late Universe is accounted for, in the context of a scalar field model which is non-minimally and quadratically coupled to gravity, is considered in Ref. [858]. The $H _ { 0 }$ value for this model using Planck 2018 $^ +$ BAO is estimated to be $H _ { 0 } = 6 8 . 2 4 _ { - 0 . 7 9 } ^ { + 0 . 5 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL [858] and the disagreement with R20 is at the level of $3 . 5 \sigma$ .

10.6.1. Early modified gravity: The scenario described by the action in Eq. (102) with $F ( \sigma ) = 1 + \xi \sigma ^ { 2 }$ and with the potential $V ( \sigma ) ~ = ~ \lambda \sigma ^ { 4 } / 4$ ( $\lambda$ is a free parameter) has been recently studied in Ref. [859], where it has been named “Early Modified Gravity

model”.16

For this model, the combination of the Planck $2 0 1 8 + \mathrm { B A O } + \mathrm { F S } + \mathrm { P a n t h e o n } + \mathrm { R 1 9 }$ $^ +$ H0LiCOW datasets gives $H _ { 0 } = 7 1 . 0 0 _ { - 0 . 7 9 } ^ { + 0 . 8 7 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [859], reducing the Hubble tension at $1 . 4 \sigma$ with R20. The analysis already includes a Gaussian prior on $H _ { 0 }$ .

This result is in agreement with the same analysis performed independently in Ref. [863] and called Conformally Coupled Modified Gravity. For Planck 2018 this model gives $H _ { 0 } = 6 7 . 9 8 _ { - 1 . 1 } ^ { + 0 . 6 3 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [863], reducing the Hubble tension at $3 . 7 \sigma$ .

10.6.2. Screened Fifth Forces: The reduction of the fifth force strength that occurs in regions of strong gravitational field (known as screening) is a fairly generic property of scalar-tensor gravity theories, see e.g. Refs. [864, 865]. Due to this behaviour, the distance ladder inferred from Cepheid measurements could be altered if a screened fifth force is present [866].

In Ref. [867] the assumption that the physics of Cepheid stars is identical across the galaxies used to build the cosmic distance ladder is questioned. The authors consider different models in which a screened fifth force is realized and show how altering the Cepheid calibration of supernova distances leads to a possible reduction of the disagreement in the Hubble constant measurements. In addition, in Ref. [868] it is shown that a fifth force is also effective for the TRGB calibration of the distance ladder, lowering the inferred $H _ { 0 }$ value.

# 10.7. Uber-gravity ¨

The ¨uber gravity model is a fixed point in the space of the gravity models obtained from varying the Ricci scalar [869]. This model mimics the Einstein-Hilbert theory in the high-curvature regime, while in the low-curvature regime it predicts a sharp transition at a model-dependent Ricci scale $R _ { 0 }$ . The cosmological model embedded in this theory, the ¨uΛCDM model, is characterised by a density-dependent transition between $\Lambda$ CDM and a phase in which the Ricci scalar is constant [870].

This scenario has been proposed to alleviate the Hubble tension in Ref. [871]. The combined analysis of Planck $2 0 1 5 \ \mathrm { T I ^ { * } + R I 6 \ + }$ BAO for this model estimates $H _ { 0 } =$ $7 0 . 6 _ { - 1 . 3 } ^ { + 1 . 1 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [871], in agreement with R20 at $1 . 5 \sigma$ . However, this result relies exclusively on Planck temperature data at high multipoles, on a Gaussian prior on $H _ { 0 }$ , as measured by R16, and on BAO measurements. In Ref. [871] it is shown that for Planck 2015 alone the constraints are largely relaxed, and therefore a possible agreement with R20 would be possible within one standard deviation. An updated analysis for this scenario has been performed in Ref. [59], and Planck 2018 (Planck 2018 $^ +$ CMB lensing $+$ R19) measurements provide a value of $H _ { 0 } = 7 0 . 7 _ { - 2 . 6 } ^ { + 1 . 4 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at ( $H _ { 0 } = 7 3 . 2 \pm 1 . 3 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } } )$ at 68% CL [59], in agreement with R20 within $1 . 3 \sigma$ $( 1 \sigma )$ .

# 10.8. Galileon gravity

The Covariant Galileon model is a theory of modified gravity in which the accelerated expansion rate of the Universe is driven by a scalar field $\varphi$ , whose Lagrangian is invariant under the Galilean shift symmetry by a constant vector $b _ { \mu }$ , $\partial _ { \mu } \varphi  \partial _ { \mu } \varphi + b _ { \mu }$ [872, 873]. One aspect of this model is that the background component of the Galileon field $\phi$ is described by a “tracker” evolution, $H \mathrm { d } \phi / \mathrm { d } t \propto \xi$ , where $\xi$ is a constant [874]. Once the Galileon field has reached the tracker solution, its energy density contributes appreciably to the total energy budget, reaching the present value

$$
\Omega _ { \phi 0 } = { \frac { c _ { 2 } } { 6 } } \xi ^ { 2 } - 2 c _ { 3 } \xi ^ { 3 } + c _ { 4 } { \frac { 1 5 } { 2 } } \xi ^ { 4 } + c _ { 5 } { \frac { 7 } { 3 } } \xi ^ { 5 } .
$$

Depending on the highest exponent for $\xi$ , we refer either to the cubic ( $c _ { 4 } = c _ { 5 } = 0$ ), quartic ( $c _ { 5 } = 0$ ), or quintic Galileon model.

In Ref. [875] the Galileon gravity scenario has been proposed to solve the Hubble tension. When the total neutrino mass is allowed to vary in addition to the standard parameters, the combination Planck 2015 TT $+$ CMB lensing $^ +$ BAO leads to the values $H _ { 0 } \ = \ 7 1 . 6 \pm 2 . 1 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ , $H _ { 0 } ~ = ~ 7 2 . 4 \pm 2 . 0 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ and $H _ { 0 } \ =$ $7 2 . 3 \pm 2 . 1 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ for the several possible Galileon scenarios (cubic, quartic and quintic, respectively), all with 95% CL errors. The Hubble tension is therefore reduced in these cases within $1 \sigma$ , even if the BAO observations are also included. Updated results with Planck 2018 are not yet available.

A similar scenario has been analysed in Ref. [876], where the authors studied a generalized cubic covariant Galileon scenario. Planck 2015 TT (Planck 2015 TT $+ \ \mathrm { B A O } \ + \ \mathrm { R S D } \ + \ \mathrm { J L A } \rangle$ ) gives in this case $H _ { 0 } = 7 2 _ { - 5 } ^ { + 8 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ ( $H _ { 0 } ~ = ~ 6 8 . 4 \pm$ $0 . 9 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } } )$ at 95% CL [876], solving the Hubble tension within $1 \sigma$ (3.4σ). Once the Planck high- $\ell$ polarization is included, the Hubble tension is however restored.

In Ref. [877], instead, it has been argued that the problem can be overcome in the Enhanced Early Gravity model, i.e. an exponentially coupled cubic Galileon scenario, where $P l a n c k 2 0 1 8 + \mathrm { B A O }$ gives $H _ { 0 } = 6 8 . 7 \pm 1 . 5 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL, relaxing the Hubble tension down to $2 . 3 \sigma$ level.

Within the subclass of Generalized Proca interactions [878–880], the authors of Ref. [881] focus on the cubic Galileon scenario, based on a vector field for the solution of the Hubble constant tension, mainly due to the phantom-like behaviour of dark energy. Using a combination of $P l a n c k ~ 2 0 1 8 ~ + ~ \mathrm { B A O } ~ + ~ \mathrm { P a n t h e o n } ~ + ~ \mathrm { R 1 9 }$ , they find $H _ { 0 } = 7 0 . 1 \pm 0 . 7 6 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [881], alleviating the Hubble tension at $2 . 4 \sigma$ , but including a Gaussian prior on $H _ { 0 }$ . The same dataset combination without R19 restores the tension above $3 \sigma$ .

Finally, in Ref. [882] a Galileon ghost condensate model has been studied to alleviate the Hubble constant tension. For this scenario Planck 2015 TT (Planck 2015 TT + BAO $+ \ \mathrm { R S D } + \mathrm { J L A } )$ gives $H _ { 0 } = 6 9 . 3 _ { - 3 . 0 } ^ { + 3 . 6 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ ( $H _ { 0 } = 6 8 . 1 \pm 1 . 1 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } } )$ at 95% CL [882], solving the Hubble tension within 1.8σ $( 3 . 6 \sigma )$ .

# 10.9. Nonlocal gravity

The introduction of quantum gravity effects in the Einstein-Hilbert action leads to the presence of non-local effects that typically signal the presence of quantum properties corresponding to the local fundamental action of gravity, including the effect of quantum fluctuations [883, 884]. Among the possible nonlocal gravity models there is the RR scenario, in which the Einstein-Hilbert action in Eq. (87) is modified as [885]

$$
S = \frac { 1 } { 2 \kappa ^ { 2 } } \int \mathrm { d } ^ { 4 } x \sqrt { - g } \left[ { \mathcal R } - \frac { m ^ { 2 } } { 6 } { \mathcal R } \frac { 1 } { \bigstar \bigstar ^ { 2 } } { \mathcal R } \right] + S _ { m } ,
$$

where $m$ is a new mass parameter. In in this scenario, the nonlocal term acts as an effective dark energy with a phantom equation of state.

The RR model is relevant for solving the Hubble tension [886]. For this particular scenario, the combination of Planck 2015 $6 9 . 4 9 _ { - 0 . 8 0 } ^ { + 0 . 7 9 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL [886], reducing th $^ +$ BAO Hubble constant tension down JLA results in to $2 . 5 \sigma$ .

Updated results for nonlocal gravity models have been performed in Ref. [887]. While the RR model does not satisfy the Lunar Laser Ranging constraints, the RT model [888] works better and for Planck 2018 $^ +$ Pantheon $+$ BAO the minimal case gives $H _ { 0 } = 6 8 . 7 4 _ { - 0 . 5 1 } ^ { + 0 . 5 9 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL [887], reducing the tension with R20 at $3 . 2 \sigma$ .

# 10.10. Unimodular gravity

Another gravitational theory having close resemblance to the Einstein gravity is the unimodular gravity. The unimodular gravity is obtained by adding the unimodular condition [889] to the Einstein-Gravity action through the Lagrange multiplier $\lambda$ [890].

The possibility that this gravitational theory could help in resolving of the $H _ { 0 }$ tension has been recently discussed in Ref. [890]. The $H _ { 0 }$ tension can be alleviated by allowing for a non-gravitational interaction between the dark matter and the dark energy fluids within this gravitational context. Considering four different interaction rates between the dark matter and dark energy, namely, Sudden Transfer Model (Model 1), Anomalous Decay of the Matter Density (Model 2), Barotropic Model (Model 3) and Continuous Spontaneous Localization (Model 4), the best estimations of the Hubble constant for the combined dataset including Planck 2018 CMB distance priors $\mathrm { + \ P a n t h e o n + \ R 1 9 \ + \ H 0 L i C O W }$ , are, respectively, $H _ { 0 } ~ = ~ 7 3 . 4 _ { - 0 . 6 } ^ { + 1 . 5 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [890] (Model 1), $H _ { 0 } ~ = ~ 7 3 . 2 _ { - 0 . 9 } ^ { + 1 . 4 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL [890] (Model 2), $H _ { 0 } = 7 0 \pm 1 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [890] (Model 3) and $H _ { 0 } = 7 2 \pm 1 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [890] (Model 4). For Model 1, Model 2 and Model 4, the $H _ { 0 }$ values are in agreement with R20 within $1 \sigma$ , while for Model 3 the $H _ { 0 }$ tension with R20 is reduced to $2 \sigma$ . However, when only CMB data are considered, the value of $H _ { 0 }$ is unconstrained, and therefore the Gaussian priors on the Hubble constant are essential in the analysis to constrain it. A complete data analysis to Planck 2018 observations is missing.

# 10.11. Scale − dependent scenario of gravity

A cosmological model with a scale − dependent scenario of gravity has been proposed in Ref. [891] to potentially alleviate the Hubble tension. Unfortunately, the data analysis is missing.

# 10.12. VCDM

A cosmological theory where the cosmological constant term $\Lambda$ of the standard $\Lambda$ CDM scenario is replaced by a free function $V ( \phi )$ , without introducing any extra physical degrees of freedom, was proposed in Ref. [892]. The ‘ $V$ ’ of V CDM therefore stands for the free function $V ( \phi )$ . The authors of Ref. [893] studied a specific model in this context finding that the $H _ { 0 }$ tension can be alleviated. Planck 2018 + BAO $^ +$ Pantheon gives $H _ { 0 } = 7 1 . 7 3 _ { - 0 . 2 9 } ^ { + 0 . 5 8 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $9 5 \%$ CL [893], alleviating the tension with R20 at $1 . 1 \sigma$ .

# 11. Inflationary models

Inflation [4–6] is a period of accelerated expansion that is believed to take place at the very early stages in the history of the Universe. It was first proposed to explain the homogeneity, isotropy, and flatness observed in the CMB, as well as the lack of relic monopoles [894, 895].

A period of inflation can be achieved when the expansion rate of the Universe is driven by the energy density of a rolling scalar field $\phi$ , the inflaton [896, 897]. In this framework, the quantum fluctuations of the inflaton field seed the density perturbations that are observed in the CMB, and later develop into the large scale structures observed [898, 899]. Within a specific model of inflation, it is possible to characterize various observables, such as the scalar spectral index $n _ { s }$ and its running $\mathrm { d } n _ { s } / \mathrm { d } \log k$ , the tensor-to-scalar ratio $r$ , the spectral index of tensor perturbations $n _ { T }$ , and the non-Gaussianity parameter $f _ { \mathrm { N L } }$ . To date, the most stringent constraints on the theory of inflation come from the observations of the CMB by the Planck satellite, which include the features of the power spectrum [900] and the bispectrum [901] of temperature anisotropies.

With such a successful beginning, the theory of inflation got a wide attention in the cosmological community and consequently this theory was intensively investigated over the years, see e.g Refs. [902–941] (see also Refs. [942,943] and references therein).17 In this section, we shall point out some recent works where modifications of the early 17 In this context, we refer to a very interesting class of models known as “quintessential inflation” [944– 964] that try to connect two distant accelerating phases of the Universe − inflation and quintessence.

Universe physics, either through a suitable choice of the inflationary potential or by modifying the primordial power spectrum, allow the Hubble constant tension to be alleviated.

Since the data points (referring to the number of models constraining $\Omega _ { m } h ^ { 2 }$ , $H _ { 0 }$ and $r _ { d } h$ ) in Sections 11–14 are very small in number, we have combined the Sections 11–14 into two Figures 17 and 18.

# 11.1. Exponential inflation

In the single-field inflation model, there exists a degeneracy between the spectral index of the primordial scalar power spectrum, $n _ { s }$ , and $N _ { \mathrm { e f f } }$ , see e.g. Ref. [965]. Therefore, in principle, it is possible to build a model in which the interplay between the inflationary mechanism and the presence of additional dark radiation may alleviate the Hubble tension, due to the strong correlation between $\Delta N _ { \mathrm { e f f } }$ and $H _ { 0 }$ . In the following, we shall discuss the inflationary models that embed additional dark radiation.

The authors of Ref. [966] re-examine various inflationary models in light of the presence of additional dark radiation. They study the large-field inflation scenario with a potential $V ( \phi ) \propto \phi ^ { 2 }$ [967], the natural inflation model [968, 969], the Starobinsky model [970], and the power-law inflation paradigm (PLI) [971], in which the potential is given in terms of an amplitude $M$ and an index $\alpha > 0$ by:18

$$
V ( \phi ) = M ^ { 4 } \exp \left( - \alpha \frac { \phi } { M _ { \mathrm { P l } } } \right) .
$$

In the $\Lambda$ CDM, the PLI model is excluded since it predicts a value of the tensor-toscalar ratio $r = 8 ( 1 - n _ { s } )$ that lies above the limit from current observations [972]. However, when including an extra component of dark radiation, the relatively large value of $n _ { s }$ predicted within PLI, turns into an opportunity to address the Hubble tension since, using Planck 2015 TT $^ +$ CMB lensing datasets, the Hubble constant results in $H _ { 0 } = 7 3 . 6 \pm 0 . 9 5 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [966], in agreement with R20 within $1 \sigma$ (see also Ref. [973] for similar results). For the very same scenario, the addition of the CMB polarization data and a lower value for the optical depth $\tau$ , as preferred by the new Planck 2018 power spectra, restores the Hubble constant tension above 3 standard deviations [974]. The same results are confirmed even when an origin of the Universe from the quantum landscape multiverse is considered (see Ref. [975]).

# 11.2. Reconstructed Primordial Power Spectrum

A possibility for solving the Hubble tension is to change the primordial power spectrum (PPS). In Ref. [976] it has been shown that band-limited features in the PPS can not resolve the Hubble tension.

18 PLI earns its name from the fact that the exact solution for the scale factor in the model is a(t) ∝ t2/α2 .

In Ref. [977], instead, the shape of the PPS is reconstructed by implementing a Modified Richardson-Lucy algorithm (MRL), and assuming the fitting of the Planck 2015 TT data, $H _ { 0 }$ from R18 and $S _ { 8 }$ from the cosmic shear data. This reconstructed model allows the data to be perfectly in agreement with the measured R20 Hubble constant. The reconstructed form of the PPS will have a suppression of power at large scales and sharp fluctuations at wave numbers larger than $0 . 0 2 \mathrm { M p c } ^ { - 1 }$ .

A generalization is performed in Ref. [978], where a class of PPS, that continuously deforms between the best-fit power-law and the MRL-reconstructed PPS, is parameterized. This interpolation is called “deformation model”, and the Hubble constant is degenerate with the new degree of freedom in the PPS. Using Planck 2018 TT, the Hubble constant is $H _ { 0 } = 7 0 . 2 \pm 1 . 2 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [978], solving the tension with R20 at $1 . 7 \sigma$ . However, it is unclear whether this result holds once polarization data are included in the analysis.

# 11.3. Lorentzian Quintessential Inflation

In Ref. [979] the authors show that the quintessential inflation, coming from the Lorentzian distribution introduced in Refs. [980,981], agrees with the recent observations and is in agreement with R20. In particular they find for Planck 2018 CMB distance priors $+$ BAO $^ +$ Pantheon $^ +$ CC $+$ R19, $H _ { 0 } = 7 1 . 7 5 \pm 0 . 8 9 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL [979].

# 11.4. Harrison-Zel’dovich spectrum

Because of the existing degeneracy between $n _ { s }$ , $N _ { \mathrm { e f f } }$ , and $H _ { 0 }$ , in Ref. [982] the authors pointed out that in light of the Hubble tension a Harrison-Zel’dovich [983–985] primordial power spectrum $n _ { s } = 1$ is not ruled out by the data.

# 12. Modified recombination history

Early recombination scenarios can also be a possible route to obtain a higher values of the Hubble constant and thus alleviate the $H _ { 0 }$ tension. We refer to Figures 17 and 18 for an overall idea about the models in this section.

In Ref. [986] a general phenomenological model that modifies the timing and width of the recombination processes has been considered. Planck 2015 (Planck 2015 + BAO) gives $H _ { 0 } = 6 7 . 1 7 _ { - 2 . 1 7 } ^ { + 2 . 0 4 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ ( $H _ { 0 } = 6 8 . 1 7 _ { - 1 . 1 4 } ^ { + 1 . 1 8 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } } )$ at 68% CL [986], alleviating the tension at $2 . 5 \sigma$ $( 2 . 8 \sigma )$ . In Ref. [987] it is possible to find a different approach.

# 12.1. Effective Electron Rest Mass

A modified effective electron rest mass $m _ { e }$ during the cosmological recombination era [988] could provide a mechanism to reduce the Hubble constant tension. In Ref. [989] it has been shown that Planck 2018 $^ +$ BAO gives $H _ { 0 } = 6 9 . 1 \pm 1 . 2 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [989] for a varying $m _ { e }$ , lowering the $H _ { 0 }$ tension down to the $2 . 3 \sigma$ level. The concordance model results in a larger electron rest mass $m _ { e } = ( 1 . 0 0 7 8 \pm 0 . 0 0 6 7 ) m _ { e , 0 }$ at 68% CL [989].

# 12.2. Time Varying Electron Mass

In Ref. [990], an explicit model showing how the recombination history of the Universe can be modified has been proposed, in which a time varying electron mass $m _ { e }$ plays a key role. Specifically, a time varying electron mass can shift the recombination epoch $z _ { * }$ and the drag epoch $z _ { d }$ from the baseline model without affecting the CMB power spectra. Thus, considering the varying electron mass within the $\Omega _ { k } \Lambda$ CDM model, the best estimated value of the Hubble constant for Planck 2018 $^ +$ BAO $^ +$ Pantheon is $H _ { 0 } = 7 2 . 3 _ { - 2 . 8 } ^ { + 2 . 7 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [990]. This reconciles the tension with R20 at less than $1 \sigma$ .

# 12.3. Axi-Higgs model

The authors of Ref. [991] present a simple model in which a light axion is coupled to the Higgs field. In this scenario, the Higgs vacuum expectation value in the early Universe is larger than its measured value, thus modifying the electron rest mass and possibly alleviating the Hubble tension (see Section 12.1). The largest estimate presented in Ref. [991] for the Hubble constant is achieved with an analysis a posteriori of the results obtained in [989] for $P l a n c k 2 0 1 8 + \mathrm { B A O }$ , with $m _ { e }$ free to vary. Assuming a model with non-linear BBN, the analysis gives $H _ { 0 } = 6 9 . 2 4 \pm 0 . 6 8 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [991], alleviating the tension with R20 at $2 . 6 \sigma$ . A complete full CMB data analysis is however missing.

# 12.4. Primordial magnetic fields

Additional small-scale, mildly non-linear inhomogeneities in the baryon density changing the recombination history could be a possible route to alleviate the $H _ { 0 }$ tension [992]. These might be caused by the evolution of primordial magnetic fields (PMF) prior to recombination.

Using the model proposed in Ref. [993] and analysed in Ref. [994], the combination of Planck 2018 $^ +$ CMB lensing $^ +$ R19 $^ +$ H0LiCOW $+$ MCP gives $H _ { 0 } ~ = ~ 7 1 . 0 3 \pm$ $0 . 7 4 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [992], reducing the Hubble tension at $1 . 4 \sigma$ . However, Gaussian priors on the Hubble constant are already included in this analysis, inducing a possible bias in the result.

Another possibility is to have a weaker impact on recombination, with only a tiny fraction of the total volume in high density regions. Planck $^ +$ CMB lensing $^ +$ R19 + $\mathrm { H 0 L i C O W + M C P }$ results in a value of $H _ { 0 } = 6 9 . 8 1 { \pm } 0 . 6 2 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [992], alleviating the Hubble tension down to the $2 . 4 \sigma$ level. Nevertheless, the Gaussian priors are also already included in this analysis, as in the previous case, which may bias the result.

![](images/e92a3ea21779292859bbef3f5751b327d4875eae9007d724219522aeab4c21ee.jpg)  
Figure 17. Estimated values of the current matter energy density $\Omega _ { m } h ^ { 2 }$ , Hubble constant $H _ { 0 }$ and sound horizon $r _ { d } h$ in terms of various data points for different models discussed throughout Sections 11-14. The cyan horizontal band corresponds to the $H _ { 0 }$ value measured by R20 [2], the yellow vertical band to the $\Omega _ { m } h ^ { 2 }$ value estimated by Planck 2018 [11] in a ΛCDM scenario, and the light green horizontal band to the $r _ { d } h$ value measured by BAO data. The points sharing the same symbol refer to the same model in the same paper, and the different colors indicate a different dataset combination.

![](images/eb9e2d1aefa732c510474856c47ea5a5dc91e14bb83af5f923d32ef0f2413236.jpg)  
Figure 18. Whisker plot with the $6 8 \%$ ( $9 5 \%$ if dashed) marginalized Hubble constant constraints for the models of Sections 11-14. The cyan vertical band corresponds to the $H _ { 0 }$ value measured by R20 [2] and the light pink vertical band corresponds to the $H _ { 0 }$ value estimated by Planck 2018 [11] in a ΛCDM scenario. For each line, when more than one error bar is shown, the dotted one corresponds to the Planck only constraint on the Hubble constant, while the solid one to the different dataset combinations reported in the red legend, in order to appreciate the shift due to the additional datasets.

# 13. Physics of the critical Phenomena

Since the physics operating at late time seems to be different from the physics of early time, yet another interesting possibility could be a phase transition in the dark sector. The critical phenomena studied extensively the idea of a phase transition, in which local interactions of a many-body system produce a global phase transition, if a free parameter of the model is lowered beyond a critical point.

We refer to Figures 17 and 18 summarizing the performance of the models discussed in this section in light of the Hubble constant tension.

# 13.1. Double-ΛCDM (ΛΛCDM)

The $D o u b l e - \Lambda$ Cold Dark Matter (ΛΛCDM) scenario is inspired by the Ising model, a classic model of critical phenomena describing the phase transition from para-magnet to ferro-magnet at Curie temperature. This cosmological scenario assumes a cosmological constant with two values before a transition redshift and with a single value afterwards. In Ref. [995] it has been shown that, with this phase transition in the dark sector, the Hubble constant tension can be solved. Considering a $\chi ^ { 2 }$ analysis, and the combination of Planc $\mathrm { : } k 2 0 1 5 \mathrm { T T } + \mathrm { B A O } + \mathrm { R 1 9 }$ , the Hubble constant is $H _ { 0 } = 7 2 . 8 \pm 1 . 6 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [995]. The $H _ { 0 }$ tension with R20 is therefore solved within $1 \sigma$ , but including already a Gaussian prior on $H _ { 0 }$ .

# 13.2. Ginzburg-Landau theory of phase transition

In the Ginzburg-Landau theory of dark energy a phase transition happens, causing a spontaneous symmetry breaking, in the Landau approximation. Considering a $\chi ^ { 2 }$ analysis, and the combination of Planck 2015 CMB distance priors on the angular size of horizon at decoupling and $\Omega _ { m } h ^ { 2 } + \mathrm { B A O } + \mathrm { R } 1 8 +$ quasars $H ( z )$ data, the Hubble constant is $H _ { 0 } = 7 1 . 8 9 \pm 0 . 9 3 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [996]. While the $H _ { 0 }$ tension with R20 is therefore solved within $1 \sigma$ , this result relies on a non full CMB data analysis and includes already a Gaussian prior on $H _ { 0 }$ .

# 13.3. Critically Emergent Dark Energy

Based on the physics of the critical phenomena, a dark energy model named as Critically Emergent Dark Energy was recently proposed in Ref. [997]. The evolution of the dark energy in this model takes the form:

$$
\Omega _ { \mathrm { D E } } ( z ) = \left( 1 - \Omega _ { m } - \Omega _ { r } \right) \sqrt { \frac { z _ { c } - z } { z _ { c } } } ,
$$

where $z _ { c }$ is the transition redshift from which dark energy starts to emerge, and the corresponding DE equation of state is

$$
w _ { \mathrm { D E } } ( z ) = - 1 - \frac { 1 + z } { 6 ( z _ { c } - z ) } .
$$

For this model, a fit to Planck 2018 data results in a value of $H _ { 0 } = 7 0 . 0 _ { - 2 . 7 } ^ { + 1 . 2 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL [997], which solves the tension with R20 within $1 . 8 \sigma$ .

# 14. Alternative proposals

In this section we include a number of models that can not be catalogued in any of the sections detailed before, i.e. other than dark energy, dark radiation, interacting models or modified gravity scenarios. In Figures 17 and 18 we have shown the viability of the models in light of the Hubble constant tension.

# 14.1. Local Inhomogeneity

Inhomogeneities in the density distribution could lead to a modification of the expansion rate over some finite region of spacetime; a domain average density in the locally observed region would lead to a modification of the estimate for the local Hubble parameter from the value inferred from using the global background energy density, see Section 3.1 for the relevant literature.

In Ref. [998] the possibility that the Hubble tension could be solved within the general relativistic framework of perturbation theory in an inhomogeneous Universe is investigated. The authors find that the crucial point is the first-order effect due to inhomogeneities at linear order in perturbation theory.

# 14.2. Bianchi type I spacetime

In Ref. [999] a simple anisotropic correction to the standard $\Lambda$ CDM model by replacing the spatially flat FLRW metric with the Bianchi type-I metric has been investigated. Adopting a compilation of 36 $H ( z )$ measurements from CC, BAO signal in both galaxy and Ly- $\alpha$ forest distributions, the authors estimate $H _ { 0 } = 7 0 . 4 \pm 1 . 7 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL [999] in the anisotropic $\Lambda$ CDM scenario, in combination with the Planck 2015 distance prior, which is in agreement with both the CMB and the R20 values within $2 \sigma$ . A full analysis considering CMB data is still missing, but the scenario is highly promising.

# 14.3. Scaling Solutions

The inclusion of the backreaction from inhomogeneities in the cosmological expansion within GR has been proposed in Refs. [181–184], see also Section 3.1. This scheme is generally referred to in the literature as the “Buchert equations”.

In Ref. [1000] a class of ‘scaling solutions’ satisfying this scalar averaging scheme has been proposed to solve the Hubble tension, while at the same time being in agreement with a slightly positively curved Universe as measured by Planck [11,18,19]. In fact, in this generic average model, there is a dynamical curvature, i.e. curvature and structure in the matter distribution are dynamically coupled within GR and without the necessity of introducing a Dark Energy component. A full data analysis is however missing for this interesting possibility.

In Ref. [1001], a GR fluid simulation of the LSS that includes a nonlinear evolution of structures leads to a negative emerging spatial curvature and to a value of the Hubble constant $H _ { 0 } = 7 2 . 5 { \pm } 2 . 1 \mathrm { k m } \mathrm { s } ^ { - 1 } \mathrm { M p c } ^ { - 1 }$ . Instead, neglecting the inhomogeneities, the same simulation finds a lower value $H _ { 0 } = 6 8 . 1 \pm 2 . 0 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ , in agreement with the findings in Ref. [1000]. Instead, an independent analysis following a fully inhomogeneous, anisotropic relativistic simulation finds that these effects alone are not sufficient to reconcile the discrepancy represented by the Hubble tension [1002].

# 14.4. CMB monopole temperature $T _ { 0 }$

In Ref. [1003] the possibility of varying the CMB monopole temperature $T _ { 0 }$ , typically fixed when considering the CMB data, is explored to solve the Hubble tension. This is in fact fixed because of the extremely good precision of measurements of $T _ { 0 }$ from the Cosmic Background Explorer (COBE) Far Infrared Absolute Spectrophotometer (FIRAS) data, molecular lines, and balloon-borne experiments, but should in principle be considered as an extra free cosmological parameter to be varied in the Bayesian analysis [1004]. Using Planck $2 0 1 8 ~ + ~ \mathrm { C M I }$ B lensing $( P l a n c k ~ 2 0 1 8 ~ + ~ \mathrm { C M B }$ lensing $^ +$ BAO), Ref. [1003] finds $H _ { 0 } = 5 5 . 3 _ { - 4 . 9 } ^ { + 1 . 7 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ $\mathrm { \Delta \cdot \mathrm { \Delta / \mathrm { \Delta / \mathrm { 6 7 . 9 2 } _ { - 0 . 5 1 } ^ { + 0 . 4 9 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } ) } } } }$ at 68% CL, increasing the tension with R20 at several standard deviations $( 3 . 8 \sigma )$ when varying $T _ { 0 }$ . Therefore, even if a strong anti-correlation is present between $T _ { 0 }$ and $H _ { 0 }$ , this is not enough for solving the Hubble tension because the CMB data prefer the wrong direction.

14.4.1. Open and Hotter Universe: Another interesting possibility to alleviate the Hubble constant tension may arise from considering a non-zero spatial curvature together with a free CMB temperature. In Ref. [1005], the authors consider such a scenario in light of Planck 2015, BAO and R19 data. The results show that both Planck 2015 and BAO prefer an open and hotter Universe with significantly higher expansion rate and the estimated values of $H _ { 0 }$ are in agreement with its local measurements from R20.

The possibility of a hotter Universe has been explored in Ref. [1006], where the currently available temperature-redshift $T ( z )$ measurements have been analysed. The authors find a good agreement with the FIRAS measurement and a discrepancy above $1 . 9 \sigma$ from the $T _ { 0 }$ value needed to solve the Hubble tension.

# 14.5. Super-ΛCDM

In Ref. [1007] it has been assumed that a non-Gaussian covariance, due to possibly non-Gaussian primordial fluctuations, can be extracted from a four-point correlation function. This non-Gaussian covariance can be modeled through two additional degrees of freedom describing the trispectrum in the theoretical CMB angular power spectrum, and the resulting model has been named as Super- $\Lambda$ CDM. The combination of Planck 2015 TT $+ ~ \tau$ prior $( P l a n c k ~ 2 0 1 5 ~ \mathrm { T T } + \tau$ prior $^ +$ R19 $^ +$ Pantheon) gives $H _ { 0 } = 6 8 . 4 _ { - 2 . 3 } ^ { + 2 . 5 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ ( $H _ { 0 } = 6 9 . 9 { \pm } 1 . 7 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } } \rangle$ ) at 95% CL [1007], reducing the Hubble tension at $2 . 7 \sigma$ $( 2 . 1 \sigma )$ . It should be checked if this result holds after the inclusion in the fit of the Planck 2018 polarization data.

# 14.6. Heisenberg uncertainty

In Ref. [1008] it has been studied how the Heisenberg principle can affect the reliability of cosmological measurements. The authors ascribe the Hubble tension as the effect due to the indetermination associated to the comparison of kinematical versus dynamical measurements. They conclude that the uncertainty on a possible photon mass not accounted for, can be the reason for the $H _ { 0 }$ disagreement.

# 14.7. Diffusion

Another possible way to alleviate the Hubble tension, considering an effective energy flux from the matter sector into dark energy has been proposed in Ref. [1009]. This scenario results naturally from a combination of unimodular gravity and an energy diffusion process. While the two simple models proposed in this study (one of them assuming a quick transfer of energy from the matter density to the cosmological constant sector, and a second one in which a diffusion process decreases anomalously the matter density) may be able to solve the Hubble tension. A complete data analysis is absent in the literature.

# 14.8. Casimir Cosmology

In Ref. [1010] the extrapolation of physics of the Quantum Vacuum [1011], a theory welltested in atomic, molecular and optical physics, has been proposed to solve the Hubble tension. In this model the vacuum energy is time-dependent because of the Casimir forces, and therefore $\Lambda$ varies with the cosmic expansion, allowing a larger value for $H _ { 0 }$ .

# 14.9. Surface forces

In Ref. [1012], the author argues that the inclusion of the surface forces of the homogeneous and isotropic Universe from the Euler Cauchy stress principle can explain the present accelerating expansion of the Universe without any dark energy fluid. The model was constrained using a joint analysis of Hubble parameter measurements and the Pantheon sample. The resulting value of the Hubble constant is enhanced $H _ { 0 } = 7 4 . 6 3 _ { - 2 . 7 } ^ { + 3 . 2 } \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at $6 8 \%$ CL [1012]) solving perfectly the tension with R20. A full analysis involving Planck 2018 data is missing.

# 14.10. Milne Model

In Ref. [1013], the author considers alleviating the Hubble tension within the Milne model [1014]. However, the model needs to be fitted with the observational data in order to be more conclusive in this direction.

# 14.11. Running Hubble Tension

In Ref. [1015] a running of $H _ { 0 }$ as a function of redshift is proposed to alleviate the Hubble tension, although a full data analysis is missing. A similar idea has been explored in Ref. [1016] to analyse the Pantheon SNIa data.

# 14.12. Rapid Transition in the effective Gravitational Constant

In Ref. [1017] a rapid transition in the value of the relative effective gravitational constant is proposed to explain the lower luminosity of local SNIa and solve the $H _ { 0 }$ crisis. In particular, the authors assume that there is a transition of this luminosity at $z _ { t } = 0 . 0 1$ , with a $1 0 \%$ higher luminosity at $z > 0 . 0 1$ , due to a gravitational transition, and they argue that this is a defined testable assumption which would fully resolve both the $H _ { 0 }$ and the $S _ { 8 }$ tensions, in addition to provide an equally good fit to BAO, SNIa and Planck. A full data analysis is however missing.

# 14.13. Causal Horizons

In Ref. [1018] it has been argued that CMB maps show “causal horizons” where cosmological parameters within each horizon can differ significantly, because those regions of the Universe have never been in causal contact. Within these causal horizons (see also Ref. [1019]) $H _ { 0 }$ takes values which differ up to 20%, and therefore, if similar “causal horizons” are present in the local Universe, variations between the local and high- $z$ measures of the Hubble constant are expected.

# 14.14. Milgromian Dynamics

In Ref. [1020] a Milgromian dynamics has been proposed as a possibility to solve the Hubble tension. Assuming a cosmological MOND model extended with the presence of sterile neutrinos with mass $\mathrm { 1 1 e V / c ^ { 2 } }$ , it has been shown that the Keenan-BargerCowie (KBC) void [1021] can arise, despite being highly unexpected within the $\Lambda$ CDM framework, and can naturally resolve the Hubble tension.

# 14.15. Charged Dark Matter

In Ref. [1022] a model of Charged Dark Matter has been explored to solve the Hubble tension. In this scenario, the Dark Matter is charged under a dark non-linear electromagnetic force which features a screening of the K-mouflage type [1023]. The idea is that the expansion of different shells is modified by the presence of the electric repulsion, and therefore the $H _ { 0 }$ value measured locally (inner shells) can be larger for the expansion rate due to the electric interaction with respect to the outer shells (see also Ref. [1024]). A full data analysis is however missing for this proposal.

# 15. Summary and Conclusions

The $\Lambda$ CDM cosmological model, a simple and elegant framework, has been found to provide a very good fit to almost all of the observational probes available until present. Despite its great success, the model is based on the assumption of three basic ingredients (CDM, a cosmological constant, and inflation) whose underlying physics are largely unknown.

The significant discrepancy in the Hubble constant measurements by early and local observations has raised a giant question mark over the $\Lambda$ CDM scenario. Along this review, we have focused in this timely and top-priority problem from a number of different perspectives.

The estimated value of $H _ { 0 }$ from early time data by the Planck satellite within the $\Lambda$ CDM paradigm [11] is significantly differing (at 4.2 $\sigma$ ) from the measured values of $H _ { 0 }$ in model-independent approaches, e.g. using the latest local distance ladders by SH0ES collaboration [2]. This has been confirmed by other astronomical missions as well (see Section 2 and references therein) leading to a serious and desperate crisis in cosmology. Understanding this large discrepancy in the different observational techniques of the Hubble constant is one of the most serious issues in modern cosmology. Over the last few years, the scientific community has taken a very active role in deciphering this problem. A very large number of possible solutions that could lead to a statistically convincing agreement between the early and late time values of $H _ { 0 }$ have been investigated. We have classified the proposed models and theories in the following categories: Early Dark Energy (Section 4), Late Dark Energy (Section 5), dark energy models with six degrees of freedom and their extensions (Section 6), models with extra relativistic degrees of freedom (Section 7), models with extra interactions (Section 8), Unified cosmologies (Section 9), Modified gravity (Section 10), Inflationary models (Section 11), Modified recombination history (Section 12), Physics of the critical Phenomena (Section 13), and Alternative proposals (Section 14).

The cosmological models arising from each category have been found to resolve the $H _ { 0 }$ tension with a significance ranging from the $1 \sigma$ to the $4 \sigma$ level. Based on this, one could first try to categorize these cosmological solutions as excellent, good, or moderate, depending on their ability to solve the $H _ { 0 }$ tension within $1 \sigma$ , $2 \sigma$ , and $3 \sigma$ , respectively, considering Planck data alone (see Table B1). Rather than being a quantitative model comparison method, this a priori simple and qualitative taxonomy provides nevertheless a very practical and sharp criteria to classify the large number of the proposed solutions. In fact, these a priori successful cosmological models are often not in agreement with additional cosmological probes, such as Baryon Acoustic Oscillations (BAO) or Pantheon data. Moreover, the Hubble constant tension is alleviated due to an increase in the error bars of $H _ { 0 }$ , rather than by an increase in the Hubble constant itself.

Clearly, this classification could appear extremely basic since it is just based on how well the proposed mechanism solves the tension while ignoring either the physics behind the model or the agreement with other cosmological observables such as, for example, BAO, as well as the effect of the correlation between the datasets, that could cause a fake solution.19 Still, it seems that models based on modifications of the dark energy sector (either dynamical or interacting dark energy) are somewhat more efficient in solving the tension than models based on early dark energy or neutrino-dark matter interactions.

For this reason, we can again now categorize these cosmological solutions as excellent, good, or promising, depending on their ability to solve the $H _ { 0 }$ tension within $1 \sigma$ , $2 \sigma$ , and $3 \sigma$ , respectively, considering Planck in combination with external data (mainly BAO, Pantheon, and R19), see Table B2. In this case, we are accounting for the overall ability of the model to agree with all the available cosmological data. Even if the datasets combinations are not the same for each model, however, this can give a good overview of the most promising proposals, with the details of the datasets combinations used in the text and Figures.

We see that, while no specific proposal makes a strong case for being highly likely or far better than all others, solutions to the Hubble puzzle present in both the Tables B1 and B2, i.e. involving EDE models, DE in extended parameters space, Dynamical DE, Metastable DE, PEDE, VM and its extension, IDE, self-interacting neutrinos, Galileon Gravity, $f ( \mathcal T )$ gravity, Uber-Gravity, Decaying DM, or Interacting Dark Radiation ¨ scenarios, can provide clear improvements to the fit of the cosmological data and thus offer the best options until a better solution comes along. Obviously, this is a priori classification method and a quantitative model comparison should be performed to make this statement more robust.

Note, that the list of potential cosmological models is quite large and therefore the phenomenology to explore is extremely rich. With the increased sensitivity in the experimental data and the precise measurements of the Hubble constant from various astronomical missions, it seems to us that the journey through the Hubble constant has just began. The measurements of the Hubble constant by the SH0ES collaboration in 2016 [64] ( $H _ { 0 } = 7 3 . 2 4 \pm 1 . 7 4 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL), 2018 [65] ( $H _ { 0 } = 7 3 . 4 8 { \pm } 1 . 6 6 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL), 2019 [66] ( $H _ { 0 } = 7 4 . 0 3 { \pm } 1 . 4 2 \mathrm { k m } \mathrm { s } ^ { - 1 } \mathrm { M p c } ^ { - 1 }$ at 68% CL) and 2020 [2] $H _ { 0 } = 7 3 . 2 { \pm } 1 . 3 \mathrm { k m s ^ { - 1 } M p c ^ { - 1 } }$ at 68% CL), have led to a striking tension, and consequently, to the strong need for an alternative physical scenario beyond $\Lambda$ CDM.

With this manuscript we aimed to the ambitious goal of presenting the most complete and up-to-date review of the proposed theoretical solutions to the Hubble tension. While we let the reader judge whether we have achieved our goal, we think to have clearly demonstrated how alternative cosmologies, beyond the canonical $\Lambda$ CDM paradigm, could play a crucial role in alleviating or solving this problem. The overwhelming effort in the field to find a new cosmological concordance scenario that could accommodate current tensions between complementary datasets that probe vastly different scales and times, strongly suggests that we are now facing a critical phase. While upcoming astronomical observations will shed light on this issue, a synergy of both new theoretical scenarios and improved experimental measurements will be mandatory to solve the Hubble constant puzzle.

# Acknowledgments

EDV acknowledges the support of the Addison-Wheeler Fellowship awarded by the Institute of Advanced Study at Durham University. OM is supported by the Spanish grants FPA2017-85985-P, PROMETEO/2019/083 and by the European ITN project HIDDeN (H2020-MSCA-ITN-2019//860881-HIDDeN). SP acknowledges the

Mathematical Research Impact-Centric Support Scheme [File No. MTR/2018/000940] of the Science and Engineering Research Board (SERB), Govt. of India. LV acknowledges support from the European Union’s Horizon 2020 research and innovation programme under the Marie Sk lodowska-Curie grant agreement No. 754496 (H2020- MSCA-COFUND-2016 FELLINI). WY is supported by the National Natural Science Foundation of China under Grants No. 11705079 and No. 11647153, and Liaoning Revitalization Talents Program under Grant no. XLYC1907098. AM thanks TASP, iniziativa specifica INFN, for support. DFM thanks the Research Council of Norway for their support. Computations were performed using resources provided by UNINETT Sigma2 – the National Infrastructure for High Performance Computing and Data Storage in Norway.

Appendix A. List of conventions and acronyms used   
Table A1. List of conventions and acronyms used in the review.   

<html><body><table><tr><td>Greek small letters μ, v...</td><td>Spacetime coordinates indices</td></tr><tr><td>Latin small letters i,j, k...</td><td>Space coordinates indices</td></tr><tr><td>gμv</td><td>Metric tensor</td></tr><tr><td></td><td>Covariant derivative</td></tr><tr><td>(一,+,+,+)</td><td>Metric signature</td></tr><tr><td>Typ</td><td>Levi-Civita connection</td></tr><tr><td>RB</td><td>Riemann curvature tensor</td></tr><tr><td>R=</td><td>Ricei ealar</td></tr><tr><td></td><td></td></tr><tr><td>Gμv =Rμv-2 THv gμvR</td><td>Einstein tensor</td></tr><tr><td>a(t)</td><td>Energy-momentum tensor</td></tr><tr><td>H(t）=</td><td>Scale factor as a function of cosmic time t</td></tr><tr><td></td><td>Hubble expansion rate at cosmic time t</td></tr><tr><td>T=s</td><td>Conformal time</td></tr><tr><td></td><td>Conformal time derivative of u</td></tr><tr><td>H=</td><td>Conformal Hubble expansion rate</td></tr><tr><td>Pm, PDM,Pb</td><td>Energy density of matter,dark matter,baryons</td></tr><tr><td>pr,Pv</td><td>Energy density of radiation and neutrinos</td></tr><tr><td>PDE，PDE</td><td>Energy density and pressure of dark energy</td></tr><tr><td>Wo</td><td>Equation of state with a constant value</td></tr><tr><td>WDE = PDE/PDE</td><td>Equation of state for dark energy (z-dependent)</td></tr><tr><td>Mp1 =1/√8πGN</td><td>Reduced Planck mass</td></tr><tr><td>K三√8πGN</td><td>Gravitational constant</td></tr><tr><td>Perit,0 = 3H2M21</td><td>Present critical energy density</td></tr><tr><td>Tup;T</td><td>Torsion tensor; torsion scalar</td></tr><tr><td>Qaμv = Vagμv; Q</td><td>Non-metricity tensor; non-metricity scalar</td></tr><tr><td>Nef;NSM =3.046</td><td>Effective number of neutrino species; SM value of Neff used here [404-406]</td></tr><tr><td></td><td>Comoving sound horizon at CMB last scattering</td></tr><tr><td>rd SM</td><td>Comoving sound horizon at the end of baryon-drag epoch</td></tr><tr><td>(C)DM</td><td>Standard Model</td></tr><tr><td>DE</td><td>(Cold) dark matter</td></tr><tr><td></td><td>Dark energy</td></tr><tr><td>CMB</td><td>Cosmic Microwave Background</td></tr><tr><td>WMAP</td><td>Wilkinson Microwave Anisotropy Probe</td></tr><tr><td>DES</td><td>Dark Energy Survey</td></tr><tr><td>SDSS</td><td> Sloan Digital Sky Survey</td></tr><tr><td>BAO</td><td>Baryon acoustic oscillations</td></tr><tr><td>BOSS</td><td>Baryon Oscillation Spectroscopic Survey</td></tr><tr><td>ACTPol</td><td>Atacama Cosmology Telescope Polarimeter</td></tr><tr><td>SPTPol</td><td>South Pole Telescope Polarimeter</td></tr><tr><td>Planck 2015/2018 TT</td><td> Planck 2015/2018 temperature power spectrum at high-l</td></tr><tr><td>Planck 2015/2018</td><td> Planck 2015/2018 temperature and polarization power spectra at high-l</td></tr><tr><td>BBN</td><td></td></tr><tr><td>HST</td><td>Big bang nucleosynthesis Hubble Space Telescope</td></tr><tr><td>LMC</td><td>Large Magellanic Cloud</td></tr></table></body></html>

Appendix B. Successful Models in light of the Hubble constant tension   

<html><body><table><tr><td>tension≤1σ“Excellentmodels”</td><td>tension≤2g“Good models”</td><td>tension≤3o“Promisingmodels&quot;</td></tr><tr><td>Dark energy in extended parameter spaces [289] Dynamical Dark Energy [309] Metastable Dark Energy [314] PEDE [392,394] Elaborated Vacuum Metamorphosis [400-402] IDE [314,636,637,639,652,657,661-663]</td><td>Early Dark Energy [235] Phantom Dark Energy [11] Dynamical Dark Energy [11,281,309] GEDE [397] Vacuum Metamorphosis [402]</td><td>Early Dark Energy [229] Decaying Warm DM [474] Neutrino-DM Interaction [506] Interacting dark radiation [517] Self-Interacting Neutrinos [700,701]</td></tr></table></body></html>

Table B1. Models solving the $H _ { 0 }$ tension with R20 within the $1 \sigma$ , $2 \sigma$ and $3 \sigma$ confidence levels considering the Planck dataset only.   

<html><body><table><tr><td>tension≤1g“Excellentmodels&quot; Early Dark Energy [228,235,240,250]</td><td>tension≤2σ “Good models”</td><td>tension≤3o“Promisingmodels”</td></tr><tr><td>Exponential Acoustic Dark Energy [259]</td><td>Early Dark Energy [212,229,236,263] Rock‘n&#x27;Roll [242]</td><td>DE in extended parameter spaces [289] Dynamical Dark Energy [281,309]</td></tr><tr><td>Phantom Crossing [315]</td><td></td><td>Holographic Dark Energy [350]</td></tr><tr><td></td><td>New Early Dark Energy [247]</td><td></td></tr><tr><td>Late Dark Energy Transition [317]</td><td>Acoustic Dark Energy [257]</td><td>Swampland Conjectures [370]</td></tr><tr><td>Metastable Dark Energy [314]</td><td>Dynamical Dark Energy [309]</td><td>MEDE [399]</td></tr><tr><td>PEDE [394]</td><td>Running vacuum model [332]</td><td>Coupled DM - Dark radiation [534]</td></tr><tr><td>Vacuum Metamorphosis [402]</td><td>Bulk viscous models [340,341]</td><td></td></tr><tr><td>Elaborated Vacuum Metamorphosis [401,402]</td><td>Holographic Dark Energy [350]</td><td>Decaying Ultralight Scalar [538]</td></tr><tr><td>Sterile Neutrinos [433]</td><td>Phantom Braneworld DE [378]</td><td>BD-ACDM [852]</td></tr><tr><td>Decaying Dark Matter [481]</td><td>PEDE [391,392]</td><td>Metastable Dark Energy [314]</td></tr><tr><td>Neutrino-Majoron Interactions [509]</td><td></td><td>Self-Interacting Neutrinos [700]</td></tr><tr><td>IDE[637,639,657,661]</td><td>Elaborated Vacuum Metamorphosis [401]</td><td>Dark Neutrino Interactions [716]</td></tr><tr><td>DM - Photon Coupling [685]</td><td>IDE [659,670]</td><td>IDE[634-636,653,656,663,669]</td></tr><tr><td>f(T) gravity theory [812]</td><td>Interacting Dark Radiation [517]</td><td>Scalar-tensor gravity [855,856]</td></tr><tr><td>BD-ACDM [851]</td><td>Decaying Dark Matter [471,474]</td><td>Galileon gravity [877,881]</td></tr><tr><td>Uber-Gravity [59]</td><td>DM - Photon Coupling 686]</td><td>Nonlocal gravity [886]</td></tr><tr><td>Galileon Gravity [875]</td><td>Self-interacting sterile neutrinos [711]</td><td>Modified recombination [986]</td></tr><tr><td>Unimodular Gravity [890]</td><td>f(T) gravity theory [817]</td><td>Effective Electron Rest Mass [989]</td></tr><tr><td>Time Varying Electron Mass [990]</td><td>Uber-Gravity [871] VCDM [893]</td><td>Super ACDM [1007]</td></tr><tr><td>MCDM[995]</td><td>Primordial magnetic felds [992]</td><td>Axi-Higgs [991]</td></tr><tr><td>Ginzburg-Landau theory [996]</td><td>Early modified gravity [859]</td><td>Self-Interacting Dark Matter [479]</td></tr><tr><td>Lorentzian Quintessential Inflation [979]</td><td></td><td>Primordial Black Holes [545]</td></tr><tr><td>Holographic Dark Energy [351]</td><td>Bianchi type I spacetime [999]</td><td></td></tr><tr><td></td><td>f(T） [818]</td><td></td></tr><tr><td></td><td></td><td></td></tr></table></body></html>

Table B2. Models solving the $H _ { 0 }$ tension with R20 within $1 \sigma$ , $2 \sigma$ and $3 \sigma$ considering Planck in combination with additional cosmological probes. Details of the combined datasets are discussed in the main text.

![](images/9badbb72e93d3e1a097ed621ac4e3537d6c6f0ad5b190a274a57c073901f73d5.jpg)  
Figure B1. In this plot we have an estimate of the density of the available cosmological models proposed to solve or alleviate the Hubble constant tension over the past couple of years. We have therefore accumulated the values of $\Omega _ { m } h ^ { 2 }$ , $H _ { 0 }$ and $r _ { d } h$ from various earlier figures (i.e. Figures 3, 5, 7, 9, 11, 13, 15, 17) into a single plot for a better understanding on the entire theme. The cyan horizontal band corresponds to the $H _ { 0 }$ value measured by R20 [2], the yellow vertical band to the $\Omega _ { m } h ^ { 2 }$ value estimated by Planck 2018 [11] for the base- $\Lambda$ CDM model, and the light green horizontal band to the $r _ { d } h$ value measured by BAO data (see the Planck Legacy Archive https://pla.esac.esa.int).

[1] Hubble E P 1936 The Realm of the Nebulae (Yale University Press)   
[2] Riess A G, Casertano S, Yuan W, Bowers J B, Macri L, Zinn J C and Scolnic D 2021 Astrophys. J. Lett. 908 L6 [arXiv:2012.08534]   
[3] Box G E P 1976 Journal of the American Statistical Association 71 791–799 URL https: //www.tandfonline.com/doi/pdf/10.1080/01621459.1976.10480949 [4] Brout R, Englert F and Gunzig E 1978 Annals Phys. 115 78 [5] Guth A H 1981 Phys. Rev. D 23 347–356 [6] Sato K 1981 Mon. Not. Roy. Astron. Soc. 195 467–479   
[7] Rubin V C and Ford Jr W K 1970 Astrophys. J. 159 379–403   
[8] Trimble V 1987 Ann. Rev. Astron. Astrophys. 25 425–472   
[9] Riess A G et al. (Supernova Search Team) 1998 Astron. J. 116 1009–1038 [arXiv:astroph/9805201]   
[10] Perlmutter S et al. (Supernova Cosmology Project) 1999 Astrophys. J. 517 565–586 [arXiv:astroph/9812133]   
[11] Aghanim N et al. (Planck) 2020 Astron. Astrophys. 641 A6 [arXiv:1807.06209]   
[12] Joudaki S et al. 2017 Mon. Not. Roy. Astron. Soc. 471 1259–1279 [arXiv:1610.04606]   
[13] Hildebrandt H et al. 2017 Mon. Not. Roy. Astron. Soc. 465 1454 [arXiv:1606.05338]   
[14] Hildebrandt H et al. 2020 Astron. Astrophys. 633 A69 [arXiv:1812.06076]   
[15] Asgari M et al. (KiDS) 2021 Astron. Astrophys. 645 A104 [arXiv:2007.15633]   
[16] Abbott T M C et al. (DES) 2018 Phys. Rev. D 98 043526 [arXiv:1708.01530]   
[17] Calabrese E, Slosar A, Melchiorri A, Smoot G F and Zahn O 2008 Phys. Rev. D 77 123531 [arXiv:0803.2309]   
[18] Di Valentino E, Melchiorri A and Silk J 2019 Nature Astron. 4 196–203 [arXiv:1911.02087]   
[19] Handley W 2021 Phys. Rev. D 103 L041301 [arXiv:1908.09139]   
[20] Ade P A R et al. (Planck) 2014 Astron. Astrophys. 571 A16 [arXiv:1303.5076]   
[21] Zyla P A et al. (Particle Data Group) 2020 PTEP 2020 083C01   
[22] Cooke R J, Pettini M and Steidel C C 2018 Astrophys. J. 855 102 [arXiv:1710.11129]   
[23] Hinshaw G et al. (WMAP) 2013 Astrophys. J. Suppl. 208 19 [arXiv:1212.5226]   
[24] Henning J W et al. (SPT) 2018 Astrophys. J. 852 97 [arXiv:1707.09353]   
[25] Dutcher D et al. (SPT-3G) 2021 [arXiv:2101.01684]   
[26] Aiola S et al. (ACT) 2020 JCAP 12 047 [arXiv:2007.07288]   
[27] Wang K and Huang Q G 2020 JCAP 06 045 [arXiv:1912.05491]   
[28] Balkenhol L et al. (SPT) 2021 [arXiv:2103.13618]   
[29] Addison G E 2021 Astrophys. J. Lett. 912 L1 [arXiv:2102.00028]   
[30] Ivanov M M, Simonovi´c M and Zaldarriaga M 2020 JCAP 05 042 [arXiv:1909.05277]   
[31] D’Amico G, Gleyzes J, Kokron N, Markovic K, Senatore L, Zhang P, Beutler F and Gil-Mar´ın H 2020 JCAP 05 005 [arXiv:1909.05271]   
[32] Colas T, D’amico G, Senatore L, Zhang P and Beutler F 2020 JCAP 06 001 [arXiv:1909.07951]   
[33] Strauss M A et al. (SDSS) 2002 Astron. J. 124 1810 [arXiv:astro-ph/0206225]   
[34] Alam S et al. (eBOSS) 2021 Phys. Rev. D 103 083533 [arXiv:2007.08991]   
[35] Scolnic D M et al. 2018 Astrophys. J. 859 101 [arXiv:1710.00845]   
[36] Troxel M A et al. (DES) 2018 Phys. Rev. D 98 043528 [arXiv:1708.01538]   
[37] Krause E et al. (DES) 2017 [arXiv:1706.09359]   
[38] Beutler F, Blake C, Colless M, Jones D H, Staveley-Smith L, Campbell L, Parker Q, Saunders W and Watson F 2011 Mon. Not. Roy. Astron. Soc. 416 3017–3032 [arXiv:1106.3366]   
[39] Ross A J, Samushia L, Howlett C, Percival W J, Burden A and Manera M 2015 Mon. Not. Roy. Astron. Soc. 449 835–847 [arXiv:1409.3242]   
[40] Alam S et al. (BOSS) 2017 Mon. Not. Roy. Astron. Soc. 470 2617–2652 [arXiv:1607.03155]   
[41] Abbott T M C et al. (DES) 2018 Mon. Not. Roy. Astron. Soc. 480 3879–3888 [arXiv:1711.00403]   
[42] Wang Y, Xu L and Zhao G B 2017 Astrophys. J. 849 84 [arXiv:1706.09149]   
[43] Zhang X, Huang Q G and Li X D 2019 Mon. Not. Roy. Astron. Soc. 483 1655–1662 [arXiv:1801.07403]   
[44] Zhang X and Huang Q G 2020 Sci. China Phys. Mech. Astron. 63 290402 [arXiv:1911.09439]   
[45] Sch¨oneberg N, Lesgourgues J and Hooper D C 2019 JCAP 10 029 [arXiv:1907.11594]   
[46] Cuceu A, Farr J, Lemos P and Font-Ribera A 2019 JCAP 10 044 [arXiv:1906.11628]   
[47] Zhang X and Huang Q G 2019 Commun. Theor. Phys. 71 826–830 [arXiv:1812.01877]   
[48] Corasaniti P S, Sereno M and Ettori S 2021 Astrophys. J. 911 82 [arXiv:2103.03283]   
[49] Philcox O H E, Sherwin B D, Farren G S and Baxter E J 2021 Phys. Rev. D 103 023538 [arXiv:2008.08084]   
[50] Aghanim N et al. (Planck) 2020 Astron. Astrophys. 641 A5 [arXiv:1907.12875]   
[51] Baxter E J and Sherwin B D 2021 Mon. Not. Roy. Astron. Soc. 501 1823–1835 [arXiv:2007.04007]   
[52] Philcox O H E, Ivanov M M, Simonovi´c M and Zaldarriaga M 2020 JCAP 05 032 [arXiv:2002.04035]   
[53] Pogosian L, Zhao G B and Jedamzik K 2020 Astrophys. J. Lett. 904 L17 [arXiv:2009.08455]   
[54] Cao S, Ryan J and Ratra B 2021 Mon. Not. Roy. Astron. Soc. 504 300–310 [arXiv:2101.08817]   
[55] Lemos P, Lee E, Efstathiou G and Gratton S 2019 Mon. Not. Roy. Astron. Soc. 483 4803–4810 [arXiv:1806.06781]   
[56] Efstathiou G and Gratton S 2019 [arXiv:1910.00483]   
[57] Ade P A R et al. (Planck) 2016 Astron. Astrophys. 594 A14 [arXiv:1502.01590]   
[58] Di Valentino E, Melchiorri A and Silk J 2016 Phys. Rev. D 93 023513 [arXiv:1509.07501]   
[59] Moshafi H, Baghram S and Khosravi N 2020 [arXiv:2012.14377]   
[60] Dhawan S, Brout D, Scolnic D, Goobar A, Riess A G and Miranda V 2020 Astrophys. J. 894 54 [arXiv:2001.09260]   
[61] Freedman W L et al. (HST) 2001 Astrophys. J. 553 47–72 [arXiv:astro-ph/0012376]   
[62] Freedman W L, Madore B F, Scowcroft V, Burns C, Monson A, Persson S E, Seibert M and Rigby J 2012 The Astrophysical Journal 758 24 ISSN 1538-4357 URL http://dx.doi.org/ 10.1088/0004-637X/758/1/24   
[63] Sandage A, Tammann G A, Saha A, Reindl B, Macchetto F D and Panagia N 2006 Astrophys. J. 653 843–860 [arXiv:astro-ph/0603647]   
[64] Riess A G et al. 2016 Astrophys. J. 826 56 [arXiv:1604.01424]   
[65] Riess A G et al. 2018 Astrophys. J. 855 136 [arXiv:1801.01120]   
[66] Riess A G, Casertano S, Yuan W, Macri L M and Scolnic D 2019 Astrophys. J. 876 85 [arXiv:1903.07603]   
[67] Pietrzy´nski G, Graczyk D, Gallenne A, Gieren W, Thompson I B, Pilecki B, Karczmarek P, G´orski M, Suchomska K, Taormina M et al. 2019 Nature 567 200–203 ISSN 1476-4687 URL http://dx.doi.org/10.1038/s41586-019-0999-4   
[68] Reid M J, Pesce D W and Riess A G 2019 Astrophys. J. Lett. 886 L27 [arXiv:1908.05625]   
[69] Lindegren L, Bastian U, Biermann M, Bombrun A, de Torres A, Gerlach E, Geyer R, Hern´andez J, Hilger T, Hobbs D and et al 2021 Astronomy & Astrophysics 649 A4 ISSN 1432-0746 URL http://dx.doi.org/10.1051/0004-6361/202039653   
[70] Brown A G A, Vallenari A, Prusti T, de Bruijne J H J, Babusiaux C, Biermann M, Creevey O L, Evans D W, Eyer L and et al 2021 Astronomy & Astrophysics 649 A1 ISSN 1432-0746 URL http://dx.doi.org/10.1051/0004-6361/202039657   
[71] Cardona W, Kunz M and Pettorino V 2017 JCAP 03 056 [arXiv:1611.06088]   
[72] Camarena D and Marra V 2020 Phys. Rev. Res. 2 013028 [arXiv:1906.11814]   
[73] Dhawan S, Jha S W and Leibundgut B 2018 Astron. Astrophys. 609 A72 [arXiv:1707.00715]   
[74] Burns C R et al. (CSP) 2018 Astrophys. J. 869 56 [arXiv:1809.06381]   
[75] Follin B and Knox L 2018 Mon. Not. Roy. Astron. Soc. 477 4534–4542 [arXiv:1707.01175]   
[76] Feeney S M, Mortlock D J and Dalmasso N 2018 Mon. Not. Roy. Astron. Soc. 476 3861–3882 [arXiv:1707.00007]   
[77] Javanmardi B, Merand A, Kervella P, Breuval L, Gallenne A, Nardetto N, Gieren W, Pietrzynski

G, Hocde V and Borgniet S 2021 Astrophys. J. 911 12 [arXiv:2102.12489] [78] Brown A G A et al. (Gaia) 2018 Astron. Astrophys. 616 A1 [arXiv:1804.09365] [79] Breuval L et al. 2020 Astron. Astrophys. 643 A115 [arXiv:2006.08763] [80] Jang I S and Lee M G 2017 Astrophys. J. 836 74 [arXiv:1702.01118] [81] Freedman W L et al. 2019 Astrophys. J. 882 34 [arXiv:1907.05922] [82] Freedman W L, Madore B F, Hoyt T, Jang I S, Beaton R, Lee M G, Monson A, Neeley J and Rich J 2020 Astrophys. J. 891 57 [arXiv:2002.01550] [83] Yuan W, Riess A G, Macri L M, Casertano S and Scolnic D 2019 Astrophys. J. 886 61 [arXiv:1908.00993] [84] Skowron D M et al. 2021 The Astrophysical Journal Supplement Series 252 23 ISSN 1538-4365 URL http://dx.doi.org/10.3847/1538-4365/abcb81 [85] Soltis J, Casertano S and Riess A G 2021 Astrophys. J. Lett. 908 L5 [arXiv:2012.09196] [86] Hoyt T J, Beaton R L, Freedman W L, Jang I S, Lee M G, Madore B F, Monson A J, Neeley J R, Rich J A and Seibert M 2021 The carnegie chicago hubble program x: Tip of the red giant branch distances to ngc 5643 and ngc 1404 [arXiv:2101.12232] [87] Kim Y J, Kang J, Lee M G and Jang I S 2020 Astrophys. J. 905 104 [arXiv:2010.01364] [88] Huang C D, Riess A G, Yuan W, Macri L M, Zakamska N L, Casertano S, Whitelock P A, Hoffmann S L, Filippenko A V and Scolnic D 2020 Astrophys. J. 889 5 [arXiv:1908.10883] [89] Rigault M et al. 2015 Astrophys. J. 802 20 [arXiv:1412.6501] [90] Rigault M et al. (Nearby Supernova Factory) 2020 Astron. Astrophys. 644 A176 [arXiv:1806.03849] [91] Nicolas N, Rigault M, Copin Y, Graziani R, Aldering G, Briday M, Nordin J, Kim Y L, Perlmutter S and Smith M 2021 Astron. Astrophys. 649 A74 [arXiv:2005.09441] [92] Jones D O et al. 2018 Astrophys. J. 867 108 [arXiv:1805.05911] [93] Khetan N et al. 2021 Astron. Astrophys. 647 A72 [arXiv:2008.07754] [94] Blakeslee J P, Jensen J B, Ma C P, Milne P A and Greene J E 2021 Astrophys. J. 911 65 [arXiv:2101.02221] [95] Kourkchi E, Tully R B, Anand G S, Courtois H M, Dupuy A, Neill J D, Rizzi L and Seibert M 2020 Astrophys. J. 896 3 [arXiv:2004.14499] [96] Schombert J, McGaugh S and Lelli F 2020 Astron. J. 160 71 [arXiv:2006.08615] [97] de Jaeger T, Stahl B E, Zheng W, Filippenko A V, Riess A G and Galbany L 2020 Mon. Not. Roy. Astron. Soc. 496 3402–3411 [arXiv:2006.03412] [98] Fern´andez Arenas D, Terlevich E, Terlevich R, Melnick J, Ch´avez R, Bresolin F, Telles E, Plionis M and Basilakos S 2018 Mon. Not. Roy. Astron. Soc. 474 1250–1276 [arXiv:1710.05951] [99] Pesce D W et al. 2020 Astrophys. J. Lett. 891 L1 [arXiv:2001.09213] [100] Boruah S S, Hudson M J and Lavaux G 2020 [arXiv:2010.01119] [101] Verde L, Treu T and Riess A G 2019 Nature Astron. 3 891 [arXiv:1907.10625] [102] Riess A G 2019 Nature Rev. Phys. 2 10–12 [arXiv:2001.03624] [103] Di Valentino E 2021 Mon. Not. Roy. Astron. Soc. 502 2065–2073 [arXiv:2011.00246] [104] Navarro J F, Frenk C S and White S D M 1997 Astrophys. J. 490 493–508 [arXiv:astroph/9611107] [105] Suyu S H et al. 2017 Mon. Not. Roy. Astron. Soc. 468 2590–2604 [arXiv:1607.00017] [106] Bonvin V et al. 2017 Mon. Not. Roy. Astron. Soc. 465 4914–4930 [arXiv:1607.01790] [107] Birrer S et al. 2019 Mon. Not. Roy. Astron. Soc. 484 4726 [arXiv:1809.01274] [108] Wong K C et al. 2020 Mon. Not. Roy. Astron. Soc. 498 1420–1439 [arXiv:1907.04869] [109] Yang T, Birrer S and Hu B 2020 Mon. Not. Roy. Astron. Soc. 497 L56–L61 [arXiv:2003.03277] [110] Shajib A J et al. (DES) 2020 Mon. Not. Roy. Astron. Soc. 494 6072–6102 [arXiv:1910.06306] [111] Harvey D 2020 Mon. Not. Roy. Astron. Soc. 498 2871–2886 [arXiv:2011.09488] [112] Millon M et al. 2020 Astron. Astrophys. 639 A101 [arXiv:1912.08027] [113] Birrer S et al. 2020 Astron. Astrophys. 643 A165 [arXiv:2007.02941] [114] Birrer S and Treu T 2021 Astron. Astrophys. 649 A61 [arXiv:2008.06157]

[115] Denzel P, Coles J P, Saha P and Williams L L R 2021 Mon. Not. Roy. Astron. Soc. 501 784–801 [arXiv:2007.14398]   
[116] Kelly P L et al. 2015 Science 347 1123 [arXiv:1411.6009]   
[117] Rodney S A et al. 2016 Astrophys. J. 820 50 [arXiv:1512.05734]   
[118] Liao K, Shafieloo A, Keeley R E and Linder E V 2019 Astrophys. J. Lett. 886 L23 [arXiv:1908.04967]   
[119] Liao K, Shafieloo A, Keeley R E and Linder E V 2020 Astrophys. J. Lett. 895 L29 [arXiv:2002.10605]   
[120] Moresco M, Jimenez R, Verde L, Pozzetti L, Cimatti A and Citro A 2018 Astrophys. J. 868 84 [arXiv:1804.05864]   
[121] Moresco M, Jimenez R, Verde L, Cimatti A and Pozzetti L 2020 Astrophys. J. 898 82 [arXiv:2003.07362]   
[122] Moresco M, Pozzetti L, Cimatti A, Jimenez R, Maraston C, Verde L, Thomas D, Citro A, Tojeiro R and Wilkinson D 2016 JCAP 05 014 [arXiv:1601.01701]   
[123] Simon J, Verde L and Jimenez R 2005 Phys. Rev. D 71 123001 [arXiv:astro-ph/0412269]   
[124] Jimenez R, Maartens R, Khalifeh A R, Caldwell R R, Heavens A F and Verde L 2019 JCAP 05 048 [arXiv:1902.11298]   
[125] Bruzual G and Charlot S 2003 Mon. Not. Roy. Astron. Soc. 344 1000 [arXiv:astro-ph/0309134]   
[126] Moresco M, Jimenez R, Cimatti A and Pozzetti L 2011 JCAP 03 045 [arXiv:1010.0831]   
[127] Yu H, Ratra B and Wang F Y 2018 Astrophys. J. 856 3 [arXiv:1711.03437]   
[128] G´omez-Valent A and Amendola L 2018 JCAP 04 051 [arXiv:1802.01505]   
[129] G´omez-Valent A and Amendola L 2019 $H _ { 0 }$ from cosmic chronometers and Type Ia supernovae, with Gaussian processes and the weighted polynomial regression method 15th Marcel Grossmann Meeting on Recent Developments in Theoretical and Experimental General Relativity, Astrophysics, and Relativistic Field Theories [arXiv:1905.04052]   
[130] Haridasu B S, Lukovi´c V V, Moresco M and Vittorio N 2018 JCAP 10 015 [arXiv:1805.03595]   
[131] Dutta K, Roy A, Ruchika, Sen A A and Sheikh-Jabbari M M 2019 Phys. Rev. D 100 103501 [arXiv:1908.07267]   
[132] Krishnan C, Colg´ain E O, Ruchika, Sen A A, Sheikh-Jabbari M M and Yang T 2020 Phys. Rev. D 102 103525 [arXiv:2002.06044]   
[133] Li E K, Du M, Zhou Z H, Zhang H and Xu L 2021 Mon. Not. Roy. Astron. Soc. 501 4452–4463 [arXiv:1911.12076]   
[134] Renzi F and Silvestri A 2020 [arXiv:2011.10559]   
[135] Nunes R C and Bernui A 2020 Eur. Phys. J. C 80 1025 [arXiv:2008.03259]   
[136] Zhang X and Huang Q G 2021 Phys. Rev. D 103 043513 [arXiv:2006.16692]   
[137] Colg´ain E and Sheikh-Jabbari M M 2021 [arXiv:2101.08565]   
[138] Dom´ınguez A and Prada F 2013 Astrophys. J. Lett. 771 L34 [arXiv:1305.2163]   
[139] Dom´ınguez A, Wojtak R, Finke J, Ajello M, Helgason K, Prada F, Desai A, Paliya V, Marcotulli L and Hartmann D 2019 Astrophys. J. 885 137 [arXiv:1903.12097]   
[140] Qi J Z, Zhao J W, Cao S, Biesiada M and Liu Y 2021 Mon. Not. Roy. Astron. Soc. 503 2179–2186 [arXiv:2011.00713]   
[141] Wan J T, Mantz A B, Sayers J, Allen S W, Glenn Morris R and Golwala S R 2021 Mon. Not. Roy. Astron. Soc. 504 1062–1076 [arXiv:2101.09389]   
[142] Lin W, Mack K J and Hou L 2020 Astrophys. J. Lett. 904 L22 [arXiv:1910.02978]   
[143] Efstathiou G 2020 [arXiv:2007.10716]   
[144] Breuval L, Kervella P, Wielg´orski P, Gieren W, Graczyk D, Trahin B, Pietrzy´nski G, Arenou F, Javanmardi B and Zgirski B 2021 The influence of metallicity on the leavitt law from geometrical distances of milky way and magellanic clouds cepheids [arXiv:2103.10894]   
[145] Abbott B P et al. (LIGO Scientific, Virgo, 1M2H, Dark Energy Camera GW-E, DES, DLT40, Las Cumbres Observatory, VINROUGE, MASTER) 2017 Nature 551 85–88 [arXiv:1710.05835]   
[146] Mukherjee S, Lavaux G, Bouchet F R, Jasche J, Wandelt B D, Nissanke S M, Leclercq F and [147] Gayathri V, Healy J, Lange J, O’Brien B, Szczepanczyk M, Bartos I, Campanelli M, Klimenko S, Lousto C and O’Shaughnessy R 2020 [arXiv:2009.14247]   
[148] Mukherjee S, Ghosh A, Graham M J, Karathanasis C, Kasliwal M M, Maga˜na Hernandez I, Nissanke S M, Silvestri A and Wandelt B D 2020 [arXiv:2009.14199]   
[149] Gayathri V, Healy J, Lange J, O’Brien B, Szczepanczyk M, Bartos I, Campanelli M, Klimenko S, Lousto C O and O’Shaughnessy R 2021 Astrophys. J. Lett. 908 L34   
[150] Ashton G, Ackley K, Hernandez I M n and Piotrzkowski B 2020 [arXiv:2009.12346]   
[151] Finke A, Foffa S, Iacovelli F, Maggiore M and Mancarella M 2021 [arXiv:2101.12660]   
[152] Llinares C, Mota D F and Winther H A 2014 Astron. Astrophys. 562 A78 [arXiv:1307.6748] [153] Barrera-Hinojosa C and Li B 2020 JCAP 01 007 [arXiv:1905.08890]   
[154] Barrera-Hinojosa C and Li B 2020 JCAP 04 056 [arXiv:2001.07968]   
[155] Wu H Y and Huterer D 2017 Mon. Not. Roy. Astron. Soc. 471 4946–4955 [arXiv:1706.09723] [156] Kenworthy W D, Scolnic D and Riess A 2019 Astrophys. J. 875 145 [arXiv:1901.08681] [157] Lukovi´c V V, Haridasu B S and Vittorio N 2020 Mon. Not. Roy. Astron. Soc. 491 2075–2087 [arXiv:1907.11219]   
[158] Cai R G, Ding J F, Guo Z K, Wang S J and Yu W W 2020 [arXiv:2012.08292]   
[159] Kalus B, Schwarz D J, Seikel M and Wiegand A 2013 Astron. Astrophys. 553 A56 [arXiv:1212.3691]   
[160] Bengaly C A P, Bernui A and Alcaniz J S 2015 Astrophys. J. 808 39 [arXiv:1503.01413] [161] Bengaly Jr C A P 2016 JCAP 04 036 [arXiv:1510.05545]   
[162] Bolejko K, Nazer M A and Wiltshire D L 2016 JCAP 06 035 [arXiv:1512.07364]   
[163] Migkas K, Schellenberger G, Reiprich T H, Pacaud F, Ramos-Ceja M E and Lovisari L 2020 Astron. Astrophys. 636 A15 [arXiv:2004.03305]   
[164] Andrade U, Bengaly C A P, Santos B and Alcaniz J S 2018 Astrophys. J. 865 119 [arXiv:1806.06990]   
[165] Clarkson C and Umeh O 2011 Class. Quant. Grav. 28 164010 [arXiv:1105.1886]   
[166] Heinesen A 2020 [arXiv:2010.06534]   
[167] Clarkson C, Ellis G F R, Faltenbacher A, Maartens R, Umeh O and Uzan J P 2012 Mon. Not. Roy. Astron. Soc. 426 1121–1136 [arXiv:1109.2484]   
[168] Adamek J, Clarkson C, Coates L, Durrer R and Kunz M 2019 Phys. Rev. D 100 021301 [arXiv:1812.04336]   
[169] Macpherson H J and Heinesen A 2021 [arXiv:2103.11918]   
[170] Ellis G F R 1984 Fundam. Theor. Phys. 9 215–288   
[171] Ellis G F R and Stoeger W 1987 Class. Quant. Grav. 4 1697–1729   
[172] Green S R and Wald R M 2014 Class. Quant. Grav. 31 234003 [arXiv:1407.8084]   
[173] Buchert T et al. 2015 Class. Quant. Grav. 32 215021 [arXiv:1505.07800]   
[174] Clifton T and Sussman R A 2019 Class. Quant. Grav. 36 205004 [arXiv:1904.02557] [175] Zalaletdinov R M 1992 Gen. Rel. Grav. 24 1015–1031   
[176] Zalaletdinov R M 1997 Bull. Astron. Soc. India 25 401–416 [arXiv:gr-qc/9703016]   
[177] Gasperini M, Marozzi G and Veneziano G 2009 JCAP 03 011 [arXiv:0901.1303]   
[178] Gasperini M, Marozzi G and Veneziano G 2010 JCAP 02 009 [arXiv:0912.3244]   
[179] Korzynski M 2010 Class. Quant. Grav. 27 105015 [arXiv:0908.4593]   
[180] Gasperini M, Marozzi G, Nugier F and Veneziano G 2011 JCAP 07 008 [arXiv:1104.1167] [181] Buchert T 2000 Gen. Rel. Grav. 32 105–125 [arXiv:gr-qc/9906015]   
[182] Buchert T 2001 Gen. Rel. Grav. 33 1381–1405 [arXiv:gr-qc/0102049]   
[183] Buchert T and R¨as¨anen S 2012 Ann. Rev. Nucl. Part. Sci. 62 57–79 [arXiv:1112.5335] [184] Buchert T, Mourier P and Roy X 2020 Gen. Rel. Grav. 52 27 [arXiv:1912.04213]   
[185] Wu W L K, Motloch P, Hu W and Raveri M 2020 Phys. Rev. D 102 023510 [arXiv:2004.10207] [186] Bernal J L, Verde L and Riess A G 2016 JCAP 10 019 [arXiv:1607.05617]   
[187] M¨ortsell E and Dhawan S 2018 JCAP 09 025 [arXiv:1801.07260]   
[188] Lin M X, Raveri M and Hu W 2019 Phys. Rev. D 99 043514 [arXiv:1810.02333]   
[189] Knox L and Millea M 2020 Phys. Rev. D 101 043533 [arXiv:1908.03663]   
[190] Arendse N et al. 2020 Astron. Astrophys. 639 A57 [arXiv:1909.07986]   
[191] Jedamzik K, Pogosian L and Zhao G B 2020 [arXiv:2010.04158]   
[192] Bernal J L, Smith T L, Boddy K K and Kamionkowski M 2020 Phys. Rev. D 102 123515 [arXiv:2004.07263]   
[193] Heinesen A, Blake C and Wiltshire D L 2020 JCAP 01 038 [arXiv:1908.11508]   
[194] Efstathiou G 2021 [arXiv:2103.08723]   
[195] Evslin J, Sen A A and Ruchika 2018 Phys. Rev. D 97 103511 [arXiv:1711.01051]   
[196] Aylor K, Joy M, Knox L, Millea M, Raghunathan S and Wu W L K 2019 Astrophys. J. 874 4 [arXiv:1811.00537]   
[197] Lin W, Chen X and Mack K J 2021 [arXiv:2102.05701]   
[198] Beenakker W and Venhoek D 2021 [arXiv:2101.01372]   
[199] Bernal J L, Verde L, Jimenez R, Kamionkowski M, Valcin D and Wandelt B D 2021 Phys. Rev. D 103 103533 [arXiv:2102.05066]   
[200] Caldwell R R, Doran M, Mueller C M, Schafer G and Wetterich C 2003 Astrophys. J. Lett. 591 L75–L78 [arXiv:astro-ph/0302505]   
[201] Bartelmann M, Doran M and Wetterich C 2006 Astron. Astrophys. 454 27–36 [arXiv:astro ph/0507257]   
[202] Doran M, Karwan K and Wetterich C 2005 JCAP 11 007 [arXiv:astro-ph/0508132]   
[203] Karwal T and Kamionkowski M 2016 Phys. Rev. D 94 103523 [arXiv:1608.01309]   
[204] Pettorino V, Amendola L and Wetterich C 2013 Phys. Rev. D 87 083009 [arXiv:1301.5279]   
[205] Sakstein J and Trodden M 2020 Phys. Rev. Lett. 124 161301 [arXiv:1911.11760]   
[206] Gogoi A, Sharma R K, Chanda P and Das S 2020 [arXiv:2005.11889]   
[207] Fardon R, Nelson A E and Weiner N 2004 JCAP 10 005 [arXiv:astro-ph/0309800]   
[208] Kaplan D B, Nelson A E and Weiner N 2004 Phys. Rev. Lett. 93 091801 [arXiv:hep-ph/0401099]   
[209] Peccei R D 2005 Phys. Rev. D 71 023527 [arXiv:hep-ph/0411137]   
[210] Tian S X and Zhu Z H 2021 Phys. Rev. D 103 043518 [arXiv:2102.06399]   
[211] Sabla V I and Caldwell R R 2021 Phys. Rev. D 103 103506 [arXiv:2103.04999]   
[212] Poulin V, Smith T L, Karwal T and Kamionkowski M 2019 Phys. Rev. Lett. 122 221301 [arXiv:1811.04083]   
[213] Kamionkowski M, Pradler J and Walker D G E 2014 Phys. Rev. Lett. 113 251302 [arXiv:1409.0549]   
[214] Turner M S 1983 Phys. Rev. D 28 1243   
[215] Poulin V, Smith T L, Grin D, Karwal T and Kamionkowski M 2018 Phys. Rev. D 98 083525 [arXiv:1806.10608]   
[216] Turner M S and Riess A G 2002 Astrophys. J. 569 18 [arXiv:astro-ph/0106051]   
[217] Barrow J D 1982 Nucl. Phys. B 208 501–508   
[218] Choi K S, Kim I W and Kim J E 2007 JHEP 03 116 [arXiv:hep-ph/0612107]   
[219] Choi K S, Nilles H P, Ramos-Sanchez S and Vaudrevange P K S 2009 Phys. Lett. B 675 381–386 [arXiv:0902.3070]   
[220] Witten E 1984 Phys. Lett. B 149 351–356   
[221] Svrcek P and Witten E 2006 JHEP 06 051 [arXiv:hep-th/0605206]   
[222] Douglas M R and Kachru S 2007 Rev. Mod. Phys. 79 733–796 [arXiv:hep-th/0610102]   
[223] Arvanitaki A, Dimopoulos S, Dubovsky S, Kaloper N and March-Russell J 2010 Phys. Rev. D 81 123530 [arXiv:0905.4720]   
[224] Marsh D J E 2016 Phys. Rept. 643 1–79 [arXiv:1510.07633]   
[225] Arias P, Cadamuro D, Goodsell M, Jaeckel J, Redondo J and Ringwald A 2012 JCAP 06 013 [arXiv:1201.5902]   
[226] Visinelli L 2017 Phys. Rev. D 96 023013 [arXiv:1703.08798]   
[227] Visinelli L and Vagnozzi S 2019 Phys. Rev. D 99 063517 [arXiv:1809.06382]   
[228] Smith T L, Poulin V and Amin M A 2020 Phys. Rev. D 101 063523 [arXiv:1908.06995]   
[229] Hill J C, McDonough E, Toomey M W and Alexander S 2020 Phys. Rev. D 102 043507 [arXiv:2003.07355]   
[230] Lucca M 2020 Phys. Lett. B 810 135791 [arXiv:2008.01115]   
[231] Haridasu B S, Viel M and Vittorio N 2021 Phys. Rev. D 103 063539 [arXiv:2012.10324]   
[232] Ivanov M M, McDonough E, Hill J C, Simonovi´c M, Toomey M W, Alexander S and Zaldarriaga M 2020 Phys. Rev. D 102 103502 [arXiv:2006.11235]   
[233] Smith T L, Poulin V, Bernal J L, Boddy K K, Kamionkowski M and Murgia R 2020 [arXiv:2009.10740]   
[234] D’Amico G, Senatore L, Zhang P and Zheng H 2020 [arXiv:2006.12420]   
[235] Murgia R, Abell´an G F and Poulin V 2021 Phys. Rev. D 103 063502 [arXiv:2009.10733]   
[236] Chudaykin A, Gorbunov D and Nedelko N 2021 Phys. Rev. D 103 043529 [arXiv:2011.04682]   
[237] Kaloper N 2019 Int. J. Mod. Phys. D 28 1944017 [arXiv:1903.11676]   
[238] Berghaus K V and Karwal T 2020 Phys. Rev. D 101 083537 [arXiv:1911.06281]   
[239] Alexander S and McDonough E 2019 Phys. Lett. B 797 134830 [arXiv:1904.08912]   
[240] Chudaykin A, Gorbunov D and Nedelko N 2020 JCAP 08 013 [arXiv:2004.13046]   
[241] Joudaki S et al. 2020 Astron. Astrophys. 638 L1 [arXiv:1906.09262]   
[242] Agrawal P, Cyr-Racine F Y, Pinner D and Randall L 2019 [arXiv:1904.01016]   
[243] Niedermann F and Sloth M S 2021 Phys. Rev. D 103 L041303 [arXiv:1910.10739]   
[244] Linde A D 1990 Phys. Lett. B 249 18–26   
[245] Adams F C and Freese K 1991 Phys. Rev. D 43 353–361 [arXiv:hep-ph/0504135]   
[246] Copeland E J, Liddle A R, Lyth D H, Stewart E D and Wands D 1994 Phys. Rev. D 49 6410–6433 [arXiv:astro-ph/9401011]   
[247] Niedermann F and Sloth M S 2020 Phys. Rev. D 102 063527 [arXiv:2006.06686]   
[248] Freese K and Spolyar D 2005 JCAP 07 007 [arXiv:hep-ph/0412145]   
[249] Freese K and Winkler M W 2021 [arXiv:2102.13655]   
[250] Ye G and Piao Y S 2020 Phys. Rev. D 101 083507 [arXiv:2001.02451]   
[251] Visinelli L, Vagnozzi S and Danielsson U 2019 Symmetry 11 1035 [arXiv:1907.07953]   
[252] Calder´on R, Gannouji R, L’Huillier B and Polarski D 2021 Phys. Rev. D 103 023526 [arXiv:2008.10237]   
[253] Akarsu O, Barrow J D, Escamilla L A and Vazquez J A 2020 Phys. Rev. D 101 063528 [arXiv:1912.08751]   
[254] Ye G and Piao Y S 2020 Phys. Rev. D 102 083523 [arXiv:2008.10832]   
[255] Barrow J D 1990 Phys. Lett. B 235 40–43   
[256] Betoule M et al. (SDSS) 2014 Astron. Astrophys. 568 A22 [arXiv:1401.4064]   
[257] Lin M X, Benevento G, Hu W and Raveri M 2019 Phys. Rev. D 100 063542 [arXiv:1905.12618]   
[258] Lin M X, Hu W and Raveri M 2020 Phys. Rev. D 102 123523 [arXiv:2009.08974]   
[259] Yin L 2020 [arXiv:2012.13917]   
[260] Kallosh R and Linde A 2013 JCAP 07 002 [arXiv:1306.5220]   
[261] Kallosh R, Linde A and Roest D 2013 JHEP 11 198 [arXiv:1311.0472]   
[262] Galante M, Kallosh R, Linde A and Roest D 2015 Phys. Rev. Lett. 114 141302 [arXiv:1412.3797]   
[263] Braglia M, Emond W T, Finelli F, Gumrukcuoglu A E and Koyama K 2020 Phys. Rev. D 102 083513 [arXiv:2005.14053]   
[264] Zhao G B et al. 2017 Nature Astron. 1 627–632 [arXiv:1701.08165]   
[265] Di Valentino E 2017 Nature Astron. 1 569–570 [arXiv:1709.04046]   
[266] Bonilla A, Kumar S and Nunes R C 2021 Eur. Phys. J. C 81 127 [arXiv:2011.07140]   
[267] Wang Y, Pogosian L, Zhao G B and Zucca A 2018 Astrophys. J. Lett. 869 L8 [arXiv:1807.03772]   
[268] Caldwell R R, Kamionkowski M and Weinberg N N 2003 Phys. Rev. Lett. 91 071301 [arXiv:astroph/0302506]   
[269] Parker L and Vanzella D A T 2004 Phys. Rev. D 69 104009 [arXiv:gr-qc/0312108]   
[270] Parker L and Raval A 2000 Phys. Rev. D 62 083503 [Erratum: Phys.Rev.D 67, 029903 (2003)] [arXiv:gr-qc/0003103]   
[271] Caldwell R R, Komp W, Parker L and Vanzella D A T 2006 Phys. Rev. D 73 023513 [arXiv:astro-ph/0507622]   
[272] Csaki C, Kaloper N and Terning J 2006 JCAP 06 022 [arXiv:astro-ph/0507148]   
[273] Kaloper N and Padilla A 2009 JCAP 10 023 [arXiv:0904.2394]   
[274] Huang Q G and Wang K 2016 Eur. Phys. J. C 76 506 [arXiv:1606.05965]   
[275] Vagnozzi S 2020 Phys. Rev. D 102 023518 [arXiv:1907.07569]   
[276] Martinelli M and Tutusaus I 2019 Symmetry 11 986 [arXiv:1906.09189]   
[277] Alestas G, Kazantzidis L and Perivolaropoulos L 2020 Phys. Rev. D 101 123516 [arXiv:2004.08363]   
[278] D’Amico G, Senatore L and Zhang P 2021 JCAP 01 006 [arXiv:2003.07956]   
[279] Chevallier M and Polarski D 2001 Int. J. Mod. Phys. D 10 213–224 [arXiv:gr-qc/0009008]   
[280] Linder E V 2003 Phys. Rev. Lett. 90 091301 [arXiv:astro-ph/0208512]   
[281] Yang W, Di Valentino E, Pan S, Wu Y and Lu J 2021 Mon. Not. Roy. Astron. Soc. 501 5845– 5858 [arXiv:2101.02168]   
[282] Menci N et al. 2020 Astrophys. J. 900 108 [arXiv:2007.12453]   
[283] Yang W, Pan S, Di Valentino E and Saridakis E N 2019 Universe 5 219 [arXiv:1811.06932]   
[284] Kitazawa N 2020 [arXiv:2010.12164]   
[285] Alestas G and Perivolaropoulos L 2021 Mon. Not. Roy. Astron. Soc. 504 3956 [arXiv:2103.04045]   
[286] Di Valentino E, Melchiorri A and Silk J 2015 Phys. Rev. D 92 121302 [arXiv:1507.06646]   
[287] Di Valentino E, Melchiorri A and Silk J 2016 Phys. Lett. B 761 242–246 [arXiv:1606.00634]   
[288] Di Valentino E, Melchiorri A, Linder E V and Silk J 2017 Phys. Rev. D 96 023523 [arXiv:1704.00762]   
[289] Di Valentino E, Melchiorri A and Silk J 2020 JCAP 01 013 [arXiv:1908.01391]   
[290] Di Valentino E, Melchiorri A and Silk J 2021 Astrophys. J. Lett. 908 L9 [arXiv:2003.04935]   
[291] Cooray A R and Huterer D 1999 Astrophys. J. Lett. 513 L95–L98 [arXiv:astro-ph/9901097]   
[292] Efstathiou G 1999 Mon. Not. Roy. Astron. Soc. 310 842–850 [arXiv:astro-ph/9904356]   
[293] Astier P 2001 Phys. Lett. B 500 8–15 [arXiv:astro-ph/0008306]   
[294] Weller J and Albrecht A 2002 Phys. Rev. D 65 103512 [arXiv:astro-ph/0106079]   
[295] Jassal H K, Bagla J S and Padmanabhan T 2005 Phys. Rev. D 72 103503 [arXiv:astroph/0506748]   
[296] Nesseris S and Perivolaropoulos L 2005 Phys. Rev. D 72 123519 [arXiv:astro-ph/0511040]   
[297] Feng B, Li M, Piao Y S and Zhang X 2006 Phys. Lett. B 634 101–105 [arXiv:astro-ph/0407432]   
[298] Barboza Jr E M and Alcaniz J S 2008 Phys. Lett. B 666 415–419 [arXiv:0805.1713]   
[299] Feng L and Lu T 2011 JCAP 11 034 [arXiv:1203.1784]   
[300] Li H and Zhang X 2012 Phys. Lett. B 713 160–164 [arXiv:1202.4071]   
[301] Feng C J, Shen X Y, Li P and Li X Z 2012 JCAP 09 023 [arXiv:1206.0063]   
[302] Yang W, Nunes R C, Pan S and Mota D F 2017 Phys. Rev. D 95 103522 [arXiv:1703.02556]   
[303] Yang W, Pan S and Paliathanasis A 2018 Mon. Not. Roy. Astron. Soc. 475 2605–2613 [arXiv:1708.01717]   
[304] Pan S, Saridakis E N and Yang W 2018 Phys. Rev. D 98 063510 [arXiv:1712.05746]   
[305] Rezaei M, Malekjani M, Basilakos S, Mehrabi A and Mota D F 2017 Astrophys. J. 843 65 [arXiv:1706.02537]   
[306] Vagnozzi S, Dhawan S, Gerbino M, Freese K, Goobar A and Mena O 2018 Phys. Rev. D 98 083501 [arXiv:1801.08553]   
[307] Du M, Yang W, Xu L, Pan S and Mota D F 2019 Phys. Rev. D 100 043535 [arXiv:1812.01440]   
[308] Gong Y g and Zhang Y Z 2005 Phys. Rev. D 72 043518 [arXiv:astro-ph/0502262]   
[309] Yang W, Pan S, Di Valentino E, Saridakis E N and Chakraborty S 2019 Phys. Rev. D 99 043543 [arXiv:1810.05141]   
[310] Shafieloo A, Hazra D K, Sahni V and Starobinsky A A 2018 Mon. Not. Roy. Astron. Soc. 473

2760–2770 [arXiv:1610.05192] [311] Li X, Shafieloo A, Sahni V and Starobinsky A A 2019 Astrophys. J. 887 153 [arXiv:1904.03790] [312] Szyd lowski M, Stachowski A and Urbanowski K 2017 Eur. Phys. J. C 77 902 [arXiv:1704.05364] [313] Szydlowski M, Stachowski A and Urbanowski K 2020 JCAP 04 029 [arXiv:1812.00616] [314] Yang W, Di Valentino E, Pan S, Basilakos S and Paliathanasis A 2020 Phys. Rev. D 102 063503 [arXiv:2001.04307] [315] Di Valentino E, Mukherjee A and Sen A A 2021 Entropy 23 404 [arXiv:2005.12587] [316] Mortonson M J, Hu W and Huterer D 2009 Phys. Rev. D 80 067301 [arXiv:0908.1408] [317] Benevento G, Hu W and Raveri M 2020 Phys. Rev. D 101 103517 [arXiv:2002.11707] [318] Alestas G, Kazantzidis L and Perivolaropoulos L 2021 Phys. Rev. D 103 083517 [arXiv:2012.13932] [319] Camarena D and Marra V 2021 Mon. Not. Roy. Astron. Soc. [arXiv:2101.08641] [320] Shapiro I L and Sola J 2002 JHEP 02 006 [arXiv:hep-th/0012227] [321] Shapiro I L and Sola J 2000 Phys. Lett. B 475 236–246 [arXiv:hep-ph/9910462] [322] Shapiro I L, Sola J and Stefancic H 2005 JCAP 01 012 [arXiv:hep-ph/0410095] [323] Sola J 2008 J. Phys. A 41 164066 [arXiv:0710.4151] [324] Shapiro I L and Sola J 2009 Phys. Lett. B 682 105–113 [arXiv:0910.4925] [325] Sola J 2011 J. Phys. Conf. Ser. 283 012033 [arXiv:1102.1815] [326] Basilakos S, Polarski D and Sola J 2012 Phys. Rev. D 86 043010 [arXiv:1204.4806] [327] Mimoso J P and Pav´on D 2013 Phys. Rev. D 87 047302 [arXiv:1302.1972] [328] Sola J 2013 J. Phys. Conf. Ser. 453 012015 [arXiv:1306.1527] [329] Sol\`a J and G´omez-Valent A 2015 Int. J. Mod. Phys. D 24 1541003 [arXiv:1501.03832] [330] Moreno-Pulido C and Sola J 2020 Eur. Phys. J. C 80 692 [arXiv:2005.03164] [331] Mavromatos N E and Sola J 2020 [arXiv:2012.07971] [332] Sol\`a J, G´omez-Valent A and de Cruz P´erez J 2017 Phys. Lett. B 774 317–324 [arXiv:1705.06723] [333] Sola Peracaula J, Gomez-Valent A, de Cruz Perez J and Moreno-Pulido C 2021 EPL 134 19001 [arXiv:2102.12758] [334] Keeley R E, Joudaki S, Kaplinghat M and Kirkby D 2019 JCAP 12 035 [arXiv:1905.10198] [335] Dutta K, Ruchika, Roy A, Sen A A and Sheikh-Jabbari M M 2020 Gen. Rel. Grav. 52 15 [arXiv:1808.06623] [336] Brevik I H and Gorbunova O 2005 Gen. Rel. Grav. 37 2039–2045 [arXiv:gr-qc/0504001] [337] Haro J and Pan S 2018 Int. J. Mod. Phys. D 27 1850052 [arXiv:1512.03033] [338] Brevik I, Grøn O, de Haro J, Odintsov S D and Saridakis E N 2017 Int. J. Mod. Phys. D 26 1730024 [arXiv:1706.02543] [339] Wang D, Yan Y J and Meng X H 2017 Eur. Phys. J. C 77 660 [arXiv:2103.14788] [340] da Silva W J C and Silva R 2021 Eur. Phys. J. C 81 403 [arXiv:2011.09516] [341] Yang W, Pan S, Di Valentino E, Paliathanasis A and Lu J 2019 Phys. Rev. D 100 103518 [arXiv:1906.04162] [342] Mostaghel B, Moshafi H and Movahed S M S 2017 Eur. Phys. J. C 77 541 [arXiv:1611.08196] [343] Mostaghel B, Moshafi H and Movahed S M S 2018 Mon. Not. Roy. Astron. Soc. 481 1799–1808 [arXiv:1810.04856] [344] Velten H and Schwarz D 2012 Phys. Rev. D 86 083501 [arXiv:1206.0986] [345] Elizalde E, Khurshudyan M, Odintsov S D and Myrzakulov R 2020 Phys. Rev. D 102 123501 [arXiv:2006.01879] [346] Li M 2004 Phys. Lett. B 603 1 [arXiv:hep-th/0403127] [347] Huang Q G and Li M 2005 JCAP 03 001 [arXiv:hep-th/0410095] [348] Zhang J F, Zhao M M, Cui J L and Zhang X 2014 Eur. Phys. J. C 74 3178 [arXiv:1409.6078] [349] Wang S, Wang Y and Li M 2017 Phys. Rept. 696 1–57 [arXiv:1612.00345] [350] Guo R Y, Zhang J F and Zhang X 2019 JCAP 02 054 [arXiv:1809.02340] [351] Dai W M, Ma Y Z and He H J 2020 Phys. Rev. D 102 121302 [arXiv:2003.03602] [352] Colg´ain E O and Sheikh-Jabbari M M 2021 [arXiv:2102.09816]

[353] van Putten M H P M 2019 Monthly Notices of the Royal Astronomical Society: Letters 491 L6–L10   
[354] van Putten M H P M 2017 Astrophys. J. 848 28 [arXiv:1709.05944]   
[355] Tsallis C and Cirto L J L 2013 Eur. Phys. J. C 73 2487 [arXiv:1202.2154]   
[356] da Silva W J C and Silva R 2021 Eur. Phys. J. Plus 136 543 [arXiv:2011.09520]   
[357] Susskind L 2003 [arXiv:hep-th/0302219]   
[358] Vafa C 2005 [arXiv:hep-th/0509212]   
[359] Arkani-Hamed N, Motl L, Nicolis A and Vafa C 2007 JHEP 06 060 [arXiv:hep-th/0601001] [360] Ooguri H and Vafa C 2007 Nucl. Phys. B 766 21–33 [arXiv:hep-th/0605264]   
[361] Klaewer D and Palti E 2017 JHEP 01 088 [arXiv:1610.00010]   
[362] Ooguri H and Vafa C 2017 Adv. Theor. Math. Phys. 21 1787–1801 [arXiv:1610.01533] [363] Freivogel B and Kleban M 2016 [arXiv:1610.04564]   
[364] Grimm T W, Palti E and Valenzuela I 2018 JHEP 08 143 [arXiv:1802.08264]   
[365] Heidenreich B, Reece M and Rudelius T 2018 Phys. Rev. Lett. 121 051601 [arXiv:1802.08698] [366] Blumenhagen R 2018 PoS CORFU2017 175 [arXiv:1804.10504]   
[367] Kinney W H, Vagnozzi S and Visinelli L 2019 Class. Quant. Grav. 36 117001 [arXiv:1808.06424] [368] Danielsson U 2019 JHEP 04 095 [arXiv:1809.04512]   
[369] Agrawal P, Obied G, Steinhardt P J and Vafa C 2018 Phys. Lett. B 784 271–276 [arXiv:1806.09718]   
[370] Agrawal P, Obied G and Vafa C 2021 Phys. Rev. D 103 043523 [arXiv:1906.08261]   
[371] Anchordoqui L A, Antoniadis I, L¨ust D, Soriano J F and Taylor T R 2020 Phys. Rev. D 101 083532 [arXiv:1912.00242]   
[372] Anchordoqui L A, Antoniadis I, L¨ust D and Soriano J F 2021 Phys. Lett. B 816 136199 [arXiv:2005.10075]   
[373] O Colg´ain E, van Putten M H P M and Yavartanoo H 2019 ´ Phys. Lett. B 793 126–129 [arXiv:1807.07451]   
[374] Colg´ain E O and Yavartanoo H 2019 Phys. Lett. B 797 134907 [arXiv:1905.02555]   
[375] Banerjee A, Cai H, Heisenberg L, Colg´ain E O, Sheikh-Jabbari M M and Yang T 2021 Phys. Rev. D 103 L081305 [arXiv:2006.00244]   
[376] Di Valentino E, Ferreira R Z, Visinelli L and Danielsson U 2019 Phys. Dark Univ. 26 100385 [arXiv:1906.11255]   
[377] Miao H and Huang Z 2018 Astrophys. J. 868 20 [arXiv:1803.07320]   
[378] Alam U, Bag S and Sahni V 2017 Phys. Rev. D 95 023524 [arXiv:1605.04707]   
[379] Sahni V and Shtanov Y 2003 JCAP 11 014 [arXiv:astro-ph/0202346]   
[380] Adler S L 2019 Phys. Rev. D 100 123503 [arXiv:1905.08228]   
[381] Cai R G, Guo Z K, Li L, Wang S J and Yu W W 2021 [arXiv:2102.02020]   
[382] Khoury J and Weltman A 2004 Phys. Rev. D 69 044026 [arXiv:astro-ph/0309411]   
[383] Khoury J and Weltman A 2004 Phys. Rev. Lett. 93 171104 [arXiv:astro-ph/0309300] [384] Brax P, van de Bruck C, Davis A C, Mota D F and Shaw D J 2007 Phys. Rev. D 76 124034 [arXiv:0709.2075]   
[385] Banerjee N, Das S and Ganguly K 2010 Pramana 74 L481–L489 [arXiv:0801.1204]   
[386] Das S and Banerjee N 2008 Phys. Rev. D 78 043512 [arXiv:0803.3936]   
[387] Brax P, van de Bruck C, Mota D F, Nunes N J and Winther H A 2010 Phys. Rev. D 82 083503 [arXiv:1006.2796]   
[388] Upadhye A, Hu W and Khoury J 2012 Phys. Rev. Lett. 109 041301 [arXiv:1204.3906] [389] Wang J, Hui L and Khoury J 2012 Phys. Rev. Lett. 109 241301 [arXiv:1208.4612]   
[390] Khoury J 2013 Class. Quant. Grav. 30 214004 [arXiv:1306.4326]   
[391] Li X and Shafieloo A 2019 Astrophys. J. Lett. 883 L3 [arXiv:1906.08275]   
[392] Pan S, Yang W, Di Valentino E, Shafieloo A and Chakraborty S 2020 JCAP 06 062 [arXiv:1907.12551]   
[393] Hern´andez-Almada A, Leon G, Maga˜na J, Garc´ıa-Aspeitia M A and Motta V 2020 Mon. Not. Roy. Astron. Soc. 497 1590–1602 [arXiv:2002.12881]   
[394] Yang W, Di Valentino E, Pan S and Mena O 2021 Phys. Dark Univ. 31 100762 [arXiv:2007.02927]   
[395] Rezaei M, Naderi T, Malekjani M and Mehrabi A 2020 Eur. Phys. J. $C$ 80 374 [arXiv:2004.08168]   
[396] Liu Z and Miao H 2020 Int. J. Mod. Phys. D 29 2050088 [arXiv:2002.05563]   
[397] Li X and Shafieloo A 2020 Astrophys. J. 902 58 [arXiv:2001.05103]   
[398] Yang W, Di Valentino E, Pan S, Shafieloo A and Li X 2021 [arXiv:2103.03815]   
[399] Benaoum H B, Yang W, Pan S and Di Valentino E 2020 [arXiv:2008.09098]   
[400] Di Valentino E, Linder E V and Melchiorri A 2018 Phys. Rev. D 97 043528 [arXiv:1710.02153]   
[401] Di Valentino E, Linder E V and Melchiorri A 2020 Phys. Dark Univ. 30 100733 [arXiv:2006.16291]   
[402] Di Valentino E, Pan S, Yang W and Anchordoqui L A 2021 [arXiv:2102.05641]   
[403] Steigman G, Schramm D N and Gunn J E 1977 Phys. Lett. B 66 202–204   
[404] Mangano G, Miele G, Pastor S, Pinto T, Pisanti O and Serpico P D 2005 Nucl. Phys. B 729 221–234 [arXiv:hep-ph/0506164]   
[405] de Salas P F and Pastor S 2016 JCAP 07 051 [arXiv:1606.06986]   
[406] Akita K and Yamaguchi M 2020 JCAP 08 012 [arXiv:2005.07047]   
[407] Froustey J, Pitrou C and Volpe M C 2020 JCAP 12 015 [arXiv:2008.01074]   
[408] Bennett J J, Buldgen G, De Salas P F, Drewes M, Gariazzo S, Pastor S and Wong Y Y Y 2021 JCAP 04 073 [arXiv:2012.02726]   
[409] Hou Z, Keisler R, Knox L, Millea M and Reichardt C 2013 Phys. Rev. D 87 083008 [arXiv:1104.2333]   
[410] Archidiacono M, Giusarma E, Hannestad S and Mena O 2013 Adv. High Energy Phys. 2013 191047 [arXiv:1307.0637]   
[411] Lattanzi M and Gerbino M 2018 Front. in Phys. 5 70 [arXiv:1712.07109]   
[412] Vagnozzi S, Giusarma E, Mena O, Freese K, Gerbino M, Ho S and Lattanzi M 2017 Phys. Rev. D 96 123503 [arXiv:1701.08172]   
[413] Green D et al. 2019 Bull. Am. Astron. Soc. 51 159 [arXiv:1903.04763]   
[414] Ade P A R et al. (Planck) 2016 Astron. Astrophys. 594 A13 [arXiv:1502.01589]   
[415] Seto O and Toda Y 2021 [arXiv:2101.03740]   
[416] Dodelson S and Widrow L M 1994 Phys. Rev. Lett. 72 17–20 [arXiv:hep-ph/9303287]   
[417] Abazajian K N et al. 2012 [arXiv:1204.5379]   
[418] Anchordoqui L A, Goldberg H and Steigman G 2013 Phys. Lett. B 718 1162–1165 [arXiv:1211.0186]   
[419] Jacques T D, Krauss L M and Lunardini C 2013 Phys. Rev. D 87 083515 [Erratum: Phys.Rev.D 88, 109901 (2013)] [arXiv:1301.3119]   
[420] Aguilar-Arevalo A A et al. (MiniBooNE) 2018 Phys. Rev. Lett. 121 221801 [arXiv:1805.12028]   
[421] Aguilar-Arevalo A et al. (LSND) 2001 Phys. Rev. D 64 112007 [arXiv:hep-ex/0104049]   
[422] Almaz´an H et al. (STEREO) 2018 Phys. Rev. Lett. 121 161801 [arXiv:1806.02096]   
[423] Ashenfelter J et al. (PROSPECT) 2018 Phys. Rev. Lett. 121 251802 [arXiv:1806.02784]   
[424] Hannestad S, Hansen R S and Tram T 2013 JCAP 04 032 [arXiv:1302.7279]   
[425] Battye R A and Moss A 2014 Phys. Rev. Lett. 112 051303 [arXiv:1308.5870]   
[426] Di Valentino E, Melchiorri A and Mena O 2013 JCAP 11 018 [arXiv:1304.5981]   
[427] Bridle S, Elvin-Poole J, Evans J, Fernandez S, Guzowski P and Soldner-Rembold S 2017 Phys. Lett. B 764 322–327 [arXiv:1607.00032]   
[428] Knee A M, Contreras D and Scott D 2019 JCAP 07 039 [arXiv:1812.02102]   
[429] Archidiacono M, Gariazzo S, Giunti C, Hannestad S, Hansen R, Laveder M and Tram T 2016 JCAP 08 067 [arXiv:1606.07673]   
[430] Chu X, Dasgupta B and Kopp J 2015 JCAP 10 011 [arXiv:1505.02795]   
[431] Paul A, Ghoshal A, Chatterjee A and Pal S 2019 Eur. Phys. J. C 79 818 [arXiv:1808.09706]   
[432] de Salas P F, Lattanzi M, Mangano G, Miele G, Pastor S and Pisanti O 2015 Phys. Rev. D 92 123534 [arXiv:1511.00672]   
[433] Carneiro S, de Holanda P C, Pigozzo C and Sobreira F 2019 Phys. Rev. D 100 023505 [arXiv:1812.06064]   
[434] Gelmini G B, Kusenko A and Takhistov V 2019 [arXiv:1906.10136]   
[435] Gelmini G B, Kawasaki M, Kusenko A, Murai K and Takhistov V 2020 JCAP 09 051 [arXiv:2005.06721]   
[436] Schwarz D J and Stuke M 2013 New J. Phys. 15 033021 [arXiv:1211.6721]   
[437] Di Valentino E, Lattanzi M, Mangano G, Melchiorri A and Serpico P 2012 Phys. Rev. D 85 043511 [arXiv:1111.3810]   
[438] Stuke M, Schwarz D J and Starkman G 2012 JCAP 03 040 [arXiv:1111.3954]   
[439] Schwarz D J and Stuke M 2009 JCAP 11 025 [Erratum: JCAP 10, E01 (2010)] [arXiv:0906.3434]   
[440] Barenboim G, Kinney W H and Park W I 2017 Eur. Phys. J. C 77 590 [arXiv:1609.03200]   
[441] Ade P A R et al. (BICEP2, Keck Array) 2015 Astrophys. J. 811 126 [arXiv:1502.00643]   
[442] Weinberg S 1978 Phys. Rev. Lett. 40 223–226   
[443] Wilczek F 1978 Phys. Rev. Lett. 40 279–282   
[444] Peccei R D and Quinn H R 1977 Phys. Rev. Lett. 38 1440–1443   
[445] Peccei R D and Quinn H R 1977 Phys. Rev. D 16 1791–1797   
[446] Di Luzio L, Giannotti M, Nardi E and Visinelli L 2020 Phys. Rept. 870 1–117 [arXiv:2003.01100]   
[447] Melchiorri A, Mena O and Slosar A 2007 Phys. Rev. D 76 041303 [arXiv:0705.2695]   
[448] Hannestad S, Mirizzi A, Raffelt G G and Wong Y Y Y 2007 JCAP 08 015 [arXiv:0706.4198]   
[449] Hannestad S, Mirizzi A, Raffelt G G and Wong Y Y Y 2008 JCAP 04 019 [arXiv:0803.1585]   
[450] Hannestad S, Mirizzi A, Raffelt G G and Wong Y Y Y 2010 JCAP 08 001 [arXiv:1004.0695]   
[451] Archidiacono M, Hannestad S, Mirizzi A, Raffelt G and Wong Y Y Y 2013 JCAP 10 020 [arXiv:1307.0615]   
[452] Giusarma E, Di Valentino E, Lattanzi M, Melchiorri A and Mena O 2014 Phys. Rev. D 90 043507 [arXiv:1403.4852]   
[453] Di Valentino E, Giusarma E, Lattanzi M, Mena O, Melchiorri A and Silk J 2016 Phys. Lett. B 752 182–185 [arXiv:1507.08665]   
[454] Ferreira R Z and Notari A 2018 Phys. Rev. Lett. 120 191301 [arXiv:1801.06090]   
[455] Giar\`e W, Di Valentino E, Melchiorri A and Mena O 2020 [arXiv:2011.14704]   
[456] Masso E, Rota F and Zsembinszki G 2002 Phys. Rev. D 66 023004 [arXiv:hep-ph/0203221]   
[457] Di Luzio L, Martinelli G and Piazza G 2021 [arXiv:2101.10330]   
[458] Turner M S 1987 Phys. Rev. Lett. 59 2489 [Erratum: Phys.Rev.Lett. 60, 1101 (1988)]   
[459] D’Eramo F, Ferreira R Z, Notari A and Bernal J L 2018 JCAP 11 014 [arXiv:1808.07430]   
[460] Salvio A, Strumia A and Xue W 2014 JCAP 01 011 [arXiv:1310.6982]   
[461] Ichiki K, Oguri M and Takahashi K 2004 Phys. Rev. Lett. 93 071302 [arXiv:astro-ph/0403164]   
[462] Berezhiani Z, Dolgov A D and Tkachev I I 2015 Phys. Rev. D 92 061303 [arXiv:1505.03644]   
[463] Anchordoqui L A, Barger V, Goldberg H, Huang X, Marfatia D, da Silva L H M and Weiler T J 2015 Phys. Rev. D 92 061301 [Erratum: Phys.Rev.D 94, 069901 (2016)] [arXiv:1506.08788]   
[464] Chudaykin A, Gorbunov D and Tkachev I 2016 Phys. Rev. D 94 023528 [arXiv:1602.08121]   
[465] Chudaykin A, Gorbunov D and Tkachev I 2018 Phys. Rev. D 97 083508 [arXiv:1711.06738]   
[466] Anchordoqui L A 2021 Phys. Rev. D 103 035025 [arXiv:2010.09715]   
[467] Bjaelde O E, Das S and Moss A 2012 JCAP 10 017 [arXiv:1205.0553]   
[468] Poulin V, Serpico P D and Lesgourgues J 2016 JCAP 08 036 [arXiv:1606.02073]   
[469] Enqvist K, Nadathur S, Sekiguchi T and Takahashi T 2015 JCAP 09 067 [arXiv:1505.05511]   
[470] Bringmann T, Kahlhoefer F, Schmidt-Hoberg K and Walia P 2018 Phys. Rev. D 98 023543 [arXiv:1803.03644]   
[471] Pandey K L, Karwal T and Das S 2020 JCAP 07 026 [arXiv:1902.10636]   
[472] Xiao L, Zhang L, An R, Feng C and Wang B 2020 JCAP 01 045 [arXiv:1908.02668]   
[473] Nygaard A, Tram T and Hannestad S 2021 JCAP 05 017 [arXiv:2011.01632]   
[474] Blinov N, Keith C and Hooper D 2020 JCAP 06 005 [arXiv:2004.06114]   
[475] Tulin S and Yu H B 2018 Phys. Rept. 730 1–57 [arXiv:1705.02358]   
[476] Spergel D N and Steinhardt P J 2000 Phys. Rev. Lett. 84 3760–3763 [arXiv:astro-ph/9909386]   
[477] Buckley M R and Fox P J 2010 Phys. Rev. D 81 083522 [arXiv:0911.3898]   
[478] Binder T, Gustafsson M, Kamada A, Sandner S M R and Wiesner M 2018 Phys. Rev. D 97 123004 [arXiv:1712.01246]   
[479] Hryczuk A and Jod lowski K 2020 Phys. Rev. D 102 043024 [arXiv:2006.16139]   
[480] Blackadder G and Koushiappas S M 2014 Phys. Rev. D 90 103527 [arXiv:1410.0683]   
[481] Vattis K, Koushiappas S M and Loeb A 2019 Phys. Rev. D 99 121302 [arXiv:1903.06220]   
[482] Feng J L, Rajaraman A and Takayama F 2003 Phys. Rev. Lett. 91 011302 [arXiv:hepph/0302215]   
[483] Haridasu B S and Viel M 2020 Mon. Not. Roy. Astron. Soc. 497 1757–1764 [arXiv:2004.07709]   
[484] Clark S J, Vattis K and Koushiappas S M 2021 Phys. Rev. D 103 043014 [arXiv:2006.03678]   
[485] Gu Y, Khlopov M, Wu L, Yang J M and Zhu B 2020 Phys. Rev. D 102 115005 [arXiv:2006.09906]   
[486] Hooper D, Queiroz F S and Gnedin N Y 2012 Phys. Rev. D 85 063513 [arXiv:1111.6599]   
[487] Alcaniz J, Bernal N, Masiero A and Queiroz F S 2021 Phys. Lett. B 812 136008 [arXiv:1912.05563]   
[488] Choi G, Suzuki M and Yanagida T T 2020 Phys. Lett. B 805 135408 [arXiv:1910.00459]   
[489] Escudero M, Hooper D, Krnjaic G and Pierre M 2019 JHEP 03 071 [arXiv:1901.02010]   
[490] Anchordoqui L A 2020 Hubble Hullabaloo and String Cosmology [arXiv:2005.01217]   
[491] Dienes K R and Thomas B 2012 Phys. Rev. D 85 083523 [arXiv:1106.4546]   
[492] Desai A, Dienes K R and Thomas B 2020 Phys. Rev. D 101 035031 [arXiv:1909.07981]   
[493] Choi G, Suzuki M and Yanagida T T 2020 Phys. Rev. D 101 075031 [arXiv:2002.00036]   
[494] Mangano G, Melchiorri A, Serra P, Cooray A and Kamionkowski M 2006 Phys. Rev. D 74 043517 [arXiv:astro-ph/0606190]   
[495] Serra P, Zalamea F, Cooray A, Mangano G and Melchiorri A 2010 Phys. Rev. D 81 043507 [arXiv:0911.4411]   
[496] Diamanti R, Giusarma E, Mena O, Archidiacono M and Melchiorri A 2013 Phys. Rev. D 87 063509 [arXiv:1212.6007]   
[497] Wilkinson R J, Boehm C and Lesgourgues J 2014 JCAP 05 011 [arXiv:1401.7597]   
[498] Olivares-Del Campo A, Palomares-Ruiz S and Pascoli S 2018 Implications of a Dark MatterNeutrino Coupling at Hyper-Kamiokande 53rd Rencontres de Moriond on Electroweak Interactions and Unified Theories [arXiv:1805.09830]   
[499] Olivares-Del Campo A, Bœhm C, Palomares-Ruiz S and Pascoli S 2018 Phys. Rev. D 97 075039 [arXiv:1711.05283]   
[500] Pandey S, Karmakar S and Rakshit S 2019 JHEP 01 095 [arXiv:1810.04203]   
[501] Choi K Y, Kim J and Rott C 2019 Phys. Rev. D 99 083018 [arXiv:1903.03302]   
[502] Stadler J, Bœhm C and Mena O 2019 JCAP 08 014 [arXiv:1903.00540]   
[503] Mosbech M R, Boehm C, Hannestad S, Mena O, Stadler J and Wong Y Y Y 2021 JCAP 03 066 [arXiv:2011.04206]   
[504] Boehm C, Dolan M J and McCabe C 2012 JCAP 12 027 [arXiv:1207.0497]   
[505] Boehm C, Dolan M J and McCabe C 2013 JCAP 08 041 [arXiv:1303.6270]   
[506] Di Valentino E, Bøehm C, Hivon E and Bouchet F R 2018 Phys. Rev. D 97 043513 [arXiv:1710.02559]   
[507] Chikashige Y, Mohapatra R N and Peccei R D 1981 Phys. Lett. B 98 265–268   
[508] Chacko Z, Hall L J, Okui T and Oliver S J 2004 Phys. Rev. D 70 085008 [arXiv:hep-ph/0312267]   
[509] Escudero M and Witte S J 2020 Eur. Phys. J. C 80 294 [arXiv:1909.04044]   
[510] Arias-Aragon F, Fernandez-Martinez E, Gonzalez-Lopez M and Merlo L 2021 Eur. Phys. J. C 81 28 [arXiv:2009.01848]   
[511] Huang G y and Rodejohann W 2021 [arXiv:2102.04280]   
[512] Escudero M and Witte S J 2021 [arXiv:2103.03249]   
[513] Boyarsky A, Ovchynnikov M, Sabti N and Syvolap V 2021 [arXiv:2103.09831]   
[514] Bernal N, Heikinheimo M, Tenkanen T, Tuominen K and Vaskonen V 2017 Int. J. Mod. Phys. A 32 1730023 [arXiv:1706.07442]   
[515] Lanfranchi G, Pospelov M and Schuster P 2020 [arXiv:2011.02157]   
[516] Agrawal P et al. 2021 [arXiv:2102.12143]   
[517] Blinov N and Marques-Tavares G 2020 JCAP 09 029 [arXiv:2003.08387]   
[518] Brust C, Cui Y and Sigurdson K 2017 JCAP 08 020 [arXiv:1703.10732]   
[519] Cyr-Racine F Y, de Putter R, Raccanelli A and Sigurdson K 2014 Phys. Rev. D 89 063517 [arXiv:1310.3278]   
[520] Buen-Abad M A, Marques-Tavares G and Schmaltz M 2015 Phys. Rev. D 92 023531 [arXiv:1505.03542]   
[521] Lesgourgues J, Marques-Tavares G and Schmaltz M 2016 JCAP 02 037 [arXiv:1507.04351]   
[522] Schewtschenko J A, Baugh C M, Wilkinson R J, Bœhm C, Pascoli S and Sawala T 2016 Mon. Not. Roy. Astron. Soc. 461 2282–2287 [arXiv:1512.06774]   
[523] Chacko Z, Cui Y, Hong S, Okui T and Tsai Y 2016 JHEP 12 108 [arXiv:1609.03569]   
[524] Krall R, Cyr-Racine F Y and Dvorkin C 2017 JCAP 09 003 [arXiv:1705.08894]   
[525] Archidiacono M, Bohr S, Hannestad S, Jørgensen J H and Lesgourgues J 2017 JCAP 11 010 [arXiv:1706.06870]   
[526] Buen-Abad M A, Schmaltz M, Lesgourgues J and Brinckmann T 2018 JCAP 01 008 [arXiv:1708.09406]   
[527] Choi G, Yanagida T T and Yokozaki N 2021 JHEP 01 127 [arXiv:2010.06892]   
[528] Ko P and Tang Y 2016 Phys. Lett. B 762 462–466 [arXiv:1608.01083]   
[529] Ko P and Tang Y 2017 Phys. Lett. B 768 12–17 [arXiv:1609.02307]   
[530] Tang Y 2016 Phys. Lett. B 757 387–392 [arXiv:1603.00165]   
[531] Ko P, Nagata N and Tang Y 2017 Phys. Lett. B 773 513–520 [arXiv:1706.05605]   
[532] Cyr-Racine F Y, Sigurdson K, Zavala J, Bringmann T, Vogelsberger M and Pfrommer C 2016 Phys. Rev. D 93 123527 [arXiv:1512.05344]   
[533] Archidiacono M, Hooper D C, Murgia R, Bohr S, Lesgourgues J and Viel M 2019 JCAP 10 055 [arXiv:1907.01496]   
[534] Becker N, Hooper D C, Kahlhoefer F, Lesgourgues J and Sch¨oneberg N 2021 JCAP 02 019 [arXiv:2010.04074]   
[535] Carlson E D, Machacek M E and Hall L J 1992 Astrophys. J. 398 43–52   
[536] Buen-Abad M A, Emami R and Schmaltz M 2018 Phys. Rev. D 98 083517 [arXiv:1803.08062]   
[537] Machacek M E 1994 Astrophys. J. 431 41–51   
[538] Gonzalez M, Hertzberg M P and Rompineve F 2020 JCAP 10 028 [arXiv:2006.13959]   
[539] Greene P B, Kofman L, Linde A D and Starobinsky A A 1997 Phys. Rev. D 56 6175–6192 [arXiv:hep-ph/9705347]   
[540] Freese K, Sfakianakis E I, Stengel P and Visinelli L 2018 JCAP 05 067 [arXiv:1712.03791]   
[541] Flambaum V V and Samsonov I B 2019 Phys. Rev. D 100 063541 [arXiv:1908.09432]   
[542] Holdom B 1986 Phys. Lett. B 166 196–198   
[543] Galison P and Manohar A 1984 Phys. Lett. B 136 279–283   
[544] Anchordoqui L A and Perez Bergliaffa S E 2019 Phys. Rev. D 100 123525 [arXiv:1910.05860]   
[545] Nesseris S, Sapone D and Sypsas S 2020 Phys. Dark Univ. 27 100413 [arXiv:1907.05608]   
[546] Green A M and Kavanagh B J 2021 J. Phys. G 48 4 [arXiv:2007.10722]   
[547] Carr B and Kuhnel F 2020 Ann. Rev. Nucl. Part. Sci. 70 355–394 [arXiv:2006.02838]   
[548] Carr B, Kuhnel F and Visinelli L 2021 Mon. Not. Roy. Astron. Soc. 501 2029–2043 [arXiv:2008.08077]   
[549] Flores M M and Kusenko A 2021 Phys. Rev. Lett. 126 041101 [arXiv:2008.12456]   
[550] van der Bij J J and Dilcher S 2006 Phys. Lett. B 638 234–238 [arXiv:hep-ph/0605008]   
[551] Georgi H 2007 Phys. Rev. Lett. 98 221601 [arXiv:hep-ph/0703260]   
[552] Banks T and Zaks A 1982 Nucl. Phys. B 196 189–204   
[553] Artymowski M, Ben-Dayan I and Kumar U 2020 [arXiv:2010.02998]   
[554] Amendola L 2000 Phys. Rev. D 62 043511 [arXiv:astro-ph/9908023]   
[555] Wetterich C 1995 Astron. Astrophys. 301 321–328 [arXiv:hep-th/9408025]   
[556] Huey G and Wandelt B D 2006 Phys. Rev. D 74 023519 [arXiv:astro-ph/0407196]   
[557] Cai R G and Wang A 2005 JCAP 03 002 [arXiv:hep-th/0411025]   
[558] Pavon D and Zimdahl W 2005 Phys. Lett. B 628 206–210 [arXiv:gr-qc/0505020]   
[559] Berger M S and Shojaei H 2006 Phys. Rev. D 73 083528 [arXiv:gr-qc/0601086]   
[560] del Campo S, Herrera R, Olivares G and Pavon D 2006 Phys. Rev. D 74 023501 [arXiv:astroph/0606520]   
[561] del Campo S, Herrera R and Pavon D 2008 Phys. Rev. D 78 021302 [arXiv:0806.2116]   
[562] del Campo S, Herrera R and Pavon D 2009 JCAP 01 020 [arXiv:0812.2210]   
[563] Wang B, Gong Y g and Abdalla E 2005 Phys. Lett. B 624 141–146 [arXiv:hep-th/0506069]   
[564] Das S, Corasaniti P S and Khoury J 2006 Phys. Rev. D 73 083509 [arXiv:astro-ph/0510628]   
[565] Sadjadi H M and Honardoost M 2007 Phys. Lett. B 647 231–236 [arXiv:gr-qc/0609076]   
[566] Mohseni Sadjadi H 2009 Eur. Phys. J. C 62 419–424 [arXiv:0902.2462]   
[567] Pan S and Chakraborty S 2014 Int. J. Mod. Phys. D 23 1450092 [arXiv:1410.8281]   
[568] Barrow J D and Clifton T 2006 Phys. Rev. D 73 103520 [arXiv:gr-qc/0604063]   
[569] Amendola L, Camargo Campos G and Rosenfeld R 2007 Phys. Rev. D 75 083506 [arXiv:astroph/0610806]   
[570] He J H and Wang B 2008 JCAP 06 010 [arXiv:0801.4233]   
[571] Valiviita J, Majerotto E and Maartens R 2008 JCAP 07 020 [arXiv:0804.0232]   
[572] Gavela M B, Hernandez D, Lopez Honorez L, Mena O and Rigolin S 2009 JCAP 07 034 [Erratum: JCAP 05, E01 (2010)] [arXiv:0901.1611]   
[573] Koyama K, Maartens R and Song Y S 2009 JCAP 10 017 [arXiv:0907.2126]   
[574] Majerotto E, Valiviita J and Maartens R 2010 Mon. Not. Roy. Astron. Soc. 402 2344–2354 [arXiv:0907.4981]   
[575] Valiviita J, Maartens R and Majerotto E 2010 Mon. Not. Roy. Astron. Soc. 402 2355–2368 [arXiv:0907.4987]   
[576] Chimento L P 2010 Phys. Rev. D 81 043525 [arXiv:0911.5687]   
[577] Boehmer C G, Caldera-Cabral G, Chan N, Lazkoz R and Maartens R 2010 Phys. Rev. D 81 083003 [arXiv:0911.3089]   
[578] He J H, Wang B and Abdalla E 2011 Phys. Rev. D 83 063515 [arXiv:1012.3904]   
[579] Chimento L P and Richarte M G 2011 Phys. Rev. D 84 123507 [arXiv:1107.4816]   
[580] Clemson T, Koyama K, Zhao G B, Maartens R and Valiviita J 2012 Phys. Rev. D 85 043007 [arXiv:1109.6234]   
[581] Chimento L P and Richarte M G 2012 Phys. Rev. D 85 127301 [arXiv:1207.1492]   
[582] Chimento L P and Richarte M G 2012 Phys. Rev. D 86 103501 [arXiv:1210.5505]   
[583] Pan S and Chakraborty S 2013 Eur. Phys. J. C 73 2575 [arXiv:1303.5602]   
[584] Pettorino V 2013 Phys. Rev. D 88 063519 [arXiv:1305.7457]   
[585] Costa A A, Xu X D, Wang B, Ferreira E G M and Abdalla E 2014 Phys. Rev. D 89 103531 [arXiv:1311.7380]   
[586] Chimento L P, Richarte M G and S´anchez Garc´ıa I E 2013 Phys. Rev. D 88 087301 [arXiv:1310.5335]   
[587] Yang W and Xu L 2014 Phys. Rev. D 89 083517 [arXiv:1401.1286]   
[588] Yang W and Xu L 2014 JCAP 08 034 [arXiv:1401.5177]   
[589] Yang W and Xu L 2014 Phys. Rev. D 90 083532 [arXiv:1409.5533]   
[590] Pan S, Bhattacharya S and Chakraborty S 2015 Mon. Not. Roy. Astron. Soc. 452 3038–3046 [arXiv:1210.0396]   
[591] Richarte M G and Xu L 2016 Gen. Rel. Grav. 48 39 [arXiv:1407.4348]   
[592] Nunes R C, Pan S and Saridakis E N 2016 Phys. Rev. D 94 023508 [arXiv:1605.01712]   
[593] Amendola L et al. 2018 Living Rev. Rel. 21 2 [arXiv:1606.00180] [594] Yang W, Li H, Wu Y and Lu J 2016 JCAP 10 007 [arXiv:1608.07039] [595] Mukherjee A and Banerjee N 2017 Class. Quant. Grav. 34 035016 [arXiv:1610.04419] [596] Costa A A, Xu X D, Wang B and Abdalla E 2017 JCAP 01 028 [arXiv:1605.04138] [597] Erdem R 2017 Phys. Dark Univ. 15 57–71 [arXiv:1612.04864] [598] Yang W, Banerjee N and Pan S 2017 Phys. Rev. D 95 123527 [Addendum: Phys.Rev.D 96,   
089903 (2017)] [arXiv:1705.09278] [599] Van De Bruck C and Mifsud J 2018 Phys. Rev. D 97 023506 [arXiv:1709.04882] [600] Pan S, Mukherjee A and Banerjee N 2018 Mon. Not. Roy. Astron. Soc. 477 1189–1205 [arXiv:1710.03725] [601] Pan S and Sharov G S 2017 Mon. Not. Roy. Astron. Soc. 472 4736–4749 [arXiv:1609.02287] [602] Sharov G S, Bhattacharya S, Pan S, Nunes R C and Chakraborty S 2017 Mon. Not. Roy. Astron. Soc. 466 3497–3506 [arXiv:1701.00780] [603] Cai R G, Tamanini N and Yang T 2017 JCAP 05 031 [arXiv:1703.07323] [604] Yang W, Pan S, Herrera R and Chakraborty S 2018 Phys. Rev. D 98 043517 [arXiv:1808.01669] [605] D’Amico G, Hamill T and Kaloper N 2016 Phys. Rev. D 94 103526 [arXiv:1605.00996] [606] Yang W, Pan S and Barrow J D 2018 Phys. Rev. D 97 043529 [arXiv:1706.04953] [607] Yang W, Pan S and Mota D F 2017 Phys. Rev. D 96 123508 [arXiv:1709.00006] [608] Bhattacharyya A, Alam U, Pandey K L, Das S and Pal S 2019 Astrophys. J. 876 143 [arXiv:1805.04716] [609] Yang W, Banerjee N, Paliathanasis A and Pan S 2019 Phys. Dark Univ. 26 100383 [arXiv:1812.06854] [610] von Marttens R, Casarini L, Mota D F and Zimdahl W 2019 Phys. Dark Univ. 23 100248 [arXiv:1807.11380] [611] Yang W, Pan S and Paliathanasis A 2019 Mon. Not. Roy. Astron. Soc. 482 1007–1016 [arXiv:1804.08558] [612] Paliathanasis A, Pan S and Yang W 2019 Int. J. Mod. Phys. D 28 1950161 [arXiv:1903.02370] [613] Yang W, Pan S, Di Valentino E, Wang B and Wang A 2020 JCAP 05 050 [arXiv:1904.11980] [614] Asghari M, Beltr´an Jim´enez J, Khosravi S and Mota D F 2019 JCAP 04 042 [arXiv:1902.05532] [615] Yang W, Vagnozzi S, Di Valentino E, Nunes R C, Pan S and Mota D F 2019 JCAP 07 037 [arXiv:1905.08286] [616] Costa A A, Landim R C G, Wang B and Abdalla E 2018 Eur. Phys. J. $C$ 78 746 [arXiv:1803.06944] [617] Gonzalez J E, Silva H H B, Silva R and Alcaniz J S 2018 Eur. Phys. J. C 78 730 [arXiv:1809.00439] [618] Li C, Ren X, Khurshudyan M and Cai Y F 2020 Phys. Lett. B 801 135141 [arXiv:1904.02458] [619] Li H L, He D Z, Zhang J F and Zhang X 2020 JCAP 06 038 [arXiv:1908.03098] [620] von Marttens R, Lombriser L, Kunz M, Marra V, Casarini L and Alcaniz J 2020 Phys. Dark Univ. 28 100490 [arXiv:1911.02618] [621] Cheng G, Ma Y Z, Wu F, Zhang J and Chen X 2020 Phys. Rev. D 102 043517 [arXiv:1911.04520] [622] Pan S, Sharov G S and Yang W 2020 Phys. Rev. D 101 103533 [arXiv:2001.03120] [623] Pan S, de Haro J, Yang W and Amor´os J 2020 Phys. Rev. D 101 123506 [arXiv:2001.09885] [624] Di Valentino E, Melchiorri A, Mena O, Pan S and Yang W 2021 Mon. Not. Roy. Astron. Soc.   
502 L23–L28 [arXiv:2011.00283] [625] S´a P M 2020 Phys. Rev. D 102 103519 [arXiv:2007.07109] [626] S´a P M 2021 [arXiv:2103.01693] [627] Yang W, Pan S, Di Valentino E, Mena O and Melchiorri A 2021 [arXiv:2101.03129] [628] Zhang M, Wang B, Qi J Z, Xu Y, Zhang J F and Zhang X 2021 [arXiv:2102.03979] [629] Bonilla A, Kumar S, Nunes R C and Pan S 2021 [arXiv:2102.06149] [630] Johnson J P, Sangwan A and Shankaranarayanan S 2021 [arXiv:2102.12367] [631] Kumar S 2021 [arXiv:2102.12902] [632] Bolotin Y L, Kostenko A, Lemets O A and Yerokhin D A 2014 Int. J. Mod. Phys. D 24 1530007 arXi 0085   
[633] Wang B, Abdalla E, Atrio-Barandela F and Pavon D 2016 Rept. Prog. Phys. 79 096901 [arXiv:1603.08299]   
[634] Kumar S and Nunes R C 2016 Phys. Rev. D 94 123511 [arXiv:1608.02454]   
[635] Kumar S and Nunes R C 2017 Phys. Rev. D 96 103511 [arXiv:1702.02143]   
[636] Yang W, Pan S, Nunes R C and Mota D F 2020 JCAP 04 008 [arXiv:1910.08821]   
[637] Di Valentino E, Melchiorri A, Mena O and Vagnozzi S 2020 Phys. Dark Univ. 30 100666 [arXiv:1908.04281]   
[638] Martinelli M, Hogg N B, Peirone S, Bruni M and Wands D 2019 Mon. Not. Roy. Astron. Soc. 488 3423–3438 [arXiv:1902.10694]   
[639] Kumar S, Nunes R C and Yadav S K 2019 Eur. Phys. J. C 79 576 [arXiv:1903.04865]   
[640] Lucca M and Hooper D C 2020 Phys. Rev. D 102 123502 [arXiv:2002.06127]   
[641] Wang L F, He D Z, Zhang J F and Zhang X 2021 [arXiv:2102.09331]   
[642] Di Valentino E and Mena O 2020 Mon. Not. Roy. Astron. Soc. 500 L22–L26 [arXiv:2009.12620]   
[643] Amendola L 2004 Phys. Rev. D 69 103524 [arXiv:astro-ph/0311175]   
[644] Pettorino V and Baccigalupi C 2008 Phys. Rev. D 77 103003 [arXiv:0802.1086]   
[645] Boehmer C G, Tamanini N and Wright M 2015 Phys. Rev. D 91 123002 [arXiv:1501.06540]   
[646] Boehmer C G, Tamanini N and Wright M 2015 Phys. Rev. D 91 123003 [arXiv:1502.04030]   
[647] Pettorino V, Amendola L, Baccigalupi C and Quercellini C 2012 Phys. Rev. D 86 103507 [arXiv:1207.3293]   
[648] Peebles P J E and Ratra B 1988 Astrophys. J. Lett. 325 L17   
[649] G´omez-Valent A, Pettorino V and Amendola L 2020 Phys. Rev. D 101 123513 [arXiv:2004.00610]   
[650] An R, Costa A A, Xiao L, Zhang J and Wang B 2019 Mon. Not. Roy. Astron. Soc. 489 297–309 [arXiv:1809.03224]   
[651] Johnson J P and Shankaranarayanan S 2021 Phys. Rev. D 103 023510 [arXiv:2006.04618]   
[652] Di Valentino E, Melchiorri A and Mena O 2017 Phys. Rev. D 96 043503 [arXiv:1704.08342]   
[653] Di Valentino E, Melchiorri A, Mena O and Vagnozzi S 2020 Phys. Rev. D 101 063502 [arXiv:1910.09853]   
[654] Yang W, Di Valentino E, Mena O, Pan S and Nunes R C 2020 Phys. Rev. D 101 083509 [arXiv:2001.10852]   
[655] Wang P and Meng X H 2005 Class. Quant. Grav. 22 283–294 [arXiv:astro-ph/0408495]   
[656] Yang W, Pan S, Di Valentino E, Nunes R C, Vagnozzi S and Mota D F 2018 JCAP 09 019 [arXiv:1805.08252]   
[657] Pan S, Yang W and Paliathanasis A 2020 Mon. Not. Roy. Astron. Soc. 493 3114–3131 [arXiv:2002.03408]   
[658] Yao Y H and Meng X H 2020 Phys. Dark Univ. 30 100729   
[659] Yao Y and Meng X 2020 [arXiv:2011.09160]   
[660] Yang W, Mukherjee A, Di Valentino E and Pan S 2018 Phys. Rev. D 98 123527 [arXiv:1809.06883]   
[661] Pan S, Yang W, Di Valentino E, Saridakis E N and Chakraborty S 2019 Phys. Rev. D 100 103520 [arXiv:1907.07540]   
[662] Yang W, Mena O, Pan S and Di Valentino E 2019 Phys. Rev. D 100 083509 [arXiv:1906.11697]   
[663] Yang W, Di Valentino E, Mena O and Pan S 2020 Phys. Rev. D 102 023535 [arXiv:2003.12552]   
[664] Sun C Y and Yue R H 2012 Phys. Rev. D 85 043010 [arXiv:1009.1214]   
[665] Wei H 2011 Commun. Theor. Phys. 56 972–980 [arXiv:1010.1074]   
[666] Forte M 2014 Gen. Rel. Grav. 46 1811 [arXiv:1311.3921]   
[667] Guo J J, Zhang J F, Li Y H, He D Z and Zhang X 2018 Sci. China Phys. Mech. Astron. 61 030011 [arXiv:1710.03068]   
[668] Arevalo F, Cid A, Chimento L P and Mella P 2019 Eur. Phys. J. C 79 355 [arXiv:1901.04300]   
[669] Pan S, Yang W, Singha C and Saridakis E N 2019 Phys. Rev. D 100 083539 [arXiv:1903.10969]   
[670] Yang W, Pan S, Xu L and Mota D F 2019 Mon. Not. Roy. Astron. Soc. 482 1858–1871 [arXiv:1804.08455]   
[671] Heymans C et al. 2013 Mon. Not. Roy. Astron. Soc. 432 2433 [arXiv:1303.1808]   
[672] Amirhashchi H and Yadav A K 2020 [arXiv:2001.03775]   
[673] B´egu´e D, Stahl C and Xue S S 2019 Nucl. Phys. B 940 312–320 [arXiv:1702.03185]   
[674] Gao L Y, Xue S S and Zhang X 2021 [arXiv:2101.10714]   
[675] Guo Z K, Piao Y S, Zhang X M and Zhang Y Z 2005 Phys. Lett. B 608 177–182 [arXiv:astroph/0410654]   
[676] Lazkoz R and Leon G 2006 Phys. Lett. B 638 303–309 [arXiv:astro-ph/0602590]   
[677] Lazkoz R, Leon G and Quiros I 2007 Phys. Lett. B 649 103–110 [arXiv:astro-ph/0701353]   
[678] Cai Y F, Saridakis E N, Setare M R and Xia J Q 2010 Phys. Rept. 493 1–60 [arXiv:0909.2776]   
[679] Leon G, Paliathanasis A and Morales-Mart´ınez J L 2018 Eur. Phys. J. C 78 753 [arXiv:1808.05634]   
[680] Panpanich S, Burikham P, Ponglertsakul S and Tannukij L 2021 Chin. Phys. C 45 015108 [arXiv:1908.03324]   
[681] Wilkinson R J, Lesgourgues J and Boehm C 2014 JCAP 04 026 [arXiv:1309.7588]   
[682] Boehm C, Schewtschenko J A, Wilkinson R J, Baugh C M and Pascoli S 2014 Mon. Not. Roy. Astron. Soc. 445 L31–L35 [arXiv:1404.7012]   
[683] Escudero M, Lopez-Honorez L, Mena O, Palomares-Ruiz S and Villanueva-Domingo P 2018 JCAP 06 007 [arXiv:1803.08427]   
[684] Stadler J and Bœhm C 2018 JCAP 10 009 [arXiv:1802.06589]   
[685] Kumar S, Nunes R C and Yadav S K 2018 Phys. Rev. D 98 043521 [arXiv:1803.10229]   
[686] Yadav S K 2019 Mod. Phys. Lett. A 35 1950358 [arXiv:1907.05886]   
[687] Barkana R 2018 Nature 555 71–74 [arXiv:1803.06698]   
[688] Chen X l, Hannestad S and Scherrer R J 2002 Phys. Rev. D 65 123515 [arXiv:astro-ph/0202496]   
[689] Boehm C and Schaeffer R 2005 Astron. Astrophys. 438 419–442 [arXiv:astro-ph/0410591]   
[690] Dvorkin C, Blum K and Kamionkowski M 2014 Phys. Rev. D 89 023519 [arXiv:1311.2937]   
[691] Mu˜noz J B and Loeb A 2017 JCAP 11 043 [arXiv:1708.08923]   
[692] Ali-Ha¨ımoud Y 2019 Phys. Rev. D 99 023523 [arXiv:1811.09903]   
[693] Boddy K K, Gluscevic V, Poulin V, Kovetz E D, Kamionkowski M and Barkana R 2018 Phys. Rev. D 98 123506 [arXiv:1808.00001]   
[694] Slatyer T R and Wu C L 2018 Phys. Rev. D 98 023013 [arXiv:1803.09734]   
[695] Xu W L, Dvorkin C and Chael A 2018 Phys. Rev. D 97 103530 [arXiv:1802.06788]   
[696] Simpson F 2010 Phys. Rev. D 82 083505 [arXiv:1007.1034]   
[697] Vagnozzi S, Visinelli L, Mena O and Mota D F 2020 Mon. Not. Roy. Astron. Soc. 493 1139–1152 [arXiv:1911.12374]   
[698] Jim´enez J B, Bettoni D, Figueruelo D and Teppa Pannia F A 2020 JCAP 08 020 [arXiv:2004.14661]   
[699] Bjaelde O E, Brookfield A W, van de Bruck C, Hannestad S, Mota D F, Schrempp L and Tocchini-Valentini D 2008 JCAP 01 026 [arXiv:0705.2018]   
[700] Lancaster L, Cyr-Racine F Y, Knox L and Pan Z 2017 JCAP 07 033 [arXiv:1704.06657]   
[701] Kreisch C D, Cyr-Racine F Y and Dor´e O 2020 Phys. Rev. D 101 123505 [arXiv:1902.00534]   
[702] Roy Choudhury S, Hannestad S and Tram T 2021 JCAP 03 084 [arXiv:2012.07519]   
[703] Das A and Ghosh S 2020 [arXiv:2011.12315]   
[704] Lyu K F, Stamou E and Wang L T 2021 Phys. Rev. D 103 015004 [arXiv:2004.10868]   
[705] Berbig M, Jana S and Trautner A 2020 Phys. Rev. D 102 115008 [arXiv:2004.13039]   
[706] Mazumdar A, Mohanty S and Parashari P 2020 [arXiv:2011.13685]   
[707] Forastieri F, Lattanzi M and Natoli P 2019 Phys. Rev. D 100 103526 [arXiv:1904.07810]   
[708] He H J, Ma Y Z and Zheng J 2020 JCAP 11 003 [arXiv:2003.12057]   
[709] Blinov N, Kelly K J, Krnjaic G Z and McDermott S D 2019 Phys. Rev. Lett. 123 191102 [arXiv:1905.02727]   
[710] Brinckmann T, Chang J H and LoVerde M 2020 [arXiv:2012.11830]   
[711] Archidiacono M, Gariazzo S, Giunti C, Hannestad S and Tram T 2020 JCAP 12 029 [arXiv:2006.12885]   
[712] Archidiacono M, Hannestad S, Hansen R S and Tram T 2015 Phys. Rev. D 91 065021 [arXiv:1404.5915]   
[713] Archidiacono M, Hannestad S, Hansen R S and Tram T 2016 Phys. Rev. D 93 045004 [arXiv:1508.02504]   
[714] Beacom J F, Bell N F and Dodelson S 2004 Phys. Rev. Lett. 93 121302 [arXiv:astro-ph/0404585]   
[715] Ghosh S, Khatri R and Roy T S 2018 Phys. Rev. D 97 063529 [arXiv:1711.09929]   
[716] Ghosh S, Khatri R and Roy T S 2020 Phys. Rev. D 102 123544 [arXiv:1908.09843]   
[717] Chaplygin S 1904 Sci. Mem. Moscow Univ. Math. Phys. 1 21   
[718] Kamenshchik A Y, Moschella U and Pasquier V 2001 Phys. Lett. B 511 265–268 [arXiv:grqc/0103004]   
[719] Bilic N, Tupper G B and Viollier R D 2002 Phys. Lett. B 535 17–21 [arXiv:astro-ph/0111325]   
[720] Gorini V, Kamenshchik A and Moschella U 2003 Phys. Rev. D 67 063509 [arXiv:astroph/0209395]   
[721] Bento M C, Bertolami O and Sen A A 2002 Phys. Rev. D 66 043507 [arXiv:gr-qc/0202064]   
[722] Benaoum H B 2002 [arXiv:hep-th/0205140]   
[723] Amendola L, Finelli F, Burigana C and Carturan D 2003 JCAP 07 005 [arXiv:astro-ph/0304325]   
[724] Avelino P P, Beca L M G, de Carvalho J P M and Martins C J A P 2003 JCAP 09 002 [arXiv:astro-ph/0307427]   
[725] Multamaki T, Manera M and Gaztanaga E 2004 Phys. Rev. D 69 023004 [arXiv:astroph/0307533]   
[726] Debnath U, Banerjee A and Chakraborty S 2004 Class. Quant. Grav. 21 5609–5618 [arXiv:grqc/0411015]   
[727] Gorini V, Kamenshchik A, Moschella U, Pasquier V and Starobinsky A 2005 Phys. Rev. D 72 103518 [arXiv:astro-ph/0504576]   
[728] Guo Z K and Zhang Y Z 2007 Phys. Lett. B 645 326–329 [arXiv:astro-ph/0506091]   
[729] Banerjee R and Ghosh S 2006 Mod. Phys. Lett. A 21 1511–1517 [arXiv:gr-qc/0508021]   
[730] Banerjee R, Ghosh S and Kulkarni S 2007 Phys. Rev. D 75 025008 [arXiv:gr-qc/0611131]   
[731] del Campo S and Herrera R 2008 Phys. Lett. B 665 100–105 [arXiv:0806.0575]   
[732] Lu J, Xu L, Chang B and Gui Y 2009 Int. J. Mod. Phys. D 18 1741–1748 [arXiv:0812.2074]   
[733] Lu J, Xu L, Li J, Chang B, Gui Y and Liu H 2008 Phys. Lett. B 662 87–91 [arXiv:1004.3364]   
[734] Lu J, Gui Y and Xu L X 2009 Eur. Phys. J. C 63 349–354 [arXiv:1004.3365]   
[735] Lu J, Xu L, Wu Y and Liu M 2011 Gen. Rel. Grav. 43 819–832 [arXiv:1105.1870]   
[736] Xu L and Lu J 2010 JCAP 03 025 [arXiv:1004.3344]   
[737] Liang N, Xu L and Zhu Z H 2011 Astron. Astrophys. 527 A11 [arXiv:1009.6059]   
[738] Bouhmadi-Lopez M, Chen P and Liu Y W 2011 Phys. Rev. D 84 023505 [arXiv:1104.0676]   
[739] Xu L, Lu J and Wang Y 2012 Eur. Phys. J. C 72 1883 [arXiv:1204.4798]   
[740] Xu L, Wang Y and Noh H 2012 Eur. Phys. J. C 72 1931 [arXiv:1204.5571]   
[741] Lu J, Geng D, Xu L, Wu Y and Liu M 2015 JHEP 02 071 [arXiv:1312.0779]   
[742] Herrera R, Videla N and Olivares M 2016 Eur. Phys. J. C 76 35 [arXiv:1601.00585]   
[743] vom Marttens R F, Casarini L, Zimdahl W, Hip´olito-Ricaldi W S and Mota D F 2017 Phys. Dark Univ. 15 114–124 [arXiv:1702.00651]   
[744] Yang W, Pan S, Vagnozzi S, Di Valentino E, Mota D F and Capozziello S 2019 JCAP 11 044 [arXiv:1907.05344]   
[745] Hova H and Yang H 2017 Int. J. Mod. Phys. D 27 1750178 [arXiv:1011.4788]   
[746] Hernandez-Almada A, Magana J, Garcia-Aspeitia M A and Motta V 2019 Eur. Phys. J. C 79 12 [arXiv:1805.07895]   
[747] Yang W, Pan S, Paliathanasis A, Ghosh S and Wu Y 2019 Mon. Not. Roy. Astron. Soc. 490 2071–2085 [arXiv:1904.10436] [748] Benetti M, Miranda W, Borges H A, Pigozzo C, Carneiro S and Alcaniz J S 2019 JCAP 12 023 [arXiv:1908.07213]   
[749] Benetti M, Borges H, Pigozzo C, Carneiro S and Alcaniz J 2021 [arXiv:2102.10123]   
[750] Gurzadyan V G and Stepanian A 2019 Eur. Phys. J. C 79 568 [arXiv:1905.03442]   
[751] Gurzadyan V G and Stepanian A 2021 Eur. Phys. J. Plus 136 235 [arXiv:2102.10100] [752] Capozziello S 2002 Int. J. Mod. Phys. D 11 483–492 [arXiv:gr-qc/0201033]   
[753] Nojiri S and Odintsov S D 2004 Gen. Rel. Grav. 36 1765–1780 [arXiv:hep-th/0308176] [754] Carloni S, Dunsby P K S, Capozziello S and Troisi A 2005 Class. Quant. Grav. 22 4839–4868 [arXiv:gr-qc/0410046]   
[755] Amarzguioui M, Elgaroy O, Mota D F and Multamaki T 2006 Astron. Astrophys. 454 707–714 [arXiv:astro-ph/0510519]   
[756] Capozziello S, Cardone V F and Troisi A 2005 Phys. Rev. D 71 043503 [arXiv:astro-ph/0501426] [757] Das S, Banerjee N and Dadhich N 2006 Class. Quant. Grav. 23 4159–4166 [arXiv:astroph/0505096]   
[758] Koivisto T and Mota D F 2007 Phys. Lett. B 644 104–108 [arXiv:astro-ph/0606078] [759] Li B, Mota D F and Shaw D J 2008 Phys. Rev. D 78 064018 [arXiv:0805.3428]   
[760] De Felice A, Mota D F and Tsujikawa S 2010 Phys. Rev. D 81 023532 [arXiv:0911.1811] [761] Paliathanasis A, Tsamparlis M and Basilakos S 2011 Phys. Rev. D 84 123514 [arXiv:1111.4547] [762] Winther H A, Mota D F and Li B 2012 Astrophys. J. 756 166 [arXiv:1110.6438]   
[763] de Haro J and Amoros J 2013 Phys. Rev. Lett. 110 071104 [arXiv:1211.5336]   
[764] Chakraborty S 2013 Gen. Rel. Grav. 45 2039–2052 [arXiv:1212.3050]   
[765] Chakraborty S 2014 Class. Quant. Grav. 31 055005 [arXiv:1309.0693]   
[766] Basilakos S, Capozziello S, De Laurentis M, Paliathanasis A and Tsamparlis M 2013 Phys. Rev. D 88 103526 [arXiv:1311.2173]   
[767] Paliathanasis A, Basilakos S, Saridakis E N, Capozziello S, Atazadeh K, Darabi F and Tsamparlis M 2014 Phys. Rev. D 89 104042 [arXiv:1402.5935]   
[768] Chakraborty S and Padmanabhan T 2014 Phys. Rev. D 90 084021 [arXiv:1408.4791] [769] Paliathanasis A 2016 Class. Quant. Grav. 33 075012 [arXiv:1512.03239]   
[770] Chakraborty S 2015 JHEP 08 029 [arXiv:1505.07272]   
[771] Chakraborty S 2015 JCAP 10 019 [arXiv:1506.02647]   
[772] Paliathanasis A, Barrow J D and Leach P G L 2016 Phys. Rev. D 94 023525 [arXiv:1606.00659] [773] Paliathanasis A and Leach P G L 2016 Phys. Lett. A 380 2815–2818 [arXiv:1605.04204] [774] Koivisto T and Tamanini N 2016 Gen. Rel. Grav. 48 97 [arXiv:1606.04060]   
[775] Nunes R C, Pan S and Saridakis E N 2016 JCAP 08 011 [arXiv:1606.04359]   
[776] Nunes R C, Bonilla A, Pan S and Saridakis E N 2017 Eur. Phys. J. C 77 230 [arXiv:1608.01960] [777] Nunes R C, Pan S, Saridakis E N and Abreu E M C 2017 JCAP 01 005 [arXiv:1610.07518] [778] Paliathanasis A 2017 Phys. Rev. D 95 064062 [arXiv:1701.04360]   
[779] Karpathopoulos L, Basilakos S, Leon G, Paliathanasis A and Tsamparlis M 2018 Gen. Rel. Grav. 50 79 [arXiv:1709.02197]   
[780] Paliathanasis A, Levi Said J and Barrow J D 2018 Phys. Rev. D 97 044008 [arXiv:1709.03432] [781] Dimakis N, Giacomini A and Paliathanasis A 2018 Phys. Lett. B 777 361–368 [arXiv:1711.04526]   
[782] Papagiannopoulos G, Basilakos S, Barrow J D and Paliathanasis A 2018 Phys. Rev. D 97 024026 [arXiv:1801.01274]   
[783] Nunes R C, Pan S and Saridakis E N 2018 Phys. Rev. D 98 104055 [arXiv:1810.03942] [784] Choudhury S G, Dasgupta A and Banerjee N 2019 Mon. Not. Roy. Astron. Soc. 485 5693–5699 [arXiv:1903.04775]   
[785] Paliathanasis A 2019 Eur. Phys. J. C 79 1031 [arXiv:1910.03288]   
[786] Capozziello S and Francaviglia M 2008 Gen. Rel. Grav. 40 357–420 [arXiv:0706.1146] [787] Sotiriou T P and Faraoni V 2010 Rev. Mod. Phys. 82 451–497 [arXiv:0805.1726]   
[788] De Felice A and Tsujikawa S 2010 Living Rev. Rel. 13 3 [arXiv:1002.4928]   
[789] Capozziello S and De Laurentis M 2011 Phys. Rept. 509 167–321 [arXiv:1108.6266]   
[790] Clifton T, Ferreira P G, Padilla A and Skordis C 2012 Phys. Rept. 513 1–189 [arXiv:1106.2476]   
[791] Nojiri S, Odintsov S D and Oikonomou V K 2017 Phys. Rept. 692 1–104 [arXiv:1705.11098]   
[792] Cai Y F, Capozziello S, De Laurentis M and Saridakis E N 2016 Rept. Prog. Phys. 79 106901 [arXiv:1511.07586]   
[793] Quiros I 2019 Int. J. Mod. Phys. D 28 1930012 [arXiv:1901.08690]   
[794] Raveri M 2020 Phys. Rev. D 101 083524 [arXiv:1902.01366]   
[795] Horndeski G W 1974 Int. J. Theor. Phys. 10 363–384   
[796] Hu W and Sawicki I 2007 Phys. Rev. D 76 064004 [arXiv:0705.1158]   
[797] D’Agostino R and Nunes R C 2020 Phys. Rev. D 101 103505 [arXiv:2002.06381]   
[798] Wang D 2020 [arXiv:2008.03966]   
[799] Odintsov S D, S´aez-Chill´on G´omez D and Sharov G S 2021 Nucl. Phys. B 966 115377 [arXiv:2011.03957]   
[800] Jim´enez Cruz N M and Escamilla-Rivera C 2021 Eur. Phys. J. Plus 136 51 [arXiv:2011.09623]   
[801] Cartan E 1923 Annales Sci. Ecole Norm. Sup. 40 325–412   
[802] Unzicker A and Case T 2005 [arXiv:physics/0503046]   
[803] Maluf J W 2013 Annalen Phys. 525 339–357 [arXiv:1303.3897]   
[804] Aldrovandi R and Pereira J G 2013 Teleparallel Gravity: An Introduction (Springer) ISBN 978-94-007-5142-2, 978-94-007-5143-9   
[805] Ferraro R and Fiorini F 2007 Phys. Rev. D 75 084031 [arXiv:gr-qc/0610067]   
[806] Bengochea G R and Ferraro R 2009 Phys. Rev. D 79 124019 [arXiv:0812.1205]   
[807] Fiorini F and Ferraro R 2009 Int. J. Mod. Phys. A 24 1686–1689 [arXiv:0904.1767]   
[808] Awad A, El Hanafy W, Nashed G G L and Saridakis E N 2018 JCAP 02 052 [arXiv:1710.10194]   
[809] Arkani-Hamed N, Cheng H C, Luty M A and Mukohyama S 2004 JHEP 05 074 [arXiv:hepth/0312099]   
[810] Li C, Cai Y, Cai Y F and Saridakis E N 2018 JCAP 10 001 [arXiv:1803.09818]   
[811] Yan S F, Zhang P, Chen J W, Zhang X Z, Cai Y F and Saridakis E N 2020 Phys. Rev. D 101 121301 [arXiv:1909.06388]   
[812] Nunes R C 2018 JCAP 05 052 [arXiv:1802.02281]   
[813] Cai Y F, Khurshudyan M and Saridakis E N 2020 Astrophys. J. 888 62 [arXiv:1907.10813]   
[814] Wang D and Mota D 2020 Phys. Rev. D 102 063530 [arXiv:2003.10095]   
[815] Linder E V 2010 Phys. Rev. D 81 127301 [Erratum: Phys.Rev.D 82, 109902 (2010)] [arXiv:1005.3039]   
[816] Bamba K, Geng C Q, Lee C C and Luo L W 2011 JCAP 01 021 [arXiv:1011.0508]   
[817] Hashim M, El Hanafy W, Golovnev A and El-Zant A A 2020 [arXiv:2010.14964]   
[818] Hashim M, El-Zant A A, El Hanafy W and Golovnev A 2021 [arXiv:2104.08311]   
[819] Briffa R, Capozziello S, Levi Said J, Mifsud J and Saridakis E N 2020 Class. Quant. Grav. 38 055007 [arXiv:2009.14582]   
[820] Ren X, Wong T H T, Cai Y F and Saridakis E N 2021 Phys. Dark Univ. 32 100812 [arXiv:2103.01260]   
[821] Bahamonde S, B¨ohmer C G and Wright M 2015 Phys. Rev. D 92 104042 [arXiv:1508.05120]   
[822] Escamilla-Rivera C and Levi Said J 2020 Class. Quant. Grav. 37 165002 [arXiv:1909.10328]   
[823] Beltr´an Jim´enez J, Heisenberg L and Koivisto T 2018 Phys. Rev. D 98 044048 [arXiv:1710.03116]   
[824] Beltr´an Jim´enez J, Heisenberg L, Koivisto T S and Pekar S 2020 Phys. Rev. D 101 103507 [arXiv:1906.10027]   
[825] Mandal S, Wang D and Sahoo P K 2020 Phys. Rev. D 102 124029 [arXiv:2011.00420]   
[826] Brans C and Dicke R H 1961 Phys. Rev. 124 925–935   
[827] Jordan P 1959 Z. Phys. 157 112–121   
[828] Chen X l and Kamionkowski M 1999 Phys. Rev. D 60 104036 [arXiv:astro-ph/9905368]   
[829] Banerjee N and Pavon D 2001 Phys. Rev. D 63 043504 [arXiv:gr-qc/0012048] [830] Banerjee N and Pavon D 2001 Class. Quant. Grav. 18 593 [arXiv:gr-qc/0012098] [831] Chakraborty S, Chakraborty N C and Debnath U 2003 Int. J. Mod. Phys. D 12 325–335 [arXiv:gr-qc/0305065] [832] Nagata R, Chiba T and Sugiyama N 2004 Phys. Rev. D 69 083512 [arXiv:astro-ph/0311274] [833] Acquaviva V, Baccigalupi C, Leach S M, Liddle A R and Perrotta F 2005 Phys. Rev. D 71   
104025 [arXiv:astro-ph/0412052] [834] Das S and Banerjee N 2006 Gen. Rel. Grav. 38 785–794 [arXiv:gr-qc/0507115] [835] Banerjee N and Das S 2006 Mod. Phys. Lett. A 21 2663–2670 [arXiv:gr-qc/0605110] [836] Banerjee N and Pavon D 2007 Phys. Lett. B 647 477–481 [arXiv:gr-qc/0702110] [837] Avilez A and Skordis C 2014 Phys. Rev. Lett. 113 011101 [arXiv:1303.4330] [838] Li Y C, Wu F Q and Chen X 2013 Phys. Rev. D 88 084053 [arXiv:1305.0055] [839] Tsamparlis M, Paliathanasis A, Basilakos S and Capozziello S 2013 Gen. Rel. Grav. 45 2003–   
2022 [arXiv:1307.6694] [840] Paliathanasis A, Tsamparlis M, Basilakos S and Capozziello S 2014 Phys. Rev. D 89 063532 [arXiv:1403.0332] [841] Umilt\`a C, Ballardini M, Finelli F and Paoletti D 2015 JCAP 08 017 [arXiv:1507.00718] [842] Paliathanasis A, Tsamparlis M, Basilakos S and Barrow J D 2016 Phys. Rev. D 93 043528 [arXiv:1511.00439] [843] Ballardini M, Finelli F, Umilt\`a C and Paoletti D 2016 JCAP 05 067 [arXiv:1601.03387] [844] Ooba J, Ichiki K, Chiba T and Sugiyama N 2016 Phys. Rev. D 93 122002 [arXiv:1602.00809] [845] Papagiannopoulos G, Barrow J D, Basilakos S, Giacomini A and Paliathanasis A 2017 Phys. Rev. D 95 024021 [arXiv:1611.00667] [846] Leon G, Paliathanasis A and Velazquez Abab L 2020 Gen. Rel. Grav. 52 71 [arXiv:1812.03830] [847] Paliathanasis A 2019 Gen. Rel. Grav. 51 101 [arXiv:1907.12261] [848] Joudaki S, Ferreira P G, Lima N A and Winther H A 2020 [arXiv:2010.15278] [849] Sol\`a Peracaula J 2018 Int. J. Mod. Phys. D 27 1847029 [arXiv:1805.09810] [850] de Cruz P´erez J and Sol\`a Peracaula J 2018 Mod. Phys. Lett. A 33 1850228 [arXiv:1809.03329] [851] Sol\`a Peracaula J, Gomez-Valent A, de Cruz P´erez J and Moreno-Pulido C 2019 Astrophys. J. Lett. 886 L6 [arXiv:1909.02554] [852] Sol\`a Peracaula J, G´omez-Valent A, de Cruz P´erez J and Moreno-Pulido C 2020 Class. Quant. Grav. 37 245003 [arXiv:2006.04273] [853] Zee A 1980 Phys. Rev. Lett. 44 703 [854] Cooper F and Venturi G 1981 Phys. Rev. D 24 3338 [855] Rossi M, Ballardini M, Braglia M, Finelli F, Paoletti D, Starobinsky A A and Umilt\`a C 2019 Phys. Rev. D 100 103524 [arXiv:1906.10218] [856] Ballardini M, Braglia M, Finelli F, Paoletti D, Starobinsky A A and Umilt\`a C 2020 JCAP 10   
044 [arXiv:2004.14349] [857] Braglia M, Ballardini M, Emond W T, Finelli F, Gumrukcuoglu A E, Koyama K and Paoletti D 2020 Phys. Rev. D 102 023529 [arXiv:2004.11161] [858] Ballesteros G, Notari A and Rompineve F 2020 JCAP 11 024 [arXiv:2004.05049] [859] Braglia M, Ballardini M, Finelli F and Koyama K 2021 Phys. Rev. D 103 043528 [arXiv:2011.12934] [860] Brax P, van de Bruck C, Clesse S, Davis A C and Sculthorpe G 2014 Phys. Rev. D 89 123507 [arXiv:1312.3361] [861] Pettorino V and Amendola L 2015 Phys. Lett. B 742 353–357 [arXiv:1408.2224] [862] Lima N A, Smer-Barreto V and Lombriser L 2016 Phys. Rev. D 94 083507 [arXiv:1603.05239] [863] Abadi T and Kovetz E D 2021 Phys. Rev. D 103 023530 [arXiv:2011.13853] [864] Burrage C and Sakstein J 2018 Living Rev. Rel. 21 1 [arXiv:1709.09071] [865] Sakstein J 2018 Int. J. Mod. Phys. D 27 1848008 [arXiv:2002.04194] [866] Jain B, Vikram V and Sakstein J 2013 Astrophys. J. 779 39 [arXiv:1204.6044] [867] Desmond H, Jain B and Sakstein J 2019 Phys. Rev. D 100 043537 [Erratum: Phys.Rev.D 101, 069904 (2020), Erratum: Phys.Rev.D 101, 129901 (2020)] [arXiv:1907.03778]   
[868] Desmond H and Sakstein J 2020 Phys. Rev. D 102 023007 [arXiv:2003.12876]   
[869] Khosravi N 2016 Phys. Rev. D 94 124035 [arXiv:1606.01887]   
[870] Khosravi N 2018 Phys. Dark Univ. 21 21–26 [arXiv:1703.02052]   
[871] Khosravi N, Baghram S, Afshordi N and Altamirano N 2019 Phys. Rev. D 99 103526 [arXiv:1710.09366]   
[872] Nicolis A, Rattazzi R and Trincherini E 2009 Phys. Rev. D 79 064036 [arXiv:0811.2197]   
[873] Deffayet C, Esposito-Farese G and Vikman A 2009 Phys. Rev. D 79 084003 [arXiv:0901.1314]   
[874] De Felice A and Tsujikawa S 2010 Phys. Rev. Lett. 105 111301 [arXiv:1007.2700]   
[875] Renk J, Zumalac´arregui M, Montanari F and Barreira A 2017 JCAP 10 020 [arXiv:1707.02263]   
[876] Frusciante N, Peirone S, Atayde L and De Felice A 2020 Phys. Rev. D 101 064001 [arXiv:1912.07586]   
[877] Zumalacarregui M 2020 Phys. Rev. D 102 023523 [arXiv:2003.06396]   
[878] Heisenberg L 2014 JCAP 05 015 [arXiv:1402.7026]   
[879] Allys E, Peter P and Rodriguez Y 2016 JCAP 02 004 [arXiv:1511.03101]   
[880] Beltran Jimenez J and Heisenberg L 2016 Phys. Lett. B 757 405–411 [arXiv:1602.03410]   
[881] Heisenberg L and Villarrubia-Rojo H 2021 JCAP 03 032 [arXiv:2010.00513]   
[882] Peirone S, Benevento G, Frusciante N and Tsujikawa S 2019 Phys. Rev. D 100 063540 [arXiv:1905.05166]   
[883] Birrell N D and Davies P C W 1984 Quantum Fields in Curved Space Cambridge Monographs on Mathematical Physics (Cambridge, UK: Cambridge Univ. Press) ISBN 978-0-521-27858-4, 978-0-521-27858-4   
[884] Mukhanov V and Winitzki S 2007 Introduction to quantum effects in gravity (Cambridge University Press) ISBN 978-0-521-86834-1, 978-1-139-78594-5   
[885] Maggiore M and Mancarella M 2014 Phys. Rev. D 90 023005 [arXiv:1402.0448]   
[886] Belgacem E, Dirian Y, Foffa S and Maggiore M 2018 JCAP 03 002 [arXiv:1712.07066]   
[887] Belgacem E, Dirian Y, Finke A, Foffa S and Maggiore M 2020 JCAP 04 010 [arXiv:2001.07619]   
[888] Maggiore M 2014 Phys. Rev. D 89 043008 [arXiv:1307.3898]   
[889] Anderson J L and Finkelstein D 1971 Am. J. Phys. 39 901–904   
[890] Linares Cede˜no F X and Nucamendi U 2021 Phys. Dark Univ. 32 100807 [arXiv:2009.10268]   
[891] Alvarez P D, Koch B, Laporte C and Rincon A 2020 [arXiv:2009.02311]   
[892] De Felice A, Doll A and Mukohyama S 2020 JCAP 09 034 [arXiv:2004.12549]   
[893] De Felice A, Mukohyama S and Pookkillath M C 2021 Phys. Lett. B 816 136201 [arXiv:2009.08718]   
[894] Guth A H and Pi S Y 1982 Phys. Rev. Lett. 49 1110–1113   
[895] Starobinsky A A 1982 Phys. Lett. B 117 175–178   
[896] Linde A D 1982 Phys. Lett. B 108 389–393   
[897] Albrecht A and Steinhardt P J 1982 Phys. Rev. Lett. 48 1220–1223   
[898] Colless M et al. (2DFGRS) 2001 Mon. Not. Roy. Astron. Soc. 328 1039 [arXiv:astroph/0106498]   
[899] Blanton M R et al. (SDSS) 2017 Astron. J. 154 28 [arXiv:1703.00052]   
[900] Akrami Y et al. (Planck) 2020 Astron. Astrophys. 641 A10 [arXiv:1807.06211]   
[901] Akrami Y et al. (Planck) 2020 Astron. Astrophys. 641 A9 [arXiv:1905.05697]   
[902] Barrow J D and Gron O 1986 Phys. Lett. B 182 25–27   
[903] Burd A B and Barrow J D 1988 Nucl. Phys. B 308 929–945 [Erratum: Nucl.Phys.B 324, 276–276 (1989)]   
[904] Barrow J D and Cotsakis S 1988 Phys. Lett. B 214 515–518   
[905] Barrow J D 1988 Nucl. Phys. B 296 697–709   
[906] Gottlober S, Muller V and Starobinsky A A 1991 Phys. Rev. D 43 2510–2520   
[907] Barrow J D 1993 Phys. Rev. D 48 1585–1590   
[908] Liddle A R, Parsons P and Barrow J D 1994 Phys. Rev. D 50 7222–7232 [arXiv:astro

#

ph/9408015] [909] Barrow J D 1994 Phys. Rev. D 49 3055–3058 [910] Barrow J D 1995 Phys. Rev. D 51 2729–2732 [911] Barrow J D and Parsons P 1995 Phys. Rev. D 52 5576–5587 [arXiv:astro-ph/9506049] [912] Linde A D and Mezhlumian A 1995 Phys. Rev. D 52 6789–6804 [arXiv:astro-ph/9506017] [913] Linde A D 1999 Phys. Rev. D 59 023503 [arXiv:hep-ph/9807493] [914] Kofman L, Linde A D and Mukhanov V F 2002 JHEP 10 057 [arXiv:hep-th/0206088] [915] Linde A D 2003 JCAP 05 002 [arXiv:astro-ph/0303245] [916] Albrecht A and Sorbo L 2004 Phys. Rev. D 70 063528 [arXiv:hep-th/0405270] [917] Nunes N J 2005 Phys. Rev. D 72 103510 [arXiv:astro-ph/0507683] [918] Bousso R, Freivogel B and Yang I S 2006 Phys. Rev. D 74 103516 [arXiv:hep-th/0606114] [919] Barrow J D, Liddle A R and Pahud C 2006 Phys. Rev. D 74 127305 [arXiv:astro-ph/0610807] [920] Watson S, Perry M J, Kane G L and Adams F C 2007 JCAP 11 017 [arXiv:hep-th/0610054] [921] Rocher J, Benabed K and Bouchet F 2007 JCAP 05 013 [arXiv:astro-ph/0612662] [922] Weinberg S 2008 Phys. Rev. D 77 123541 [arXiv:0804.4291] [923] Turner M S 2008 Nature Phys. 4 89–91 [924] Koivisto T and Mota D F 2008 JCAP 08 021 [arXiv:0805.4229] [925] Baumann D and Peiris H V 2009 Adv. Sci. Lett. 2 105–120 [arXiv:0810.3022] [926] Koivisto T S, Mota D F and Pitrou C 2009 JHEP 09 092 [arXiv:0903.4158] [927] Ringstrom H 2009 Commun. Math. Phys. 290 155–218 [928] Pal B K, Pal S and Basu B 2010 JCAP 01 029 [arXiv:0908.2302] [929] Weinberg S 2010 Phys. Rev. D 81 083535 [arXiv:0911.3165] [930] Kaneda S, Ketov S V and Watanabe N 2010 Class. Quant. Grav. 27 145016 [arXiv:1002.3659] [931] Yamauchi D, Linde A, Naruko A, Sasaki M and Tanaka T 2011 Phys. Rev. D 84 043513 [arXiv:1105.2674] [932] Mithani A T and Vilenkin A 2013 JCAP 04 024 [arXiv:1302.0568] [933] Tsujikawa S, Ohashi J, Kuroyanagi S and De Felice A 2013 Phys. Rev. D 88 023529 [arXiv:1305.3044] [934] Ellis J, Fairbairn M and Sueiro M 2014 JCAP 02 044 [arXiv:1312.1353] [935] Wan Y, Li S, Li M, Qiu T, Cai Y and Zhang X 2014 Phys. Rev. D 90 023537 [arXiv:1405.2784] [936] Creminelli P, L´opez Nacir D, Simonovi´c M, Trevisan G and Zaldarriaga M 2014 Phys. Rev. D 90 083513 [arXiv:1405.6264] [937] Freese K and Kinney W H 2015 JCAP 03 044 [arXiv:1403.5277] [938] Basilakos S and Barrow J D 2015 Phys. Rev. D 91 103517 [arXiv:1504.03469] [939] Barrow J D and Paliathanasis A 2016 Phys. Rev. D 94 083518 [arXiv:1609.01126] [940] Barrow J D and Paliathanasis A 2018 Gen. Rel. Grav. 50 82 [arXiv:1611.06680] [941] Paliathanasis A 2017 Eur. Phys. J. C 77 438 [arXiv:1706.06400] [942] Linde A D 2000 Phys. Rept. 333 575–591 [943] Brandenberger R 2016 Int. J. Mod. Phys. D 26 1740002 [arXiv:1601.01918] [944] Peebles P J E and Vilenkin A 1999 Phys. Rev. D 59 063505 [arXiv:astro-ph/9810509] [945] Peloso M and Rosati F 1999 JHEP 12 026 [arXiv:hep-ph/9908271] [946] Kaganovich A B 2001 Phys. Rev. D 63 025022 [arXiv:hep-th/0007144] [947] Yahiro M, Mathews G J, Ichiki K, Kajino T and Orito M 2002 Phys. Rev. D 65 063502 [arXiv:astro-ph/0106349] [948] Sami M and Sahni V 2004 Phys. Rev. D 70 083513 [arXiv:hep-th/0402086] [949] Rosenfeld R and Frieman J A 2005 JCAP 09 003 [arXiv:astro-ph/0504191] [950] Geng C Q, Hossain M W, Myrzakulov R, Sami M and Saridakis E N 2015 Phys. Rev. D 92 023522 [arXiv:1502.03597] [951] de Haro J and Elizalde E 2012 Phys. Rev. Lett. 108 061303 [arXiv:1201.1227] [952] de Haro J, Amor´os J and Pan S 2016 Phys. Rev. D 93 084018 [arXiv:1601.08175] [953] de Haro J and Elizalde E 2016 Gen. Rel. Grav. 48 77 [arXiv:1602.03433]

[954] de Haro J 2017 Gen. Rel. Grav. 49 6 [arXiv:1602.07138]   
[955] de Haro J, Amor´os J and Pan S 2016 Phys. Rev. D 94 064060 [arXiv:1607.06726]   
[956] De Haro J and Arest´e Sal´o L 2017 Phys. Rev. D 95 123501 [arXiv:1702.04212]   
[957] Geng C Q, Lee C C, Sami M, Saridakis E N and Starobinsky A A 2017 JCAP 06 011 [arXiv:1705.01329]   
[958] Arest´e Sal´o L and de Haro J 2017 Eur. Phys. J. C 77 798 [arXiv:1707.02810]   
[959] Haro J, Yang W and Pan S 2019 JCAP 01 023 [arXiv:1811.07371]   
[960] Haro J, Amor´os J and Pan S 2019 Eur. Phys. J. C 79 505 [arXiv:1901.00167]   
[961] de Haro J, Pan S and Arest´e Sal´o L 2019 JCAP 06 056 [arXiv:1903.01181]   
[962] Haro J and Arest´e Sal´o L 2019 Phys. Rev. D 100 043519 [arXiv:1906.02548]   
[963] Dimopoulos K and Donaldson-Wood L 2019 Phys. Lett. B 796 26–31 [arXiv:1906.09648] [964] Haro J, Amor´os J and Pan S 2020 Eur. Phys. J. C 80 404 [arXiv:1908.01516]   
[965] Bowen R, Hansen S H, Melchiorri A, Silk J and Trotta R 2002 Mon. Not. Roy. Astron. Soc. 334 760 [arXiv:astro-ph/0110636]   
[966] Tram T, Vallance R and Vennin V 2017 JCAP 01 046 [arXiv:1606.09199]   
[967] Linde A D 1983 Phys. Lett. B 129 177–181   
[968] Freese K, Frieman J A and Olinto A V 1990 Phys. Rev. Lett. 65 3233–3236   
[969] Adams F C, Bond J R, Freese K, Frieman J A and Olinto A V 1993 Phys. Rev. D 47 426–455 [arXiv:hep-ph/9207245]   
[970] Starobinsky A A 1980 Phys. Lett. B 91 99–102   
[971] Lucchin F and Matarrese S 1985 Phys. Rev. D 32 1316   
[972] Ade P A R et al. (Planck) 2014 Astron. Astrophys. 571 A22 [arXiv:1303.5082]   
[973] Guo R Y and Zhang X 2017 Eur. Phys. J. C 77 882 [arXiv:1704.04784]   
[974] Di Valentino E and Bouchet F R 2016 JCAP 10 011 [arXiv:1609.00328]   
[975] Di Valentino E and Mersini-Houghton L 2017 JCAP 03 020 [arXiv:1612.08334]   
[976] Liu M and Huang Z 2020 Astrophys. J. 897 166 [arXiv:1910.05670]   
[977] Hazra D K, Shafieloo A and Souradeep T 2019 JCAP 04 036 [arXiv:1810.08101]   
[978] Keeley R E, Shafieloo A, Hazra D K and Souradeep T 2020 JCAP 09 055 [arXiv:2006.12710] [979] Arest´e Sal´o L, Benisty D, Guendelman E I and Haro J d 2021 [arXiv:2102.09514]   
[980] Benisty D and Guendelman E I 2020 Int. J. Mod. Phys. D 29 2042002 [arXiv:2004.00339] [981] Benisty D and Guendelman E I 2020 Eur. Phys. J. C 80 577 [arXiv:2006.04129]   
[982] Di Valentino E, Melchiorri A, Fantaye Y and Heavens A 2018 Phys. Rev. D 98 063508 [arXiv:1808.09201]   
[983] Harrison E R 1970 Phys. Rev. D 1 2726–2730   
[984] Peebles P J E and Yu J T 1970 Astrophys. J. 162 815–836   
[985] Zeldovich Y B 1972 Mon. Not. Roy. Astron. Soc. 160 1P–3P   
[986] Chiang C T and Slosar A 2018 [arXiv:1811.03624]   
[987] Liu M, Huang Z, Luo X, Miao H, Singh N K and Huang L 2020 Sci. China Phys. Mech. Astron. 63 290405 [arXiv:1912.00190]   
[988] Hart L and Chluba J 2018 Mon. Not. Roy. Astron. Soc. 474 1850–1861 [arXiv:1705.03925] [989] Hart L and Chluba J 2020 Mon. Not. Roy. Astron. Soc. 493 3255–3263 [arXiv:1912.03986] [990] Sekiguchi T and Takahashi T 2021 Phys. Rev. D 103 083507 [arXiv:2007.03381]   
[991] Fung L W, Li L, Liu T, Luu H N, Qiu Y C and Tye S H H 2021 [arXiv:2102.11257]   
[992] Jedamzik K and Pogosian L 2020 Phys. Rev. Lett. 125 181302 [arXiv:2004.09487]   
[993] Jedamzik K and Abel T 2011 [arXiv:1108.2517]   
[994] Jedamzik K and Saveliev A 2019 Phys. Rev. Lett. 123 021301 [arXiv:1804.06115]   
[995] Banihashemi A, Khosravi N and Shirazi A H 2020 Phys. Rev. D 101 123521 [arXiv:1808.02472] [996] Banihashemi A, Khosravi N and Shirazi A H 2019 Phys. Rev. D 99 083509 [arXiv:1810.11007] [997] Banihashemi A, Khosravi N and Shafieloo A 2020 [arXiv:2012.01407]   
[998] Kasai M and Futamase T 2019 PTEP 2019 073E01 [arXiv:1904.09689]   
[999] Akarsu O, Kumar S, Sharma S and Tedesco L 2019 Phys. Rev. D 100 023532 [arXiv:1905.06949]   
[1000] Heinesen A and Buchert T 2020 Class. Quant. Grav. 37 164001 [Erratum: Class.Quant.Grav. 37, 229601 (2020)] [arXiv:2002.10831]   
[1001] Bolejko K 2018 Phys. Rev. D 97 103529 [arXiv:1712.02967]   
[1002] Macpherson H J, Lasky P D and Price D J 2018 Astrophys. J. Lett. 865 L4 [arXiv:1807.01714]   
[1003] Ivanov M M, Ali-Ha¨ımoud Y and Lesgourgues J 2020 Phys. Rev. D 102 063515 [arXiv:2005.10656]   
[1004] Yoo J, Mitsou E, Dirian Y and Durrer R 2019 Phys. Rev. D 100 063510 [arXiv:1905.09288]   
[1005] Bose B and Lombriser L 2021 Phys. Rev. D 103 L081304 [arXiv:2006.16149]   
[1006] Bengaly C A P, Gonzalez J E and Alcaniz J S 2020 Eur. Phys. J. C 80 936 [arXiv:2007.13789]   
[1007] Adhikari S and Huterer D 2020 Phys. Dark Univ. 28 100539 [arXiv:1905.02278]   
[1008] Capozziello S, Benetti M and Spallicci A D A M 2020 Found. Phys. 50 893–899 [arXiv:2007.00462]   
[1009] Perez A, Sudarsky D and Wilson-Ewing E 2021 Gen. Rel. Grav. 53 7 [arXiv:2001.07536]   
[1010] Berechya D and Leonhardt U 2020 [arXiv:2008.04789]   
[1011] Leonhardt U 2020 Phil. Trans. Roy. Soc. Lond. A 378 20190229 [arXiv:2001.03943]   
[1012] Ortiz C 2020 Int. J. Mod. Phys. D 29 2050115 [arXiv:2011.02317]   
[1013] Vishwakarma R G 2020 Int. J. Mod. Phys. D 29 2043025 [arXiv:2011.12146]   
[1014] Milne E A 1935 Relativity, gravitation and world-structure (Oxford University Press)   
[1015] Krishnan C, Colg´ain E O, Sheikh-Jabbari M M and Yang T 2021 Phys. Rev. D 103 103509 [arXiv:2011.02858]   
[1016] Dainotti M G, De Simone B, Schiavone T, Montani G, Rinaldi E and Lambiase G 2021 Astrophys. J. 912 150 [arXiv:2103.02117]   
[1017] Marra V and Perivolaropoulos L 2021 [arXiv:2102.06012]   
[1018] Fosalba P and Gazta˜naga E 2020 [arXiv:2011.00910]   
[1019] Gaztanaga E 2020 Mon. Not. Roy. Astron. Soc. 494 2766–2772 [arXiv:2003.11544]   
[1020] Haslbauer M, Banik I and Kroupa P 2020 Mon. Not. Roy. Astron. Soc. 499 2845–2883 [arXiv:2009.11292]   
[1021] Keenan R C, Barger A J and Cowie L L 2013 Astrophys. J. 775 62 [arXiv:1304.2884]   
[1022] Beltr´an Jim´enez J, Bettoni D and Brax P 2021 Phys. Rev. D 103 103505 [arXiv:2004.13677]   
[1023] Beltran Jimenez J, Bettoni D and Brax P 2021 [arXiv:2103.03627]   
[1024] Beltran Jimenez J, Bettoni D and Brax P 2020 Int. J. Mod. Phys. D 29 2043010 [arXiv:2007.11029]